/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk.marketplace;

import com.contentstack.sdk.Client;
import com.contentstack.sdk.Region;
import com.contentstack.sdk.marketplace.apps.App;
import com.contentstack.sdk.marketplace.auths.Auth;
import com.contentstack.sdk.marketplace.installations.Installation;
import com.contentstack.sdk.marketplace.login.LoginModel;
import com.contentstack.sdk.marketplace.login.LoginService;
import com.contentstack.sdk.marketplace.request.AppRequest;
import java.io.IOException;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class Marketplace {
    private final Retrofit client;
    protected final String orgId;
    private final String host;
    private final String authtoken;

    private Marketplace(String authtoken, String organizationUid, String host, Region region) {
        this.authtoken = authtoken;
        this.orgId = organizationUid;
        if (region != null) {
            host = region.name().toLowerCase() + "-" + host;
        }
        this.host = host.isEmpty() ? "developerhub-api.contentstack.com" : host;
        this.client = Client.getInstance(this.host);
    }

    public App app() {
        return new App(this.client, this.authtoken, this.orgId);
    }

    public App app(@NotNull String uid) {
        return new App(this.client, this.authtoken, this.orgId, uid);
    }

    public Auth authorizations() {
        return new Auth(this.client, this.authtoken, this.orgId);
    }

    public Installation installation() {
        return new Installation(this.client, this.authtoken, this.orgId);
    }

    public Installation installation(String installationId) {
        return new Installation(this.client, this.authtoken, this.orgId, installationId);
    }

    public AppRequest request() {
        return new AppRequest(this.client, this.authtoken, this.orgId);
    }

    public static class Builder {
        private final String orgId;
        private String host;
        private Region region = null;
        private String authtoken;

        public Builder(@NotNull String organizationUid) {
            if (organizationUid.isEmpty()) {
                throw new NullPointerException("Empty fields are not allowed");
            }
            this.orgId = organizationUid;
        }

        public Builder host(String customHost) {
            this.host = customHost;
            return this;
        }

        public Builder region(Region stackRegion) {
            this.region = stackRegion;
            return this;
        }

        public Builder authtoken(String authtoken) {
            this.authtoken = authtoken;
            return this;
        }

        public Marketplace build() {
            return new Marketplace(this.authtoken, this.orgId, this.host, this.region);
        }

        public Builder login(String email, String password) {
            String BASE_URL = "https://api.contentstack.io/v3/";
            Retrofit.Builder builder = new Retrofit.Builder().baseUrl("https://api.contentstack.io/v3/").addConverterFactory((Converter.Factory)GsonConverterFactory.create());
            Retrofit retrofit = builder.build();
            LoginService service = (LoginService)retrofit.create(LoginService.class);
            HashMap<String, HashMap<String, String>> userSession = new HashMap<String, HashMap<String, String>>();
            userSession.put("user", this.setCredentials(email, password));
            JSONObject userDetail = new JSONObject(userSession);
            Call<LoginModel> request = service.login(this.loginHeader(), userDetail);
            try {
                Response response = request.execute();
                assert (response.body() != null);
                this.authtoken = ((LoginModel)response.body()).getUser().authtoken;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
            return this;
        }

        private HashMap<String, String> loginHeader() {
            HashMap<String, String> loginHeader = new HashMap<String, String>();
            loginHeader.put("Content-Type", "application/json");
            return loginHeader;
        }

        private HashMap<String, String> setCredentials(String ... arguments) {
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("email", arguments[0]);
            credentials.put("password", arguments[1]);
            if (arguments.length > 2) {
                credentials.put("tfa_token", arguments[2]);
            }
            return credentials;
        }
    }
}

