/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk.marketplace.apps;

import com.contentstack.sdk.BaseImplementation;
import com.contentstack.sdk.marketplace.apps.AppService;
import com.contentstack.sdk.marketplace.apps.hosting.Hosting;
import com.contentstack.sdk.marketplace.apps.oauth.Oauth;
import java.util.HashMap;
import java.util.Objects;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;
import retrofit2.Call;
import retrofit2.Retrofit;

public class App
implements BaseImplementation<App> {
    private final AppService service;
    protected HashMap<String, String> headers;
    protected HashMap<String, Object> params;
    private String appUid;
    private final Retrofit client;

    public App(Retrofit client, String authtoken, @NotNull String organizationUid) {
        this.client = client;
        this.headers = new HashMap();
        this.params = new HashMap();
        Objects.requireNonNull(organizationUid, "Organization uid could not be empty");
        this.headers.put("organization_uid", organizationUid);
        if (authtoken != null) {
            this.headers.put("authtoken", authtoken);
        }
        this.service = (AppService)client.create(AppService.class);
    }

    public App(Retrofit client, String authtoken, @NotNull String organizationUid, @NotNull String uid) {
        this.client = client;
        this.headers = new HashMap();
        this.params = new HashMap();
        Objects.requireNonNull(organizationUid, "Organization uid could not be empty");
        this.headers.put("organization_uid", organizationUid);
        if (authtoken != null) {
            this.headers.put("authtoken", authtoken);
        }
        Objects.requireNonNull(uid, "Manifest uid is required");
        this.appUid = uid;
        this.service = (AppService)client.create(AppService.class);
    }

    @Override
    public App addParam(@NotNull String key, @NotNull Object value) {
        this.params.put(key, value);
        return this;
    }

    @Override
    public App addHeader(@NotNull String key, @NotNull String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public App addParams(@NotNull HashMap<String, Object> params) {
        this.params.putAll(params);
        return this;
    }

    @Override
    public App addHeaders(@NotNull HashMap<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public Call<ResponseBody> createInstallation(@NotNull JSONObject body) {
        return this.service.createInstallation(this.headers, this.appUid, body, this.params);
    }

    public Call<ResponseBody> updateVersion(@NotNull JSONObject body) {
        return this.service.updateVersion(this.headers, this.appUid, body, this.params);
    }

    public Call<ResponseBody> findAppAuthorizations() {
        return this.service.findAppAuthorizations(this.headers, this.appUid, this.params);
    }

    public Call<ResponseBody> deleteAuthorization(@NotNull String authorizationUid) {
        return this.service.deleteAuthorization(this.headers, this.appUid, authorizationUid);
    }

    public Call<ResponseBody> findAppInstallations() {
        return this.service.listAppInstallations(this.headers, this.appUid, this.params);
    }

    public Call<ResponseBody> findApps() {
        return this.service.listApps(this.headers, this.params);
    }

    public Call<ResponseBody> createApp(@NotNull JSONObject body) {
        return this.service.createApp(this.headers, this.params, body);
    }

    public Call<ResponseBody> fetchApp() {
        return this.service.fetchApp(this.headers, this.appUid, this.params);
    }

    public Call<ResponseBody> updateApp(@NotNull JSONObject body) {
        return this.service.updateApp(this.headers, this.appUid, body);
    }

    public Call<ResponseBody> deleteApp() {
        return this.service.delete(this.headers, this.appUid);
    }

    public Call<ResponseBody> findAppRequests() {
        return this.service.listAppRequests(this.headers, this.appUid, this.params);
    }

    public Oauth oauth() {
        String orgId = this.headers.get("organization_uid");
        return new Oauth(this.client, orgId);
    }

    public Oauth oauth(@NotNull String id) {
        String orgId = this.headers.get("organization_uid");
        return new Oauth(this.client, orgId, id);
    }

    public Hosting hosting() {
        String orgId = this.headers.get("organization_uid");
        return new Hosting(this.client, orgId, this.appUid);
    }

    public Hosting hosting(@NotNull String appId) {
        String orgId = this.headers.get("organization_uid");
        return new Hosting(this.client, orgId, appId);
    }
}

