/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk.marketplace.apps.hosting;

import com.contentstack.sdk.BaseImplementation;
import com.contentstack.sdk.marketplace.apps.hosting.HostingService;
import java.util.HashMap;
import java.util.Objects;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;
import retrofit2.Call;
import retrofit2.Retrofit;

public class Hosting
implements BaseImplementation<Hosting> {
    private final HostingService service;
    protected HashMap<String, String> headers = new HashMap();
    protected HashMap<String, Object> params = new HashMap();
    protected final String appId;

    public Hosting(Retrofit client, String organizationId, @NotNull String appId) {
        Objects.requireNonNull(appId, "app id/manifest uid is required");
        this.appId = appId;
        Objects.requireNonNull(organizationId, "Organization uid could not be empty");
        this.headers.put("organization_uid", organizationId);
        this.service = (HostingService)client.create(HostingService.class);
    }

    public Call<ResponseBody> fetchHosting() {
        return this.service.getHosting(this.headers, this.appId, this.params);
    }

    public Call<ResponseBody> createSignedUploadUrl() {
        return this.service.signedUploadUrl(this.headers, this.appId);
    }

    public Call<ResponseBody> uploadFile(@NotNull String url) {
        Objects.requireNonNull(url, "Url is required to upload the file");
        return this.service.uploadFile(url, this.headers, this.params);
    }

    public Call<ResponseBody> createDeployment(@NotNull JSONObject body) {
        return this.service.createDeployments(this.headers, this.appId, body, this.params);
    }

    public Call<ResponseBody> findDeployments() {
        return this.service.findDeployments(this.headers, this.appId, this.params);
    }

    public Call<ResponseBody> fetchDeployment(@NotNull String deploymentId) {
        Objects.requireNonNull(this.appId, "App uid is required");
        Objects.requireNonNull(deploymentId, "deploymentId is required to get deployment");
        return this.service.fetchDeployment(this.headers, this.appId, deploymentId, this.params);
    }

    public Call<ResponseBody> getLatestLiveDeployment() {
        return this.service.fetchLatestLiveDeployment(this.headers, this.appId, this.params);
    }

    public Call<ResponseBody> findDeploymentLogs(@NotNull String deploymentId) {
        return this.service.findDeploymentLogs(this.headers, this.appId, deploymentId, this.params);
    }

    public Call<ResponseBody> createSignedDownloadUrl() {
        return this.service.createSignedDownloadUrl(this.headers, this.appId, this.params);
    }

    public Call<ResponseBody> downloadFile(@NotNull String url) {
        return this.service.downloadFile(url, this.headers, this.params);
    }

    public Call<ResponseBody> enableToggleHosting() {
        Objects.requireNonNull(this.appId, "App uid is required");
        return this.service.toggleEnableHosting(this.headers, this.appId);
    }

    public Call<ResponseBody> disableToggleHosting() {
        return this.service.toggleDisableHosting(this.headers, this.appId);
    }

    @Override
    public Hosting addParam(@NotNull String key, @NotNull Object value) {
        this.params.put(key, value);
        return this;
    }

    @Override
    public Hosting addHeader(@NotNull String key, @NotNull String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public Hosting addParams(@NotNull HashMap<String, Object> params) {
        this.params.putAll(params);
        return this;
    }

    @Override
    public Hosting addHeaders(@NotNull HashMap<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }
}

