/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk.marketplace.apps.oauth;

import com.contentstack.sdk.BaseImplementation;
import com.contentstack.sdk.marketplace.apps.oauth.OauthService;
import java.util.HashMap;
import java.util.Objects;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;
import retrofit2.Call;
import retrofit2.Retrofit;

public class Oauth
implements BaseImplementation<Oauth> {
    private final OauthService service;
    protected HashMap<String, String> headers = new HashMap();
    protected HashMap<String, Object> params = new HashMap();
    protected String appId;

    public Oauth(Retrofit client, String organizationId) {
        this.headers.put("organization_uid", organizationId);
        this.service = (OauthService)client.create(OauthService.class);
    }

    public Oauth(Retrofit client, String organizationId, @NotNull String appId) {
        Objects.requireNonNull(appId, "App Id is required");
        this.appId = appId;
        Objects.requireNonNull(organizationId, "Organization uid could not be empty");
        this.headers.put("organization_uid", organizationId);
        this.service = (OauthService)client.create(OauthService.class);
    }

    public Call<ResponseBody> fetchOauthConfiguration(@NotNull String appId) {
        return this.service.getOauthConfiguration(this.headers, appId);
    }

    Call<ResponseBody> updateOauthConfiguration(JSONObject body) {
        return this.service.updateOauthConfiguration(this.headers, this.appId, body);
    }

    Call<ResponseBody> findScopes() {
        return this.service.findScopes(this.headers);
    }

    @Override
    public Oauth addParam(@NotNull String key, @NotNull Object value) {
        this.params.put(key, value);
        return this;
    }

    @Override
    public Oauth addHeader(@NotNull String key, @NotNull String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public Oauth addParams(@NotNull HashMap<String, Object> params) {
        this.params.putAll(params);
        return this;
    }

    @Override
    public Oauth addHeaders(@NotNull HashMap<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }
}

