/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk.marketplace.auths;

import com.contentstack.sdk.BaseImplementation;
import com.contentstack.sdk.marketplace.auths.AuthService;
import java.util.HashMap;
import java.util.Objects;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Retrofit;

public class Auth
implements BaseImplementation<Auth> {
    private final AuthService service;
    protected HashMap<String, String> headers = new HashMap();
    protected HashMap<String, Object> params = new HashMap();

    public Auth(Retrofit clientInstance, String authtoken, String organizationUid) {
        Objects.requireNonNull(organizationUid, "Organization uid could not be empty");
        this.headers.put("organization_uid", organizationUid);
        if (authtoken != null) {
            this.headers.put("authtoken", authtoken);
        }
        this.service = (AuthService)clientInstance.create(AuthService.class);
    }

    public Call<ResponseBody> findAuthorizedApp() {
        return this.service.findAuthorizedApps(this.headers, this.params);
    }

    @Override
    public Auth addParam(@NotNull String key, @NotNull Object value) {
        this.params.put(key, value);
        return this;
    }

    @Override
    public Auth addHeader(@NotNull String key, @NotNull String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public Auth addParams(@NotNull HashMap<String, Object> params) {
        this.params.putAll(params);
        return this;
    }

    @Override
    public Auth addHeaders(@NotNull HashMap<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }
}

