/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk.marketplace.installations;

import com.contentstack.sdk.BaseImplementation;
import com.contentstack.sdk.marketplace.installations.InstallationService;
import com.contentstack.sdk.marketplace.installations.location.Location;
import com.contentstack.sdk.marketplace.installations.webhook.Webhook;
import java.util.HashMap;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;
import retrofit2.Call;
import retrofit2.Retrofit;

public class Installation
implements BaseImplementation<Installation> {
    private String installationId;
    private String organisationId;
    private InstallationService service;
    protected HashMap<String, String> headers;
    protected HashMap<String, Object> params;
    private Retrofit client;

    public Installation(Retrofit client, String authtoken, @NotNull String organisationId, @NotNull String installationId) {
        this.checkOrganisationId(organisationId);
        this.init(client, authtoken, organisationId, installationId);
    }

    protected void checkOrganisationId(String organisationId) {
        if (organisationId.isEmpty()) {
            throw new NullPointerException("organization uid is required");
        }
    }

    protected void validateInstallationId(String installationId) {
        if (installationId == null || installationId.isEmpty()) {
            throw new IllegalArgumentException("installationId is requirement");
        }
    }

    public Installation(@NotNull Retrofit client, String authtoken, @NotNull String organisationId) {
        this.checkOrganisationId(organisationId);
        this.init(client, authtoken, organisationId, null);
    }

    private void init(Retrofit client, String authtoken, @NotNull String organisationId, String installationId) {
        this.headers = new HashMap();
        this.params = new HashMap();
        this.installationId = installationId;
        this.organisationId = organisationId;
        this.client = client;
        this.headers.put("organization_uid", organisationId);
        if (authtoken != null) {
            this.headers.put("authtoken", authtoken);
        }
        this.service = (InstallationService)this.client.create(InstallationService.class);
    }

    Call<ResponseBody> findInstalledApps() {
        return this.service.listInstalledApps(this.headers, this.params);
    }

    Call<ResponseBody> findInstallations() {
        return this.service.listInstallations(this.headers, this.params);
    }

    Call<ResponseBody> fetchInstallation() {
        this.validateInstallationId(this.installationId);
        return this.service.getInstallations(this.headers, this.installationId, this.params);
    }

    Call<ResponseBody> fetchInstallationData() {
        this.validateInstallationId(this.installationId);
        return this.service.getInstallationData(this.headers, this.installationId, this.params);
    }

    Call<ResponseBody> updateInstallation(JSONObject body) {
        this.validateInstallationId(this.installationId);
        return this.service.updateInstallation(this.headers, this.installationId, body, this.params);
    }

    Call<ResponseBody> findInstalledUsers() {
        return this.service.listInstalledUsers(this.headers, this.params);
    }

    Call<ResponseBody> findInstalledStacks() {
        return this.service.listInstalledStacks(this.headers, this.params);
    }

    Call<ResponseBody> uninstall() {
        this.validateInstallationId(this.installationId);
        return this.service.uninstall(this.headers, this.installationId);
    }

    Call<ResponseBody> fetchAppConfiguration() {
        this.validateInstallationId(this.installationId);
        return this.service.getAppConfiguration(this.headers, this.installationId, this.params);
    }

    Call<ResponseBody> fetchServerConfiguration() {
        this.validateInstallationId(this.installationId);
        return this.service.getServerConfiguration(this.headers, this.installationId, this.params);
    }

    Call<ResponseBody> updateServerConfiguration(JSONObject body) {
        this.validateInstallationId(this.installationId);
        return this.service.updateServerConfiguration(this.headers, this.installationId, body, this.params);
    }

    Call<ResponseBody> updateStackConfiguration(JSONObject body) {
        this.validateInstallationId(this.installationId);
        return this.service.updateStackConfiguration(this.headers, this.installationId, body, this.params);
    }

    Call<ResponseBody> createInstallationToken() {
        this.validateInstallationId(this.installationId);
        return this.service.createInstallationToken(this.headers, this.installationId, this.params);
    }

    public Location location() {
        this.validateInstallationId(this.installationId);
        return new Location(this.client, this.organisationId, this.installationId);
    }

    public Webhook webhook(@NotNull String webhookId) {
        this.validateInstallationId(this.installationId);
        return new Webhook(this.client, this.organisationId, webhookId, this.installationId);
    }

    @Override
    public Installation addParam(@NotNull String key, @NotNull Object value) {
        this.params.put(key, value);
        return this;
    }

    @Override
    public Installation addHeader(@NotNull String key, @NotNull String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public Installation addParams(@NotNull HashMap<String, Object> parameters) {
        this.params.putAll(parameters);
        return this;
    }

    @Override
    public Installation addHeaders(@NotNull HashMap<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }
}

