/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk.marketplace.installations.location;

import com.contentstack.sdk.BaseImplementation;
import com.contentstack.sdk.marketplace.installations.location.LocationService;
import java.util.HashMap;
import java.util.Objects;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Retrofit;

public class Location
implements BaseImplementation<Location> {
    private final String installationId;
    protected HashMap<String, String> headers = new HashMap();
    private final LocationService service;
    protected HashMap<String, Object> params = new HashMap();

    public Location(Retrofit client, @NotNull String organizationUid, @NotNull String installationId) {
        this.installationId = installationId;
        this.headers.put("organization_uid", organizationUid);
        this.service = (LocationService)client.create(LocationService.class);
    }

    Call<ResponseBody> fetchConfigurationLocation() {
        Objects.requireNonNull(this.installationId, "Installation Id is required");
        return this.service.getConfigurationLocation(this.headers, this.installationId, this.params);
    }

    @Override
    public Location addParam(@NotNull String key, @NotNull Object value) {
        this.params.put(key, value);
        return this;
    }

    @Override
    public Location addHeader(@NotNull String key, @NotNull String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public Location addParams(@NotNull HashMap<String, Object> params) {
        this.params.putAll(params);
        return this;
    }

    @Override
    public Location addHeaders(@NotNull HashMap<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }
}

