/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk.marketplace.installations.webhook;

import com.contentstack.sdk.BaseImplementation;
import com.contentstack.sdk.marketplace.installations.webhook.WebhookService;
import java.util.HashMap;
import java.util.Objects;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.Retrofit;

public class Webhook
implements BaseImplementation<Webhook> {
    private final String installationId;
    protected HashMap<String, String> headers = new HashMap();
    private final WebhookService service;
    protected HashMap<String, Object> params = new HashMap();
    protected String webhookId;

    public Webhook(Retrofit client, @NotNull String organizationUid, @NotNull String webhookId, @NotNull String installationId) {
        this.webhookId = webhookId;
        this.installationId = installationId;
        this.headers.put("organization_uid", organizationUid);
        this.service = (WebhookService)client.create(WebhookService.class);
    }

    public Call<ResponseBody> findExecutionLogs() {
        Objects.requireNonNull(this.installationId, "installation uid is required");
        return this.service.findExecutionLogs(this.headers, this.installationId, this.webhookId, this.params);
    }

    public Call<ResponseBody> fetchExecutionLogs(String executionId) {
        Objects.requireNonNull(this.installationId, "installation uid is required");
        return this.service.fetchExecutionLog(this.headers, this.installationId, this.webhookId, executionId, this.params);
    }

    public Call<ResponseBody> retryExecution(@NotNull String executionId) {
        Objects.requireNonNull(this.installationId, "installation uid is required");
        return this.service.retryExecution(this.headers, this.installationId, this.webhookId, executionId, this.params);
    }

    @Override
    public Webhook addParam(@NotNull String key, @NotNull Object value) {
        this.params.put(key, value);
        return this;
    }

    @Override
    public Webhook addHeader(@NotNull String key, @NotNull String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public Webhook addParams(@NotNull HashMap<String, Object> params) {
        this.params.putAll(params);
        return this;
    }

    @Override
    public Webhook addHeaders(@NotNull HashMap<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }
}

