/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.sdk.marketplace.request;

import com.contentstack.sdk.BaseImplementation;
import com.contentstack.sdk.marketplace.request.RequestService;
import java.util.HashMap;
import java.util.Map;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;
import retrofit2.Call;
import retrofit2.Retrofit;

public class AppRequest
implements BaseImplementation<AppRequest> {
    private final RequestService service;
    private final Map<String, String> headers;
    private final Map<String, Object> params;

    public AppRequest(@NotNull Retrofit client, String authtoken, @NotNull String orgId) {
        this.service = (RequestService)client.create(RequestService.class);
        this.headers = new HashMap<String, String>();
        this.headers.put("organization_uid", orgId);
        if (authtoken != null) {
            this.headers.put("authtoken", authtoken);
        }
        this.params = new HashMap<String, Object>();
    }

    Call<ResponseBody> create(JSONObject data) {
        return this.service.create(this.headers, data);
    }

    Call<ResponseBody> find() {
        return this.service.listRequests(this.headers, this.params);
    }

    Call<ResponseBody> findRequestedStacks() {
        return this.service.listRequestedStacks(this.headers, this.params);
    }

    Call<ResponseBody> delete(String requestId) {
        return this.service.deleteRequest(this.headers, requestId);
    }

    @Override
    public AppRequest addParam(@NotNull String key, @NotNull Object value) {
        this.params.put(key, value);
        return this;
    }

    @Override
    public AppRequest addHeader(@NotNull String key, @NotNull String value) {
        this.headers.put(key, value);
        return this;
    }

    @Override
    public AppRequest addHeaders(@NotNull HashMap<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    @Override
    public AppRequest addParams(@NotNull HashMap<String, Object> parameters) {
        this.params.putAll(parameters);
        return this;
    }
}

