/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.utils;

import com.contentstack.utils.AutomateCommon;
import com.contentstack.utils.interfaces.ContentCallback;
import com.contentstack.utils.interfaces.MetaToEmbedCallback;
import com.contentstack.utils.render.DefaultOption;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.validation.constraints.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

public class GQL {
    private static JSONArray embeddedItems = null;

    private GQL() throws IllegalAccessException {
        throw new IllegalAccessException("Invalid Access! Could not create instance of GQL");
    }

    public static void jsonToHTML(@NotNull JSONObject gqlEntry, @NotNull String[] path, @NotNull DefaultOption renderOption) {
        ContentCallback callback = content -> {
            JSONObject embeddedConnection;
            JSONObject contentDict = (JSONObject)content;
            if (contentDict.has("embedded_itemsConnection") && (embeddedConnection = contentDict.optJSONObject("embedded_itemsConnection")).has("edges")) {
                embeddedItems = embeddedConnection.optJSONArray("edges");
            }
            if (contentDict.has("json")) {
                MetaToEmbedCallback converter = metadata -> {
                    if (embeddedItems != null) {
                        Optional<JSONObject> filteredContent = StreamSupport.stream(embeddedItems.spliterator(), false).map(JSONObject.class::cast).filter(itemDict -> {
                            JSONObject nodeObject = itemDict.optJSONObject("node");
                            if (nodeObject.has("uid")) {
                                String uid = nodeObject.optString("uid");
                                return uid.equals(metadata.getItemUid());
                            }
                            return false;
                        }).findFirst();
                        if (filteredContent.isPresent()) {
                            return filteredContent;
                        }
                    }
                    return Optional.empty();
                };
                Object contentJson = contentDict.opt("json");
                if (contentJson instanceof JSONArray) {
                    JSONArray contentArray = (JSONArray)contentJson;
                    return AutomateCommon.enumerateContents(contentArray, renderOption, converter);
                }
                if (contentJson instanceof JSONObject) {
                    JSONObject jsonObject = (JSONObject)contentJson;
                    return AutomateCommon.enumerateContent(jsonObject, renderOption, converter);
                }
            }
            return null;
        };
        for (String pathKey : path) {
            AutomateCommon.findContent(gqlEntry, pathKey, callback);
        }
    }
}

