/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.utils.render;

import com.contentstack.utils.helper.Metadata;
import com.contentstack.utils.interfaces.NodeCallback;
import com.contentstack.utils.interfaces.Option;
import com.contentstack.utils.node.MarkType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.text.StringEscapeUtils;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class DefaultOption
implements Option {
    @Override
    public String renderOptions(JSONObject embeddedObject, Metadata metadata) {
        switch (metadata.getStyleType()) {
            case BLOCK: {
                return "<div><p>" + this.findTitleOrUid(embeddedObject) + "</p><div><p>Content type: <span>" + embeddedObject.optString("_content_type_uid") + "</span></p></div>";
            }
            case INLINE: {
                return "<span>" + this.findTitleOrUid(embeddedObject) + "</span>";
            }
            case LINK: {
                return "<a href=\"" + embeddedObject.optString("url") + "\">" + this.findTitleOrUid(embeddedObject) + "</a>";
            }
            case DISPLAY: {
                return "<img src=\"" + embeddedObject.optString("url") + "\" alt=\"" + this.findAssetTitle(embeddedObject) + "\" />";
            }
        }
        return "";
    }

    @Override
    public String renderMark(MarkType markType, String text) {
        switch (markType) {
            case SUPERSCRIPT: {
                return "<sup>" + text + "</sup>";
            }
            case SUBSCRIPT: {
                return "<sub>" + text + "</sub>";
            }
            case INLINECODE: {
                return "<span>" + text + "</span>";
            }
            case STRIKETHROUGH: {
                return "<strike>" + text + "</strike>";
            }
            case UNDERLINE: {
                return "<u>" + text + "</u>";
            }
            case ITALIC: {
                return "<em>" + text + "</em>";
            }
            case BOLD: {
                return "<strong>" + text + "</strong>";
            }
            case BREAK: {
                return "<br />" + text.replace("\n", "");
            }
        }
        return text;
    }

    private String escapeInjectHtml(JSONObject nodeObj, String nodeType) {
        String injectedHtml = this.getNodeStr(nodeObj, nodeType);
        return StringEscapeUtils.escapeHtml4((String)injectedHtml);
    }

    @Override
    public String renderNode(String nodeType, JSONObject nodeObject, NodeCallback callback) {
        String strAttrs = this.strAttrs(nodeObject);
        String children = callback.renderChildren(nodeObject.optJSONArray("children"));
        Document sanitizedChildren = Jsoup.parse((String)children);
        String cleanChildren = sanitizedChildren.body().html();
        switch (nodeType) {
            case "p": {
                return "<p" + strAttrs + ">" + cleanChildren + "</p>";
            }
            case "a": {
                return "<a" + strAttrs + " href=\"" + this.escapeInjectHtml(nodeObject, "href") + "\">" + cleanChildren + "</a>";
            }
            case "img": {
                String assetLink = this.getNodeStr(nodeObject, "asset-link");
                if (!assetLink.isEmpty()) {
                    JSONObject attrs = nodeObject.optJSONObject("attrs");
                    if (attrs.has("link")) {
                        return "<a href=\"" + this.escapeInjectHtml(nodeObject, "link") + "\" ><img" + strAttrs + " src=\"" + this.escapeInjectHtml(nodeObject, "asset-link") + "\" />" + cleanChildren + "</a>";
                    }
                    return "<img" + strAttrs + " src=\"" + this.escapeInjectHtml(nodeObject, "asset-link") + "\" />" + cleanChildren;
                }
                return "<img" + strAttrs + " src=\"" + this.escapeInjectHtml(nodeObject, "src") + "\" />" + cleanChildren;
            }
            case "embed": {
                return "<iframe" + strAttrs + " src=\"" + this.escapeInjectHtml(nodeObject, "src") + "\"" + cleanChildren + "</iframe>";
            }
            case "h1": {
                return "<h1" + strAttrs + ">" + cleanChildren + "</h1>";
            }
            case "h2": {
                return "<h2" + strAttrs + ">" + cleanChildren + "</h2>";
            }
            case "h3": {
                return "<h3" + strAttrs + ">" + cleanChildren + "</h3>";
            }
            case "h4": {
                return "<h4" + strAttrs + ">" + cleanChildren + "</h4>";
            }
            case "h5": {
                return "<h5" + strAttrs + ">" + cleanChildren + "</h5>";
            }
            case "h6": {
                return "<h6" + strAttrs + ">" + cleanChildren + "</h6>";
            }
            case "ol": {
                return "<ol" + strAttrs + ">" + cleanChildren + "</ol>";
            }
            case "ul": {
                return "<ul" + strAttrs + ">" + cleanChildren + "</ul>";
            }
            case "li": {
                return "<li" + strAttrs + ">" + cleanChildren + "</li>";
            }
            case "hr": {
                return "<hr" + strAttrs + " />";
            }
            case "table": {
                return "<table " + strAttrs + ">" + cleanChildren + "</table>";
            }
            case "thead": {
                return "<thead " + strAttrs + ">" + cleanChildren + "</thead>";
            }
            case "tbody": {
                return "<tbody" + strAttrs + ">" + cleanChildren + "</tbody>";
            }
            case "tfoot": {
                return "<tfoot" + strAttrs + ">" + cleanChildren + "</tfoot>";
            }
            case "tr": {
                return "<tr" + strAttrs + ">" + cleanChildren + "</tr>";
            }
            case "th": {
                if (nodeObject.has("attrs") && nodeObject.optJSONObject("attrs").has("void") && nodeObject.optJSONObject("attrs").optBoolean("void")) {
                    return "";
                }
                return "<th" + strAttrs + ">" + cleanChildren + "</th>";
            }
            case "td": {
                if (nodeObject.has("attrs") && nodeObject.optJSONObject("attrs").has("void") && nodeObject.optJSONObject("attrs").optBoolean("void")) {
                    return "";
                }
                return "<td" + strAttrs + ">" + cleanChildren + "</td>";
            }
            case "blockquote": {
                return "<blockquote" + strAttrs + ">" + cleanChildren + "</blockquote>";
            }
            case "code": {
                return "<code" + strAttrs + ">" + cleanChildren + "</code>";
            }
            case "reference": {
                return "";
            }
            case "fragment": {
                return "<fragment" + strAttrs + ">" + cleanChildren + "</fragment>";
            }
        }
        return cleanChildren;
    }

    String strAttrs(JSONObject nodeObject) {
        JSONObject attrsObject;
        StringBuilder result = new StringBuilder();
        if (nodeObject.has("attrs") && (attrsObject = nodeObject.optJSONObject("attrs")) != null && !attrsObject.isEmpty()) {
            for (String key : attrsObject.keySet()) {
                Object objValue = attrsObject.opt(key);
                String value = objValue.toString();
                StringBuilder escapedValue = new StringBuilder();
                for (char ch : value.toCharArray()) {
                    if (ch == '&' || ch == '<' || ch == '>' || ch == '\"' || ch == '\'') {
                        escapedValue.append("&#").append((int)ch).append(';');
                        continue;
                    }
                    escapedValue.append(ch);
                }
                value = escapedValue.toString();
                if (Objects.equals(key, "style")) {
                    String resultStyle = this.stringifyStyles(attrsObject.optJSONObject("style"));
                    result.append(" ").append(key).append("=\"").append(resultStyle).append("\"");
                    continue;
                }
                String[] ignoreKeys = new String[]{"href", "asset-link", "src", "url"};
                ArrayList<String> ignoreKeysList = new ArrayList<String>(Arrays.asList(ignoreKeys));
                if (ignoreKeysList.contains(key)) continue;
                result.append(" ").append(key).append("=\"").append(value).append("\"");
            }
        }
        return result.toString();
    }

    private String stringifyStyles(JSONObject style) {
        HashMap<String, String> styleMap = new HashMap<String, String>();
        Iterator keys = style.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = style.getString(key);
            styleMap.put(key, value);
        }
        StringBuilder styleString = new StringBuilder();
        for (Map.Entry entry : styleMap.entrySet()) {
            String property = (String)entry.getKey();
            String value = (String)entry.getValue();
            styleString.append(property).append(": ").append(value).append("; ");
        }
        return styleString.toString();
    }

    private String getNodeStr(JSONObject nodeObject, String key) {
        String herf = nodeObject.optJSONObject("attrs").optString(key);
        if (herf == null || herf.isEmpty()) {
            herf = nodeObject.optJSONObject("attrs").optString("url");
        }
        return herf;
    }

    protected String findTitleOrUid(JSONObject embeddedObject) {
        String _title = "";
        if (embeddedObject != null) {
            if (embeddedObject.has("title") && !embeddedObject.optString("title").isEmpty()) {
                _title = embeddedObject.optString("title");
            } else if (embeddedObject.has("uid")) {
                _title = embeddedObject.optString("uid");
            }
        }
        return _title;
    }

    protected String findAssetTitle(JSONObject embeddedObject) {
        String _title = "";
        if (embeddedObject != null) {
            if (embeddedObject.has("title") && !embeddedObject.optString("title").isEmpty()) {
                _title = embeddedObject.optString("title");
            } else if (embeddedObject.has("filename")) {
                _title = embeddedObject.optString("filename");
            } else if (embeddedObject.has("uid")) {
                _title = embeddedObject.optString("uid");
            }
        }
        return _title;
    }
}

