/*
 * Decompiled with CFR 0.152.
 */
package com.contentstack.utils;

import com.contentstack.utils.AutomateCommon;
import com.contentstack.utils.helper.Metadata;
import com.contentstack.utils.interfaces.ContentCallback;
import com.contentstack.utils.interfaces.MetaToEmbedCallback;
import com.contentstack.utils.interfaces.Option;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import javax.validation.constraints.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class Utils {
    static final Logger logger = Logger.getLogger(Utils.class.getName());

    public static void render(JSONObject entryObj, String[] pathString, Option renderObject) {
        block4: {
            ContentCallback callback = content -> {
                if (content instanceof JSONArray) {
                    JSONArray contentArray = (JSONArray)content;
                    return Utils.renderContents(contentArray, entryObj, renderObject);
                }
                if (content instanceof String) {
                    String contentString = (String)content;
                    return Utils.renderContent(contentString, entryObj, renderObject);
                }
                return null;
            };
            if (entryObj == null || !entryObj.has("_embedded_items")) break block4;
            if (pathString != null && pathString.length > 0) {
                for (String path : pathString) {
                    AutomateCommon.findContent(entryObj, path, callback);
                }
            } else {
                JSONObject embedKeys = entryObj.getJSONObject("_embedded_items");
                ArrayList pathKeys = new ArrayList(embedKeys.keySet());
                for (String path : pathKeys) {
                    AutomateCommon.findContent(entryObj, path, callback);
                }
            }
        }
    }

    public static String renderContent(String rteStringify, JSONObject embedObject, Option option) {
        String[] sReplaceRTE = new String[]{rteStringify};
        Document html = Jsoup.parse((String)rteStringify);
        AutomateCommon.getEmbeddedObjects(html, metadata -> {
            Optional<Object> filteredContent = Optional.empty();
            boolean available = embedObject.has("_embedded_items");
            if (available) {
                JSONObject jsonArray = embedObject.optJSONObject("_embedded_items");
                filteredContent = Utils.findEmbeddedItems(jsonArray, metadata);
            }
            if (filteredContent.isPresent()) {
                JSONObject contentToPass = (JSONObject)filteredContent.get();
                String stringOption = AutomateCommon.getStringOption(option, metadata, contentToPass);
                sReplaceRTE[0] = html.body().html().replace(metadata.getOuterHTML(), stringOption);
            }
        });
        return sReplaceRTE[0];
    }

    public static JSONArray renderContents(JSONArray rteArray, JSONObject entryObject, Option option) {
        JSONArray jsonArrayRTEContent = new JSONArray();
        for (Object RTE : rteArray) {
            String stringify = (String)RTE;
            String renderContent = Utils.renderContent(stringify, entryObject, option);
            jsonArrayRTEContent.put((Object)renderContent);
        }
        return jsonArrayRTEContent;
    }

    private static Optional<JSONObject> findEmbeddedItems(JSONObject jsonObject, Metadata metadata) {
        Set allKeys = jsonObject.keySet();
        for (String key : allKeys) {
            JSONArray jsonArray = jsonObject.optJSONArray(key);
            Optional<JSONObject> filteredContent = StreamSupport.stream(jsonArray.spliterator(), false).map(val -> (JSONObject)val).filter(val -> val.optString("uid").equalsIgnoreCase(metadata.getItemUid())).findFirst();
            if (!filteredContent.isPresent()) continue;
            return filteredContent;
        }
        return Optional.empty();
    }

    public static void jsonToHTML(@NotNull JSONArray entryArray, @NotNull String[] keyPath, @NotNull Option option) {
        entryArray.forEach(jsonObj -> Utils.jsonToHTML((JSONObject)jsonObj, keyPath, option));
    }

    public static void jsonToHTML(@NotNull JSONObject entry, @NotNull String[] keyPath, Option renderOption) {
        MetaToEmbedCallback converter = metadata -> {
            boolean available = entry.has("_embedded_items");
            if (available) {
                JSONObject jsonArray = entry.optJSONObject("_embedded_items");
                return Utils.findEmbeddedItems(jsonArray, metadata);
            }
            return Optional.empty();
        };
        ContentCallback callback = content -> {
            if (content instanceof JSONArray) {
                JSONArray contentArray = (JSONArray)content;
                return AutomateCommon.enumerateContents(contentArray, renderOption, converter);
            }
            if (content instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)content;
                return AutomateCommon.enumerateContent(jsonObject, renderOption, converter);
            }
            return null;
        };
        if (keyPath.length > 0) {
            for (String path : keyPath) {
                logger.info(path);
                AutomateCommon.findContent(entry, path, callback);
            }
        }
    }

    public static String jsonToHTML(@NotNull JSONObject jsonRTE, Option renderOption, JSONObject embeddeditems) {
        MetaToEmbedCallback converter = metadata -> {
            if (embeddeditems != null && !embeddeditems.isEmpty()) {
                return Utils.findEmbeddedItems(embeddeditems, metadata);
            }
            return Optional.empty();
        };
        return AutomateCommon.enumerateContent(jsonRTE, renderOption, converter);
    }

    public static Object jsonToHTML(@NotNull JSONArray jsonRTE, Option renderOption, JSONObject embeddeditems) {
        MetaToEmbedCallback converter = metadata -> {
            if (embeddeditems != null && !embeddeditems.isEmpty()) {
                return Utils.findEmbeddedItems(embeddeditems, metadata);
            }
            return Optional.empty();
        };
        return AutomateCommon.enumerateContents(jsonRTE, renderOption, converter);
    }

    public void render(@NotNull JSONArray jsonArray, @NotNull String[] keyPath, @NotNull Option renderObject) {
        jsonArray.forEach(jsonObj -> Utils.render((JSONObject)jsonObj, keyPath, renderObject));
    }
}

