/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent;

import com.contrastsecurity.agent.ContrastStarter;
import com.contrastsecurity.agent.injection.ClassInjector;
import java.io.File;
import java.io.InputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.security.AccessControlException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ContrastLoaderAgent {
    private static final AtomicBoolean ATTACHED;
    private static final String BASE_INJECTIONS = "/lib/contrast-agent-base-injections.jar";
    public static final File AGENT_JAR_FILE;

    public static void main(String[] args) {
        ContrastStarter.diagnostics(args);
    }

    public static void agentmain(String args, Instrumentation inst) {
        ContrastLoaderAgent.premain(args, inst);
    }

    public static void premain(String args, Instrumentation inst) {
        if (ATTACHED.getAndSet(true)) {
            System.err.println("The Contrast Agent is already attached, verify that your VM arguments don't include `-javaagent` twice for the Contrast Agent.");
            return;
        }
        long premainStart = System.nanoTime();
        long jvmUptime = ContrastLoaderAgent.getJvmUptime();
        try {
            try {
                ClassInjector.inject(inst);
            }
            catch (AccessControlException e2) {
                throw e2;
            }
            catch (Exception e3) {
                e3.printStackTrace(System.err);
                System.err.println("Unexpected error during Contrast Agent initialization. Continuing application startup without Contrast Agent....");
            }
            ContrastStarter.start(args, inst, premainStart, jvmUptime);
        }
        catch (AccessControlException e4) {
            System.err.println("When using a Java SecurityManager, the Contrast agent requires the java.security.AllPermission. Continuing without Contrast...");
            e4.printStackTrace(System.err);
        }
    }

    public static InputStream getBaseInjectionsAsStream() {
        return ContrastLoaderAgent.class.getResourceAsStream(BASE_INJECTIONS);
    }

    private static long getJvmUptime() {
        RuntimeMXBean mxBean = ManagementFactory.getRuntimeMXBean();
        return mxBean != null ? mxBean.getUptime() : 0L;
    }

    private ContrastLoaderAgent() {
    }

    static {
        File agentJar;
        ATTACHED = new AtomicBoolean();
        try {
            agentJar = new File(ContrastLoaderAgent.class.getProtectionDomain().getCodeSource().getLocation().getFile());
        }
        catch (NullPointerException e2) {
            agentJar = new File(System.getProperty("contrast.agent.location"));
        }
        AGENT_JAR_FILE = agentJar;
    }
}

