/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps;

import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.Language;
import com.contrastsecurity.agent.apps.c.a;
import com.contrastsecurity.agent.apps.c.b;
import com.contrastsecurity.agent.apps.c.c;
import com.contrastsecurity.agent.apps.java.codeinfo.LibraryFacts;
import com.contrastsecurity.agent.apps.java.f;
import com.contrastsecurity.agent.commons.l;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.eventbus.EventBus;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.frameworks.play.d;
import com.contrastsecurity.agent.plugins.frameworks.synapse.e;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.ProviderUtil;
import com.contrastsecurity.agent.s;
import com.contrastsecurity.agent.util.C;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;

@Sensor
public class ApplicationManager {
    private static final Logger a = LoggerFactory.getLogger(ApplicationManager.class);
    private final ThreadLocal<Application> b = new ThreadLocal();
    private final Set<Application> c;
    private final List<a> d;
    private boolean e;
    private boolean f;
    private final ConcurrentMap<String, LibraryFacts> g;
    private final com.contrastsecurity.agent.plugins.g h;
    private final g i;
    private AssessmentManager j;
    private ProviderUtil k;

    public ApplicationManager(g g2, com.contrastsecurity.agent.plugins.g g3) {
        this.h = g3;
        this.i = g2;
        this.e = false;
        this.c = new CopyOnWriteArraySet<Application>();
        this.d = this.a();
        this.g = Application.isGlobalApplicationNameSet(g2) ? new ConcurrentHashMap() : null;
    }

    public void initialize(AssessmentManager assessmentManager, ProviderUtil providerUtil) {
        l.a(assessmentManager);
        l.a(providerUtil);
        if (this.j != null || this.k != null) {
            throw new IllegalStateException("ApplicationManager already initialized");
        }
        this.j = assessmentManager;
        this.k = providerUtil;
    }

    private List<a> a() {
        ArrayList<a> arrayList = new ArrayList<a>();
        if (this.h != null) {
            for (ContrastPlugin object : this.h.getPlugins()) {
                arrayList.addAll(object.getApplicationResolvers());
            }
        }
        arrayList.add(new com.contrastsecurity.agent.plugins.frameworks.play.c());
        arrayList.add(new b());
        String string = this.i.b("contrast.standalone.appname");
        if (StringUtils.isNotBlank(string)) {
            if (this.h != null) {
                for (ContrastPlugin contrastPlugin : this.h.getPlugins()) {
                    contrastPlugin.onStandaloneApp();
                }
            }
            a.debug("{} is set [{}], FallbackAppResolver will be active.", (Object)"contrast.standalone.appname", (Object)string);
            arrayList.add(new c(string, this.i, this.h, this));
        }
        return arrayList;
    }

    public void current(Application application) {
        this.b.set(application);
    }

    public Application current() {
        Application application = this.b.get();
        if (application != null) {
            return application;
        }
        if (!this.f && this.e) {
            this.f = this.c();
            this.b();
        }
        for (a a2 : this.d) {
            application = a2.a(this.c);
            if (application == null) continue;
            return application;
        }
        return null;
    }

    public final boolean detectedAppContainer() {
        return this.e;
    }

    public void detectedAppContainer(boolean bl) {
        Application application = this.b.get();
        if (application instanceof f) {
            this.b.set(null);
            if (application.getInventoryState().c()) {
                this.a(application);
            }
        }
        this.e = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b() {
        List<a> list = this.d;
        synchronized (list) {
            Iterator<a> iterator = this.d.iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof c)) continue;
                a.info("Application container detected. Removing FallbackAppResolver");
                iterator.remove();
            }
        }
    }

    private boolean c() {
        boolean bl = true;
        ArrayList<Application> arrayList = new ArrayList<Application>();
        for (Application application : this.c) {
            if (!(application instanceof f)) continue;
            if (application.getInventoryState().c()) {
                a.info("Application container detected. Removing J2SEJavaApplication {} {} {}", application.getFindableApplicationName(), application.getDisplayName(), application.getPath());
                arrayList.add(application);
                continue;
            }
            a.info("Application container detected. Delaying removal of uninventoried J2SEJavaApplication {} {} {}", application.getFindableApplicationName(), application.getDisplayName(), application.getPath());
            bl = false;
        }
        this.c.removeAll(arrayList);
        return bl;
    }

    public Application createApplication(String string, Language language) {
        return this.createApplication(null, string, language);
    }

    public Application createApplication(String string, String string2, Language language) {
        Application application;
        switch (language) {
            case Java: {
                if (com.contrastsecurity.agent.util.s.d()) {
                    application = new com.contrastsecurity.agent.apps.b.a(string, this.i, this.h, this.g);
                    break;
                }
                application = new com.contrastsecurity.agent.plugins.frameworks.j2ee.a.c(string, this.i, this.h, this.g);
                break;
            }
            case Play: {
                application = new d(string, this.i, this.h, this.j, this.k, this.g, this);
                break;
            }
            case Netty: {
                application = new com.contrastsecurity.agent.plugins.frameworks.netty.b(string, this.i, this.h, this.g);
                break;
            }
            case Grizzly: {
                application = new com.contrastsecurity.agent.plugins.frameworks.grizzly.a(string, this.i, this.h, this.g);
                break;
            }
            case Undertow: {
                application = new com.contrastsecurity.agent.plugins.frameworks.undertow.a(this.i, this.h, this.g);
                break;
            }
            case Synapse: {
                application = new e(string, this.i, this.h, this.g);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown language: " + (Object)((Object)language));
            }
        }
        switch (language) {
            case Synapse: {
                C.a("The " + (Object)((Object)language) + " application framework does not support a standard naming convention.");
                C.a("You may want to add the '-Dcontrast.rootapp' JVM flag to your startup script. If you do not, this application will be reported as 'root' and may be joined with other applications in TeamServer.");
                break;
            }
        }
        application.setPath(string2);
        application.setKey("");
        this.registerApplication(application);
        return application;
    }

    private void a(Application application) {
        this.c.remove(application);
    }

    public Application findByCodeSourcePath(String string) {
        if (string == null) {
            return null;
        }
        Application application = null;
        for (Application application2 : this.c) {
            String string2;
            String string3 = application2.getResolvedPath();
            if (string3 == null || !string.contains(string2 = s.b(string3)) || (application = application2) instanceof f) continue;
            return application;
        }
        return application;
    }

    public Application findApplicationByPath(String string, Language language) {
        return this.findApplicationByPath(string, language, true);
    }

    public Application findApplicationByPath(String string, Language language, boolean bl) {
        for (Application application : this.c) {
            if (!string.equals(application.getPath())) continue;
            return application;
        }
        if (bl) {
            a.debug("Creating new application at {}", (Object)string);
            return this.createApplication(string, language);
        }
        return null;
    }

    public void registerApplication(Application application) {
        a.debug("Registering app {}", (Object)application.getDisplayName());
        this.c.add(application);
        EventBus.get().onApplicationProfiled(application);
    }

    public Set<Application> getApplications() {
        return this.c;
    }

    public List<a> getAppResolvers() {
        return this.d;
    }

    public ConcurrentMap<String, LibraryFacts> getSharedLibraryUsage() {
        return this.g;
    }
}

