/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps.exclusions;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.exclusions.InputExclusionHandler;
import com.contrastsecurity.agent.apps.exclusions.d;
import com.contrastsecurity.agent.apps.exclusions.f;
import com.contrastsecurity.agent.apps.exclusions.h;
import com.contrastsecurity.agent.apps.exclusions.l;
import com.contrastsecurity.agent.messages.app.settings.CodeExceptionDTM;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.messages.app.settings.ICodeExclusion;
import com.contrastsecurity.agent.messages.app.settings.IInputExclusion;
import com.contrastsecurity.agent.messages.app.settings.IUrlExclusion;
import com.contrastsecurity.agent.messages.app.settings.InputExceptionDTM;
import com.contrastsecurity.agent.messages.app.settings.RuleExceptionDTM;
import com.contrastsecurity.agent.messages.app.settings.UrlExceptionDTM;
import com.contrastsecurity.agent.o.i;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;

@DontObfuscate
public class DefaultExclusionProcessor
implements h {
    private final InputExclusionHandler inputExclusionHandler = new InputExclusionHandler();
    private final l urlExclusionHandler = new l();
    private final d codeExclusionHandler = new d();
    private static final Logger logger = LoggerFactory.getLogger(DefaultExclusionProcessor.class);

    DefaultExclusionProcessor(List<? extends IInputExclusion> list, List<? extends ICodeExclusion> list2, List<? extends IUrlExclusion> list3) {
        this.parseInputExclusions(list);
        this.parseCodeExclusions(list2);
        this.parseUrlExclusions(list3);
    }

    public DefaultExclusionProcessor() {
    }

    public void addRuleExceptionDTM(RuleExceptionDTM ruleExceptionDTM) {
        if (ruleExceptionDTM instanceof InputExceptionDTM) {
            this.parseInputExclusionDTM((InputExceptionDTM)ruleExceptionDTM);
        } else if (ruleExceptionDTM instanceof UrlExceptionDTM) {
            this.parseUrlExclusionDTM((UrlExceptionDTM)ruleExceptionDTM);
        } else if (ruleExceptionDTM instanceof CodeExceptionDTM) {
            this.parseCodeExclusionDTM((CodeExceptionDTM)ruleExceptionDTM);
        }
    }

    @Override
    public boolean hasQuerystringExclusions(f.a a2) {
        return this.inputExclusionHandler.hasQuerystringExclusions(a2);
    }

    @Override
    public boolean hasParameterExclusions(f.a a2) {
        return this.inputExclusionHandler.hasParameterExceptions(a2);
    }

    @Override
    public boolean hasHeaderExclusions(f.a a2) {
        return this.inputExclusionHandler.hasHeaderExceptions(a2);
    }

    @Override
    public boolean hasCookieExclusions(f.a a2) {
        return this.inputExclusionHandler.hasCookieExceptions(a2);
    }

    @Override
    public boolean isInputExclusion(f.a a2, String string, String string2, ExceptionInputTypeDTM exceptionInputTypeDTM) {
        return this.isInputExclusion(a2, string, string2, exceptionInputTypeDTM, null);
    }

    @Override
    public boolean isInputExclusion(f.a a2, String string, String string2, ExceptionInputTypeDTM exceptionInputTypeDTM, String string3) {
        switch (exceptionInputTypeDTM) {
            case BODY: {
                return this.inputExclusionHandler.isBodyExclusion(a2, string, string2);
            }
            case COOKIE: {
                return this.inputExclusionHandler.isCookieExclusion(a2, string, string2, string3);
            }
            case HEADER: {
                return this.inputExclusionHandler.isHeaderExclusion(a2, string, string2, string3);
            }
            case PARAMETER: {
                return this.inputExclusionHandler.isParameterExclusion(a2, string, string2, string3);
            }
            case QUERYSTRING: {
                return this.inputExclusionHandler.isQuerystringExclusion(a2, string, string2);
            }
        }
        logger.error("Unknown input type asked for in input exception: {}", (Object)exceptionInputTypeDTM);
        return false;
    }

    @Override
    public boolean isCodeExclusion(f.a a2, String string, i i2) {
        return i2 != null && this.codeExclusionHandler.a(a2, string, i2);
    }

    @Override
    public boolean isDisabledByUrl(f.a a2, String string, String string2) {
        return this.urlExclusionHandler.a(a2, string, string2);
    }

    @Override
    public boolean hasCodeExclusions() {
        return this.codeExclusionHandler.a();
    }

    @Override
    public boolean hasCodeExclusion(f.a a2, String string) {
        return this.codeExclusionHandler.a(a2, string);
    }

    private void parseUrlExclusions(List<? extends IUrlExclusion> list) {
        if (list != null) {
            for (IUrlExclusion iUrlExclusion : list) {
                UrlExceptionDTM urlExceptionDTM = UrlExceptionDTM.fromExclusion(iUrlExclusion);
                this.parseUrlExclusionDTM(urlExceptionDTM);
            }
        }
    }

    private void parseCodeExclusions(List<? extends ICodeExclusion> list) {
        if (list != null) {
            for (ICodeExclusion iCodeExclusion : list) {
                CodeExceptionDTM codeExceptionDTM = CodeExceptionDTM.fromExclusion(iCodeExclusion);
                this.parseCodeExclusionDTM(codeExceptionDTM);
            }
        }
    }

    private void parseInputExclusions(List<? extends IInputExclusion> list) {
        if (list != null) {
            for (IInputExclusion iInputExclusion : list) {
                InputExceptionDTM inputExceptionDTM = InputExceptionDTM.fromExclusion(iInputExclusion);
                this.parseInputExclusionDTM(inputExceptionDTM);
            }
        }
    }

    private void parseInputExclusionDTM(InputExceptionDTM inputExceptionDTM) {
        this.inputExclusionHandler.process(inputExceptionDTM);
    }

    private void parseCodeExclusionDTM(CodeExceptionDTM codeExceptionDTM) {
        this.codeExclusionHandler.a(codeExceptionDTM);
    }

    private void parseUrlExclusionDTM(UrlExceptionDTM urlExceptionDTM) {
        this.urlExclusionHandler.a(urlExceptionDTM);
    }
}

