/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps.exclusions;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.exclusions.f;
import com.contrastsecurity.agent.apps.exclusions.i;
import com.contrastsecurity.agent.apps.exclusions.j;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.messages.app.settings.InputExceptionDTM;
import com.contrastsecurity.agent.messages.app.settings.UrlMatchingStrategyDTM;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@DontObfuscate
public class InputExclusionHandler {
    private Map<String, List<j>> globalParameterExclusions;
    private a<List<j>> globalHeaderExclusions;
    private Map<String, List<j>> globalCookieExclusions;
    private Map<String, List<j>> querystringExclusions;
    private Map<String, List<j>> bodyExclusions;
    private Map<String, Map<String, List<j>>> cookieExclusions;
    private Map<String, Map<String, List<j>>> parameterExclusions;
    private Map<String, a<List<j>>> headerExclusions;
    private boolean hasAssessModeQuerystringExclusions;
    private boolean hasAssessModeBodyExclusions;
    private boolean hasAssessModeCookieExclusions;
    private boolean hasAssessModeHeaderExclusions;
    private boolean hasAssessModeParameterExclusions;
    private boolean hasDefendModeQuerystringExclusions;
    private boolean hasDefendModeBodyExclusions;
    private boolean hasDefendModeCookieExclusions;
    private boolean hasDefendModeHeaderExclusions;
    private boolean hasDefendModeParameterExclusions;
    private static final String ALL = "*";
    private static final Logger logger = LoggerFactory.getLogger(InputExclusionHandler.class);

    public boolean hasQuerystringExclusions(f.a a2) {
        return f.a.a.equals((Object)a2) ? this.hasAssessModeQuerystringExclusions : this.hasDefendModeQuerystringExclusions;
    }

    public boolean hasParameterExceptions(f.a a2) {
        return f.a.a.equals((Object)a2) ? this.hasAssessModeParameterExclusions : this.hasDefendModeParameterExclusions;
    }

    public boolean hasHeaderExceptions(f.a a2) {
        return f.a.a.equals((Object)a2) ? this.hasAssessModeHeaderExclusions : this.hasDefendModeHeaderExclusions;
    }

    public boolean hasCookieExceptions(f.a a2) {
        return f.a.a.equals((Object)a2) ? this.hasAssessModeCookieExclusions : this.hasDefendModeCookieExclusions;
    }

    public boolean isParameterExclusion(f.a a2, String string, String string2, String string3) {
        Map<String, List<j>> map;
        if (this.globalParameterExclusions != null && !this.globalParameterExclusions.isEmpty()) {
            map = this.globalParameterExclusions.get(string);
            if (this.exceptionMatches(a2, string2, string3, (List<j>)((Object)map))) {
                return true;
            }
            map = this.globalParameterExclusions.get("all-rules");
            if (this.exceptionMatches(a2, string2, string3, (List<j>)((Object)map))) {
                return true;
            }
            map = this.globalParameterExclusions.get(f.a.a.equals((Object)a2) ? "all-assess-rules" : "all-defend-rules");
            if (this.exceptionMatches(a2, string2, string3, (List<j>)((Object)map))) {
                return true;
            }
        }
        if (string3 != null && this.parameterExclusions != null && !this.parameterExclusions.isEmpty()) {
            List<j> list;
            map = this.parameterExclusions.get(string);
            if (map != null && this.exceptionMatches(a2, string2, string3, list = (List<j>)map.get(string3))) {
                return true;
            }
            map = this.parameterExclusions.get("all-rules");
            if (map != null && this.exceptionMatches(a2, string2, string3, list = (List)map.get(string3))) {
                return true;
            }
            map = this.parameterExclusions.get(f.a.a.equals((Object)a2) ? "all-assess-rules" : "all-defend-rules");
            if (map != null && this.exceptionMatches(a2, string2, string3, list = map.get(string3))) {
                return true;
            }
        }
        return false;
    }

    public boolean isHeaderExclusion(f.a a2, String string, String string2, String string3) {
        if (this.globalHeaderExclusions != null && !this.globalHeaderExclusions.a()) {
            if (this.exceptionMatches(a2, string2, string3, this.globalHeaderExclusions.a(string))) {
                return true;
            }
            if (this.exceptionMatches(a2, string2, string3, this.globalHeaderExclusions.a("all-rules"))) {
                return true;
            }
            if (this.exceptionMatches(a2, string2, string3, this.globalHeaderExclusions.a(f.a.a.equals((Object)a2) ? "all-assess-rules" : "all-defend-rules"))) {
                return true;
            }
        }
        if (string3 != null && this.headerExclusions != null && !this.headerExclusions.isEmpty()) {
            List<j> list;
            a<List<j>> a3 = this.headerExclusions.get(string);
            if (a3 != null && this.exceptionMatches(a2, string2, string3, list = a3.a(string3))) {
                return true;
            }
            a3 = this.headerExclusions.get("all-rules");
            if (a3 != null && this.exceptionMatches(a2, string2, string3, list = a3.a(string3))) {
                return true;
            }
            a3 = this.headerExclusions.get(f.a.a.equals((Object)a2) ? "all-assess-rules" : "all-defend-rules");
            if (a3 != null && this.exceptionMatches(a2, string2, string3, list = a3.a(string3))) {
                return true;
            }
        }
        return false;
    }

    public boolean isCookieExclusion(f.a a2, String string, String string2, String string3) {
        if (this.globalCookieExclusions != null) {
            if (this.exceptionMatches(a2, string2, string3, this.globalCookieExclusions.get(string))) {
                return true;
            }
            if (this.exceptionMatches(a2, string2, string3, this.globalCookieExclusions.get("all-rules"))) {
                return true;
            }
            if (this.exceptionMatches(a2, string2, string3, this.globalCookieExclusions.get(f.a.a.equals((Object)a2) ? "all-assess-rules" : "all-defend-rules"))) {
                return true;
            }
        }
        if (string3 != null && this.cookieExclusions != null && !this.cookieExclusions.isEmpty()) {
            List<j> list;
            Map<String, List<j>> map = this.cookieExclusions.get(string);
            if (map != null && this.exceptionMatches(a2, string2, string3, list = map.get(string3))) {
                return true;
            }
            map = this.cookieExclusions.get("all-rules");
            if (map != null && this.exceptionMatches(a2, string2, string3, list = map.get(string3))) {
                return true;
            }
            map = this.cookieExclusions.get(f.a.a.equals((Object)a2) ? "all-assess-rules" : "all-defend-rules");
            if (map != null && this.exceptionMatches(a2, string2, string3, list = map.get(string3))) {
                return true;
            }
        }
        return false;
    }

    public boolean isQuerystringExclusion(f.a a2, String string, String string2) {
        if (this.querystringExclusions != null) {
            List<j> list = this.querystringExclusions.get(string);
            if (this.hasExceptionsFor(a2, string2, list)) {
                return true;
            }
            list = this.querystringExclusions.get("all-rules");
            if (this.hasExceptionsFor(a2, string2, list)) {
                return true;
            }
            list = this.querystringExclusions.get(f.a.a.equals((Object)a2) ? "all-assess-rules" : "all-defend-rules");
            if (this.hasExceptionsFor(a2, string2, list)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasExceptionsFor(f.a a2, String string, List<j> list) {
        if (list != null && !list.isEmpty()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                j j2 = list.get(i2);
                if ((!f.a.a.equals((Object)a2) || !j2.c()) && (!f.a.b.equals((Object)a2) || !j2.d()) || !j2.a(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isBodyExclusion(f.a a2, String string, String string2) {
        if (this.bodyExclusions == null || this.bodyExclusions.isEmpty()) {
            return false;
        }
        if (this.hasExceptionsFor(a2, string2, this.bodyExclusions.get(string))) {
            return true;
        }
        if (this.hasExceptionsFor(a2, string2, this.bodyExclusions.get("all-rules"))) {
            return true;
        }
        return this.hasExceptionsFor(a2, string2, this.bodyExclusions.get(f.a.a.equals((Object)a2) ? "all-assess-rules" : "all-defend-rules"));
    }

    private boolean exceptionMatches(f.a a2, String string, String string2, List<j> list) {
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                j j2 = list.get(i2);
                if (i.a(j2, a2) && j2.a(string)) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Exception applies to parameter {} on {}/{} in mode {}", new Object[]{j2.a(), j2.b(), string, a2});
                    }
                    return true;
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Exception for {}/{} didn't match for parameter {} in mode {}", new Object[]{j2.a(), string, string2, a2});
            }
        }
        return false;
    }

    public void process(InputExceptionDTM inputExceptionDTM) {
        int n2;
        boolean bl;
        if (!i.a(inputExceptionDTM)) {
            return;
        }
        ExceptionInputTypeDTM exceptionInputTypeDTM = inputExceptionDTM.getInputType();
        if (exceptionInputTypeDTM == null) {
            logger.error("No exclusion input type for {}", (Object)inputExceptionDTM.getName());
            return;
        }
        String string = inputExceptionDTM.getInputName();
        if (StringUtils.isEmpty(string) && exceptionInputTypeDTM.isNamed()) {
            logger.error("No input name for type {} for {}, ignoring", (Object)exceptionInputTypeDTM, (Object)inputExceptionDTM.getName());
            return;
        }
        List<String> list = inputExceptionDTM.getAssessmentRules();
        List<String> list2 = inputExceptionDTM.getRules();
        boolean bl2 = list != null && list.isEmpty();
        boolean bl3 = bl = list2 != null && list2.isEmpty();
        if (bl2 && bl) {
            this.processException("all-rules", exceptionInputTypeDTM, inputExceptionDTM, true, true);
        } else if (bl2) {
            this.processException("all-assess-rules", exceptionInputTypeDTM, inputExceptionDTM, true, false);
        } else if (bl) {
            this.processException("all-defend-rules", exceptionInputTypeDTM, inputExceptionDTM, false, true);
        }
        if (list != null) {
            for (n2 = 0; n2 < list.size(); ++n2) {
                this.processException(list.get(n2), exceptionInputTypeDTM, inputExceptionDTM, true, false);
            }
        }
        if (list2 != null) {
            for (n2 = 0; n2 < list2.size(); ++n2) {
                this.processException(list2.get(n2), exceptionInputTypeDTM, inputExceptionDTM, false, true);
            }
        }
    }

    private void processException(String string, ExceptionInputTypeDTM exceptionInputTypeDTM, InputExceptionDTM inputExceptionDTM, boolean bl, boolean bl2) {
        j j2 = new j(inputExceptionDTM.getName(), string, bl, bl2, inputExceptionDTM.getUrls(), inputExceptionDTM.getMatchStrategy() == null ? UrlMatchingStrategyDTM.ALL : inputExceptionDTM.getMatchStrategy(), exceptionInputTypeDTM, inputExceptionDTM.getInputName());
        switch (exceptionInputTypeDTM) {
            case COOKIE: {
                this.addCookie(string, j2);
                break;
            }
            case HEADER: {
                this.addHeader(string, j2);
                break;
            }
            case PARAMETER: {
                this.addParameter(string, j2);
                break;
            }
            case QUERYSTRING: {
                this.addQuerystring(string, j2);
                break;
            }
            case BODY: {
                this.addBody(string, j2);
                break;
            }
            default: {
                logger.error("Unknown exception type {} -- nothing added", (Object)exceptionInputTypeDTM);
            }
        }
    }

    void addBody(String string, j j2) {
        List<j> list;
        if (this.bodyExclusions == null) {
            this.bodyExclusions = new HashMap<String, List<j>>();
        }
        if ((list = this.bodyExclusions.get(string)) == null) {
            list = new LinkedList<j>();
            this.bodyExclusions.put(string, list);
        }
        list.add(j2);
        this.hasAssessModeBodyExclusions = this.hasAssessModeBodyExclusions || j2.c();
        this.hasDefendModeBodyExclusions = this.hasDefendModeBodyExclusions || j2.d();
    }

    void addQuerystring(String string, j j2) {
        List<j> list;
        if (this.querystringExclusions == null) {
            this.querystringExclusions = new HashMap<String, List<j>>();
        }
        if ((list = this.querystringExclusions.get(string)) == null) {
            list = new LinkedList<j>();
            this.querystringExclusions.put(string, list);
        }
        list.add(j2);
        this.hasAssessModeQuerystringExclusions = this.hasAssessModeQuerystringExclusions || j2.c();
        this.hasDefendModeQuerystringExclusions = this.hasDefendModeQuerystringExclusions || j2.d();
    }

    void addCookie(String string, j j2) {
        String string2 = j2.f();
        if (ALL.equals(string2)) {
            List<j> list;
            if (this.globalCookieExclusions == null) {
                this.globalCookieExclusions = new HashMap<String, List<j>>();
            }
            if ((list = this.globalCookieExclusions.get(string)) == null) {
                list = new LinkedList<j>();
                this.globalCookieExclusions.put(string, list);
            }
            list.add(j2);
        } else {
            List<j> list;
            Map<String, List<j>> map;
            if (this.cookieExclusions == null) {
                this.cookieExclusions = new HashMap<String, Map<String, List<j>>>();
            }
            if ((map = this.cookieExclusions.get(string)) == null) {
                map = new HashMap<String, List<j>>();
                this.cookieExclusions.put(string, map);
            }
            if ((list = map.get(string2)) == null) {
                list = new LinkedList<j>();
                map.put(string2, list);
            }
            list.add(j2);
        }
        this.hasAssessModeCookieExclusions = this.hasAssessModeCookieExclusions || j2.c();
        this.hasDefendModeCookieExclusions = this.hasDefendModeCookieExclusions || j2.d();
    }

    void addHeader(String string, j j2) {
        String string2 = j2.f();
        if (ALL.equals(string2)) {
            List<j> list;
            if (this.globalHeaderExclusions == null) {
                this.globalHeaderExclusions = new a();
            }
            if ((list = this.globalHeaderExclusions.a(string)) == null) {
                list = new LinkedList<j>();
                this.globalHeaderExclusions.a(string, list);
            }
            list.add(j2);
        } else {
            List<j> list;
            a<List<j>> a2;
            if (this.headerExclusions == null) {
                this.headerExclusions = new HashMap<String, a<List<j>>>();
            }
            if ((a2 = this.headerExclusions.get(string)) == null) {
                a2 = new a();
                this.headerExclusions.put(string, a2);
            }
            if ((list = a2.a(string2)) == null) {
                list = new LinkedList<j>();
                a2.a(string2, list);
            }
            list.add(j2);
        }
        this.hasAssessModeHeaderExclusions = this.hasAssessModeHeaderExclusions || j2.c();
        this.hasDefendModeHeaderExclusions = this.hasDefendModeHeaderExclusions || j2.d();
    }

    void addParameter(String string, j j2) {
        String string2 = j2.f();
        if (ALL.equals(string2)) {
            List<j> list;
            if (this.globalParameterExclusions == null) {
                this.globalParameterExclusions = new HashMap<String, List<j>>();
            }
            if ((list = this.globalParameterExclusions.get(string)) == null) {
                list = new LinkedList<j>();
                this.globalParameterExclusions.put(string, list);
            }
            list.add(j2);
        } else {
            List<j> list;
            Map<String, List<j>> map;
            if (this.parameterExclusions == null) {
                this.parameterExclusions = new HashMap<String, Map<String, List<j>>>();
            }
            if ((map = this.parameterExclusions.get(string)) == null) {
                map = new HashMap<String, List<j>>();
                this.parameterExclusions.put(string, map);
            }
            if ((list = map.get(string2)) == null) {
                list = new LinkedList<j>();
                map.put(string2, list);
            }
            list.add(j2);
        }
        this.hasAssessModeParameterExclusions = this.hasAssessModeParameterExclusions || j2.c();
        this.hasDefendModeParameterExclusions = this.hasDefendModeParameterExclusions || j2.d();
    }

    private static final class a<T> {
        HashMap<String, T> a = new HashMap();

        a() {
        }

        T a(String string) {
            return this.a.get(string != null ? string.toLowerCase() : string);
        }

        void a(String string, T t2) {
            this.a.put(string != null ? string.toLowerCase() : string, t2);
        }

        boolean a() {
            return this.a.isEmpty();
        }
    }
}

