/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.apps.java.codeinfo;

import com.contrastsecurity.agent.B;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.l;
import com.contrastsecurity.agent.messages.app.info.LibraryDTM;
import com.contrastsecurity.thirdparty.com.google.gson.annotations.SerializedName;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

@DontObfuscate
public final class LibraryFacts {
    private final String hash;
    private final Set<String> usedClasses;
    @SerializedName(value="file")
    private String jarName;
    private long internalDate;
    private long externalDate;
    private String manifestInfo;
    private int classCount;
    private URL url;
    private String versionCaptured;
    private String tags;

    @B
    public LibraryFacts() {
        this("hash");
    }

    public LibraryFacts(String string) {
        this.hash = l.a(string, "hash");
        this.usedClasses = new HashSet<String>();
    }

    public String getHash() {
        return this.hash;
    }

    public String getFile() {
        return this.jarName;
    }

    public void setFile(String string) {
        this.jarName = string.toLowerCase();
    }

    public Set<String> getUsedClasses() {
        return this.usedClasses;
    }

    public long getInternalDate() {
        return this.internalDate;
    }

    public void setInternalDate(long l2) {
        this.internalDate = l2;
    }

    public long getExternalDate() {
        return this.externalDate;
    }

    public void setExternalDate(long l2) {
        this.externalDate = l2;
    }

    public String getManifestInfo() {
        return this.manifestInfo;
    }

    public void setManifestInfo(String string) {
        this.manifestInfo = string;
    }

    public int getClassCount() {
        return this.classCount;
    }

    public void setClassCount(int n2) {
        this.classCount = n2;
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL uRL) {
        this.url = uRL;
    }

    public LibraryDTM toDTM() {
        return LibraryDTM.builder().file(this.getFile()).hash(this.getHash()).internalDate(this.getInternalDate()).externalDate(this.getExternalDate()).manifest(this.getManifestInfo()).classCount(this.getClassCount()).usedClassCount(this.getUsedClasses().size()).tags(this.getTags()).build();
    }

    public String getVersionCaptured() {
        return this.versionCaptured;
    }

    public void setVersionCaptured(String string) {
        this.versionCaptured = string;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String string) {
        this.tags = string;
    }

    public String toString() {
        return "\n\tHash    : " + this.getHash() + "\n\tIDate   : " + this.getInternalDate() + "\n\tEDate   : " + this.getExternalDate() + "\n\tClasses : " + this.classCount + "\n\tUsed    : " + this.getUsedClasses().size() + "\n\tManifest: " + this.getManifestInfo();
    }

    public void addUsedClass(String string) {
        this.usedClasses.add(string);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LibraryFacts libraryFacts = (LibraryFacts)object;
        return this.hash.equals(libraryFacts.hash);
    }

    public int hashCode() {
        return this.hash.hashCode();
    }
}

