/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.config;

import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.config.ActiveProperty;
import com.contrastsecurity.agent.config.RetirementNotice;
import com.contrastsecurity.agent.config.b;
import com.contrastsecurity.agent.config.enums.SaveReportMode;
import com.contrastsecurity.agent.config.enums.TraceMapStrategy;
import com.contrastsecurity.agent.d.e;
import com.contrastsecurity.agent.messages.app.settings.ApplicationAssessSettingsDTM;
import com.contrastsecurity.agent.messages.app.settings.ApplicationSettingsDTM;
import com.contrastsecurity.agent.messages.app.settings.defend.ProtectionModeDTM;
import com.contrastsecurity.agent.messages.server.features.DefendFeatures;
import com.contrastsecurity.agent.messages.server.features.FeatureSet;
import com.contrastsecurity.agent.messages.server.features.defend.SyslogSeverity;
import java.util.Map;
import java.util.Set;

@Sensor
public final class ContrastProperties {
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, hidden=true, defaultValue="2020-04-01", description="Date and time (format yyyy-MM-dd 00:00:00z) at which to start the Protect SQLi semantic analysis experiment")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.stx.sqli_semantic.start_date")
    public static final String TELEMETRY_SEMANTIC_SQL_START_DATE = "agent.java.stx.sqli_semantic.start_date";
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, hidden=true, defaultValue="2020-05-01", description="Date and time (format yyyy-MM-dd 00:00:00z) after which to the Protect SQLi semantic analysis experiment expires")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.stx.sqli_semantic.expired_date")
    public static final String TELEMETRY_SEMANTIC_SQL_EXPIRATION_DATE = "agent.java.stx.sqli_semantic.expired_date";
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, hidden=true, type=Long.class, defaultValue="300000", description="Interval in millis for reporting Protect SQLi semantic analysis telemetry data")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.stx.sqli_semantic.report_interval_ms", c=Long.class)
    public static final String TELEMETRY_SEMANTIC_SQL_REPORT_INTERVAL = "agent.java.stx.sqli_semantic.report_interval_ms";
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, hidden=true, type=Integer.class, defaultValue="300000", description="frequency (expres in number of queries) with which to report SQL queries for the Protect SQLi semantic analysis experiment")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.stx.sqli_semantic.sample_spacing", c=Integer.class)
    public static final String TELEMETRY_SEMANTIC_SQL_SAMPLE_SPACING = "agent.java.stx.sqli_semantic.sample_spacing";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, hidden=true, type=Integer.class, defaultValue="30000", description="the time to live(in milliseconds) whereby a configuration setting is allowed to be cached before re-reading, 0 means no caching allowed")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.config_caching_ttl_ms", c=Integer.class)
    public static final String CONFIGURATON_CACHE_TTL = "contrast.config.caching.ttl";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Boolean.class, defaultValue="true", hidden=true, description="if true, system properties can be cached at startup, otherwise they will be read live from System.getProperty() every time and may cause performance issues under heavy concurrent load")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_system_property_caching", c=Boolean.class)
    public static final String CACHE_SYSTEM_PROPERTIES = "contrast.systemproperties.caching";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Boolean.class, defaultValue="true", hidden=true, description="Set to false to force the agent to discover the Java runtime class hierarchy each time it starts up. You might want to do this if there is reason to believe our pre-cached snapshot of the runtime hierarchy is insufficient, but it will increase agent startup time. By default the agent uses a prepackaged cache to improve startup time.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.runtime_hierachy_cache", c=Boolean.class)
    public static final String USE_RUNTIME_CACHE = "contrast.agent.java.runtime_hierachy_cache";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="Metadata from the agent to Contrast UI defined. The format should be HTTP Request header compatible where key=value pairs are separated by semicolons. Spaces between key and value and between entries is not significant. (e.g. key=value; key=value)")
    @com.contrastsecurity.agent.config.f.d(a="application.metadata", d=true)
    public static final String AGENT_METADATA = "contrast.agent.metadata";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="Provide the ID of a session which already exists in the Contrast UI. Vulnerabilities discovered by the agent are associated with this session. If an invalid ID is supplied, the agent will be disabled. This option and `application.session_metadata` are mutually exclusive; if both are set, the agent will be disabled.")
    @com.contrastsecurity.agent.config.f.d(a="application.session_id", d=true)
    @com.contrastsecurity.agent.config.a(a=b.class)
    public static final String SESSION_ID = "application.session_id";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="Provide metadata which is used to create a new session ID in the Contrast UI. Vulnerabilities discovered by the agent are associated with this new session. This value should be formatted as key=value pairs (conforming to RFC 2253). Available key names for this configuration are branchName, buildNumber, commitHash, committer, gitTag, repository, testRun, and version. This option and `application.session_id` are mutually exclusive; if both are set the agent will be disabled.")
    @com.contrastsecurity.agent.config.f.d(a="application.session_metadata", d=true)
    public static final String SESSION_METADATA = "application.session_metadata";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, hidden=true, defaultValue="2", description="threshold of exceptions thrown from a type's toString() method before the type is considered problematic")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.length_error_threshold", c=Integer.class)
    public static final String ASSESS_LENGTH_ERROR_THRESHOLD = "contrast.assess.length-error.threshold";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Integer.class, defaultValue="-1", description="if specified, tells Contrast how long to run the agent before shutting down itself (in milliseconds), a negative value disables scheduled shutdown")
    @com.contrastsecurity.agent.config.f.d(a="agent.shutdown_time_ms", c=Integer.class)
    public static final String SCHEDULED_SHUTDOWN_TIME = "contrast.shutdown.time";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, defaultValue="false", type=Boolean.class, description="on shutdown, actually causes deinstrumentation classes instead of just disabling sensors")
    @com.contrastsecurity.agent.config.f.d(a="agent.deinstrument_on_shutdown", c=Boolean.class)
    public static final String DEINSTRUMENT_ON_SHUTDOWN = "contrast.shutdown.deinstrument";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, defaultValue="false", type=Boolean.class, description="whether or not automatic boot delegation of agent classes is weaved into ClassLoaders")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.automatic_boot_delegation", c=Boolean.class)
    public static final String AUTOMATIC_BOOTDELEGATION = "contrast.automaticbootdelegation";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Integer.class, nullDefaultValue=true, hidden=true, description="the percentage chance that the agent should startup (values are 1-99 inclusive)")
    @com.contrastsecurity.agent.config.f.d(a="agent.probabilistic_startup", c=Integer.class)
    public static final String PROBABILISTIC_STARTUP = "contrast.startup.probabilistic";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Boolean.class, defaultValue="true", description="limits the manifest information reported for libraries")
    @com.contrastsecurity.agent.config.f.d(a="inventory.prune_package_details", c=Boolean.class)
    public static final String INVENTORY_PRUNE_LIBRARY_MANIFEST = "contrast.inventory.prune.library.manifest";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Boolean.class, defaultValue="true", description="controls whether libraries are analyzed")
    @com.contrastsecurity.agent.config.f.d(a="inventory.analyze_libraries", c=Boolean.class)
    @com.contrastsecurity.agent.config.p(a=T.class)
    public static final String INVENTORY_LIBRARIES = "contrast.inventory.libraries";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, type=Boolean.class, defaultValue="true", description="controls whether library usage is reported")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.library_usage.reporting.enable", c=Boolean.class)
    public static final String LIBRARY_USAGE_REPORTING = "contrast.libraries.reporting";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, nullDefaultValue=true, description="set by the launcher agent to tell agents where the location of the agent jar", hidden=true)
    @com.contrastsecurity.agent.config.f(a="TODO: looks launcher related. Remove.")
    public static final String AGENT_LOCATION = "contrast.agent.location";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, type=Boolean.class, defaultValue="true", description="set for debugging purposes, tells the Agent not to compress HTTP Request payloads; default true", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_http_compression", c=Boolean.class)
    public static final String USE_HTTP_COMPRESSION = "contrast.agent.http.compression";
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, type=Boolean.class, defaultValue="false", description="whether or not certificate errors are ignored when talking to TeamServer")
    @com.contrastsecurity.agent.config.f.d(a="api.ignore_cert_errors", b={"contrast.ignore_cert_errors"}, c=Boolean.class)
    public static final String IGNORE_CERTIFICATE_ERRORS = "contrast.agent.http.ignorecerterrors";
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, type=Boolean.class, defaultValue="false", description="set SNI information on TLS extension manually to avoid JDK bugs where the information is not sent in niche cases", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="api.explicit_sni_socket_factory", c=Boolean.class)
    public static final String EXPLICIT_SNI_SOCKET_FACTORY = "contrast.api.explicit_sni_socket_factory";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, type=Boolean.class, defaultValue="false", description="true, if the agent should send telemetry MQ messages -- false otherwise", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.mq_reporter.enable", c=Boolean.class)
    public static final String MQ_TELEMETRY = "contrast.mq";
    private static final String a = "localhost";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, defaultValue="localhost", description="if contrast.mq is true, this allows us to specify the MQ host name", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.mq_reporter.hostname")
    public static final String MQ_HOST_NAME = "contrast.mq.host.name";
    private static final String b = "5672";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, type=Integer.class, defaultValue="5672", description="if contrast.mq is true, this allows us to specify the MQ port", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.mq_reporter.port", c=Integer.class)
    public static final String MQ_PORT = "contrast.mq.host.port";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, nullDefaultValue=true, description="Optional property, if contrast.mq is true, this allows us to specify the username for the MQ connection", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.mq_reporter.username")
    public static final String MQ_USERNAME = "contrast.agent.java.mq_reporter.usernam";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, nullDefaultValue=true, description="Optional property, if contrast.mq is true, this allows us to specify the password for the MQ connection", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.mq_reporter.password")
    public static final String MQ_PASSWORD = "contrast.agent.java.mq_reporter.password";
    private static final String c = "contrastEvents";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, defaultValue="contrastEvents", description="if contrast.mq is true, this allows us to specify the MQ queue name", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.mq_reporter.queue_name")
    public static final String MQ_QUEUE_NAME = "contrast.mq.queue.name";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, type=Boolean.class, defaultValue="false", description="set for debugging purposes, tells the Agent to print to stdout purgeable metrics", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.report_purgeables", c=Boolean.class)
    public static final String PROFILE_PURGEABLES = "contrast.profile.purgeables";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, type=Boolean.class, defaultValue="false", description="set for debugging purposes, tells the Agent to print to stdout metrics about per-request data collection", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.report_context_metrics", c=Boolean.class)
    public static final String PROFILE_CONTEXT_METRICS = "contrast.profile.contextmetrics";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, type=Boolean.class, defaultValue="false", description="set for debugging purposes, tells the Agent to print to stdout startup metrics", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.report_startup_metrics", c=Boolean.class)
    public static final String PROFILE_STARTUP = "contrast.profile.startup";
    public static final int MAP_TIMEOUT_MS_DEFAULT = 30000;
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, hidden=true, type=Integer.class, defaultValue="30000", description="number of milliseconds to allow strongly reachable threads to pass thread context. Defaults to 30000 (30 seconds in milliseconds).")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.context_thread_timeout_ms", c=Integer.class)
    public static final String CONTEXT_MAP_PURGE_TIMEOUT = "contrast.context.purge.timeout";
    public static final int CONTEXT_MAP_PURGE_ENTRY_MINIMUM_DEFAULT = 350;
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, hidden=true, type=Integer.class, defaultValue="350", description="number of threads to concurrently manage in our context manager before we proactively purge strongly reachable threads")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.context_minimum_threads", c=Integer.class)
    public static final String CONTEXT_MAP_PURGE_ENTRY_MINIMUM = "contrast.context.purge.minimum";
    public static final int WEB_SESSION_TIMEOUT_MINUTES_DEFAULT = 30;
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Integer.class, defaultValue="30", description="Overrides the maximum \"safe\" session timeout value to check against the <session-timeout> detected in the application web.xml file, ServletContext.setSessionTimeout(int), or Spring Boot application.properties. The default value is 30 (minutes).")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.web_session_timeout", c=Integer.class)
    public static final String WEB_SESSION_TIMEOUT = "web.session.timeout";
    @ActiveProperty(type=Boolean.class, defaultValue="true", description="Controls whether or not String interning is disabled in Jackson. The default value is true.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_jackson_intern", c=Boolean.class)
    public static final String JACKSON_INTERN_ENABLE = "contrast.supporter.jackson.interning";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable instrumentation of standard Antlr classes")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_antlr_support", c=Boolean.class)
    public static final String SUPPORTER_ANTLR = "contrast.supporter.antlr";
    @RetirementNotice(retiringProperty="apache.file.uploader.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean enable/disable support of Apache Commons FileUpload library")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_apache_fileupload_support", c=Boolean.class)
    public static final String SUPPORTER_APACHE_FILE_UPLOAD = "contrast.supporter.apache.file.uploader";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean enable/disable support of Apache ActiveMQ library")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_activemq_support", c=Boolean.class)
    public static final String SUPPORTER_APACHE_ACTIVEMQ = "contrast.supporter.apache.activemq";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean enable/disable support of Apache HTTP Client")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_apache_client_support", c=Boolean.class)
    public static final String SUPPORTER_APACHE_CLIENT = "contrast.supporter.apache.client";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean enable/disable support of Apache Request Library")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_apache_request_support", c=Boolean.class)
    public static final String SUPPORT_APACHE_REQUEST = "contrast.supporter.apache.request";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="false", description="boolean enable/disable support of special sensors to avoid conflicts with AppDynamics")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_app_dynamics_support", c=Boolean.class)
    public static final String SUPPORTER_APP_DYNAMICS = "contrast.supporter.appdynamics";
    @RetirementNotice(retiringProperty="apache.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable support/instrumentation of Apache HTTP libraries")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_apache_http_support", c=Boolean.class)
    public static final String SUPPORTER_APACHE = "contrast.supporter.apache";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable support/instrumentation of AWS HTTP client")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_aws_client_support", c=Boolean.class)
    public static final String SUPPORTER_AWS = "contrast.supporter.aws";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable support/instrumentation of AWS Dynamo client")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_aws_dynamo_support", c=Boolean.class)
    public static final String SUPPORTER_AWS_DYNAMODB = "contrast.supporter.aws_dynamodb";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable support for Carbon")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_carbon_support", c=Boolean.class)
    public static final String SUPPORTER_CARBON = "contrast.supporter.carbon";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable support for Struts2 applications")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_struts2_support", c=Boolean.class)
    public static final String SUPPORTER_STRUTS2 = "contrast.supporter.struts2";
    @RetirementNotice(retiringProperty="coverity.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable instrumentation of Coverity")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_coverity_support", c=Boolean.class)
    public static final String SUPPORTER_COVERITY = "contrast.supporter.coverity";
    @RetirementNotice(retiringProperty="concurrency.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable instrumentation of Java Concurrency classes")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_concurrency_support", c=Boolean.class)
    public static final String SUPPORTER_CONCURRENCY = "contrast.supporter.concurrency";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable support for DropWizard applications")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_dropwizard_support", c=Boolean.class)
    public static final String SUPPORTER_DROPWIZARD = "contrast.supporter.dropwizard";
    @RetirementNotice(retiringProperty="dwr.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Direct Web Remoting support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_dwr_support", c=Boolean.class)
    public static final String SUPPORTER_DWR = "contrast.supporter.dwr";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Equinox support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_equinox_support", c=Boolean.class)
    public static final String SUPPORTER_EQUINOX = "contrast.supporter.equinox";
    @RetirementNotice(retiringProperty="esapi.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable instrumentation of ESAPI classes")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_esapi_support", c=Boolean.class)
    public static final String SUPPORTER_ESAPI = "contrast.supporter.esapi";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Apache Felix support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_apache_felix_support", c=Boolean.class)
    public static final String SUPPORTER_FELIX = "contrast.supporter.felix";
    @RetirementNotice(retiringProperty="freemarker.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable FreeMarker support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_freemarker_support", c=Boolean.class)
    public static final String SUPPORTER_FREEMARKER = "contrast.supporter.freemarker";
    @RetirementNotice(retiringProperty="grizzy.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Grizzly support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_grizzly_support", c=Boolean.class)
    public static final String SUPPORTER_GRIZZLY = "contrast.supporter.grizzly";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Grails support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_grails_support", c=Boolean.class)
    public static final String SUPPORTER_GRAILS = "contrast.supporter.grails";
    @RetirementNotice(retiringProperty="groovy.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Groovy support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_groovy_support", c=Boolean.class)
    public static final String SUPPORTER_GROOVY = "contrast.supporter.groovy";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Hibernate support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_hibernate_support", c=Boolean.class)
    public static final String SUPPORTER_HIBERNATE = "contrast.supporter.hibernate";
    @RetirementNotice(retiringProperty="jboss.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable JBoss support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_jboss_support", c=Boolean.class)
    public static final String SUPPORTER_JBOSS = "contrast.supporter.jboss";
    @RetirementNotice(retiringProperty="j2ee.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable instrumentation of standard J2EE servlet classes")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_j2ee_support", c=Boolean.class)
    public static final String SUPPORTER_J2EE = "contrast.supporter.j2ee";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable instrumentation of standard Apache's Jasper classes")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_jasper_support", c=Boolean.class)
    public static final String SUPPORTER_JASPER = "contrast.supporter.jasper";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable instrumentation of standard Jetty classes")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_jetty_support", c=Boolean.class)
    public static final String SUPPORTER_JETTY = "contrast.supporter.jetty";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable instrumentation of compiled JSP classes")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_jsp_support", c=Boolean.class)
    public static final String SUPPORTER_JSP = "contrast.supporter.jsp";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable instrumentation of Java lambdas")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_lambda_support", c=Boolean.class)
    public static final String SUPPORTER_LAMBDA = "contrast.supporter.lambda";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable instrumentation of standard LDAP classes")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_ldap_support", c=Boolean.class)
    public static final String SUPPORTER_LDAP = "contrast.supporter.ldap";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable instrumentation of standard Log4j classes")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_log4j_support", c=Boolean.class)
    public static final String SUPPORTER_LOG4J = "contrast.supporter.log4j";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable instrumentation of standard Mongo classes")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_mongo_support", c=Boolean.class)
    public static final String SUPPORTER_MONGO = "contrast.supporter.mongo";
    @RetirementNotice(retiringProperty="jackson.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Jackson support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_jackson_support", c=Boolean.class)
    public static final String SUPPORTER_JACKSON = "contrast.supporter.jackson";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable JAXB support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_jaxb_support", c=Boolean.class)
    public static final String SUPPORTER_JAXB = "contrast.supporter.jaxb";
    @RetirementNotice(retiringProperty="javax.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Javax support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_javax_ws_rs_support", c=Boolean.class)
    public static final String SUPPORTER_JAVAX_WS_RS = "contrast.supporter.javax.ws.rs";
    @RetirementNotice(retiringProperty="jersey.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Jersey support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_jersey_support", c=Boolean.class)
    public static final String SUPPORTER_JERSEY = "contrast.supporter.jersey";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable JSF support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_jsf_support", c=Boolean.class)
    public static final String SUPPORTER_JSF = "contrast.supporter.jsf";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Karaf support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_karaf_support", c=Boolean.class)
    public static final String SUPPORTER_KARAF = "contrast.supporter.karaf";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Kryo support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_kyro_support", c=Boolean.class)
    public static final String SUPPORTER_KRYO = "contrast.supporter.kryo";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Liferay support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_liferay_support", c=Boolean.class)
    public static final String SUPPORTER_LIFERAY = "contrast.supporter.liferay";
    @ActiveProperty(type=Boolean.class, defaultValue="true", description="boolean to enable/disable net.minidev.json support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_minidev_json_support", c=Boolean.class)
    public static final String SUPPORTER_MINIDEV_JSON = "contrast.supporter.minidevjson";
    @RetirementNotice(retiringProperty="mustache.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Mustache support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_mustache_support", c=Boolean.class)
    public static final String SUPPORTER_MUSTACHE = "contrast.supporter.mustache";
    @RetirementNotice(retiringProperty="netty.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Netty support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_netty_support", c=Boolean.class)
    public static final String SUPPORTER_NETTY = "contrast.supporter.netty";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Oracle support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_oracle_support", c=Boolean.class)
    public static final String SUPPORTER_ORACLE = "contrast.supporter.oracle";
    @RetirementNotice(retiringProperty="osgi.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable OSGi support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_osgi_support", c=Boolean.class)
    public static final String SUPPORTER_OSGI = "contrast.supporter.osgi";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable OutSystems support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_out_systems_support", c=Boolean.class)
    public static final String SUPPORTER_OUTSYSTEMS = "contrast.supporter.outsystems";
    @RetirementNotice(retiringProperty="play.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Play support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_play_support", c=Boolean.class)
    public static final String SUPPORTER_PLAY = "contrast.supporter.play";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Rabbit MQ support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_rabbit_mq_support", c=Boolean.class)
    public static final String SUPPORTER_RABBITMQ = "contrast.supporter.rabbitmq";
    @RetirementNotice(retiringProperty="seam.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable SEAM support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_seam_support", c=Boolean.class)
    public static final String SUPPORTER_SEAM = "contrast.supporter.seam";
    @RetirementNotice(retiringProperty="smap.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable SMAP support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_smap_support", c=Boolean.class)
    public static final String SUPPORTER_SMAP = "contrast.supporter.smap";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable java.sql support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_java_sql_support", c=Boolean.class)
    public static final String SUPPORTER_SQL = "contrast.supporter.sql";
    @RetirementNotice(retiringProperty="springboot.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Spring Boot support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_spring_boot_support", c=Boolean.class)
    public static final String SUPPORTER_SPRINGBOOT = "contrast.supporter.spring_boot";
    @RetirementNotice(retiringProperty="spring.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Spring support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_spring_support", c=Boolean.class)
    public static final String SUPPORTER_SPRING = "contrast.supporter.spring";
    @RetirementNotice(retiringProperty="struts.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Struts support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_struts_support", c=Boolean.class)
    public static final String SUPPORTER_STRUTS = "contrast.supporter.struts";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable support for Synapse containers")
    @com.contrastsecurity.agent.config.f.d(a="java.agent.enable_synapse_support", c=Boolean.class)
    public static final String SUPPORTER_SYNAPSE = "contrast.supporter.synapse";
    @RetirementNotice(retiringProperty="tomcat.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Tomcat support")
    @com.contrastsecurity.agent.config.f.d(a="java.agent.enable_tomcat_support", c=Boolean.class)
    public static final String SUPPORTER_TOMCAT = "contrast.supporter.tomcat";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="false", description="boolean to enable/disable support for Undertow applications")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_undertow_support", c=Boolean.class)
    public static final String SUPPORTER_UNDERTOW = "contrast.supporter.undertow";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable java.net.URL support")
    @com.contrastsecurity.agent.config.f.d(a="java.agent.enable_java_url_support", c=Boolean.class)
    public static final String SUPPORTER_URL = "contrast.supporter.url";
    @RetirementNotice(retiringProperty="vertx.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Vert.x support")
    @com.contrastsecurity.agent.config.f.d(a="java.agent.enable_vertx_support", c=Boolean.class)
    public static final String SUPPORTER_VERTX = "contrast.supporter.vertx";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Weblogic support")
    @com.contrastsecurity.agent.config.f(a="CONTRAST-36554: This supporter was only added because PolicyFinder requires a supporter, but we don't need this as a configuration value")
    public static final String SUPPORTER_WEBLOGIC = "contrast.supporter.weblogic";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable W3C API support")
    @com.contrastsecurity.agent.config.f.d(a="java.agent.enable_w3c_support", c=Boolean.class)
    public static final String SUPPORTER_W3C = "contrast.supporter.w3c";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Oracle WebLogic support")
    @com.contrastsecurity.agent.config.f.d(a="java.agent.enable_weblogic_support", c=Boolean.class)
    public static final String SUPPORTER_WEB_LOGGER_IC = "contrast.supporter.weblogic";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable java.lang.String support")
    @com.contrastsecurity.agent.config.f.d(a="java.agent.enable_java_string_support", c=Boolean.class)
    public static final String SUPPORTER_JAVA_STRING = "contrast.supporter.string";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable WebSphere support")
    @com.contrastsecurity.agent.config.f.d(a="java.agent.enable_websphere_support", c=Boolean.class)
    public static final String SUPPORTER_WEBSPHERE = "contrast.supporter.websphere";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Wildfly support")
    @com.contrastsecurity.agent.config.f.d(a="java.agent.enable_wildfly_support", c=Boolean.class)
    public static final String SUPPORTER_WILDFLY = "contrast.supporter.wildfly";
    @RetirementNotice(retiringProperty="cxf.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Apache CXF support")
    @com.contrastsecurity.agent.config.f.d(a="java.agent.enable_cxf_support", c=Boolean.class)
    public static final String SUPPORTER_CXF = "contrast.supporter.cxf";
    @RetirementNotice(retiringProperty="poi.supporter.disabled")
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable Apache POI support")
    @com.contrastsecurity.agent.config.f.d(a="java.agent.enable_poi_support", c=Boolean.class)
    public static final String SUPPORTER_POI = "contrast.supporter.poi";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable VMware Xenon support")
    @com.contrastsecurity.agent.config.f.d(a="java.agent.enable_xenon_support", c=Boolean.class)
    public static final String SUPPORTER_XENON = "contrast.supporter.xenon";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable XStream support")
    @com.contrastsecurity.agent.config.f.d(a="java.agent.enable_xstream_support", c=Boolean.class)
    public static final String SUPPORTER_XSTREAM = "contrast.supporter.xstream";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Boolean.class, defaultValue="true", description="boolean to enable/disable hierarchy cache")
    @com.contrastsecurity.agent.config.f.d(a="assess.cache.hierarchy_enable", c=Boolean.class)
    public static final String CACHE_HIERARCHY = "contrast.cache.hierarchy";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Boolean.class, defaultValue="false", description="boolean to trigger rebuilding/resetting the hierarchy cache")
    @com.contrastsecurity.agent.config.f.d(a="assess.cache.hierarchy_rebuild", c=Boolean.class)
    public static final String HIERARCHY_REBUILD = "contrast.hierarchy.rebuild";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="8192", hidden=true, description="maximum size of a string that can be cached in snapshot cache")
    @com.contrastsecurity.agent.config.f.d(a="assess.cache.snapshot_cache_string_max", b={"agent.cache.snapshot_cache_string_max"}, c=Integer.class)
    public static final String ASSESS_SNAPSHOT_CACHE_MAX_STRING_SIZE = "contrast.snapshotcache.maxstringsize";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="4", hidden=true, description="minimum size of a string that can be cached in snapshot cache")
    @com.contrastsecurity.agent.config.f.d(a="assess.cache.snapshot_cache_string_min", b={"agent.cache.snapshot_cache_string_min"}, c=Integer.class)
    public static final String ASSESS_SNAPSHOT_CACHE_MIN_STRING_SIZE = "contrast.snapshotcache.minstringsize";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="4000000", hidden=true, description="maximum size of the assess snapshot cache (in total combined string size), must be divisible by 4")
    @com.contrastsecurity.agent.config.f.d(a="assess.cache.snapshot_cache_size_max", b={"agent.cache.snapshot_cache_size_max"}, c=Integer.class)
    public static final String ASSESS_SNAPSHOT_CACHE_MAX_SIZE = "contrast.snapshotcache.maxcachesize";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Boolean.class, defaultValue="false", description="boolean to trigger updating the hierarchy cache")
    @com.contrastsecurity.agent.config.f.d(a="assess.cache.hierarchy_update", c=Boolean.class)
    public static final String HIERARCHY_UPDATE = "contrast.hierarchy.update";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="500000", hidden=true, description="maximum weighted size of the protect analysis cache. cache is weighted on total number of chars in each input value. This limits the usage of memory for the analysis cache. The default value of 500,000 limits usage to approximately 977 KB with 16bit char code units. This will vary depending on the JVM.")
    @com.contrastsecurity.agent.config.f.d(a="protect.cache.analysis_cache_size_max", c=Integer.class)
    public static final String ANALYSIS_CACHE_MAX_SIZE = "contrast.analysiscache.size";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="100000", hidden=true, description="maximum length in chars of a user input value that will be stored in the analysis cache. Larger values than this will not be cached.")
    @com.contrastsecurity.agent.config.f.d(a="protect.cache.analysis_cache_string_limit", c=Integer.class)
    public static final String ANALYSIS_CACHE_STRING_LIMIT = "contrast.analysiscache.stringlimit";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Long.class, defaultValue="300000", hidden=true, description="expiration time of elements within the analysis cache in milliseconds")
    @com.contrastsecurity.agent.config.f.d(a="protect.cache.analysis_cache_expiry_ms", c=Long.class)
    public static final String ANALYSIS_CACHE_EXPIRY = "contrast.analysiscache.expiry.ms";
    public static final int NESTED_LIBS_DEPTH_DEFAULT = 3;
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Integer.class, defaultValue="3", description="max archive unpacking depth when analyzing libraries")
    @com.contrastsecurity.agent.config.f.d(a="inventory.library_depth", c=Integer.class)
    public static final String NESTED_LIBS_DEPTH = "contrast.nested.libs.depth";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Boolean.class, defaultValue="false", description="Boolean to enable/disable analysis of libraries listed in java.class.path property. Determines whether or not Contrast will track usage of libraries listed in the environment's *java.class.path* property. This should only be on in J2SE/desktop situations.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_classpath_libs", c=Boolean.class)
    public static final String CLASSPATH_LIBS = "contrast.classpath.libs";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="semi-colon delimited list of directories where external libraries are stored; used during library analysis")
    @com.contrastsecurity.agent.config.f.d(a="inventory.library_dirs")
    public static final String EXTERNAL_LIB_DIR = "contrast.external.lib.dir";
    @RetirementNotice(retiringProperty="contrast.appname")
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="sets the application name; this name will be reported to TeamServer")
    @com.contrastsecurity.agent.config.f.d(a="application.name", d=true)
    public static final String APPLICATION_NAME = "contrast.override.appname";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="sets the application version; this version will be reported to TeamServer")
    @com.contrastsecurity.agent.config.f.d(a="application.version", d=true)
    @com.contrastsecurity.agent.config.a(a=c.class)
    public static final String APPLICATION_VERSION = "contrast.override.appversion";
    public static final int MAX_CONCURRENT_REQUESTS_DEFAULT = 20;
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="20", description="average number of concurrent users logged into the application at any one time")
    @com.contrastsecurity.agent.config.f.d(a="agent.concurrent_requests", c=Integer.class)
    public static final String CONCURRENT_REQUESTS = "contrast.concurrent.requests";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="Indicates the application is a standalone app with the provided name")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.standalone_app_name")
    public static final String STANDALONE_APPNAME = "contrast.standalone.appname";
    private static final long d = 900000L;
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Long.class, defaultValue="900000", description="The amount of time to pause agent to TeamServer communication when a bad response code is received. 900000 (15 minutes in milliseconds).")
    @com.contrastsecurity.agent.config.f.d(a="agent.polling.contrast_ui_channel_pause_period_ms", c=Long.class)
    public static final String TEAMSERVER_CHANNEL_PAUSE_PERIOD = "contrast.teamserver.channel.pause.period";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, description="Set the URL for the Contrast UI")
    @com.contrastsecurity.agent.config.f.d(a="api.url", b={"contrast.url"})
    public static final String TEAMSERVER_URL = "contrast.teamserver.url";
    public static final int TEAMSERVER_TIMEOUT_SECS_DEFAULT = 10;
    @Deprecated
    @com.contrastsecurity.agent.config.f(a="Timeout in seconds not in Common Config, timeout in milliseconds is configurable via *api.timeout_ms*")
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Integer.class, defaultValue="10", description="This value can override the default timeout (in seconds) for communicating with TeamServer. This value is deprecated in favor of *api.timeout_ms*. If both values are set the agent respects *api.timeout_ms* over this property.", deprecationAlternative="api.timeout_ms")
    public static final String TIMEOUT = "contrast.timeout";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Integer.class, nullDefaultValue=true, description="This value can override the default timeout (in milliseconds) for communicating with TeamServer. This value is the deprecation alternative to *contrast.timeout*. If both values are set the agent respects this property over *contrast.timeout*.")
    @com.contrastsecurity.agent.config.f.d(a="api.timeout_ms", b={"contrast.timeout_ms"}, c=Integer.class)
    public static final String TIMEOUT_MS = "contrast.api.timeout_ms";
    @ActiveProperty(category=ActiveProperty.Category.PROXY_SETTINGS, type=Boolean.class, nullDefaultValue=true, description="If present, determines whether or not the Agent should communicate with TeamServer over a proxy. Otherwise, enabled status is determined by the presence of a valid proxy host and port")
    @com.contrastsecurity.agent.config.f.d(a="api.proxy.enable", b={"contrast.proxy.enable"}, c=Boolean.class)
    public static final String PROXY_ENABLED = "contrast.proxy.enable";
    @ActiveProperty(category=ActiveProperty.Category.PROXY_SETTINGS, nullDefaultValue=true, description="Proxy url, e.g. http://host:port. This value should be set in place of scheme, host, and port settings. If both this and one of the others are set, a ContrastConfigurationException will be thrown")
    @com.contrastsecurity.agent.config.f.d(a="api.proxy.url", b={"contrast.proxy.url"})
    public static final String PROXY_URL = "contrast.proxy.url";
    @ActiveProperty(category=ActiveProperty.Category.PROXY_SETTINGS, nullDefaultValue=true, description="Proxy protocol, e.g. http, https")
    @com.contrastsecurity.agent.config.f.d(a="api.proxy.scheme", b={"contrast.proxy.scheme"})
    public static final String PROXY_PROTOCOL = "contrast.proxy.protocol";
    @ActiveProperty(category=ActiveProperty.Category.PROXY_SETTINGS, nullDefaultValue=true, description="Override authentication type for Proxy")
    @com.contrastsecurity.agent.config.f.d(a="api.proxy.auth_type", b={"contrast.proxy.auth_type"})
    public static final String PROXY_AUTH = "proxy.auth";
    @ActiveProperty(category=ActiveProperty.Category.PROXY_SETTINGS, nullDefaultValue=true, description="Override Host for Proxy")
    @com.contrastsecurity.agent.config.f.d(a="api.proxy.host", b={"contrast.proxy.host"})
    public static final String PROXY_HOST = "proxy.host";
    public static final int PROXY_PORT_DEFAULT = 0;
    @ActiveProperty(category=ActiveProperty.Category.PROXY_SETTINGS, type=Integer.class, defaultValue="0", description="Override Port for Proxy. Defaults to 0, an invalid port number.")
    @com.contrastsecurity.agent.config.f.d(a="api.proxy.port", b={"contrast.proxy.port"}, c=Integer.class)
    public static final String PROXY_PORT = "proxy.port";
    @ActiveProperty(category=ActiveProperty.Category.PROXY_SETTINGS, nullDefaultValue=true, description="Override User for Proxy")
    @com.contrastsecurity.agent.config.f.d(a="api.proxy.user", b={"contrast.proxy.user"})
    public static final String PROXY_USER = "proxy.user";
    @ActiveProperty(category=ActiveProperty.Category.PROXY_SETTINGS, nullDefaultValue=true, shouldMask=true, description="Override Password for Proxy")
    @com.contrastsecurity.agent.config.f.d(a="api.proxy.pass", b={"contrast.proxy.pass"})
    public static final String PROXY_PASSWORD = "proxy.pass";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Boolean.class, defaultValue="true", description="boolean to enable/disable the Contrast activity thread")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_activity_thread", c=Boolean.class)
    public static final String ACTIVITY = "contrast.activity";
    public static final long APP_ACTIVITY_PERIOD_MS_DEFAULT = 30000L;
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Long.class, defaultValue="30000", description="Contrast app activity thread polling period in milliseconds. 30000 (30  seconds, in milliseconds)")
    @com.contrastsecurity.agent.config.f.d(a="agent.polling.app_activity_ms", c=Long.class)
    public static final String APP_ACTIVITY_PERIOD_MS = "contrast.app.activity.period";
    public static final long STALE_APP_ACTIVITY_UPDATE_MS_DEFAULT = 300000L;
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Long.class, defaultValue="300000", description="The maximum amount of time to wait before requesting new \"application settings\" from TeamServer. Typically, the agent receives new settings each time it sends activity, but if there is no activity the agent will wait this long before requesting new settings. Defaults to 300000 (5  minutes, in milliseconds)")
    @com.contrastsecurity.agent.config.f.d(a="agent.polling.app_activity_stale_ms", c=Long.class)
    public static final String STALE_APP_ACTIVITY_UPDATE_MS = "contrast.stale.app.activity.update.ms";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Boolean.class, defaultValue="true", description="boolean to enable/disable threads that sends updates about applications to Team Server")
    @com.contrastsecurity.agent.config.f.d(a="application.enable_app_updates", c=Boolean.class)
    public static final String APPUPDATE = "contrast.appupdate";
    public static final long APP_UPDATE_POLL_PERIOD_MS_DEFAULT = 5000L;
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Long.class, defaultValue="5000", description="Contrast app update thread polling period in milliseconds")
    @com.contrastsecurity.agent.config.f.d(a="agent.polling.app_update_ms", c=Long.class)
    public static final String APP_UPDATE_PERIOD = "contrast.app.update.period";
    public static final long APP_UPDATE_STALE_THRESHOLD_MS_DEFAULT = 1800000L;
    @ActiveProperty(hidden=true, category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Long.class, defaultValue="1800000", description="Even when no appupdate is warranted on client side, ask TeamServer via preflight if needed on this frequency. 30 mins, in milliseconds.")
    @com.contrastsecurity.agent.config.f.d(a="agent.polling.app_update_stale_threshold_ms", c=Long.class)
    public static final String APP_UPDATE_STALE_THRESHOLD = "contrast.app.update.threshold";
    @ActiveProperty(nullDefaultValue=true, description="JSON from disk to use for app")
    @com.contrastsecurity.agent.config.f.d(a="application.app_features_file")
    public static final String APP_FEATURES = "contrast.app.features";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, nullDefaultValue=true, description="The path to the file that lists classes currently on the denylist.  Classes listed here will be ignored by the agent.")
    @com.contrastsecurity.agent.config.f.d(a="agent.blacklist")
    public static final String DENYLIST_PATH = "contrast.blacklist";
    @ActiveProperty(type=Boolean.class, defaultValue="true", description="boolean to enable/disable cloning of tracked objects")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_input_cloning", c=Boolean.class)
    public static final String CLONEINPUT = "contrast.cloneinput";
    @ActiveProperty(type=Boolean.class, defaultValue="true", description="boolean to enable/disable cloning of leaf nodes in object graphs of deserialized objects")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_deep_cloning", c=Boolean.class)
    public static final String DEEP_CLONEINPUT = "contrast.deepclone";
    @ActiveProperty(type=Boolean.class, defaultValue="false", description="boolean to enable/disable tainting of keys in maps of deserialized objects")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.taint_map_key", c=Boolean.class)
    public static final String DEEP_TAINTKEYS = "contrast.deep.mapkeys";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="10", hidden=true, description="The max depth to traverse and analyze deserialized objects in Protect. Set to 0 to disable deserialized object analysis.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.protect_deserialization_analysis_traversal_depth", c=Integer.class)
    public static final String DESERIALIZER_MAX_DEPTH = "contrast.deserializer.maxdepth";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="manually override the web app container name/id")
    @com.contrastsecurity.agent.config.f.d(a="server.type")
    public static final String SERVER_TYPE = "contrast.container";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="This value can override the default location of the Contrast working directory. Defaults to ${HOME}/.contrast of the user account the application runs under.")
    @com.contrastsecurity.agent.config.f.d(a="agent.contrast_working_dir")
    public static final String WORKING_DIR = "contrast.dir";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="comma separated list of tags to be sent with each server update and create")
    @com.contrastsecurity.agent.config.f.d(a="server.tags")
    public static final String SERVER_TAGS = "server.tags";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="comma separated list of tags to be sent with each application message")
    @com.contrastsecurity.agent.config.f.d(a="application.tags", d=true)
    public static final String APPLICATION_TAGS = "application.tags";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="comma separated list of tags to be sent with each inventory message")
    @com.contrastsecurity.agent.config.f.d(a="inventory.tags", d=true)
    public static final String INVENTORY_TAGS = "inventory.tags";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="comma separated list of tags to be sent with each assess message")
    @com.contrastsecurity.agent.config.f.d(a="assess.tags", d=true)
    public static final String ASSESS_TAGS = "assess.tags";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Boolean.class, defaultValue="true", description="boolean to enable/disable analysis of HTTP parameters")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_http_parameter_analysis", c=Boolean.class)
    public static final String HTTP_ANALYSIS_PARAMETERS = "contrast.http.analysis.parameters";
    @RetirementNotice(retiringProperty="contrast.disable.dbinspection")
    @ActiveProperty(type=Boolean.class, defaultValue="true", description="boolean to enable/disable DB inspection when analyzing application architecture")
    @com.contrastsecurity.agent.config.f.d(a="inventory.inspect_database", c=Boolean.class)
    @com.contrastsecurity.agent.config.p(a=Q.class)
    public static final String DBINSPECTION = "contrast.dbinspection";
    @ActiveProperty(type=Boolean.class, defaultValue="true", description="boolean to enable/disable LDAP call counting and analysis")
    @com.contrastsecurity.agent.config.f.d(a="inventory.inspect_ldap", c=Boolean.class)
    @com.contrastsecurity.agent.config.p(a=S.class)
    public static final String INVENTORY_MONITOR_LDAP = "contrast.monitorldap";
    @ActiveProperty(type=Boolean.class, defaultValue="true", description="boolean to enable/disable web call counting and analysis, web calls being the HTTP requests made to this application")
    @com.contrastsecurity.agent.config.f.d(a="inventory.inspect_web_calls", c=Boolean.class)
    @com.contrastsecurity.agent.config.p(a=U.class)
    public static final String INVENTORY_MONITOR_WEB_CALL = "contrast.monitorwebcalls";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Boolean.class, defaultValue="true", description="Determines whether or not Contrast will monitor the JVM. You can use this feature to quickly turn Contrast on or off without removing the *-javaagent* flag.")
    @com.contrastsecurity.agent.config.f.d(a="enable", b={"contrast.enable"}, c=Boolean.class)
    public static final String ENABLED = "contrast.enabled";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="The file to which the last configuration from TeamServer should be loaded or reloaded.")
    @com.contrastsecurity.agent.config.f.d(a="api.last_config_path", b={"contrast.last_config_path"})
    public static final String LAST_CONFIG_PATH = "contrast.last_config_path";
    @ActiveProperty(nullDefaultValue=true, hidden=true, description="location of features JSON")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.features_file_override")
    public static final String FEATUREJSON = "contrast.featureJSON";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, defaultValue="true", description="boolean to enable/disable identity tags")
    @com.contrastsecurity.agent.config.p(a=g.class)
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_identity_tagging", c=Boolean.class)
    public static final String IDENTITYTAGS = "contrast.identitytags";
    @ActiveProperty(category=ActiveProperty.Category.FRAMEWORK_SUPPORT, hidden=true, type=Boolean.class, defaultValue="false", description="boolean to enable/disable jmx support")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_jmx_support", c=Boolean.class)
    public static final String JMX = "contrast.jmx";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Boolean.class, defaultValue="true", description="boolean to enable/disable caching of instrumented classes")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_j2ee_class_cache", c=Boolean.class)
    public static final String J2EE_CLASSCACHE = "contrast.j2ee.classcache";
    @ActiveProperty(type=Boolean.class, defaultValue="true", description="boolean to enable/disable J2EE context discovery")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.j2ee_context_discovery", c=Boolean.class)
    public static final String J2EE_CONTEXT_DISCOVERY = "contrast.j2ee.context.discovery";
    @ActiveProperty(hidden=true, nullDefaultValue=true, description="Valid values: assess/defend/inventory/all. assess: data flow analysis, defend: defend features, inventory: library catalog and analysis, all: all features; Note when this property is enabled, the Agent will ignore all customizations from TeamServer.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.mode")
    public static final String MODE = "contrast.mode";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Boolean.class, defaultValue="false", description="If present, used to determine if the Assess feature should be enabled. If not present, decision delegated to Contrast UI")
    @com.contrastsecurity.agent.config.p(a=f.class)
    @com.contrastsecurity.agent.config.f.d(a="assess.enable", c=Boolean.class)
    public static final String ASSESS_ENABLED = "contrast.assess.enabled";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Boolean.class, defaultValue="true", description="Used to determine if the Inventory feature should be enabled. Inventory encompasses several facets of application analysis including library detection and usage, HTTP call counting and database usage analysis")
    @com.contrastsecurity.agent.config.f.d(a="inventory.enable", c=Boolean.class)
    @com.contrastsecurity.agent.config.p(a=R.class)
    public static final String INVENTORY_ENABLED = "contrast.inventory.enabled";
    @ActiveProperty(hidden=true, type=Boolean.class, defaultValue="false", description="boolean to enable/disable Contrast to start up without access to TeamServer")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_disconnected_startup", c=Boolean.class)
    public static final String NOTEAMSERVER_ENABLE = "contrast.noteamserver.enable";
    @ActiveProperty(nullDefaultValue=true, description="Contrast \"working directory\" override. Defaults to CWD.")
    @com.contrastsecurity.agent.config.f.d(a="server.path")
    public static final String SERVER_PATH = "contrast.path";
    @ActiveProperty(nullDefaultValue=true, description="Overrides reported server build")
    @com.contrastsecurity.agent.config.f.d(a="server.build")
    public static final String SERVER_BUILD = "contrast.server.build";
    @ActiveProperty(nullDefaultValue=true, description="Overrides reported server version")
    @com.contrastsecurity.agent.config.f.d(a="server.version")
    public static final String SERVER_VERSION = "contrast.server.version";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="This value can override (or provide one if none exist) a display name for the app running at the root context. This may be needed for Contrast to collect analytics on the application.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.root_app_name")
    public static final String ROOTAPP = "contrast.rootapp";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, nullDefaultValue=true, description="Enable and configure *sampling mode*. By default, just placing this flag will result in a *baseline* (how many times a request should be analyzed before it is considered sampled) and *frequency* (how often after the baseline has been established should new samples be taken) of **5** and a *sampling window* (how long the baseline is valid, in seconds) of **180 seconds**. This means that after the same request has been seen five times in 180 seconds, it will only be analyzed every subsequent fifth time. You can customize this further by setting the value to \"#,#,#\". In this case, the baseline will be set to the first number, the frequency second, and the window third. Note that if you choose to customize any value, you must provide all three inputs.")
    @com.contrastsecurity.agent.config.f(a="TODO: Do we still need this configuration?")
    public static final String SAMPLING = "contrast.sampling";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Boolean.class, defaultValue="false", description="Enable sampling mode")
    @com.contrastsecurity.agent.config.f.d(a="assess.sampling.enable", c=Boolean.class)
    @com.contrastsecurity.agent.config.p(a=k.class)
    public static final String ASSESS_SAMPLING_ENABLED = "contrast.sampling.enabled";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="5", description="indicates how many requests to analyze in each window before sampling begins")
    @com.contrastsecurity.agent.config.f.d(a="assess.sampling.baseline", c=Integer.class)
    @com.contrastsecurity.agent.config.p(a=j.class)
    public static final String ASSESS_SAMPLING_BASELINE = "contrast.sampling.baseline";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="10", description="indicates every nth request (after baseline) will be analyzed")
    @com.contrastsecurity.agent.config.f.d(a="assess.sampling.request_frequency", c=Integer.class)
    @com.contrastsecurity.agent.config.p(a=l.class)
    public static final String ASSESS_SAMPLING_REQ_FREQUENCY = "contrast.sampling.request_frequency";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="25", description="indicates every nth request (after baseline) will be analyzed")
    @com.contrastsecurity.agent.config.f.d(a="assess.sampling.response_frequency", c=Integer.class)
    @com.contrastsecurity.agent.config.p(a=m.class)
    public static final String ASSESS_SAMPLING_RES_FREQUENCY = "contrast.sampling.response_frequency";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="180000", description="indicates duration for which a sample set is valid, in ms")
    @com.contrastsecurity.agent.config.f.d(a="assess.sampling.window_ms", c=Integer.class)
    @com.contrastsecurity.agent.config.p(a=n.class)
    public static final String ASSESS_SAMPLING_WINDOW_MS = "contrast.sampling.window_ms";
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, nullDefaultValue=true, description="Output location of the saved *before/after bytecode* of classes where sensors have been added.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.save_bytecode")
    public static final String SAVEBYTECODE = "contrast.savebytecode";
    public static final SaveReportMode SAVERESULTS_DEFAULT = SaveReportMode.Never;
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, defaultValue="never", description="controls when Contrast findings are saved locally")
    @com.contrastsecurity.agent.config.f.d(a="assess.save_results")
    public static final String SAVERESULTS = "contrast.saveresults";
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, nullDefaultValue=true, description="controls where Contrast findings are saved locally")
    @com.contrastsecurity.agent.config.f.d(a="assess.local_results_dir")
    public static final String LOCAL_RESULTS_DIR = "contrast.local.results.dir";
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, type=Boolean.class, defaultValue="false", description="controls whether the JarInputStream verifier is disabled during our scoped operations")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.override_scoped_jar_verifier", c=Boolean.class)
    public static final String JARVERIFIER_OVERRIDE = "contrast.scoped.jarverifier";
    @ActiveProperty(type=Boolean.class, defaultValue="true", description="boolean to enable/disable scanning of HTTP responses -- override for assess and protect")
    @com.contrastsecurity.agent.config.f(a="CONTRAST-30445")
    public static final String SCANRESPONSES = "contrast.scanresponses";
    @ActiveProperty(type=Boolean.class, defaultValue="true", description="boolean to enable/disable scanning of HTTP responses -- assess only")
    @com.contrastsecurity.agent.config.p(a=o.class)
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_scan_response", c=Boolean.class)
    public static final String SCAN_ASSESS_RESPONSES = "contrast.assess.scanresponses";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="Overrides name of the server displayed in the Contrast TeamServer. Includes any valid path characters, e.g. *myserver-1/myapp* or *john_dev*.")
    @com.contrastsecurity.agent.config.f.d(a="server.name")
    public static final String SERVER_NAME = "contrast.server";
    public static final long SERVER_ACTIVITY_PERIOD_MS_DEFAULT = 30000L;
    @ActiveProperty(type=Long.class, defaultValue="30000", description="Polling period for TeamServer polling thread 30000 (30 seconds in milliseconds)")
    @com.contrastsecurity.agent.config.f.d(a="agent.polling.server_activity_ms", c=Long.class)
    public static final String SERVER_ACTIVITY_PERIOD = "contrast.server.activity.period";
    public static final long STALE_SERVER_ACTIVITY_UPDATE_MS_DEFAULT = 300000L;
    @ActiveProperty(type=Long.class, defaultValue="300000", description="The maximum amount of time to wait before requesting new \"server settings\" from TeamServer. Typically, the agent receives new settings each time it sends activity, but if there is no activity the agent will wait this long before requesting new settings. (5 minutes, in milliseconds)")
    @com.contrastsecurity.agent.config.f.d(a="agent.polling.server_activity_stale_ms", c=Long.class)
    public static final String STALE_SERVER_ACTIVITY_UPDATE_MS = "contrast.stale.server.activity.update.ms";
    public static final int MAX_STACKDEPTH_DEFAULT = 75;
    @ActiveProperty(type=Integer.class, defaultValue="75", description="max stack depth to include in reported findings, minimum of 2")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.max_stack_depth", c=Integer.class)
    public static final String STACKS_MAXDEPTH = "contrast.stacks.maxdepth";
    @ActiveProperty(type=Boolean.class, hidden=true, defaultValue="false", description="Suppress findings from Team Server")
    @com.contrastsecurity.agent.config.f.d(a="api.suppress_findings", c=Boolean.class)
    public static final String TEAMSERVER_SUPPRESS = "contrast.teamserver.suppress";
    @ActiveProperty(nullDefaultValue=true, description="Location for Contrast telemetry output")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.telemetry_directory")
    public static final String TELEMETRY_DIR = "contrast.telemetry.dir";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="use the contrast.config file packaged in another contrast.jar")
    @com.contrastsecurity.agent.config.f(a="TODO: wait what? seriously?")
    public static final String USECONFIG = "contrast.useconfig";
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, type=Boolean.class, defaultValue="false", description="When set to true, all logs will be written to stdout instead of the file system.  May be combined with the corresponding stderr configuration to write to both streams.")
    @com.contrastsecurity.agent.config.f.d(a="agent.logger.stdout", c=Boolean.class)
    public static final String LOGGER_STDOUT = "contrast.stdout";
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, type=Boolean.class, defaultValue="false", hidden=true, description="When set to true, all logs will be written to stderr instead of the file system. May be combined with the corresponding stdout configuration to write to both streams.")
    @com.contrastsecurity.agent.config.f.d(a="agent.logger.stderr", c=Boolean.class)
    public static final String LOGGER_STDERR = "contrast.stderr";
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, type=Boolean.class, defaultValue="false", description="When set to true, all normal stdout messages will be suppressed -- has no effects on file or syslog logging")
    @com.contrastsecurity.agent.config.f(a="TODO: why do we have this setting and `agent.logger.stdout`?")
    public static final String SUPPRESS_STDOUT = "contrast.stdout.quiet";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, defaultValue="INFO", description="Set the log level for security logging. Values include: trace, debug, info, warn, error, fatal, off. Setting this to off will disable security logging.")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.level")
    public static final String SECURITY_LOGGER_LEVEL = "contrast.security.log.level";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_ASSESS, defaultValue="INFO", description="Log output level")
    @com.contrastsecurity.agent.config.p(a=V.class)
    @com.contrastsecurity.agent.config.f.d(a="agent.logger.level")
    public static final String LOGGER_LEVEL = "contrast.level";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, defaultValue="security.log", description="The file to which logging of security events will occur. By default, this file is located at ${HOME}/.contrast/security.log.")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.path")
    public static final String SECURITY_LOGGER_FILE = "contrast.security.log.file";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_ASSESS, defaultValue="contrast.log", description="Enable *diagnostic logging*. This hurts performance, but generates useful information for debugging Contrast. The value set here will be the location to which log output is saved. If no log file exists at this location, one will be created. For instance, */opt/Contrast/contrast.log* will create a log in the */opt/Contrast* directory and rotate it automatically as needed. By default, this file is located at ${HOME}/.contrast/contrast.log")
    @com.contrastsecurity.agent.config.p(a=W.class)
    @com.contrastsecurity.agent.config.f.d(a="agent.logger.path")
    public static final String LOGGER_LOCATION = "contrast.log";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, type=Boolean.class, defaultValue="true", description="Change the Contrast security logger from a file sized based rolling scheme to a date based rolling scheme. At midnight server time, the previous day's log will be renamed to file_name.yyyy-MM-dd. Note, this scheme does not have a size limit, so manual log pruning will be required. This flag must be set to use the backups and size flags.")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.roll_daily", c=Boolean.class)
    public static final String SECURITY_LOGGER_DAILY = "contrast.security.log.daily";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_ASSESS, type=Boolean.class, defaultValue="true", description="Change the Contrast logger from a file sized based rolling scheme to a date based rolling scheme. At midnight serve time, the previous day's log will be renamed to file_name.yyyy-MM-dd. Note, this scheme does not have a size limit, so manual log pruning will be required. This flag must be set to use the backups and size flags.")
    @com.contrastsecurity.agent.config.f.d(a="agent.logger.roll_daily", c=Boolean.class)
    public static final String LOGGER_DAILY = "contrast.log.daily";
    public static final int MAX_LOGGER_BACKUPS_DEFAULT = 100;
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, type=Integer.class, defaultValue="100", description="Specify the number of \"backup\" logs that will be created before Contrast will clean up the oldest file. This value has a cap of 100, meaning no more than 100 log files can be stored on the file system at one time. A value of 0 here means that no backups will be created and the log will simply be truncated when it reaches its size cap. Note: This property must be used with contrast.security.log.daily=false, or we will continue to log daily and disregard this limit.")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.backups", c=Integer.class)
    public static final String SECURITY_LOGGER_BACKUPS = "contrast.security.log.backups";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_ASSESS, type=Integer.class, defaultValue="100", description="Specify the number of \"backup\" logs that will be created before Contrast will clean up the oldest file. This value has a cap of 100, meaning no more than 100 log files can be stored on the file system at one time. A value of 0 here means that no backups will be created and the log will simply be truncated when it reaches its size cap. Note: This property must be used with contrast.log.daily=false, or we will continue to log daily and disregard this limit.")
    @com.contrastsecurity.agent.config.f.d(a="agent.logger.backups", c=Integer.class)
    public static final String LOGGER_BACKUPS = "contrast.log.backups";
    public static final int MAX_LOGGER_FILE_SIZE_MB_DEFAULT = 10;
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, type=Integer.class, defaultValue="10", description="Specify the file size cap, in MB, of each log file. This value has a cap of 10, meaning no more than 10MB will be logged to a single file. By default, this value is '10'.")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.roll_size", c=Integer.class)
    public static final String SECURITY_LOGGER_SIZE = "contrast.security.log.size";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_ASSESS, type=Integer.class, defaultValue="10", description="Specify the file size cap, in MB, of each log file. This value has a cap of 10, meaning no more than 10MB will be logged to a single file.")
    @com.contrastsecurity.agent.config.f.d(a="agent.logger.roll_size", c=Integer.class)
    public static final String LOGGER_SIZE = "contrast.log.size";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, type=Boolean.class, defaultValue="false", description="flag for controlling the use of Syslog")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.syslog.enable", c=Boolean.class)
    @com.contrastsecurity.agent.config.p(a=v.class)
    public static final String CEF_SYSLOGGER_ENABLE = "agent.security_logger.syslog.enable";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, hidden=true, description="Set the address of the Syslog server to which the agent should send messages.  This can be a fully qualified domain name or ip address; e.g. syslog.hostname.com or 10.10.10.13")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.syslog.server_host", b={"agent.security_logger.syslog.ip"})
    @com.contrastsecurity.agent.config.p(a=y.class)
    public static final String CEF_SYSLOGGER_HOST_NEW = "agent.security_logger.syslog.ip";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, description="Set the address of the Syslog server to which the agent should send messages.  This can be a fully qualified domain name or ip address; e.g. syslog.hostname.com or 10.10.10.13")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.syslog.ip")
    @com.contrastsecurity.agent.config.p(a=y.class)
    public static final String CEF_SYSLOGGER_HOST = "agent.security_logger.syslog.ip";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, hidden=true, description="Specify the connection protocol used for the Syslog server connection.  Value options are 'UDP' (default), 'TCP', or 'TCP_TLS'.  Default if missing is UDP.")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.syslog.protocol")
    public static final String CEF_SYSLOGGER_PROTOCOL = "agent.security_logger.syslog.protocol";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, type=Integer.class, defaultValue="514", description="The port of the Syslog server to which we should send messages")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.syslog.port", c=Integer.class)
    @com.contrastsecurity.agent.config.p(a=z.class)
    public static final String CEF_SYSLOGGER_PORT = "agent.security_logger.syslog.port";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, type=Integer.class, defaultValue="19", description="The facility code of the messages we are sending to Syslog")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.syslog.facility", c=Integer.class)
    @com.contrastsecurity.agent.config.p(a=x.class)
    public static final String CEF_SYSLOGGER_FACILITY = "agent.security_logger.syslog.facility";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, type=Boolean.class, defaultValue="false", description="Set to `true` to enable the Syslog heartbeat.  The heartbeat will issue a Syslog message every after every interval passes.")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.syslog.heartbeat.enable", c=Boolean.class)
    public static final String CEF_SYSLOGGER_HEARTBEAT = "agent.security_logger.syslog.heartbeat.enable";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, type=Integer.class, defaultValue="60000", description="Set the interval of the Syslog server of which to send heartbeat messages to the Syslog server. (in milliseconds)")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.syslog.heartbeat.interval_ms", c=Integer.class)
    public static final String CEF_SYSLOGGER_HEARTBEAT_INTERVAL = "agent.security_logger.syslog.heartbeat.interval_ms";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, defaultValue="ALERT", description="Set the log level of Exploited attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.syslog.severity_exploited")
    @com.contrastsecurity.agent.config.p(a=w.class)
    public static final String CEF_SYSLOGGER_EXPLOITED_LEVEL = "agent.security_logger.syslog.severity_exploited";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, defaultValue="WARNING", hidden=true, description="Set the log level of Suspicious attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.syslog.severity_suspicious")
    public static final String CEF_SYSLOGGER_SUSPICIOUS_LEVEL = "agent.security_logger.syslog.severity_suspicious";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, defaultValue="NOTICE", description="Set the log level of Blocked attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.syslog.severity_blocked")
    @com.contrastsecurity.agent.config.p(a=u.class)
    public static final String CEF_SYSLOGGER_BLOCKED_LEVEL = "agent.security_logger.syslog.severity_blocked";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, defaultValue="WARNING", description="Set the log level of Probed attacks. Value options are `ALERT`, `CRITICAL`, `ERROR`, `WARNING`, `NOTICE`, `INFO`, and `DEBUG`.")
    @com.contrastsecurity.agent.config.f.d(a="agent.security_logger.syslog.severity_probed")
    @com.contrastsecurity.agent.config.p(a=A.class)
    public static final String CEF_SYSLOGGER_PROBED_LEVEL = "agent.security_logger.syslog.severity_probed";
    @ActiveProperty(category=ActiveProperty.Category.LOGGING_DEFEND, nullDefaultValue=true, hidden=true, description="In order to get diagnostics about how the SQL is being analyzed for defend purposes, you can log queries that contain the canary specified by this setting.")
    @com.contrastsecurity.agent.config.f.d(a="protect.sql_canary")
    public static final String DEFEND_SQL_CANARY = "contrast.defend.sql.canary";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.ato.mode")
    public static final String DEFEND_ATO_MODE = "contrast.defend.ato.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2010-1622.mode")
    @com.contrastsecurity.agent.config.a(a=s.class)
    public static final String DEFEND_BEAN_INTROSPECTION_MODE = "contrast.defend.cve-2010-1622.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cmd-injection.mode")
    @com.contrastsecurity.agent.config.a(a=B.class)
    public static final String DEFEND_CMDI_MODE = "contrast.defend.cmd-injection.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="true", description="Detect when the agent sees user parameters being executed as system commands. The agent blocks if blocking is enabled.")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cmd-injection.detect_parameter_command_backdoors", c=Boolean.class)
    public static final String DEFEND_CMDI_BACKDOORS = "contrast.defend.cmdinjection.backdoors";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="true", description="Detect when a system command is issued which contains chained commands. The agent blocks if blocking is enabled.")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cmd-injection.detect_chained_commands", c=Boolean.class)
    public static final String DEFEND_CMDI_CHAINS = "contrast.defend.cmdinjection.chaining";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="true", description="Detect when a system command is issued which contains a dangerous path argument - e.g. /etc/passwd. The agent blocks if blocking is enabled.")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cmd-injection.detect_dangerous_path_args", c=Boolean.class)
    public static final String DEFEND_CMDI_DANGEROUS_PATH_ARGS = "contrast.protect.rules.cmd-injection.detect_dangerous_path_args";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, hidden=true, defaultValue="true", description="controls whether phased commands queries will be blocked")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cmd-injection.detect_phased_commands", c=Boolean.class)
    public static final String DEFEND_CMDI_PHASES = "contrast.defend.cmdinjection.phases";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2011-2730.mode")
    @com.contrastsecurity.agent.config.a(a=C.class)
    public static final String DEFEND_CVE_2011_2730_MODE = "contrast.defend.cve-2011-2730.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2014-0112.mode")
    @com.contrastsecurity.agent.config.a(a=D.class)
    public static final String DEFEND_CVE_2014_0112_MODE = "contrast.defend.cve-2014-0112.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2014-0114.mode")
    @com.contrastsecurity.agent.config.a(a=E.class)
    public static final String DEFEND_CVE_2014_0114_MODE = "contrast.defend.cve-2014-0114.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2014-0116.mode")
    @com.contrastsecurity.agent.config.a(a=F.class)
    public static final String DEFEND_CVE_2014_0116_MODE = "contrast.defend.cve-2014-0116.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2017-5638.mode")
    @com.contrastsecurity.agent.config.a(a=I.class)
    public static final String DEFEND_CVE_2017_5638_MODE = "contrast.defend.cve-2017-5638.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2017-9791.mode")
    @com.contrastsecurity.agent.config.a(a=J.class)
    public static final String DEFEND_CVE_2017_9791_MODE = "contrast.defend.cve-2017-9791.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2017-12616.mode")
    @com.contrastsecurity.agent.config.a(a=G.class)
    public static final String DEFEND_CVE_2017_12616_MODE = "contrast.defend.cve-2017-12616.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2017-12617.mode")
    @com.contrastsecurity.agent.config.a(a=H.class)
    public static final String DEFEND_CVE_2017_12617_MODE = "contrast.defend.cve-2017-12617.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2016-4438.mode")
    @com.contrastsecurity.agent.config.a(a=K.class)
    public static final String DEFEND_CVE_2016_4438_MODE = "contrast.defend.cve-2016-4438.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2016-3081.mode")
    @com.contrastsecurity.agent.config.a(a=L.class)
    public static final String DEFEND_CVE_2016_3081_MODE = "contrast.defend.cve-2016-3081.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.expression-language-injection.mode")
    @com.contrastsecurity.agent.config.a(a=O.class)
    public static final String DEFEND_EL_INJECTION_MODE = "contrast.defend.expression-language-injection.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.method-tampering.mode")
    @com.contrastsecurity.agent.config.a(a=P.class)
    public static final String DEFEND_METHOD_TAMPERING_MODE = "contrast.defend.method-tampering.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2010-4476.mode")
    @com.contrastsecurity.agent.config.a(a=Y.class)
    public static final String DEFEND_MOTB_MODE = "contrast.defend.cve-2010-4476.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.malformed-header.mode")
    @com.contrastsecurity.agent.config.a(a=X.class)
    public static final String DEFEND_MALFORMED_HEADER_MODE = "contrast.defend.malformed-header.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.ognl-injection.mode")
    @com.contrastsecurity.agent.config.a(a=Z.class)
    public static final String DEFEND_OGNL_MODE = "contrast.defend.ognl-injection.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.padding-oracle.mode")
    @com.contrastsecurity.agent.config.a(a=aa.class)
    public static final String DEFEND_PADDING_ORACLE_MODE = "contrast.defend.padding-oracle.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.path-traversal.mode")
    @com.contrastsecurity.agent.config.a(a=ab.class)
    public static final String DEFEND_PATH_TRAVERSAL_MODE = "contrast.defend.path-traversal.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="true", description="Detect when custom code attempts to access sensitive system files. The agent blocks if blocking is enabled.")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.path-traversal.detect_custom_code_accessing_system_files", c=Boolean.class)
    public static final String DEFEND_PT_CUSTOM_CODE_ACCESS = "contrast.defend.pathtraversal.detect_custom_code_accessing_system_files";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="true", description="Detect when users attempt to bypass filters by using \"::$DATA\" channels or null bytes in file names. The agent blocks if blocking is enabled.")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.path-traversal.detect_common_file_exploits", c=Boolean.class)
    public static final String DEFEND_PT_COMMON_EXPLOIT = "contrast.defend.pathtraversal.detect_common_file_exploits";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.redos.mode")
    @com.contrastsecurity.agent.config.a(a=ac.class)
    public static final String DEFEND_REDOS_MODE = "contrast.defend.redos.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2011-2732.mode")
    @com.contrastsecurity.agent.config.a(a=ae.class)
    public static final String DEFEND_SPRING_INJECTION_MODE = "contrast.defend.cve-2011-2732.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.sql-injection.mode")
    @com.contrastsecurity.agent.config.a(a=ad.class)
    public static final String DEFEND_SQL_MODE = "contrast.defend.sql-injection.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", description="Tell the agent to detect when semantic analysis of the query reveals database queries are being made for system tables and sensitive information. The agent blocks if blocking is enabled.")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.sql-injection.detect_suspicious_unions", c=Boolean.class)
    public static final String DEFEND_SQL_SEMANTIC_UNIONS = "contrast.defend.sqlinjection.suspiciousunions";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", description="Tell the agent to detect when semantic analysis of the query reveals tautologies used in exfiltration attacks (e.g., \"or 1=1\" or \"or 2<>3\"). The agent blocks if blocking is enabled.")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.sql-injection.detect_tautologies", c=Boolean.class)
    public static final String DEFEND_SQL_SEMANTIC_TAUTOLOGIES = "contrast.defend.sqlinjection.tautologies";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", description="Tell the agent to detect when semantic analysis of the query reveals chained queries, which is uncommon in normal usage but common in exploit. The agent blocks if blocking is enabled.")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.sql-injection.detect_chained_queries", c=Boolean.class)
    public static final String DEFEND_SQL_SEMANTIC_CHAINING = "contrast.defend.sqlinjection.chaining";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", description="controls whether aggressive comment filtering is used to block")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.sql-injection.aggressive_comment", c=Boolean.class)
    public static final String DEFEND_SQL_AGGRESSIVE_COMMENT = "contrast.defend.sqlinjection.aggressive_comment";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", description="Tell the agent to detect when semantic analysis of the query reveals the invocation of dangerous functions typically used in weaponized exploits. The agent blocks if blocking is enabled.")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.sql-injection.detect_dangerous_functions", c=Boolean.class)
    public static final String DEFEND_SQL_SEMANTIC_DANGEROUS_FUNCTIONS = "contrast.defend.sqlinjection.dangerous_functions";
    private static final int e = 300;
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, defaultValue="300", description="Set the number of queries for which semantic analysis findings are cached. Set to 0 to disable caching")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.semantic_findings_cache_size", c=Integer.class)
    public static final String DEFEND_SQL_SEMANTIC_FINDING_CACHE_SIZE = "contrast.semantic_findings_cache_size";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2013-2251.mode")
    @com.contrastsecurity.agent.config.a(a=af.class)
    public static final String DEFEND_CVE_2013_2251_MODE = "contrast.defend.cve-2013-2251.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.untrusted-deserialization.mode")
    @com.contrastsecurity.agent.config.a(a=ah.class)
    public static final String DEFEND_DESERIALIZATION_MODE = "contrast.defend.untrusted-deserialization.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cve-2016-3082.mode")
    @com.contrastsecurity.agent.config.a(a=ak.class)
    public static final String DEFEND_XSLT_MODE = "contrast.defend.cve-2016-3082.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.reflected-xss.mode")
    @com.contrastsecurity.agent.config.a(a=ai.class)
    public static final String DEFEND_XSS_MODE = "contrast.defend.reflected-xss.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.xxe.mode")
    @com.contrastsecurity.agent.config.a(a=aj.class)
    public static final String DEFEND_XXE_MODE = "contrast.defend.xxe.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block, block_at_perimeter, or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.unsafe-file-upload.mode")
    @com.contrastsecurity.agent.config.a(a=ag.class)
    public static final String DEFEND_UNSAFE_FILE_UPLOAD_MODE = "contrast.defend.unsafe-file-upload.mode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, nullDefaultValue=true, hidden=true, description="File path to overriding XSS keywords file")
    @com.contrastsecurity.agent.config.f(a="We don't need to make this available to users")
    public static final String UNSAFE_FILE_UPLOAD_KEYWORDS = "contrast.unsafe-file-upload.keywords";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, nullDefaultValue=true, hidden=true, description="Location of XSS patterns file")
    @com.contrastsecurity.agent.config.f(a="We don't need to make this available to users")
    public static final String UNSAFE_FILE_UPLOAD_PATTERNS = "contrast.unsafe-file-upload.patterns";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", hidden=true, description="boolean to enable/disable the threshold after which an input is no longer checked against possible attack patterns")
    @com.contrastsecurity.agent.config.f(a="We don't need to make this available to users")
    public static final String UNSAFE_FILE_UPLOAD_THRESHOLD_DISABLED = "contrast.unsafe-file-upload.threshold";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, hidden=true, defaultValue="OFF", description="if present, controls the mode of the rule; can be monitor, block or off (default: off)")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.zip-file-overwrite.mode")
    @com.contrastsecurity.agent.config.a(a=al.class)
    public static final String DEFEND_ZFO_MODE = "contrast.defend.zip-file-overwrite.mode";
    public static final int MAX_TIME_SINCE_REFRESH_SECS_DEFAULT = 30;
    public static final int MAX_TIME_TO_LIVE_SECS_DEFAULT = 90;
    public static final int ABSOLUTE_MAX_TIME_SINCE_REFRESH_SECS = 90;
    public static final int ABSOLUTE_MAX_TIME_TO_LIVE_SECS = 240;
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, hidden=true, defaultValue="90", description="Some rules keep state in order to detect repetitive or multi-payload attacks. This can be tuned down to eat less persistent heap")
    @com.contrastsecurity.agent.config.f(a="CONTRAST-30447")
    public static final String PROTECT_RULE_STATE_MAX_TIME = "contrast.defend.rulestate.ttlmax";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=ProtectionModeDTM.class, hidden=true, nullDefaultValue=true, description="Valid values: off, blocking, monitoring. An override setting for whether protection rules should all be in off, monitoring or blocking modes")
    @com.contrastsecurity.agent.config.f(a="JAVA-212")
    public static final String PROTECT_RULE_MODE_OVERRIDE = "contrast.defend.rulemode";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, hidden=true, defaultValue="30", description="Some rules keep state in order to detect repetitive or multi-payload attacks. This can be tuned down to eat less persistent heap")
    @com.contrastsecurity.agent.config.f(a="CONTRAST-30444")
    public static final String PROTECT_RULE_STATE_MAX_REFRESH = "contrast.defend.rulestate.ttlrefresh";
    public static final int PROTECT_ENCODINGS_THRESHOLD_DEFAULT = 3;
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, hidden=true, defaultValue="3", description="minimum nested encodings observed within a single input before blocking (0 for unlimited)")
    @com.contrastsecurity.agent.config.f.d(a="protect.encodings_threshold", c=Integer.class)
    public static final String PROTECT_ENCODINGS_THRESHOLD = "contrast.defend.maxencodings";
    @ActiveProperty(category=ActiveProperty.Category.POLICY, nullDefaultValue=true, description="If you set this value to a .jar file or URL path, Contrast will load the rules from it (Java 6+ only)")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.rules_jar")
    public static final String CUSTOM_RULES_JAR = "contrast.rules.jar";
    @ActiveProperty(category=ActiveProperty.Category.POLICY, nullDefaultValue=true, description="If you set this value to a file or URL, Contrast will use it in addition to the pre-packaged security policy. This means that rules from both the standard Contrast policy and your custom policy will be used, with conflicts being resolved in favor of the external policy, i.e. if two sources have the same ID, one in the internal policy and one in the external, the external source will be used.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.external_policy_files")
    public static final String POLICY = "contrast.policy";
    @ActiveProperty(category=ActiveProperty.Category.POLICY, nullDefaultValue=true, description="Same functionality as contrast.policy, but policies listed here have a higher priority, meaning that conflicts will be resolved in favor of the overrides policy, i.e. if two sources have the same ID, one in the policy and one in the override, the override source will be used. ")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.external_policy_overrides")
    public static final String POLICY_OVERRIDES = "contrast.policy.overrides";
    @ActiveProperty(category=ActiveProperty.Category.POLICY, nullDefaultValue=true, description="If you set this value to a file or URL, Contrast will use it instead of the pre-packaged security policy. For more information about rule customization, please contact your account manager.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.standalone_policy")
    public static final String POLICY_STANDALONE = "contrast.policy.standalone";
    @ActiveProperty(category=ActiveProperty.Category.POLICY, hidden=true, nullDefaultValue=true, description="A list of rule and custom trigger for each rule, formatted rule-id:com.package.Class.methodName(argType,argType,argType,...) where the argType of interest is marked with a *")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.custom_triggers")
    public static final String POLICY_CUSTOM_TRIGGERS = "contrast.policy.custom.triggers";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, description="list of comma-separated disabled rule ids")
    @com.contrastsecurity.agent.config.p(a=d.class)
    @com.contrastsecurity.agent.config.a(a=a.class)
    @com.contrastsecurity.agent.config.f.d(a="assess.rules.disabled_rules")
    public static final String ASSESS_DISABLED_RULES = "contrast.disabledrules";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, nullDefaultValue=true, description="list of comma-separated disabled source ids")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.disabled_sources")
    public static final String DISABLEDSOURCES = "contrast.disabledsources";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, nullDefaultValue=true, hidden=true, description="list of comma-separated disabled propagator ids")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.disabled_propagators")
    public static final String DISABLEDPROPAGATORS = "contrast.disabledpropagators";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, defaultValue="true", description="boolean to enable/disable loading of deadzones from policy")
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_deadzones", c=Boolean.class)
    public static final String DEADZONES = "contrast.deadzones";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, defaultValue="true", description="boolean to enable/disable loading of sources from policy")
    @com.contrastsecurity.agent.config.p(a=p.class)
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_sources", c=Boolean.class)
    public static final String SOURCES = "contrast.sources";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, defaultValue="true", description="boolean to enable/disable loading of dynamic sources from policy")
    @com.contrastsecurity.agent.config.p(a=e.class)
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_dynamic_sources", c=Boolean.class)
    public static final String DYNAMIC_SOURCES = "contrast.dynamicsources";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, defaultValue="true", description="boolean enable/disable loading of propagators from policy")
    @com.contrastsecurity.agent.config.p(a=h.class)
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_propagators", c=Boolean.class)
    public static final String PROPAGATORS = "contrast.propagators";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, defaultValue="true", description="boolean to enable/disable loading of tags from policy")
    @com.contrastsecurity.agent.config.p(a=q.class)
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_taggers", c=Boolean.class)
    public static final String TAGS = "contrast.tags";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, defaultValue="true", description="boolean to enable/disable loading of properties from policy")
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_properties", c=Boolean.class)
    public static final String ENABLE_PROPERTIES = "contrast.enable_properties";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, defaultValue="true", description="boolean enable/disable loading of annotations from policy")
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_annotations", c=Boolean.class)
    public static final String ANNOTATIONS = "contrast.annotations";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, defaultValue="true", description="boolean to enable/disable loading of rules from policy")
    @com.contrastsecurity.agent.config.p(a=i.class)
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_rules", c=Boolean.class)
    public static final String RULES = "contrast.rules";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, defaultValue="true", description="boolean to enable/disable loading of validators from policy")
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_validators", c=Boolean.class)
    public static final String VALIDATORS = "contrast.validators";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, hidden=true, defaultValue="true", description="boolean to enable/disable the real-time learning to tune Assess rules")
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_adaptive_optimization", c=Boolean.class)
    public static final String ADAPTIVE_OPTIMIZATION = "contrast.adaptiveoptimizations";
    public static final int ADAPTIVE_OPTIMIZATION_FREQUENCY_DEFAULT = 200;
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Integer.class, hidden=true, defaultValue="200", description="how many propagation events should be sampled to find low-yield code paths (turn higher to hurt short-term performance in order to find optimizations quicker)")
    @com.contrastsecurity.agent.config.f.d(a="assess.adaptive_optimization_frequency", c=Integer.class)
    public static final String ADAPTIVE_OPTIMIZATION_FREQUENCY = "contrast.adaptiveoptimizations.frequency";
    public static final int ADAPTIVE_OPTIMIZATION_MAX_DEFAULT = 20;
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Integer.class, hidden=true, defaultValue="20", description="how many instances of a particular low-yield propagation code path can be observed before being disabled")
    @com.contrastsecurity.agent.config.f.d(a="assess.adaptive_optimization_max", c=Integer.class)
    public static final String ADAPTIVE_OPTIMIZATION_MAXIMUM = "contrast.adaptiveoptimizations.max";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, defaultValue="false", hidden=true, description="controls whether or not data paths should be considered per-URI instead of globally")
    @com.contrastsecurity.agent.config.f.d(a="assess.adaptive_optimization_per_request", c=Boolean.class)
    public static final String ADAPTIVE_OPTIMIZATION_PER_REQUEST = "contrast.adaptiveoptimizations.sources.considerrequest";
    @RetirementNotice(retiringProperty="contrast.scopes")
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, defaultValue="true", description="boolean to enable/disable loading of validator-scopes")
    @com.contrastsecurity.agent.config.p(a=r.class)
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_validator_scopes", c=Boolean.class)
    public static final String VALIDATOR_SCOPES = "contrast.validator.scopes";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, hidden=true, type=Boolean.class, defaultValue="true", description="boolean to enable/disable loading of intern-prevention-scopes")
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_intern_scopes", c=Boolean.class)
    public static final String INTERN_PREVENTION_SCOPES = "contrast.internPrevention.scopes";
    public static final int MAXIMUM_SOURCE_EVENTS_DEFAULT = 100;
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, hidden=true, defaultValue="100", description="the maximum number of untrusted data flows to observe per request")
    @com.contrastsecurity.agent.config.f.d(a="assess.max_context_source_events", c=Integer.class)
    public static final String MAX_CONTEXT_SOURCE_EVENTS = "contrast.assess.context.max.sources";
    public static final int MAXIMUM_PROPAGATION_EVENTS_DEFAULT = 250;
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, hidden=true, defaultValue="250", description="the maximum number of untrusted data flow propagations to observe per request")
    @com.contrastsecurity.agent.config.f.d(a="assess.max_propagation_events", c=Integer.class)
    public static final String MAX_CONTEXT_PROPAGATION_EVENTS = "contrast.assess.context.max.propagations";
    public static final int MAXIMUM_CONTEXT_SNAPSHOTS_DEFAULT = 64;
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, hidden=true, defaultValue="64", description="the maximum number of cached method object snapshots per context")
    @com.contrastsecurity.agent.config.f.d(a="assess.max_cached_context_snapshots", c=Integer.class)
    public static final String MAX_CONTEXT_SNAPSHOT_CACHE_SIZE = "contrast.assess.context.max.snapshots";
    public static final long MAX_TRACE_TTL_MS_DEFAULT = 15000L;
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Long.class, hidden=true, defaultValue="15000", description="the number of milliseconds to retain a trace with a strongly held reference")
    @com.contrastsecurity.agent.config.f.d(a="assess.trace_max_ttl_ms", c=Long.class)
    public static final String MAX_TRACE_TTL = "contrast.trace.ttl.max";
    public static final TraceMapStrategy TRACE_MAP_STRATEGY_DEFAULT = TraceMapStrategy.BOTH;
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, hidden=true, defaultValue="both", description="the strategy for tracking data: 'global', which allows data to be tracked across threads and requests, 'context', which limits data flows to a single request/response scope, or 'both', which tries to use context scope, but defaults to both")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.trace_map_strategy")
    public static final String TRACE_MAP_STRATEGY = "contrast.trace.map";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="location of file containing Java properties style key, value pairs. ")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.properties_file")
    public static final String PROPERTIES = "contrast.properties";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", description="If present, used to determine if the Protect feature should be enabled. If not present, decision delegated to Contrast UI")
    @com.contrastsecurity.agent.config.p(a=M.class)
    @com.contrastsecurity.agent.config.f.d(a="protect.enable", c=Boolean.class)
    public static final String DEFEND_ENABLED = "contrast.defend.enabled";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="true", hidden=true, description="boolean to enable/disable AppCheck when Contrast is in DEFEND mode")
    @com.contrastsecurity.agent.config.f.d(a="protect.enable_appcheck", c=Boolean.class)
    public static final String DEFEND_APPCHECK_ENABLED = "contrast.defend.appcheck.enabled";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="true", description="boolean to enable/disable whether API request bodies should be scanned for attacks if no known deserializers are in use")
    @com.contrastsecurity.agent.config.f.d(a="protect.enable_api_request_body_reading", c=Boolean.class)
    public static final String DEFEND_API_BODY_READ = "contrast.defend.api.bodyread";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", description="configures Contrast to use simple signaturing to block traffic from scrapers, attack tools, and other unwanted automation.")
    @com.contrastsecurity.agent.config.p(a=t.class)
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.bot-blocker.enable", c=Boolean.class)
    public static final String DEFEND_BOT_BLOCKER_ENABLE = "contrast.defend.botblocker";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="true", hidden=true, description="boolean to enable/disable monitoring sinks when Contrast is in DEFEND mode")
    @com.contrastsecurity.agent.config.f.d(a="protect.enable_sinks", c=Boolean.class)
    public static final String DEFEND_SINKS = "contrast.defend.sinks";
    @RetirementNotice(retiringProperty="contrast.rasp.patterns")
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, nullDefaultValue=true, description="File path to overriding RASP patterns file (used when Contrast is in DEFEND mode)")
    @com.contrastsecurity.agent.config.f.d(a="protect.patterns_file")
    public static final String DEFEND_PATTERNS = "contrast.defend.patterns";
    @RetirementNotice(retiringProperty="contrast.rasp.telemetry.dir")
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, nullDefaultValue=true, description="File path to RASP telemetry directory (used when Contrast is in DEFEND mode)")
    @com.contrastsecurity.agent.config.f.d(a="protect.telemetry_directory")
    public static final String DEFEND_TELEMETRY_DIR = "contrast.defend.telemetry.dir";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", hidden=true, description="Outputs stack trace when agent fails to analyze request body deserialization")
    @com.contrastsecurity.agent.config.f.d(a="protect.enable_body_stacktraces", c=Boolean.class)
    public static final String DESERIALIZER_TRACE_BODY_READ = "contrast.deserializer.trace.body.read";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, nullDefaultValue=true, description="File path to overriding XSS keywords file")
    @com.contrastsecurity.agent.config.f.d(a="protect.xss_keywords_file")
    public static final String XSS_KEYWORDS = "contrast.xss.keywords";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, nullDefaultValue=true, description="Location of XSS patterns file")
    @com.contrastsecurity.agent.config.f.d(a="protect.xss_patterns_file")
    public static final String XSS_PATTERNS = "contrast.xss.patterns";
    @RetirementNotice(retiringProperty="contrast.xss.threshold.disabled")
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", hidden=true, description="boolean to enable/disable the threshold after which an input is no longer checked against possible attack patterns")
    @com.contrastsecurity.agent.config.f.d(a="protect.enable_xss_threshold", c=Boolean.class)
    public static final String XSS_THRESHOLD_DISABLED = "contrast.xss.threshold";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, nullDefaultValue=true, description="File path to overriding SQL Injection keywords file")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.sql-injection.keywords_file")
    public static final String SQLINJECTION_KEYWORDS = "contrast.sqlinjection.keywords";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, nullDefaultValue=true, description="Location of SQL Injection patterns file")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.sql-injection.patterns_file")
    public static final String SQLINJECTION_PATTERNS = "contrast.sqlinjection.patterns";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", hidden=true, description="boolean to enable/disable the threshold after which an input is no longer checked against possible SQL Injection attack patterns")
    @com.contrastsecurity.agent.config.f(a="CONTRAST-30448")
    public static final String SQLINJECTION_THRESHOLD_DISABLED = "contrast.sqlinjection.threshold";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", hidden=true, description="boolean to enable/disable the threshold after which an input is no longer checked against possible Command Injection attack patterns")
    @com.contrastsecurity.agent.config.f(a="CONTRAST-30449")
    public static final String CMDINJECTION_THRESHOLD_DISABLED = "contrast.cmdinjection.threshold";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, nullDefaultValue=true, description="File path to overriding Command Injection keywords file")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cmd-injection.keywords_file")
    public static final String CMDINJECTION_KEYWORDS = "contrast.cmdinjection.keywords";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, nullDefaultValue=true, description="Location of Command Injection patterns file")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.cmd-injection.patterns_file")
    public static final String CMDINJECTION_PATTERNS = "contrast.cmdinjection.patterns";
    @ActiveProperty(type=Boolean.class, defaultValue="false", hidden=true, description="Flag for testing xss detection strategy. This enables the backup search.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_xss_pids", c=Boolean.class)
    public static final String XSS_PIDS = "contrast.xss.pids";
    public static final int REDOS_STRING_ACCESS_LIMIT_DEFAULT = 3000000;
    @ActiveProperty(type=Integer.class, defaultValue="3000000", description="The number of character accesses that can occur when processing a regular expression before blocking occurs")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.redos_character_access_limit", c=Integer.class)
    public static final String REDOS_STRING_ACCESS_LIMIT = "contrast.redos.characcess.limit";
    public static final int MAX_INEFFECTIVE_SAMPLES_PER_PERIOD_DEFAULT = 50;
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, defaultValue="50", description="Max number of detailed reports generated for ineffective attacks detected during a reporting period")
    @com.contrastsecurity.agent.config.f.d(a="protect.samples.probed", c=Integer.class)
    public static final String DEFEND_INEFFECTIVE_SAMPLES = "contrast.defend.ineffective.samples";
    public static final int MAX_BLOCKED_SAMPLES_PER_PERIOD_DEFAULT = 25;
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, defaultValue="25", description="Max number of detailed reports generated for blocked attacks detected during a reporting period")
    @com.contrastsecurity.agent.config.f.d(a="protect.samples.blocked", c=Integer.class)
    public static final String DEFEND_BLOCKED_SAMPLES = "contrast.defend.blocked.samples";
    public static final int MAX_PERIM_BLOCKED_SAMPLES_PER_PERIOD_DEFAULT = 25;
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, defaultValue="25", description="Max number of detailed reports generated for perimeter blocked attacks detected during a reporting period")
    @com.contrastsecurity.agent.config.f.d(a="protect.samples.blocked_at_perimeter", c=Integer.class)
    public static final String DEFEND_PERIMETER_BLOCKED_SAMPLES = "contrast.defend.blockedperimeter.samples";
    public static final int MAX_EXPLOITED_SAMPLES_PER_PERIOD_DEFAULT = 100;
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, defaultValue="100", description="Max number of detailed reports generated for exploited attacks during a reporting period")
    @com.contrastsecurity.agent.config.f.d(a="protect.samples.exploited", c=Integer.class)
    public static final String DEFEND_EXPLOITED_SAMPLES = "contrast.defend.exploited.samples";
    public static final int MAX_SUSPICOUS_SAMPLES_PER_PERIOD_DEFAULT = 100;
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, defaultValue="100", description="Max number of detailed reports generated for suspicious attacks during a reporting period")
    @com.contrastsecurity.agent.config.f.d(a="protect.samples.suspicious", c=Integer.class)
    public static final String DEFEND_SUSPICIOUS_SAMPLES = "contrast.protect.suspicious.samples";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, description="Comma separated list of protect rules to disable for this JVM")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.disabled_rules")
    public static final String DEFEND_DISABLED_RULES = "contrast.defend.disabled.rules";
    @ActiveProperty(hidden=true, category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, defaultValue="1800000", description="Period during which the agent will reject requests from sources attempting to exploit a Padding Oracle before resetting its volumetric analysis")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.padding-oracle.breaker_reset_delay_ms", c=Integer.class)
    public static final String PADDING_ORACLE_BREAKER_RESET_DELAY = "contrast.protect.rules.padding-oracle.breaker_reset_delay_ms";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, defaultValue="20", description="Minimum number of padding errors to be observed within the padding-oracle detection window in order to be classified as malicious")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.padding-oracle.threshold", c=Integer.class, b={"protect.padding_oracle_threshold"})
    public static final String PADDING_ORACLE_THRESHOLD = "contrast.defend.paddingoracle.threshold";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, defaultValue="900000", description="Size of the sliding window (in milliseconds) within which the agent detects padding-oracle attacks using volumetric analysis.")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.padding-oracle.window_ms", c=Integer.class)
    public static final String PADDING_ORACLE_WINDOW_SIZE = "contrast.protect.rules.padding-oracle.window_ms";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, defaultValue="500", description="The maximum number of potential attackers to analyze concurrently. Increasing this value allows Contrast to track more potential sources of Padding Oracle attacks; however, it consumes more memory to do so.")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.padding-oracle.attackers_max", c=Integer.class)
    public static final String PADDING_ORACLE_ATTACKERS_MAX = "contrast.protect.rules.padding-oracle.attackers_max";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Integer.class, defaultValue="600000", description="The rate (in milliseconds) at which this agent will report blocked Padding Oracle attacks after the first such attack is discovered. This configuration keeps agents from sending potentially many redundant attack blocked reports during an ongoing Padding Oracle attack.")
    @com.contrastsecurity.agent.config.f.d(a="protect.rules.padding-oracle.report_rate_ms", c=Integer.class)
    public static final String PADDING_ORACLE_ATTACK_REPORT_RATE_MS = "contrast.protect.rules.padding-oracle.report_rate_ms";
    @ActiveProperty(type=Boolean.class, hidden=true, defaultValue="false", description="boolean to enable/disable the PerformanceMonitor utility class.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_performance_monitor", c=Boolean.class)
    public static final String PERF = "contrast.perf";
    @ActiveProperty(category=ActiveProperty.Category.RULES_CONFIG, type=Boolean.class, defaultValue="false", description="Set to \"true\" to factor in request URL when computing hash for reported finding")
    @com.contrastsecurity.agent.config.f.d(a="assess.include_url_in_finding_hash", c=Boolean.class)
    public static final String USE_URL_IN_HASH = "contrast.assess.hashing.includeurl";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Boolean.class, defaultValue="true", hidden=true, description="used to tell whether we should attempt to conserve heap by caching method signatures")
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_method_cache", c=Boolean.class)
    public static final String USE_METHOD_CACHE = "contrast.assess.methodcache";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="Location of shared library directory on WebSphere")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.websphere_shared_libs_directory")
    public static final String WEBSPHERE_SHARED_LIB_DIR = "contrast.websphere.shared.libs";
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, type=Boolean.class, defaultValue="true", description="boolean to enable/disable detecting security sensors")
    @com.contrastsecurity.agent.config.f.d(a="assess.enable_sensor_autodetection", c=Boolean.class)
    public static final String ASSESS_AUTODETECT_CONTROLS = "contrast.assess.autodetect.controls";
    @ActiveProperty(category=ActiveProperty.Category.DIAGNOSTICS, nullDefaultValue=true, description="A value that will be fed by attack testing tools in order to test stored XSS or other second-order injection attacks to be detected coming out of databases")
    @com.contrastsecurity.agent.config.f.d(a="assess.second_order_canary")
    public static final String ASSESS_DETECT_CANARIES = "contrast.assess.secondorder.canary";
    public static final int MAX_ASSESS_ENTRIES_PER_PERIOD_DEFAULT = 100;
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="100", description="The maximum number of vulnerabilities per rule type that can be discovered within a period defined by contrast.assess.threshold.period")
    @com.contrastsecurity.agent.config.f.d(a="assess.threshold.entries", c=Integer.class)
    public static final String ASSESS_THRESHOLD_ENTRIES = "contrast.assess.threshold.entries";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, nullDefaultValue=true, description="The period, in milliseconds, in which a maximum number of vulnerabilities per rule type can be discovered")
    @com.contrastsecurity.agent.config.f.d(a="assess.threshold.period_ms", c=Integer.class)
    public static final String ASSESS_THRESHOLD_PERIOD_MS = "contrast.assess.threshold.period.ms";
    @Deprecated
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="60", description="The period, in seconds, in which a maximum number of vulnerabilities per rule type can be discovered", deprecationAlternative="assess.threshold.period_ms")
    @com.contrastsecurity.agent.config.f(a="CONTRAST-30446")
    public static final String ASSESS_THRESHOLD_PERIOD = "contrast.assess.threshold.period";
    private static final int f = 20000;
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Integer.class, defaultValue="20000", description="size of queue that holds library update events that are intended to be sent to TeamServer")
    @com.contrastsecurity.agent.config.f.d(a="agent.reporting.library_update.observations.queue.size", c=Integer.class)
    public static final String LIBRARY_UPDATE_QUEUE_SIZE = "contrast.agent.reporting.library_update.queue.size";
    private static final int g = 3000;
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Integer.class, defaultValue="3000", description="size of queue that holds route observation events that are intended to be sent to TeamServer")
    @com.contrastsecurity.agent.config.f.d(a="agent.reporting.route_coverage.observations.queue.size", c=Integer.class)
    public static final String ROUTE_OBSERVATION_QUEUE_SIZE = "contrast.agent.reporting.route_coverage.queue.size";
    private static final int h = 3000;
    @ActiveProperty(hidden=true, category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Integer.class, defaultValue="3000", description="size of queue that holds silent telemetry events that are intended to be sent to TeamServer")
    @com.contrastsecurity.agent.config.f.d(a="agent.reporting.silent_telemetry.observations.queue.size", c=Integer.class)
    public static final String SILENT_TELEMETRY_QUEUE_SIZE = "contrast.agent.reporting.silent_telemetry.queue.size";
    private static final int i = 300;
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Integer.class, defaultValue="300", description="size of queue that holds app inventory events that are intended to be sent to TeamServer")
    @com.contrastsecurity.agent.config.f.d(a="agent.reporting.app_inventory.observations.queue.size", c=Integer.class)
    public static final String APP_INVENTORY_QUEUE_SIZE = "contrast.agent.reporting.app_inventory.queue.size";
    public static final long LEGACY_REPORTING_PERIOD_MS_DEFAULT = 5000L;
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Long.class, defaultValue="5000", description="Set the polling period for spooling reports.")
    @com.contrastsecurity.agent.config.f.d(a="agent.polling.reporting_period_ms", c=Long.class)
    public static final String LEGACY_REPORTING_PERIOD = "contrast.reporting.period";
    private static final long j = 500L;
    @ActiveProperty(hidden=true, category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Integer.class, defaultValue="500", description="Specifies period between sending single report to TeamServer through the agent reporting service.")
    @com.contrastsecurity.agent.config.f.d(a="agent.reporting.period", c=Integer.class)
    public static final String REPORTING_PERIOD = "contrast.agent.reporting.period";
    public static final long DUP_DELAY_MS_DEFAULT = 5000L;
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Long.class, defaultValue="5000", description="The period for which duplicate traces, based on Contrast hashing methods, will be supressed (in milliseconds)")
    @com.contrastsecurity.agent.config.f.d(a="assess.duplicate_delay_ms", c=Long.class)
    public static final String DUP_DELAY = "contrast.duplicate.delay";
    @ActiveProperty(nullDefaultValue=true, description="Set the path to a file containing line-separated URLs patterns which don't require CSRF tokens")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.csrf_exempt_urls_file")
    public static final String CSRF_IDEMPOTENT_URLS = "csrf.allowed.urls";
    @ActiveProperty(nullDefaultValue=true, description="Set the path to a file containing line-separated URLs patterns which require CSRF tokens")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.csrf_protected_urls_file")
    public static final String CSRF_PROTECTED_URLS = "csrf.protected.urls";
    @ActiveProperty(nullDefaultValue=true, description="A comma-separated list of allowed file suffixes which CSRF won't consider as evidence of state change")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.csrf_exempt_suffixes_file")
    public static final String CSRF_ALLOWED_FILEWRITE_SUFFIXES = "csrf.allowed.filewrite.suffixes";
    @ActiveProperty(hidden=true, type=Boolean.class, defaultValue="true", description="By default, the Java agent will visit all classes at startup to look for vulnerabilities which may be detected by scanning a class (for example, hardcoded passwords). Set this property to `false` to disable the default behavior so that the agent will instead only visit classes which are likely to require sensors. This can improve application startup time, but may produce less findings (most likely those which require static analysis).")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.scan_all_code_sources", c=Boolean.class)
    public static final String SCAN_CODE_SOURCES = "contrast.process.codesources";
    @ActiveProperty(hidden=true, type=Boolean.class, defaultValue="true", description="By default, the Java agent will deeply inspect all jar and war files loaded by the JVM in order to build a comprehensive understanding of the type hierarchy. Building this comprehensive understanding allows Contrast to instrument sensors into types that it might otherwise overlook. In most cases this produces a slight increase in accuracy at the cost of increased application startup time. Customers can disable this scanning by setting this property to `false`.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.scan_all_classes", c=Boolean.class)
    public static final String INSPECT_ALL_CLASSES = "contrast.inspect.allclasses";
    @ActiveProperty(hidden=true, nullDefaultValue=true, description="A path on disk where additional hierarchy information can be found (as XML)")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.hierarchy_file")
    public static final String HIERARCHY_OVERRIDE = "contrast.hierarchy.path";
    @ActiveProperty(nullDefaultValue=true, hidden=true, description="A comma-separated list of packages that Contrast should deeply scan for SMAP information, vulnerabilities, and other app-related analysis")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.user_packages")
    public static final String PACKAGES_TO_SCAN = "contrast.user.packages";
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Boolean.class, defaultValue="false", description="boolean to enable/disable preflight reporting fail open. In this case, fail open means that in the event of an error during a preflight check, all reports will be sent to TeamServer. Typically, the Contrast Agent uses a preflight hashing mechanism to avoid duplicate reporting, reducing load on TeamServer. Occasionally, this process can be overwhelmed, and TeamServer cannot reply quickly enough. In this case, in order to avoid losing any vulnerability data, the Agent will send any reports that are being filtered by preflight. While TeamServer can usually recover and resume preflight, it sometimes falls behind (for instance if the application being monitored is placed under a load test). To ensure that TeamServer has a chance to catch up, you can set this flag to false; however, it is worth noting that doing so may result in lost vulnerability information as all reports will be disregarded.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_preflight_fail_open", c=Boolean.class)
    public static final String PREFLIGHT_FAIL_OPEN = "contrast.preflight.open";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", hidden=true, description="boolean to enable/disable XML scanning inside of individual parameters")
    @com.contrastsecurity.agent.config.f.d(a="protect.enable_xml_parameter_inspection", c=Boolean.class)
    public static final String INSPECT_PARAMETERS_AS_XML = "contrast.defend.parameters.xml";
    @ActiveProperty(category=ActiveProperty.Category.DEFEND_MODE_CONFIG, type=Boolean.class, defaultValue="false", hidden=true, description="boolean to enable/disable JSON scanning inside of individual parameters")
    @com.contrastsecurity.agent.config.f.d(a="protect.enable_json_parameter_inspection", c=Boolean.class)
    public static final String INSPECT_PARAMETERS_AS_JSON = "contrast.defend.parameters.json";
    public static final int STARTUP_DELAY_DEFAULT = 0;
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, type=Integer.class, defaultValue="0", description="this is the number of milliseconds to delay startup of the agent, if 0 or less, no startup delay")
    @com.contrastsecurity.agent.config.f.d(a="agent.startup_delay_ms", c=Integer.class)
    public static final String DELAYED_STARTUP = "contrast.startup.delay";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, defaultValue="activation", description="can be 'activation' or 'boot'; when doing delayed startup, what strategy should be used.  For `activation` booting and instrumentation do take place but the sensors are only enabled later.  For `boot` very little action is taken at agent startup, the agent booting and instrumentation occur later after the delay period.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.delayed_startup_strategy")
    public static final String DELAYED_STARTUP_STRATEGY = "contrast.startup.strategy";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, type=Boolean.class, defaultValue="true", hidden=true, description="whether or not instruction caching is allowed")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.allow_instruction_caching", c=Boolean.class)
    public static final String ALLOW_INSTRUCTION_CACHE = "contrast.instrcache.allow";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="the name of the environment this server should be associated with in the TeamServer")
    @com.contrastsecurity.agent.config.f.d(a="server.environment")
    public static final String SERVER_ENVIRONMENT = "contrast.env";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="the name of the application group this application should be associated with in the TeamServer")
    @com.contrastsecurity.agent.config.f.d(a="application.group", d=true)
    public static final String GROUP = "contrast.group";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="the 'application code' for the application to be used in TeamServer")
    @com.contrastsecurity.agent.config.f.d(a="application.code", d=true)
    public static final String APP_CODE = "contrast.application.code";
    public static final int SUMMARIZED_EVENTS_BEFORE_FREEZE_DEFAULT = 140;
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="140", description="Number of summarized events in a trace before trace is frozen", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.trace_summary.freeze_threshold", c=Integer.class)
    public static final String FREEZE_THRESHOLD = "contrast.freeze.threshold";
    public static final int EVENTS_BEFORE_SUMMARY_DEFAULT = 100;
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="100", description="Number of events in a trace before summarization kicks in", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.trace_summary.threshold", c=Integer.class)
    public static final String SUMMARIZATION_THRESHOLD = "contrast.summarization.threshold";
    public static final int EVENTS_PRECEDING_SUMMARY_DEFAULT = 10;
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="10", description="Number of leading events to preserve when summarizing a trace", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.trace_summary.leading_events", c=Integer.class)
    public static final String SUMMARIZATION_LEADING_EVENTS = "contrast.summarization.leading.events";
    public static final int EVENTS_FOLLOWING_SUMMARY_DEFAULT = 10;
    @ActiveProperty(category=ActiveProperty.Category.PERFORMANCE, type=Integer.class, defaultValue="10", description="Minimum number of trailing events to preserve when summarizing a trace", hidden=true)
    @com.contrastsecurity.agent.config.f.d(a="agent.java.trace_summary.trailing_events", c=Integer.class)
    public static final String SUMMARIZATION_TRAILING_EVENTS = "contrast.summarization.trailing.events";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="Overrides the Contrast user name.")
    @com.contrastsecurity.agent.config.f.d(a="api.user_name", b={"contrast.user_name"})
    public static final String USER_NAME = "contrast.user.name";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, shouldMask=true, description="Overrides the Contrast api key.")
    @com.contrastsecurity.agent.config.f.d(a="api.api_key", b={"contrast.api_key"})
    public static final String API_KEY = "contrast.api.key";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, shouldMask=true, description="Overrides the Contrast service key.")
    @com.contrastsecurity.agent.config.f.d(a="api.service_key", b={"contrast.service_key"})
    public static final String SERVICE_KEY = "contrast.service.key";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, defaultValue="Java", hidden=true, description="Override the reported VM")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.vm_id")
    public static final String VM_ID = "contrast.vm.id";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, description="Overrides the detected context path (location) of the application. This affects the \"Application-Path\" header value when sending reports. Overriding this could cause reports to be thrown away.")
    @com.contrastsecurity.agent.config.f.d(a="application.path")
    public static final String APPLICATION_PATH = "contrast.application.path";
    @ActiveProperty(category=ActiveProperty.Category.INTERNAL_USAGE, type=Boolean.class, defaultValue="false", hidden=true, description="USE WITH CAUTION! If enabled, Contrast will intentionally fail to start up if certain conditions are met! Currently, this includes detecting if a retired/deprecated property is in use.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.enable_strict_startup", c=Boolean.class)
    public static final String STRICT = "contrast.testing.strict";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, type=Boolean.class, defaultValue="true", description="Controls caching of basic information gathered from detected libraries.")
    @com.contrastsecurity.agent.config.f.d(a="agent.java.cache_library_facts", c=Boolean.class)
    public static final String INVENTORY_CACHE_LIBRARY_FACTS = "contrast.inventory.cache.library.facts";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, defaultValue="true", type=Boolean.class, description="Toggle the route based coverage feature")
    @com.contrastsecurity.agent.config.f.d(a="agent.route_coverage.enable", c=Boolean.class)
    public static final String ROUTE_COVERAGE = "contrast.agent.route_coverage.enable";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, nullDefaultValue=true, hidden=true, description="List of JAR, EAR, or WAR file names to skip during library scanning")
    @com.contrastsecurity.agent.config.f.d(a="inventory.blacklist")
    public static final String INVENTORY_DENYLIST = "contrast.inventory.blacklist";
    @ActiveProperty(defaultValue="false", type=Boolean.class, description="Set to true to enable functionality in the com.contrastsecurity.agent.reloadable package. This is only needed for our legacy integration tests", hidden=true)
    @com.contrastsecurity.agent.config.f(a="This should be removed along with the integration tests")
    public static final String ENABLE_RELOADABLE_BEANS = "contrast.agent.java.enable_reloadable_beans";
    @ActiveProperty(category=ActiveProperty.Category.GENERAL_PROPERTIES, defaultValue="false", type=Boolean.class, description="Toggle the diagnostics telemetry feature", hidden=true)
    @com.contrastsecurity.agent.config.p(a=N.class)
    @com.contrastsecurity.agent.config.f.d(a="agent.diagnostics.enable", c=Boolean.class)
    public static final String DIAGNOSTICS_TELEMETRY = "contrast.agent.diagnostics.enable";
    public static final Map<String, com.contrastsecurity.agent.config.f.d> INTERNAL_TO_YAML = com.contrastsecurity.agent.config.h.a(ContrastProperties.class, com.contrastsecurity.agent.config.f.d.class);

    private static boolean e(FeatureSet featureSet) {
        return featureSet != null && featureSet.getAssessment() != null;
    }

    private static boolean f(FeatureSet featureSet) {
        return ContrastProperties.e(featureSet) && featureSet.getAssessment().getSampling() != null;
    }

    private static boolean g(FeatureSet featureSet) {
        return featureSet != null && featureSet.getDefend() != null;
    }

    private static boolean h(FeatureSet featureSet) {
        return ContrastProperties.g(featureSet) && featureSet.getDefend().getSyslog() != null;
    }

    private static boolean b(Integer n2) {
        return n2 != null && n2 > 0;
    }

    private ContrastProperties() {
    }

    static class N
    implements com.contrastsecurity.agent.config.r<Boolean> {
        N() {
        }

        public Boolean a(FeatureSet featureSet) {
            if (featureSet != null && featureSet.getTelemetry() != null) {
                return featureSet.getTelemetry().getEnable();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class t
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            DefendFeatures defendFeatures = featureSet.getDefend();
            if (defendFeatures == null) {
                return null;
            }
            return defendFeatures.isBotProtectionEnabled();
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class M
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (ContrastProperties.g(featureSet)) {
                return featureSet.getDefend().isEnabled();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class r
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (ContrastProperties.e(featureSet)) {
                return featureSet.getAssessment().isUseValidatorScopes();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class i
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (ContrastProperties.e(featureSet)) {
                return featureSet.getAssessment().isUseRules();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class q
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (ContrastProperties.e(featureSet)) {
                return featureSet.getAssessment().isUseTaggers();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class h
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (ContrastProperties.e(featureSet)) {
                return featureSet.getAssessment().isUsePropagators();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class e
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (ContrastProperties.e(featureSet)) {
                return featureSet.getAssessment().isUseDynamicSources();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class p
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (ContrastProperties.e(featureSet)) {
                return featureSet.getAssessment().isUseSources();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static final class a
    implements com.contrastsecurity.agent.config.b<String> {
        public String b(com.contrastsecurity.agent.d.e e2, ApplicationSettingsDTM applicationSettingsDTM) {
            if (applicationSettingsDTM == null) {
                return null;
            }
            ApplicationAssessSettingsDTM applicationAssessSettingsDTM = applicationSettingsDTM.getAssessment();
            if (applicationAssessSettingsDTM == null) {
                return null;
            }
            Set<String> set = applicationAssessSettingsDTM.getDisabledRules();
            if (set == null || set.isEmpty()) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder(set.size() * 16);
            for (String string : set) {
                stringBuilder.append(string);
                stringBuilder.append(',');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }

        @Override
        public /* synthetic */ Object a(com.contrastsecurity.agent.d.e e2, ApplicationSettingsDTM applicationSettingsDTM) {
            return this.b(e2, applicationSettingsDTM);
        }
    }

    public static class d
    implements com.contrastsecurity.agent.config.r<String> {
        public String a(FeatureSet featureSet) {
            if (featureSet == null || featureSet.getAssessment() == null) {
                return null;
            }
            Set<String> set = featureSet.getAssessment().getDisabledRules();
            if (set == null || set.isEmpty()) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : set) {
                stringBuilder.append(string);
                stringBuilder.append(',');
            }
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            return stringBuilder.toString();
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static final class al
    extends b.a {
        al() {
            super("zip-file-overwrite");
        }
    }

    public static final class ag
    extends b.a {
        ag() {
            super("unsafe-file-upload");
        }
    }

    public static final class aj
    extends b.a {
        aj() {
            super("xxe");
        }
    }

    public static final class ai
    extends b.a {
        ai() {
            super("reflected-xss");
        }
    }

    public static final class ak
    extends b.a {
        ak() {
            super("cve-2016-3082");
        }
    }

    public static final class ah
    extends b.a {
        ah() {
            super("untrusted-deserialization");
        }
    }

    public static final class af
    extends b.a {
        af() {
            super("cve-2013-2251");
        }
    }

    public static final class ad
    extends b.a {
        ad() {
            super("sql-injection");
        }
    }

    public static final class ae
    extends b.a {
        ae() {
            super("cve-2011-2732");
        }
    }

    public static final class ac
    extends b.a {
        ac() {
            super("redos");
        }
    }

    public static final class ab
    extends b.a {
        ab() {
            super("path-traversal");
        }
    }

    public static final class aa
    extends b.a {
        aa() {
            super("padding-oracle");
        }
    }

    public static final class Z
    extends b.a {
        Z() {
            super("ognl-injection");
        }
    }

    public static final class X
    extends b.a {
        X() {
            super("malformed-header");
        }
    }

    public static final class Y
    extends b.a {
        Y() {
            super("cve-2010-4476");
        }
    }

    public static final class P
    extends b.a {
        P() {
            super("method-tampering");
        }
    }

    public static final class O
    extends b.a {
        O() {
            super("expression-language-injection");
        }
    }

    public static final class L
    extends b.a {
        L() {
            super("cve-2016-3081");
        }
    }

    public static final class K
    extends b.a {
        K() {
            super("cve-2016-4438");
        }
    }

    public static final class H
    extends b.a {
        H() {
            super("cve-2017-12617");
        }
    }

    public static final class G
    extends b.a {
        G() {
            super("cve-2017-12616");
        }
    }

    public static final class J
    extends b.a {
        J() {
            super("cve-2017-9791");
        }
    }

    public static final class I
    extends b.a {
        I() {
            super("cve-2017-5638");
        }
    }

    public static final class F
    extends b.a {
        F() {
            super("cve-2014-0116");
        }
    }

    public static final class E
    extends b.a {
        E() {
            super("cve-2014-0114");
        }
    }

    public static final class D
    extends b.a {
        D() {
            super("cve-2014-0112");
        }
    }

    public static final class C
    extends b.a {
        C() {
            super("cve-2011-2730");
        }
    }

    public static class B
    extends b.a {
        B() {
            super("cmd-injection");
        }
    }

    public static final class s
    extends b.a {
        s() {
            super("cve-2010-1622");
        }
    }

    public static class A
    implements com.contrastsecurity.agent.config.r<String> {
        public String a(FeatureSet featureSet) {
            if (ContrastProperties.h(featureSet)) {
                SyslogSeverity syslogSeverity = featureSet.getDefend().getSyslog().getSyslogSeverityProbed();
                return syslogSeverity == null ? null : syslogSeverity.name();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class u
    implements com.contrastsecurity.agent.config.r<String> {
        public String a(FeatureSet featureSet) {
            if (ContrastProperties.h(featureSet)) {
                SyslogSeverity syslogSeverity = featureSet.getDefend().getSyslog().getSyslogSeverityBlocked();
                return syslogSeverity == null ? null : syslogSeverity.name();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class w
    implements com.contrastsecurity.agent.config.r<String> {
        public String a(FeatureSet featureSet) {
            if (ContrastProperties.h(featureSet)) {
                SyslogSeverity syslogSeverity = featureSet.getDefend().getSyslog().getSyslogSeverityExploited();
                return syslogSeverity == null ? null : syslogSeverity.name();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class x
    implements com.contrastsecurity.agent.config.r<Integer> {
        public Integer a(FeatureSet featureSet) {
            if (ContrastProperties.h(featureSet)) {
                return featureSet.getDefend().getSyslog().getSyslogFacilityCode();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class z
    implements com.contrastsecurity.agent.config.r<Integer> {
        public Integer a(FeatureSet featureSet) {
            if (ContrastProperties.h(featureSet)) {
                return featureSet.getDefend().getSyslog().getSyslogPortNumber();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class y
    implements com.contrastsecurity.agent.config.r<String> {
        public String a(FeatureSet featureSet) {
            if (ContrastProperties.h(featureSet)) {
                return featureSet.getDefend().getSyslog().getSyslogIpAddress();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class v
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (ContrastProperties.h(featureSet)) {
                return featureSet.getDefend().getSyslog().isSyslogEnabled();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    static class W
    implements com.contrastsecurity.agent.config.r<String> {
        W() {
        }

        public String a(FeatureSet featureSet) {
            return featureSet.getLogFile();
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    static class V
    implements com.contrastsecurity.agent.config.r<String> {
        V() {
        }

        public String a(FeatureSet featureSet) {
            return featureSet.getLogLevel();
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class o
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (ContrastProperties.e(featureSet)) {
                return featureSet.getAssessment().isScanningResponse();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    static class n
    implements com.contrastsecurity.agent.config.r<Integer> {
        n() {
        }

        public Integer a(FeatureSet featureSet) {
            if (ContrastProperties.f(featureSet)) {
                Integer n2 = featureSet.getAssessment().getSampling().getWindow();
                return ContrastProperties.b(n2) ? Integer.valueOf(n2 * 1000) : null;
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    static class m
    implements com.contrastsecurity.agent.config.r<Integer> {
        m() {
        }

        public Integer a(FeatureSet featureSet) {
            if (ContrastProperties.f(featureSet)) {
                Integer n2 = featureSet.getAssessment().getSampling().getResponseFrequency();
                return ContrastProperties.b(n2) ? n2 : null;
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    static class l
    implements com.contrastsecurity.agent.config.r<Integer> {
        l() {
        }

        public Integer a(FeatureSet featureSet) {
            if (ContrastProperties.f(featureSet)) {
                Integer n2 = featureSet.getAssessment().getSampling().getRequestFrequency();
                return ContrastProperties.b(n2) ? n2 : null;
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    static class j
    implements com.contrastsecurity.agent.config.r<Integer> {
        j() {
        }

        public Integer a(FeatureSet featureSet) {
            if (ContrastProperties.f(featureSet)) {
                Integer n2 = featureSet.getAssessment().getSampling().getBaseline();
                return ContrastProperties.b(n2) ? n2 : null;
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    static class k
    implements com.contrastsecurity.agent.config.r<Boolean> {
        k() {
        }

        public Boolean a(FeatureSet featureSet) {
            if (ContrastProperties.f(featureSet)) {
                return featureSet.getAssessment().getSampling().isEnabled();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class R
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (featureSet == null || featureSet.getInventory() == null) {
                return null;
            }
            return featureSet.getInventory().isReportActivity();
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class f
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (ContrastProperties.e(featureSet)) {
                return featureSet.getAssessment().isEnabled();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class g
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (ContrastProperties.e(featureSet)) {
                return featureSet.getAssessment().isIdentityTagging();
            }
            return null;
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class U
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (featureSet == null || featureSet.getInventory() == null) {
                return null;
            }
            return featureSet.getInventory().isMonitorWebCalls();
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class S
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (featureSet == null || featureSet.getInventory() == null) {
                return null;
            }
            return featureSet.getInventory().isMonitorLdap();
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class Q
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (featureSet == null || featureSet.getInventory() == null) {
                return null;
            }
            return featureSet.getInventory().isMonitorDatabase();
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static final class c
    implements com.contrastsecurity.agent.config.b<String> {
        public static final e.a<String> a = e.a.a(String.class);

        public String b(com.contrastsecurity.agent.d.e e2, ApplicationSettingsDTM applicationSettingsDTM) {
            return e2.a(a);
        }

        @Override
        public /* synthetic */ Object a(com.contrastsecurity.agent.d.e e2, ApplicationSettingsDTM applicationSettingsDTM) {
            return this.b(e2, applicationSettingsDTM);
        }
    }

    public static class T
    implements com.contrastsecurity.agent.config.r<Boolean> {
        public Boolean a(FeatureSet featureSet) {
            if (featureSet == null || featureSet.getInventory() == null) {
                return null;
            }
            return featureSet.getInventory().isAnalyzeLibraries();
        }

        @Override
        public /* synthetic */ Object b(FeatureSet featureSet) {
            return this.a(featureSet);
        }
    }

    public static class b
    implements com.contrastsecurity.agent.config.b<String> {
        public String b(com.contrastsecurity.agent.d.e e2, ApplicationSettingsDTM applicationSettingsDTM) {
            if (applicationSettingsDTM == null) {
                return null;
            }
            ApplicationAssessSettingsDTM applicationAssessSettingsDTM = applicationSettingsDTM.getAssessment();
            return applicationAssessSettingsDTM == null ? null : applicationAssessSettingsDTM.getSessionId();
        }

        @Override
        public /* synthetic */ Object a(com.contrastsecurity.agent.d.e e2, ApplicationSettingsDTM applicationSettingsDTM) {
            return this.b(e2, applicationSettingsDTM);
        }
    }
}

