/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.Contrast;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.http.a;
import com.contrastsecurity.agent.http.b;
import com.contrastsecurity.agent.http.j;
import com.contrastsecurity.agent.http.k;
import com.contrastsecurity.agent.http.r;
import com.contrastsecurity.agent.j.c;
import com.contrastsecurity.agent.j.d;
import com.contrastsecurity.agent.messages.mq.HttpRequestResponseDTM;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.util.K;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.org.apache.commons.io.FileUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@DontObfuscate
public class HttpManager
implements a {
    private final com.contrastsecurity.agent.plugins.g pluginManager;
    private final ApplicationManager applicationManager;
    private j publisher;
    private final ThreadLocal<HttpRequest> httpRequest = new ThreadLocal<HttpRequest>(){

        protected HttpRequest a() {
            return null;
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.a();
        }
    };
    private final ThreadLocal<HttpResponse> httpResponse = new ThreadLocal<HttpResponse>(){

        protected HttpResponse a() {
            return null;
        }

        @Override
        protected /* synthetic */ Object initialValue() {
            return this.a();
        }
    };
    private static final List<ContrastPlugin> EMPTY_PLUGINS = new LinkedList<ContrastPlugin>();
    public static final int MAX_CONCURRENT_USERS = Contrast.config().c("contrast.concurrent.requests");
    private static final Logger logger = LoggerFactory.getLogger(HttpManager.class);

    public HttpManager(com.contrastsecurity.agent.plugins.g g2, ApplicationManager applicationManager) {
        this.pluginManager = g2;
        this.applicationManager = applicationManager;
    }

    public void initialize(g g2) {
        boolean bl = g2.f("contrast.mq");
        if (bl) {
            c c2 = new c(d.a());
            this.publisher = new k(Collections.singletonList(c2));
        }
    }

    public HttpRequest getCurrentRequest() {
        Application application;
        HttpRequest httpRequest = this.httpRequest.get();
        if (httpRequest == null && (application = this.applicationManager.current()) != null) {
            httpRequest = application.findRequest();
        }
        return httpRequest;
    }

    public HttpRequest cloneCurrentRequest() {
        HttpRequest httpRequest = this.getCurrentRequest();
        return httpRequest == null ? null : httpRequest.clone();
    }

    public void setCurrentRequest(HttpRequest httpRequest) {
        try {
            this.updateRequestCrumbs(httpRequest);
        }
        catch (Exception exception) {
            logger.error("Problem updating HTTP request crumbs", exception);
        }
        if (httpRequest == null) {
            this.httpRequest.remove();
        } else {
            this.httpRequest.set(httpRequest);
        }
    }

    public void setCurrentResponse(HttpResponse httpResponse) {
        try {
            this.updateResponseBreadCrumbs(httpResponse);
        }
        catch (Exception exception) {
            logger.error("Problem updating HTTP response crumbs", exception);
        }
        if (httpResponse == null) {
            this.httpResponse.remove();
        } else {
            this.httpResponse.set(httpResponse);
        }
    }

    public HttpResponse getCurrentResponse() {
        Application application;
        HttpResponse httpResponse = this.httpResponse.get();
        if (httpResponse == null && (application = this.applicationManager.current()) != null && (httpResponse = application.findResponse()) != null) {
            this.httpResponse.set(httpResponse);
        }
        return httpResponse;
    }

    private void updateRequestCrumbs(HttpRequest httpRequest) {
        if (httpRequest == null) {
            HttpRequest httpRequest2 = this.httpRequest.get();
            if (httpRequest2 != null) {
                httpRequest2.updateBreadCrumbs(b.b.c);
            }
        } else {
            httpRequest.updateBreadCrumbs(b.b.b);
        }
    }

    private void updateResponseBreadCrumbs(HttpResponse httpResponse) {
        if (httpResponse == null) {
            HttpResponse httpResponse2 = this.httpResponse.get();
            if (httpResponse2 != null) {
                httpResponse2.updateBreadCrumbs(b.b.c);
            }
        } else {
            httpResponse.updateBreadCrumbs(b.b.b);
        }
    }

    public void onRequestStart(HttpRequest httpRequest) {
        List<ContrastPlugin> list = this.pluginManager.getPlugins();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            if (!contrastPlugin.isActivated()) continue;
            List<r> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                r r2 = list2.get(i3);
                r2.a(httpRequest);
            }
        }
    }

    public void onResponseStart(HttpRequest httpRequest, HttpResponse httpResponse) {
        List<ContrastPlugin> list = this.pluginManager.getPlugins();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            if (!contrastPlugin.isActivated()) continue;
            List<r> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                r r2 = list2.get(i3);
                r2.a(httpRequest, httpResponse);
            }
        }
    }

    public void onRequestEnd() {
        Object object;
        HttpRequest httpRequest = this.getCurrentRequest();
        HttpResponse httpResponse = this.getCurrentResponse();
        if (this.publisher != null) {
            this.publisher.a(new HttpRequestResponseDTM(httpRequest.toMqHttpRequestDTM(), httpResponse.toHttpResponseDTM()));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Request ending for {} - response is {} and output mechanism is {}", httpRequest != null ? httpRequest.getUri() : "(null)", K.a(httpResponse), httpResponse != null ? K.a(httpResponse.getOutputMechanism()) : "response-null");
            if (httpResponse != null && httpResponse.getOutputMechanism() != null) {
                object = httpResponse.getOutputMechanism();
                logger.debug("De-assigning output mechanism {}", (Object)K.a(object));
            }
        }
        if (httpResponse != null && httpResponse.isCapturingInFile()) {
            logger.debug("Closing response file");
            try {
                httpResponse.closeFileBuffer();
            }
            catch (IOException iOException) {
                logger.error("Problem closing response file buffer", iOException);
            }
        }
        if (httpRequest != null && httpRequest.isScanningResponse()) {
            this.analyzeResponseContents(httpRequest, httpResponse);
        }
        if (logger.isDebugEnabled() && (httpRequest == null || httpResponse == null)) {
            this.logCrumbData(httpRequest, httpResponse);
        }
        object = this.pluginManager.getPlugins();
        for (int i2 = 0; i2 < object.size(); ++i2) {
            ContrastPlugin contrastPlugin = object.get(i2);
            if (!contrastPlugin.isActivated()) continue;
            List<r> list = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list.size(); ++i3) {
                r r2 = list.get(i3);
                try {
                    r2.b(httpRequest, httpResponse);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.warn("Problem ending request watching with {}", (Object)r2, (Object)throwable);
                }
            }
        }
        this.setCurrentRequest(null);
        this.setCurrentResponse(null);
        this.applicationManager.current(null);
    }

    void analyzeResponseContents(HttpRequest httpRequest, HttpResponse httpResponse) {
        String string = httpRequest.getUri();
        if (httpResponse != null && !httpResponse.isEmpty()) {
            logger.debug("Scanning response for {}", (Object)string);
            byte[] byArray = ObjectShare.EMPTY_BYTE_ARRAY;
            if (httpResponse.isCapturingInMemory()) {
                byArray = httpResponse.getMemoryBuffer().c();
            } else if (httpResponse.isCapturingInFile()) {
                byArray = this.readFile(httpResponse.getFileBufferPath());
            } else {
                logger.warn("Problem scanning response to {}: nothing captured in memory or file!", (Object)string);
            }
            String string2 = "";
            try {
                String string3 = httpResponse.getCharacterEncoding();
                if (string3 == null || !Charset.isSupported(string3)) {
                    string3 = Charset.defaultCharset().name();
                }
                string2 = new String(byArray, string3);
                logger.debug("Scanning {} response text with length {}/charset {}", string, string2.length(), string3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                logger.error("Couldn't parse response body because of weird encoding", unsupportedEncodingException);
            }
            this.delegateResponseWrittenEvent(httpRequest, httpResponse, string2);
        } else {
            logger.debug("Response was null or empty for URI {}", (Object)string);
        }
    }

    private void logCrumbData(HttpRequest httpRequest, HttpResponse httpResponse) {
        logger.debug("Unexpected null(s) - time to examine CRUMB:");
        if (httpRequest == null) {
            logger.debug("\trequest is null");
        }
        if (httpResponse == null) {
            logger.debug("\tresponse is null");
        }
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        for (int i2 = 0; i2 < Math.min(10, stackTraceElementArray.length); ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            logger.debug("\t\t{}.{}({}:{})", stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber());
        }
    }

    private void delegateResponseWrittenEvent(HttpRequest httpRequest, HttpResponse httpResponse, String string) {
        List<ContrastPlugin> list = this.pluginManager.getPlugins();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            if (!contrastPlugin.isActivated()) continue;
            List<r> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                r r2 = list2.get(i3);
                try {
                    r2.a(httpRequest, httpResponse, string);
                    continue;
                }
                catch (Throwable throwable) {
                    logger.warn("Problem ending request watching with {}", (Object)r2, (Object)throwable);
                }
            }
        }
    }

    public void onMultipartHeaderRead(HttpRequest httpRequest, MultipartItem multipartItem) {
        List<ContrastPlugin> list = this.pluginManager.getPlugins();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            if (!contrastPlugin.isActivated()) continue;
            List<r> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                r r2 = list2.get(i3);
                r2.a(httpRequest, multipartItem);
            }
        }
    }

    public void onMultipartBodyRead(HttpRequest httpRequest, MultipartItem multipartItem) {
        List<ContrastPlugin> list = this.pluginManager.getPlugins();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            if (!contrastPlugin.isActivated()) continue;
            List<r> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                r r2 = list2.get(i3);
                r2.b(httpRequest, multipartItem);
            }
        }
    }

    public void onParametersResolved(HttpRequest httpRequest) {
        List<ContrastPlugin> list = this.pluginManager.getPlugins();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            if (!contrastPlugin.isActivated()) continue;
            List<r> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                r r2 = list2.get(i3);
                r2.b(httpRequest);
            }
        }
    }

    public void onMoreParametersResolved(HttpRequest httpRequest, Map<String, String[]> map) {
        List<ContrastPlugin> list = this.pluginManager.getPlugins();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            if (!contrastPlugin.isActivated()) continue;
            List<r> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                r r2 = list2.get(i3);
                r2.a(httpRequest, map);
            }
        }
    }

    @Override
    public void onBodyInputReceived(com.contrastsecurity.agent.plugins.rasp.d.k k2, String string, String string2) {
        List<ContrastPlugin> list = this.pluginManager.getPlugins();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ContrastPlugin contrastPlugin = list.get(i2);
            if (!contrastPlugin.isActivated()) continue;
            List<r> list2 = contrastPlugin.getRequestLifecycleListeners();
            for (int i3 = 0; i3 < list2.size(); ++i3) {
                r r2 = list2.get(i3);
                r2.a(string, string2, k2);
            }
        }
    }

    private byte[] readFile(String string) {
        byte[] byArray = ObjectShare.EMPTY_BYTE_ARRAY;
        try {
            byArray = FileUtils.readFileToByteArray(new File(string));
        }
        catch (IOException iOException) {
            logger.error("Problem reading response file", iOException);
        }
        return byArray;
    }
}

