/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.ScopingSensor;
import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.b.e;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.http.b;
import com.contrastsecurity.agent.http.c;
import com.contrastsecurity.agent.http.f;
import com.contrastsecurity.agent.http.g;
import com.contrastsecurity.agent.http.h;
import com.contrastsecurity.agent.http.o;
import com.contrastsecurity.agent.http.s;
import com.contrastsecurity.agent.http.u;
import com.contrastsecurity.agent.messages.HTTPRequestID;
import com.contrastsecurity.agent.messages.HttpVersion;
import com.contrastsecurity.agent.messages.Protocol;
import com.contrastsecurity.agent.messages.mq.MqHttpRequestDTM;
import com.contrastsecurity.agent.plugins.ContrastPlugin;
import com.contrastsecurity.agent.plugins.rasp.AttackBlockedException;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.RuleProvider;
import com.contrastsecurity.agent.util.i;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.ArrayUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Sensor
public abstract class HttpRequest
extends b {
    protected Protocol protocol = Protocol.FALLBACK_VALUE;
    protected HttpVersion version = HttpVersion.DEFAULT;
    protected String method;
    protected String uri;
    protected String normalizedUri;
    protected String queryString;
    protected String remoteIp;
    protected int port;
    protected Map<String, String[]> parameters;
    protected Map<String, String[]> headers;
    protected String contextPath;
    protected String serverVersionInfo;
    protected boolean parsedParameters = false;
    protected boolean parsedMultipartParameters = false;
    protected Collection<RuleProvider> responseProviders;
    protected boolean analyzing;
    protected g frameworkInfo;
    private int scope = 0;
    protected byte[] cachedBody;
    protected String cachedBodyStr;
    protected HashMap<String, Object> properties = new HashMap();
    private Set<MultipartItem> multipartItems = new HashSet<MultipartItem>();
    private String cachedContentType;
    protected Integer cachedContentLength;
    private boolean cachedXForwardedFor = false;
    private String[] cachedXForwardedForHeaders;
    private boolean cachedXForwardedForAsString;
    private String cachedXForwardedForHeadersAsString;
    private final HTTPRequestID requestID;
    private boolean checkedForDeserializer = false;
    private final long startTime = System.currentTimeMillis();
    private long elapsed = -1L;
    private final com.contrastsecurity.agent.d.h context;
    private static final char[] ALLOWED_BODY_SPECIAL_CHARS = new char[]{'<', '>', '\"', '\'', '&', ';', '[', ']', '{', '}', '!', '@', '#', '$', '%', '^', '_', '-', '+', '=', ':', ';', '.', ',', '(', ')', '?', '|', '\\', '/'};
    private static final e[] NO_COOKIES = new e[0];
    private static final int TARGET_SCOPE = 1;
    private static final o BUFFER = new s();
    private static final f FILE_BUFFER = new f("request");
    private static final Logger logger = LoggerFactory.getLogger(HttpRequest.class);
    private static final int MAX_REQUEST_SIZE = 4096;

    public HTTPRequestID getRequestID() {
        return this.requestID;
    }

    public HttpRequest(byte[] byArray) {
        this(byArray, new com.contrastsecurity.agent.d.h());
    }

    protected HttpRequest(byte[] byArray, com.contrastsecurity.agent.d.h h2) {
        this(new h().a(), byArray, h2);
    }

    private HttpRequest(HTTPRequestID hTTPRequestID, byte[] byArray, com.contrastsecurity.agent.d.h h2) {
        super("request");
        this.requestID = hTTPRequestID;
        this.cachedBody = byArray;
        this.cachedBodyStr = byArray != null ? new String(byArray) : null;
        this.context = h2;
    }

    public final com.contrastsecurity.agent.d.g context() {
        return this.context;
    }

    protected final com.contrastsecurity.agent.d.h contextImplementation() {
        return this.context;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String string) {
        this.contextPath = string;
    }

    public String[] getXForwardedFor() {
        if (!this.cachedXForwardedFor) {
            this.cachedXForwardedForHeaders = this.getHeaders("X-Forwarded-For");
            this.cachedXForwardedFor = true;
        }
        return this.cachedXForwardedForHeaders;
    }

    public String getXForwardedForAsString() {
        if (!this.cachedXForwardedForAsString) {
            StringBuilder stringBuilder = new StringBuilder(64);
            String[] stringArray = this.getXForwardedFor();
            if (stringArray != null) {
                for (String string : stringArray) {
                    for (int i2 = 0; i2 < string.length(); ++i2) {
                        char c2 = string.charAt(i2);
                        if (c2 == ' ') continue;
                        stringBuilder.append(c2);
                    }
                    stringBuilder.append(',');
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            this.cachedXForwardedForHeadersAsString = stringBuilder.toString();
            this.cachedXForwardedForAsString = true;
        }
        return this.cachedXForwardedForHeadersAsString;
    }

    public String getContentType() {
        if (this.cachedContentType != null) {
            return this.cachedContentType;
        }
        this.cachedContentType = this.getHeader("Content-Type");
        return this.cachedContentType;
    }

    public int getContentLength() {
        if (this.cachedContentLength != null) {
            return this.cachedContentLength;
        }
        this.cachedContentLength = 0;
        String string = this.getHeader("Content-Length");
        if (string == null || "0".equals(string)) {
            return 0;
        }
        try {
            this.cachedContentLength = Integer.parseInt(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Invalid content length header value detected: {}", (Object)string, (Object)numberFormatException);
        }
        return this.cachedContentLength;
    }

    public boolean isFormSubmission() {
        String string = this.getHeader("Content-Type");
        return string != null && string.startsWith("application/x-www-form-urlencoded");
    }

    public final Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        if (protocol != null) {
            this.protocol = protocol;
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String string) {
        this.method = string;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public void addMultipartItem(MultipartItem multipartItem) {
        this.multipartItems.add(multipartItem);
    }

    public void setMultipartItems(Set<MultipartItem> set) {
        this.multipartItems = set;
    }

    public Set<MultipartItem> getMultipartItems() {
        return this.multipartItems;
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String[]> map) {
        this.parameters = map;
    }

    public void setHeaders(Map<String, String[]> map) {
        this.headers = map;
    }

    public Map<String, String[]> getHeaders() {
        return this.headers;
    }

    public String[] getHeaders(String string) {
        if (this.headers == null) {
            return null;
        }
        String[] stringArray = this.headers.get(string.toLowerCase());
        if (stringArray != null && stringArray.length > 0) {
            return stringArray;
        }
        stringArray = this.headers.get(string);
        if (stringArray != null && stringArray.length > 0) {
            return stringArray;
        }
        return null;
    }

    public String getHeader(String string) {
        if (this.headers == null) {
            return null;
        }
        String[] stringArray = this.headers.get(string.toLowerCase());
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        stringArray = this.headers.get(string);
        if (stringArray != null && stringArray.length > 0) {
            return stringArray[0];
        }
        return null;
    }

    public boolean isParametersResolved() {
        return this.parsedParameters;
    }

    public void resolvedParameters() {
        this.parsedParameters = true;
    }

    public void markParametersUnresolved() {
        this.parsedParameters = false;
    }

    public boolean isMultipartParametersResolved() {
        return this.parsedMultipartParameters;
    }

    public void resolvedMultipartParameters() {
        this.parsedMultipartParameters = true;
    }

    public String getCookie() {
        return this.getHeader("Cookie");
    }

    public e[] parseCookies() {
        String string = this.getCookie();
        if (string == null || string.length() == 0) {
            return NO_COOKIES;
        }
        return c.a(string);
    }

    public final HttpVersion getVersion() {
        return this.version;
    }

    public void setVersion(HttpVersion httpVersion) {
        if (httpVersion != null) {
            this.version = httpVersion;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n2) {
        this.port = n2;
    }

    public String getNormalizedUri() {
        return this.normalizedUri;
    }

    public void setNormalizedUri(String string) {
        this.normalizedUri = string;
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    public void setRemoteIp(String string) {
        this.remoteIp = string;
    }

    public abstract HttpRequest clone();

    public byte[] getBody() {
        this.cacheBody();
        return this.cachedBody;
    }

    void setBodyCache(byte[] byArray) {
        this.cachedBody = byArray;
    }

    void clearBodyCache() {
        this.cachedBody = null;
        this.cachedBodyStr = null;
    }

    public void reset() {
        BUFFER.a();
        this.cachedContentLength = null;
        this.cachedContentType = null;
    }

    public Collection<RuleProvider> getResponseProviders() {
        return this.responseProviders;
    }

    public void setResponseProviders(Collection<RuleProvider> collection) {
        this.responseProviders = collection;
    }

    public void setAnalyzing(boolean bl) {
        this.analyzing = bl;
    }

    public boolean isAnalyzing() {
        return this.analyzing;
    }

    public String getServerVersionInfo() {
        return this.serverVersionInfo;
    }

    public void setServerVersionInfo(String string) {
        this.serverVersionInfo = string;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap<String, Object> hashMap) {
        this.properties = hashMap;
    }

    public boolean isScanningResponse() {
        return this.responseProviders != null && !this.responseProviders.isEmpty();
    }

    @ScopedSensor
    public void onBytesRead(int n2) {
        block9: {
            try {
                Object object;
                int n3;
                ScopingSensor.aspectOf().startScope();
                if (this.scope != 1 || n2 == -1) break block9;
                if (this.capturingInMemory && (n3 = ((ByteArrayOutputStream)(object = BUFFER.b())).size()) < 4096) {
                    ((ByteArrayOutputStream)object).write(n2);
                }
                if (this.bufferToPlugins) {
                    for (ContrastPlugin contrastPlugin : this.bufferingPlugins) {
                        contrastPlugin.onRequestBodyChunkRead(this, n2);
                    }
                }
                if (!this.capturingInFile) break block9;
                try {
                    object = this.openFile();
                    if (object != null) {
                        ((FileOutputStream)object).write(n2);
                    }
                }
                catch (Exception exception) {
                    logger.error("Problem writing file", exception);
                }
            }
            finally {
                ScopingSensor.aspectOf().leaveScope();
            }
        }
    }

    @ScopedSensor
    public void onBytesRead(int n2, byte[] byArray) {
        try {
            ScopingSensor.aspectOf().startScope();
            if (this.scope == 1 && n2 != -1 && byArray != null) {
                this.onBytesRead(n2, byArray, 0, byArray.length);
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    @ScopedSensor
    public void onBytesRead(int n2, byte[] byArray, int n3, int n4) {
        block12: {
            try {
                ScopingSensor.aspectOf().startScope();
                if (this.scope != 1 || byArray == null || n3 < 0) break block12;
                if (n4 < 0 && n2 != -1) {
                    break block12;
                }
                try {
                    Object object;
                    if (this.capturingInMemory) {
                        object = BUFFER.b();
                        ((ByteArrayOutputStream)object).write(byArray, n3, n2);
                    }
                    if (this.bufferToPlugins) {
                        object = this.bufferingPlugins.iterator();
                        while (object.hasNext()) {
                            ContrastPlugin contrastPlugin = (ContrastPlugin)object.next();
                            contrastPlugin.onRequestBodyChunkRead(this, n2, byArray, n3, n4);
                        }
                    }
                    if (this.capturingInFile && (object = this.openFile()) != null) {
                        ((FileOutputStream)object).write(byArray, n3, n2);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    logger.error("Response write with bad indices", indexOutOfBoundsException);
                }
                catch (AttackBlockedException attackBlockedException) {
                    throw attackBlockedException;
                }
                catch (Throwable throwable) {
                    logger.error("Unknown problem capturing response", throwable);
                }
            }
            finally {
                ScopingSensor.aspectOf().leaveScope();
            }
        }
    }

    public abstract u getSession(boolean var1);

    public void cacheBody() {
        if (!(this.cachedBody != null || this.getContentLength() <= 0 && BUFFER.e())) {
            this.cachedBody = BUFFER.c();
            this.cachedBodyStr = new String(this.cachedBody);
        }
    }

    @Override
    public File getFile() throws IOException {
        return FILE_BUFFER.b();
    }

    @Override
    public o getMemoryBuffer() {
        return BUFFER;
    }

    @Override
    public f getFileBuffer() {
        return FILE_BUFFER;
    }

    @ScopedSensor
    public void enterReadingScope() {
        try {
            ScopingSensor.aspectOf().startScope();
            ++this.scope;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    @ScopedSensor
    public void leaveReadingScope() {
        try {
            ScopingSensor.aspectOf().startScope();
            --this.scope;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    public boolean isCheckedForDeserializer() {
        return this.checkedForDeserializer;
    }

    public void setCheckedForDeserializer(boolean bl) {
        this.checkedForDeserializer = bl;
    }

    @Override
    protected String getAdditionalBreadCrumbInfo() {
        return this.uri;
    }

    public void markEndTime() {
        this.elapsed = System.currentTimeMillis() - this.startTime;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public boolean isFormEncodedContentType() {
        String string = this.getContentType();
        if (string == null) {
            return false;
        }
        return string.contains("application/x-www-form-urlencoded") || string.contains("multipart/form-data");
    }

    public String getEncodedBodyAsString() {
        String string = null;
        byte[] byArray = this.getBody();
        if (byArray != null && byArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder(byArray.length);
            this.appendTranslatedBody(stringBuilder, byArray);
            string = stringBuilder.toString();
        }
        return string;
    }

    public String getBodyAsString() {
        this.cacheBody();
        return this.cachedBodyStr;
    }

    public String headersToString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, String[]> entry : this.headers.entrySet()) {
            arrayList.add(entry.getKey() + "= " + Arrays.toString(entry.getValue()));
        }
        return "Headers{" + StringUtils.join(arrayList, ", ") + "}";
    }

    public String toString() {
        return "HttpRequest{protocol=" + (Object)((Object)this.protocol) + ", version=" + (Object)((Object)this.version) + ", method='" + this.method + '\'' + ", uri='" + this.uri + '\'' + ", normalizedUri='" + this.normalizedUri + '\'' + ", queryString='" + this.queryString + '\'' + ", remoteIp='" + this.remoteIp + '\'' + ", port=" + this.port + ", parameters=" + this.parameters + ", headers=" + this.headersToString() + ", contextPath='" + this.contextPath + '\'' + ", serverVersionInfo='" + this.serverVersionInfo + '\'' + ", parsedParameters=" + this.parsedParameters + ", parsedMultipartParameters=" + this.parsedMultipartParameters + ", responseProviders=" + this.responseProviders + ", analyzing=" + this.analyzing + ", frameworkInfo=" + this.frameworkInfo + ", scope=" + this.scope + ", cachedBody=" + Arrays.toString(this.cachedBody) + ", cachedBodyStr='" + this.cachedBodyStr + '\'' + ", properties=" + this.properties + ", multipartItems=" + this.multipartItems + ", cachedContentType='" + this.cachedContentType + '\'' + ", cachedContentLength=" + this.cachedContentLength + ", cachedXForwardedFor=" + this.cachedXForwardedFor + ", cachedXForwardedForHeaders=" + Arrays.toString(this.cachedXForwardedForHeaders) + ", cachedXForwardedForAsString=" + this.cachedXForwardedForAsString + ", cachedXForwardedForHeadersAsString='" + this.cachedXForwardedForHeadersAsString + '\'' + ", requestID=" + this.requestID + ", checkedForDeserializer=" + this.checkedForDeserializer + ", startTime=" + this.startTime + ", elapsed=" + this.elapsed + '}';
    }

    private void appendTranslatedBody(StringBuilder stringBuilder, byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            String string = new String(byArray);
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                if (Character.isWhitespace(c2) || Character.isLetterOrDigit(c2)) {
                    stringBuilder.append(c2);
                    continue;
                }
                if (ArrayUtils.contains(ALLOWED_BODY_SPECIAL_CHARS, c2)) {
                    i.a(stringBuilder, c2);
                    continue;
                }
                stringBuilder.append(".");
            }
        }
    }

    public void setFrameworkInfo(g g2) {
        this.frameworkInfo = g2;
    }

    public g getFrameworkInfo() {
        return this.frameworkInfo;
    }

    public abstract MqHttpRequestDTM toMqHttpRequestDTM();
}

