/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.http;

import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.ScopingSensor;
import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.e.c;
import com.contrastsecurity.agent.http.ReplacedResponseChunk;
import com.contrastsecurity.agent.http.b;
import com.contrastsecurity.agent.http.f;
import com.contrastsecurity.agent.http.o;
import com.contrastsecurity.agent.http.t;
import com.contrastsecurity.agent.messages.mq.HttpResponseDTM;
import com.contrastsecurity.agent.plugins.rasp.AttackBlockedException;
import com.contrastsecurity.agent.util.K;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

@Sensor
public abstract class HttpResponse
extends b {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    protected int scope = 0;
    protected boolean modifiable = true;
    public static final int ENCODING_UTF8 = 0;
    public static final int ENCODING_UTF16 = 1;
    public static final int ENCODING_UTF32 = 2;
    public static final int ENCODING_ASCII = 3;
    public static final int ENCODING_ISO88591 = 4;
    public static final int ENCODING_SYSTEM_DEFAULT = 5;
    public static final int NUM_ENCODING_DEFAULTS = 6;
    private static final o BUFFER = new t();
    private static final f FILE_BUFFER = new f("response");
    private static final String[] ALLOWED_CONTENT_TYPES = new String[]{"text/html", "text/plain", "application/xhtml", "application/xml"};
    private static final int TARGET_SCOPE = 1;
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final Logger logger = LoggerFactory.getLogger(HttpResponse.class);
    private static final int MAX_CAPTURED_SIZE = 65536;
    private static Map<String, Integer> ENCODING_MAP = new HashMap<String, Integer>();
    public static Map<Integer, String> CHARSET_MAP;

    public HttpResponse() {
        super("response");
    }

    public abstract int getStatus();

    public abstract String getContentType();

    public abstract String getCharacterEncoding();

    public abstract HttpResponseDTM toHttpResponseDTM();

    public String getDefaultCharacterEncoding() {
        return Charset.defaultCharset().name();
    }

    public abstract Object getOutputMechanism();

    public boolean isEmpty() {
        return this.getMemoryBuffer().b().size() <= 0;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setModifiable(boolean bl) {
        this.modifiable = bl;
    }

    @Sensor
    public void enterWritingScope(Object object) {
        ++this.scope;
    }

    @Sensor
    public void leaveWritingScope(Object object) {
        --this.scope;
    }

    @Sensor
    public final ReplacedResponseChunk write(byte[] byArray, String string) {
        return this.write(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensor
    public final ReplacedResponseChunk write(String string, int n2, int n3) {
        if (string != null && this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            ContrastEngine contrastEngine = ContrastEngine.get();
            try {
                contrastEngine.onEnteringSensor();
                string = string.substring(n2, n2 + n3);
                byte[] byArray = this.toEncodedBytes(string);
                if (this.capturingInMemory || this.capturingInFile) {
                    OutputStream outputStream;
                    if (this.capturingInMemory) {
                        outputStream = this.getMemoryBuffer().b();
                        int n4 = Math.max(0, 65536 - ((ByteArrayOutputStream)outputStream).size());
                        int n5 = Math.min(n4, byArray.length);
                        ((ByteArrayOutputStream)outputStream).write(byArray, 0, n5);
                    }
                    if (this.capturingInFile && (outputStream = this.openFile()) != null) {
                        ((FileOutputStream)outputStream).write(byArray);
                    }
                }
            }
            catch (IOException iOException) {
                logger.error("Couldn't write response chunk to stream", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            finally {
                contrastEngine.onLeavingSensor();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensor
    public final ReplacedResponseChunk write(String string) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            if (string == null) {
                string = "null";
            }
            ContrastEngine contrastEngine = ContrastEngine.get();
            try {
                contrastEngine.onEnteringSensor();
                if (this.capturingInFile || this.capturingInMemory) {
                    OutputStream outputStream;
                    byte[] byArray = this.toEncodedBytes(string);
                    if (this.capturingInMemory) {
                        outputStream = this.getMemoryBuffer().b();
                        int n2 = Math.max(0, 65536 - ((ByteArrayOutputStream)outputStream).size());
                        ((ByteArrayOutputStream)outputStream).write(byArray, 0, Math.min(byArray.length, n2));
                    }
                    if (this.capturingInFile && (outputStream = this.openFile()) != null) {
                        ((FileOutputStream)outputStream).write(byArray);
                    }
                }
            }
            catch (IOException iOException) {
                logger.error("Couldn't write response chunk to stream", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            finally {
                contrastEngine.onLeavingSensor();
            }
        }
        return null;
    }

    @Sensor
    public final ContrastReplacedResponseChunkModel write(char[] cArray) {
        if (cArray != null) {
            this.write(cArray, 0, cArray.length);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensor
    public final ContrastReplacedResponseChunkModel write(byte[] byArray) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            ContrastEngine contrastEngine = ContrastEngine.get();
            try {
                OutputStream outputStream;
                contrastEngine.onEnteringSensor();
                if (this.capturingInMemory) {
                    outputStream = this.getMemoryBuffer().b();
                    int n2 = Math.max(0, 65536 - ((ByteArrayOutputStream)outputStream).size());
                    ((ByteArrayOutputStream)outputStream).write(byArray, 0, Math.min(byArray.length, n2));
                }
                if (this.capturingInFile && (outputStream = this.openFile()) != null) {
                    ((FileOutputStream)outputStream).write(byArray);
                }
            }
            catch (IOException iOException) {
                logger.error("Couldn't write response chunk to stream", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            finally {
                contrastEngine.onLeavingSensor();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensor
    public final ContrastReplacedResponseChunkModel write(char[] cArray, int n2, int n3) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            ContrastEngine contrastEngine = ContrastEngine.get();
            try {
                contrastEngine.onEnteringSensor();
                if (this.capturingInFile) {
                    FileOutputStream fileOutputStream = this.openFile();
                    for (int i2 = n2; i2 < n2 + n3; ++i2) {
                        fileOutputStream.write(cArray[i2]);
                    }
                }
                if (this.capturingInMemory) {
                    ByteArrayOutputStream byteArrayOutputStream = this.getMemoryBuffer().b();
                    for (int i3 = n2; i3 < n2 + n3; ++i3) {
                        if (byteArrayOutputStream.size() >= 65536) continue;
                        byteArrayOutputStream.write(cArray[i3]);
                    }
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                logger.error("Response write with bad indices", indexOutOfBoundsException);
            }
            catch (IOException iOException) {
                logger.error("Problem writing response to file", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            finally {
                contrastEngine.onLeavingSensor();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensor
    public final ContrastReplacedResponseChunkModel write(byte[] byArray, int n2, int n3) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            ContrastEngine contrastEngine = ContrastEngine.get();
            try {
                OutputStream outputStream;
                contrastEngine.onEnteringSensor();
                if (this.capturingInFile) {
                    outputStream = this.openFile();
                    ((FileOutputStream)outputStream).write(byArray, n2, n3);
                }
                if (this.capturingInMemory) {
                    outputStream = this.getMemoryBuffer().b();
                    int n4 = Math.max(0, 65536 - ((ByteArrayOutputStream)outputStream).size());
                    ((ByteArrayOutputStream)outputStream).write(byArray, n2, Math.min(n3, n4));
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                logger.error("Response write with bad indices", indexOutOfBoundsException);
            }
            catch (IOException iOException) {
                logger.error("Problem writing response to file", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            finally {
                contrastEngine.onLeavingSensor();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensor
    public final ContrastReplacedResponseChunkModel write(byte by) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            ContrastEngine contrastEngine = ContrastEngine.get();
            try {
                OutputStream outputStream;
                contrastEngine.onEnteringSensor();
                if (this.capturingInMemory && ((ByteArrayOutputStream)(outputStream = this.getMemoryBuffer().b())).size() < 65536) {
                    ((ByteArrayOutputStream)outputStream).write(by);
                }
                if (this.capturingInFile) {
                    outputStream = this.openFile();
                    ((FileOutputStream)outputStream).write(by);
                }
            }
            catch (IOException iOException) {
                logger.error("Problem writing response to file", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            finally {
                contrastEngine.onLeavingSensor();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensor
    public final ContrastReplacedResponseChunkModel write(int n2) {
        if (this.scope == 1 && (this.bufferToPlugins || this.capturingInMemory || this.capturingInFile)) {
            ContrastEngine contrastEngine = ContrastEngine.get();
            try {
                OutputStream outputStream;
                contrastEngine.onEnteringSensor();
                if (this.capturingInMemory && ((ByteArrayOutputStream)(outputStream = this.getMemoryBuffer().b())).size() < 65536) {
                    ((ByteArrayOutputStream)outputStream).write(n2);
                }
                if (this.capturingInFile && (outputStream = this.openFile()) != null) {
                    ((FileOutputStream)outputStream).write(n2);
                }
            }
            catch (IOException iOException) {
                logger.error("Problem writing response to file", iOException);
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Unknown problem capturing response", throwable);
            }
            finally {
                contrastEngine.onLeavingSensor();
            }
        }
        return null;
    }

    @Sensor
    public final ContrastReplacedResponseChunkModel print(String string, int n2, int n3) {
        return this.write(string, n2, n3);
    }

    @Sensor
    public ContrastReplacedResponseChunkModel print(String string) {
        return this.write(string);
    }

    @Sensor
    public final ContrastReplacedResponseChunkModel print(char[] cArray, int n2, int n3) {
        return this.write(cArray, n2, n3);
    }

    @Sensor
    public final ContrastReplacedResponseChunkModel print(byte[] byArray, int n2, int n3) {
        return this.write(byArray, n2, n3);
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(char c2) {
        ContrastReplacedResponseChunkModel contrastReplacedResponseChunkModel;
        try {
            ScopingSensor.aspectOf().startScope();
            String string = String.valueOf(c2);
            this.write(string);
            contrastReplacedResponseChunkModel = null;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return contrastReplacedResponseChunkModel;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(short s2) {
        ContrastReplacedResponseChunkModel contrastReplacedResponseChunkModel;
        try {
            ScopingSensor.aspectOf().startScope();
            String string = String.valueOf(s2);
            this.write(string);
            contrastReplacedResponseChunkModel = null;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return contrastReplacedResponseChunkModel;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(int n2) {
        ContrastReplacedResponseChunkModel contrastReplacedResponseChunkModel;
        try {
            ScopingSensor.aspectOf().startScope();
            String string = String.valueOf(n2);
            this.write(string);
            contrastReplacedResponseChunkModel = null;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return contrastReplacedResponseChunkModel;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(long l2) {
        ReplacedResponseChunk replacedResponseChunk;
        try {
            ScopingSensor.aspectOf().startScope();
            String string = String.valueOf(l2);
            replacedResponseChunk = this.write(string);
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return replacedResponseChunk;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(double d2) {
        ReplacedResponseChunk replacedResponseChunk;
        try {
            ScopingSensor.aspectOf().startScope();
            String string = String.valueOf(d2);
            replacedResponseChunk = this.write(string);
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return replacedResponseChunk;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(float f2) {
        ReplacedResponseChunk replacedResponseChunk;
        try {
            ScopingSensor.aspectOf().startScope();
            String string = String.valueOf(f2);
            replacedResponseChunk = this.write(string);
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return replacedResponseChunk;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(boolean bl) {
        ReplacedResponseChunk replacedResponseChunk;
        try {
            ScopingSensor.aspectOf().startScope();
            String string = String.valueOf(bl);
            replacedResponseChunk = this.write(string);
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return replacedResponseChunk;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(Object object) {
        ReplacedResponseChunk replacedResponseChunk;
        try {
            ScopingSensor.aspectOf().startScope();
            String string = String.valueOf(object);
            replacedResponseChunk = this.write(string);
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return replacedResponseChunk;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel print(char[] cArray) {
        ReplacedResponseChunk replacedResponseChunk;
        try {
            ScopingSensor.aspectOf().startScope();
            String string = String.valueOf(cArray);
            replacedResponseChunk = this.write(string);
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return replacedResponseChunk;
    }

    @Sensor
    public final ContrastReplacedResponseChunkModel println(String string) {
        ReplacedResponseChunk replacedResponseChunk = this.write(string);
        this.write(ObjectShare.LINE_SEPARATOR);
        return replacedResponseChunk;
    }

    @Sensor
    public ContrastReplacedResponseChunkModel println() {
        this.write(ObjectShare.LINE_SEPARATOR);
        return null;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(char c2) {
        ContrastReplacedResponseChunkModel contrastReplacedResponseChunkModel;
        try {
            ScopingSensor.aspectOf().startScope();
            this.print(c2);
            this.println();
            contrastReplacedResponseChunkModel = null;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return contrastReplacedResponseChunkModel;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(short s2) {
        ContrastReplacedResponseChunkModel contrastReplacedResponseChunkModel;
        try {
            ScopingSensor.aspectOf().startScope();
            this.print(s2);
            this.println();
            contrastReplacedResponseChunkModel = null;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return contrastReplacedResponseChunkModel;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(int n2) {
        ContrastReplacedResponseChunkModel contrastReplacedResponseChunkModel;
        try {
            ScopingSensor.aspectOf().startScope();
            this.print(n2);
            this.println();
            contrastReplacedResponseChunkModel = null;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return contrastReplacedResponseChunkModel;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(long l2) {
        ContrastReplacedResponseChunkModel contrastReplacedResponseChunkModel;
        try {
            ScopingSensor.aspectOf().startScope();
            this.print(l2);
            this.println();
            contrastReplacedResponseChunkModel = null;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return contrastReplacedResponseChunkModel;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(double d2) {
        ContrastReplacedResponseChunkModel contrastReplacedResponseChunkModel;
        try {
            ScopingSensor.aspectOf().startScope();
            this.print(d2);
            this.println();
            contrastReplacedResponseChunkModel = null;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return contrastReplacedResponseChunkModel;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(float f2) {
        ContrastReplacedResponseChunkModel contrastReplacedResponseChunkModel;
        try {
            ScopingSensor.aspectOf().startScope();
            this.print(f2);
            this.println();
            contrastReplacedResponseChunkModel = null;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return contrastReplacedResponseChunkModel;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(boolean bl) {
        ContrastReplacedResponseChunkModel contrastReplacedResponseChunkModel;
        try {
            ScopingSensor.aspectOf().startScope();
            this.print(bl);
            this.println();
            contrastReplacedResponseChunkModel = null;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return contrastReplacedResponseChunkModel;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(Object object) {
        ContrastReplacedResponseChunkModel contrastReplacedResponseChunkModel;
        try {
            ScopingSensor.aspectOf().startScope();
            this.print(object);
            this.println();
            contrastReplacedResponseChunkModel = null;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return contrastReplacedResponseChunkModel;
    }

    @ScopedSensor
    public final ContrastReplacedResponseChunkModel println(char[] cArray) {
        ContrastReplacedResponseChunkModel contrastReplacedResponseChunkModel;
        try {
            ScopingSensor.aspectOf().startScope();
            this.print(cArray);
            this.println();
            contrastReplacedResponseChunkModel = null;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return contrastReplacedResponseChunkModel;
    }

    private byte[] toEncodedBytes(String string) throws IOException {
        String string2 = this.getCharacterEncoding();
        if (string2 == null || !this.isKnownEncoding(string2)) {
            string2 = DEFAULT_ENCODING;
        }
        byte[] byArray = string.getBytes(string2);
        return byArray;
    }

    private boolean isKnownEncoding(String string) {
        return Charset.isSupported(string);
    }

    @Sensor
    public void onHeaderSet(String string, String string2, String string3) {
        if (string2 != null && this.isUntrackedMimeDeclaration(string, string2)) {
            logger.info("Ignoring response for {} because content type was: {}", (Object)(string3 != null ? string3 : "(unknown)"), (Object)c.a(logger, string2));
            this.capturingInMemory = false;
        }
    }

    private boolean isUntrackedMimeDeclaration(String string, String string2) {
        boolean bl = false;
        if ("Content-Disposition".equals(string)) {
            bl = string2.contains("attachment");
        } else if ("Content-Type".equals(string)) {
            bl = this.isUntrackableContentType(string2);
        }
        return bl;
    }

    private boolean isUntrackableContentType(String string) {
        return !K.d(ALLOWED_CONTENT_TYPES, string);
    }

    @Override
    public File getFile() throws IOException {
        return FILE_BUFFER.b();
    }

    @Override
    public o getMemoryBuffer() {
        return BUFFER;
    }

    @Override
    public f getFileBuffer() {
        return FILE_BUFFER;
    }

    static {
        ENCODING_MAP.put(null, 5);
        ENCODING_MAP.put("", 5);
        ENCODING_MAP.put("ascii", 3);
        ENCODING_MAP.put("ASCII", 3);
        ENCODING_MAP.put("US-ASCII", 3);
        ENCODING_MAP.put("US_ASCII", 3);
        ENCODING_MAP.put("utf8", 0);
        ENCODING_MAP.put("UTF8", 0);
        ENCODING_MAP.put("utf-8", 0);
        ENCODING_MAP.put("UTF-8", 0);
        ENCODING_MAP.put("utf16", 1);
        ENCODING_MAP.put("UTF16", 1);
        ENCODING_MAP.put("utf-16", 1);
        ENCODING_MAP.put("UTF-16", 1);
        ENCODING_MAP.put("utf32", 2);
        ENCODING_MAP.put("UTF32", 2);
        ENCODING_MAP.put("utf-32", 2);
        ENCODING_MAP.put("UTF-32", 2);
        CHARSET_MAP = new HashMap<Integer, String>();
        CHARSET_MAP.put(3, "ASCII");
        CHARSET_MAP.put(0, "UTF-8");
        CHARSET_MAP.put(1, "UTF-16");
        CHARSET_MAP.put(2, "UTF-32");
        CHARSET_MAP.put(4, DEFAULT_ENCODING);
        CHARSET_MAP.put(5, Charset.defaultCharset().name());
    }
}

