/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.jmx;

import com.contrastsecurity.agent.Contrast;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.apps.java.codeinfo.LibraryFacts;
import com.contrastsecurity.agent.commons.l;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.jmx.ContrastManagementMBean;
import com.contrastsecurity.agent.p;
import com.contrastsecurity.agent.plugins.security.SecurityPlugin;
import com.contrastsecurity.agent.plugins.security.c.f;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.controller.EventScope;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.s;
import com.contrastsecurity.agent.util.C;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.m;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@DontObfuscate
public final class ContrastManagement
implements ContrastManagementMBean {
    private final TraceController traceController;
    private final p hierarchyCache;
    private final ApplicationManager applicationManager;
    private final f responseFindingCache;
    private final s orphanage;

    public ContrastManagement(TraceController traceController, p p2, ApplicationManager applicationManager, f f2, s s2) {
        this.traceController = l.a(traceController, "traceController");
        this.hierarchyCache = l.a(p2, "hierarchyCache");
        this.applicationManager = l.a(applicationManager);
        this.responseFindingCache = l.a(f2);
        this.orphanage = l.a(s2);
    }

    @Override
    public void resume() {
        SecurityPlugin.setEnabled(EventContext.get(), EventScope.TRACKER, true);
    }

    @Override
    public void suspend() {
        SecurityPlugin.setEnabled(EventContext.get(), EventScope.TRACKER, false);
    }

    @Override
    public boolean doesClassExist(String string) {
        ContrastEngine contrastEngine = ContrastEngine.get();
        for (Class clazz : contrastEngine.getInstrumentation().getAllLoadedClasses()) {
            if (!clazz.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doesMethodExist(String string, String string2, String[] stringArray) {
        ContrastEngine contrastEngine = ContrastEngine.get();
        for (Class clazz : contrastEngine.getInstrumentation().getAllLoadedClasses()) {
            if (!clazz.getName().equals(string) || !ContrastManagement.doesMethodExist(clazz, string2, stringArray)) continue;
            return true;
        }
        return false;
    }

    private static boolean doesMethodExist(Class<?> clazz, String string, String[] stringArray) {
        for (Class<?> clazz2 : ContrastManagement.getClassAncestry(clazz)) {
            for (Method method : clazz2.getDeclaredMethods()) {
                if (!ContrastManagement.doesMethodExist(method, string, stringArray)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean doesMethodExist(Method method, String string, String[] stringArray) {
        Class<?>[] classArray;
        if (method.getName().equals(string) && (classArray = method.getParameterTypes()).length == stringArray.length) {
            boolean bl = true;
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                bl = bl && classArray[i2].getName().equals(stringArray[i2]);
            }
            return bl;
        }
        return false;
    }

    private static List<Class<?>> getClassAncestry(Class<?> clazz) {
        ArrayList arrayList = new ArrayList(5);
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            arrayList.addAll(ContrastManagement.getClassAncestry(clazz2));
        }
        arrayList.addAll(ContrastManagement.getRecursiveInterfaces(clazz));
        arrayList.add(clazz);
        return arrayList;
    }

    private static Collection<? extends Class<?>> getRecursiveInterfaces(Class<?> clazz) {
        ArrayList arrayList = new ArrayList();
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            arrayList.add(clazz2);
            arrayList.addAll(0, ContrastManagement.getRecursiveInterfaces(clazz2));
        }
        return arrayList;
    }

    @Override
    public void turnOff() {
        ContrastEngine contrastEngine = ContrastEngine.get();
        this.suspend();
        try {
            C.a("Stopping the agent...");
            contrastEngine.stop();
            C.a("Successfully stopped agent.");
        }
        catch (Exception exception) {
            C.b("Failed to stop() agent");
            exception.printStackTrace();
        }
    }

    @Override
    public void turnOn() {
        ContrastEngine contrastEngine = ContrastEngine.get();
        this.resume();
        try {
            C.a("Restarting the agent...");
            contrastEngine.restart();
            C.a("Successfully restarted the agent");
        }
        catch (Exception exception) {
            C.b("Failed to start() the agent");
            exception.printStackTrace();
        }
    }

    @Override
    public void deinstrument() {
        ContrastEngine contrastEngine = ContrastEngine.get();
        try {
            C.a("De-instrumenting the instrumented classes...");
            contrastEngine.deinstrument();
            C.a("Successfully de-instrumented");
        }
        catch (Exception exception) {
            C.b("Problem de-instrumenting classes");
            exception.printStackTrace();
        }
    }

    @Override
    public String getStatus() {
        return Contrast.getStatus();
    }

    @Override
    public int getTraceMapSize() {
        return this.traceController.getSize();
    }

    @Override
    public int getHierarchyCacheSize() {
        return this.hierarchyCache.c();
    }

    @Override
    public int getResponseFindingCacheSize() {
        return this.responseFindingCache.b();
    }

    @Override
    public String[] getApps() {
        Set<Application> set = this.applicationManager.getApplications();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Application application : set) {
            arrayList.add(application.getDisplayName());
        }
        return arrayList.toArray(ObjectShare.EMPTY_STRING_ARRAY);
    }

    @Override
    public String getAppData(String string) {
        Set<Application> set = this.applicationManager.getApplications();
        for (Application application : set) {
            if (!string.equals(application.getDisplayName()) && !string.equals(application.getPath())) continue;
            return m.a(new a(application));
        }
        return null;
    }

    @Override
    public int getOrphanageSize() {
        return this.orphanage.a();
    }

    public class a {
        private String b;
        private String c;
        private int d;
        private int e;
        private Collection<LibraryFacts> f;
        private String g;
        private long h;
        private long i;
        private String j;
        private Set<String> k;

        a(Application application) {
            this.f = application.getAllLibraryFacts();
            this.c = application.getDisplayName();
            this.b = application.getPath();
            this.g = application.getClassloaderId();
            this.d = application.getAccessibleViews();
            this.h = application.getLastActivityReportedTime();
            this.i = application.getLastChangeOccurred();
            this.j = application.getResolvedPath();
            this.k = application.getTechnologies();
            this.e = application.getTotalViews();
        }

        public Collection<LibraryFacts> a() {
            return this.f;
        }

        public void a(List<LibraryFacts> list) {
            this.f = list;
        }

        public String b() {
            return this.b;
        }

        public void a(String string) {
            this.b = string;
        }

        public int c() {
            return this.d;
        }

        public String d() {
            return this.g;
        }

        public long e() {
            return this.i;
        }

        public long f() {
            return this.h;
        }

        public String g() {
            return this.c;
        }

        public Set<String> h() {
            return this.k;
        }

        public String i() {
            return this.j;
        }

        public int j() {
            return this.e;
        }
    }
}

