/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages;

import com.contrastsecurity.agent.commons.g;
import com.contrastsecurity.agent.messages.HTTPRequestID;
import com.contrastsecurity.agent.messages.HttpVersion;
import com.contrastsecurity.agent.messages.Protocol;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class HttpActivityDTM {
    private final String body;
    private final String contextPath;
    private final Map<String, List<String>> headers;
    private final String method;
    private final transient HTTPRequestID requestID;
    private final String normalizedUri;
    private final Map<String, List<String>> parameters;
    private final Integer port;
    private final Protocol protocol;
    private final String queryString;
    private final String serverVersionInfo;
    private final String uri;
    private final HttpVersion version;

    private HttpActivityDTM(Builder builder) {
        this.body = builder.body;
        this.contextPath = builder.contextPath;
        this.headers = builder.headers;
        this.method = builder.method;
        this.requestID = builder.requestID;
        this.normalizedUri = builder.normalizedUri;
        this.parameters = builder.parameters;
        this.port = builder.port;
        this.protocol = builder.protocol;
        this.queryString = builder.queryString;
        this.serverVersionInfo = builder.serverVersionInfo;
        this.uri = builder.uri;
        this.version = builder.version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String body() {
        return this.body;
    }

    public String contextPath() {
        return this.contextPath;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String method() {
        return this.method;
    }

    public String normalizedUri() {
        return this.normalizedUri;
    }

    public Map<String, List<String>> parameters() {
        return this.parameters;
    }

    public Integer port() {
        return this.port;
    }

    public Protocol protocol() {
        return this.protocol;
    }

    public String queryString() {
        return this.queryString;
    }

    public String serverVersionInfo() {
        return this.serverVersionInfo;
    }

    public String uri() {
        return this.uri;
    }

    public HttpVersion HttpVersion() {
        return this.version;
    }

    public HTTPRequestID requestID() {
        return this.requestID;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HttpActivityDTM httpActivityDTM = (HttpActivityDTM)object;
        if (this.body != null ? !this.body.equals(httpActivityDTM.body) : httpActivityDTM.body != null) {
            return false;
        }
        if (this.contextPath != null ? !this.contextPath.equals(httpActivityDTM.contextPath) : httpActivityDTM.contextPath != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(httpActivityDTM.headers) : httpActivityDTM.headers != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(httpActivityDTM.method) : httpActivityDTM.method != null) {
            return false;
        }
        if (this.normalizedUri != null ? !this.normalizedUri.equals(httpActivityDTM.normalizedUri) : httpActivityDTM.normalizedUri != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(httpActivityDTM.parameters) : httpActivityDTM.parameters != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(httpActivityDTM.port) : httpActivityDTM.port != null) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals((Object)httpActivityDTM.protocol) : httpActivityDTM.protocol != null) {
            return false;
        }
        if (this.queryString != null ? !this.queryString.equals(httpActivityDTM.queryString) : httpActivityDTM.queryString != null) {
            return false;
        }
        if (this.serverVersionInfo != null ? !this.serverVersionInfo.equals(httpActivityDTM.serverVersionInfo) : httpActivityDTM.serverVersionInfo != null) {
            return false;
        }
        if (this.uri != null ? !this.uri.equals(httpActivityDTM.uri) : httpActivityDTM.uri != null) {
            return false;
        }
        return this.version != null ? this.version.equals((Object)httpActivityDTM.version) : httpActivityDTM.version == null;
    }

    public int hashCode() {
        int n2 = this.body != null ? this.body.hashCode() : 0;
        n2 = 31 * n2 + (this.contextPath != null ? this.contextPath.hashCode() : 0);
        n2 = 31 * n2 + (this.headers != null ? this.headers.hashCode() : 0);
        n2 = 31 * n2 + (this.method != null ? this.method.hashCode() : 0);
        n2 = 31 * n2 + (this.normalizedUri != null ? this.normalizedUri.hashCode() : 0);
        n2 = 31 * n2 + (this.parameters != null ? this.parameters.hashCode() : 0);
        n2 = 31 * n2 + (this.port != null ? this.port.hashCode() : 0);
        n2 = 31 * n2 + (this.protocol != null ? this.protocol.hashCode() : 0);
        n2 = 31 * n2 + (this.queryString != null ? this.queryString.hashCode() : 0);
        n2 = 31 * n2 + (this.serverVersionInfo != null ? this.serverVersionInfo.hashCode() : 0);
        n2 = 31 * n2 + (this.uri != null ? this.uri.hashCode() : 0);
        n2 = 31 * n2 + (this.version != null ? this.version.hashCode() : 0);
        return n2;
    }

    public static final class Builder {
        private String body;
        private String contextPath;
        private Map<String, List<String>> headers;
        private String method;
        private HTTPRequestID requestID;
        private String normalizedUri;
        private Map<String, List<String>> parameters;
        private Integer port;
        private Protocol protocol;
        private String queryString;
        private String serverVersionInfo;
        private String uri;
        private HttpVersion version;

        public Builder() {
        }

        public Builder(HttpActivityDTM httpActivityDTM) {
            this.body = httpActivityDTM.body;
            this.contextPath = httpActivityDTM.contextPath;
            this.headers = httpActivityDTM.headers;
            this.method = httpActivityDTM.method;
            this.requestID = httpActivityDTM.requestID;
            this.normalizedUri = httpActivityDTM.normalizedUri;
            this.parameters = httpActivityDTM.parameters;
            this.port = httpActivityDTM.port;
            this.protocol = httpActivityDTM.protocol;
            this.queryString = httpActivityDTM.queryString;
            this.serverVersionInfo = httpActivityDTM.serverVersionInfo;
            this.uri = httpActivityDTM.uri;
            this.version = httpActivityDTM.version;
        }

        public Builder body(String string) {
            this.body = string;
            return this;
        }

        public Builder contextPath(String string) {
            this.contextPath = string;
            return this;
        }

        public Builder headers(Map<String, List<String>> map) {
            this.headers = map != null ? g.a(map) : Collections.emptyMap();
            return this;
        }

        public Builder method(String string) {
            this.method = string;
            return this;
        }

        public Builder requestID(HTTPRequestID hTTPRequestID) {
            this.requestID = hTTPRequestID;
            return this;
        }

        public Builder normalizedUri(String string) {
            this.normalizedUri = string;
            return this;
        }

        public Builder parameters(Map<String, List<String>> map) {
            this.parameters = map != null ? g.a(map) : Collections.emptyMap();
            return this;
        }

        public Builder port(Integer n2) {
            this.port = n2;
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.protocol = protocol;
            return this;
        }

        public Builder queryString(String string) {
            this.queryString = string;
            return this;
        }

        public Builder serverVersionInfo(String string) {
            this.serverVersionInfo = string;
            return this;
        }

        public Builder uri(String string) {
            this.uri = string;
            return this;
        }

        public Builder version(HttpVersion httpVersion) {
            this.version = httpVersion;
            return this;
        }

        public HttpActivityDTM build() {
            return new HttpActivityDTM(this);
        }
    }
}

