/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.app.activity.assessment.properties;

import com.contrastsecurity.thirdparty.com.google.gson.annotations.SerializedName;

public final class CSPInstruction {
    private static final String BASE_URI = "base-uri";
    private static final String DEFAULT_SRC = "default-src";
    private static final String CHILD_SRC = "child-src";
    private static final String CONNECT_SRC = "connect-src";
    private static final String FRAME_SRC = "frame-src";
    private static final String MEDIA_SRC = "media-src";
    private static final String OBJECT_SRC = "object-src";
    private static final String SCRIPT_SRC = "script-src";
    private static final String STYLE_SRC = "style-src";
    private static final String FORM_ACTION = "form-action";
    private static final String FRAME_ANCESTORS = "frame-ancestors";
    private static final String PLUGIN_TYPES = "plugin-types";
    private static final String REFLECTED_XSS = "reflected-xss";
    private static final String REFERRER = "referrer";
    private final boolean baseUriSecure;
    private final String baseUriValue;
    private final boolean defaultSrcSecure;
    private final String defaultSrcValue;
    private final boolean childSrcSecure;
    private final String childSrcValue;
    private final boolean connectSrcSecure;
    private final String connectSrcValue;
    private final boolean frameSrcSecure;
    private final String frameSrcValue;
    private final boolean mediaSrcSecure;
    private final String mediaSrcValue;
    private final boolean objectSrcSecure;
    private final String objectSrcValue;
    private final boolean scriptSrcSecure;
    private final String scriptSrcValue;
    private final boolean styleSrcSecure;
    private final String styleSrcValue;
    private final boolean formActionSecure;
    private final String formActionValue;
    private final boolean frameAncestorsSecure;
    private final String frameAncestorsValue;
    private final boolean pluginTypesSecure;
    private final String pluginTypesValue;
    private final boolean reflectedXssSecure;
    private final String reflectedXssValue;
    @SerializedName(value="refererSecure")
    private final boolean referrerSecure;
    @SerializedName(value="refererValue")
    private final String referrerValue;

    public static CSPInstruction create(String string) {
        String string2 = CSPInstruction.processSetting(BASE_URI, string);
        String string3 = CSPInstruction.processSetting(DEFAULT_SRC, string);
        String string4 = CSPInstruction.processSetting(CHILD_SRC, string);
        String string5 = CSPInstruction.processSetting(CONNECT_SRC, string);
        String string6 = CSPInstruction.processSetting(FRAME_SRC, string);
        String string7 = CSPInstruction.processSetting(MEDIA_SRC, string);
        String string8 = CSPInstruction.processSetting(OBJECT_SRC, string);
        String string9 = CSPInstruction.processSetting(SCRIPT_SRC, string);
        String string10 = CSPInstruction.processSetting(STYLE_SRC, string);
        String string11 = CSPInstruction.processSetting(FORM_ACTION, string);
        String string12 = CSPInstruction.processSetting(FRAME_ANCESTORS, string);
        String string13 = CSPInstruction.processSetting(PLUGIN_TYPES, string);
        String string14 = CSPInstruction.processSetting(REFLECTED_XSS, string);
        String string15 = CSPInstruction.processSetting(REFERRER, string);
        boolean bl = CSPInstruction.isContentSecure(string2);
        boolean bl2 = CSPInstruction.isContentSecure(string3);
        boolean bl3 = CSPInstruction.isContentSecure(string4);
        boolean bl4 = CSPInstruction.isContentSecure(string5);
        boolean bl5 = CSPInstruction.isContentSecure(string6);
        boolean bl6 = CSPInstruction.isContentSecure(string7);
        boolean bl7 = CSPInstruction.isContentSecure(string8);
        boolean bl8 = CSPInstruction.isContentSecure(string9) && CSPInstruction.isContentSafe(string9);
        boolean bl9 = CSPInstruction.isContentSecure(string10) && CSPInstruction.isContentSafe(string10);
        boolean bl10 = CSPInstruction.isContentSecure(string11);
        boolean bl11 = CSPInstruction.isContentSecure(string12);
        boolean bl12 = CSPInstruction.isContentSecure(string13);
        boolean bl13 = "1".equals(string14);
        boolean bl14 = CSPInstruction.isContentSecure(string15) && CSPInstruction.isContentSafe(string15) && !string15.contains("unsafe-url");
        return new CSPInstruction(bl, string2, bl2, string3, bl3, string4, bl4, string5, bl5, string6, bl6, string7, bl7, string8, bl8, string9, bl9, string10, bl10, string11, bl11, string12, bl12, string13, bl13, string14, bl14, string15);
    }

    private CSPInstruction(boolean bl, String string, boolean bl2, String string2, boolean bl3, String string3, boolean bl4, String string4, boolean bl5, String string5, boolean bl6, String string6, boolean bl7, String string7, boolean bl8, String string8, boolean bl9, String string9, boolean bl10, String string10, boolean bl11, String string11, boolean bl12, String string12, boolean bl13, String string13, boolean bl14, String string14) {
        this.baseUriSecure = bl;
        this.baseUriValue = string;
        this.defaultSrcSecure = bl2;
        this.defaultSrcValue = string2;
        this.childSrcSecure = bl3;
        this.childSrcValue = string3;
        this.connectSrcSecure = bl4;
        this.connectSrcValue = string4;
        this.frameSrcSecure = bl5;
        this.frameSrcValue = string5;
        this.mediaSrcSecure = bl6;
        this.mediaSrcValue = string6;
        this.objectSrcSecure = bl7;
        this.objectSrcValue = string7;
        this.scriptSrcSecure = bl8;
        this.scriptSrcValue = string8;
        this.styleSrcSecure = bl9;
        this.styleSrcValue = string9;
        this.formActionSecure = bl10;
        this.formActionValue = string10;
        this.frameAncestorsSecure = bl11;
        this.frameAncestorsValue = string11;
        this.pluginTypesSecure = bl12;
        this.pluginTypesValue = string12;
        this.reflectedXssSecure = bl13;
        this.reflectedXssValue = string13;
        this.referrerSecure = bl14;
        this.referrerValue = string14;
    }

    private static String processSetting(String string, String string2) {
        int n2 = string2.indexOf(string);
        String string3 = null;
        if (n2 != -1) {
            int n3 = string2.indexOf(59, n2 += string.length() + 1);
            int n4 = string2.indexOf(62, n2);
            string3 = n3 == -1 ? (n4 == -1 ? string2.substring(n2) : string2.substring(n2, n4 - 1)) : string2.substring(n2, n3);
        }
        return string3;
    }

    private static boolean isContentSecure(String string) {
        return string != null && !string.contains("*");
    }

    private static boolean isContentSafe(String string) {
        return !string.contains("unsafe-inline") && !string.contains("unsafe-eval");
    }

    public boolean isSafe() {
        return this.formActionSecure && this.frameAncestorsSecure && this.pluginTypesSecure && this.reflectedXssSecure && this.baseUriSecure && this.referrerSecure && this.areSourcesSecure();
    }

    private boolean areSourcesSecure() {
        if (this.defaultSrcSecure) {
            if (!this.childSrcSecure && this.childSrcValue != null || !this.frameSrcSecure && this.frameSrcValue != null) {
                return false;
            }
            if (!this.connectSrcSecure && this.connectSrcValue != null) {
                return false;
            }
            if (!this.mediaSrcSecure && this.mediaSrcValue != null) {
                return false;
            }
            if (!this.objectSrcSecure && this.objectSrcValue != null) {
                return false;
            }
            if (!this.scriptSrcSecure && this.scriptSrcValue != null) {
                return false;
            }
            return this.styleSrcSecure || this.styleSrcValue == null;
        }
        return this.childSrcSecure && this.connectSrcSecure && this.frameSrcSecure && this.mediaSrcSecure && this.objectSrcSecure && this.scriptSrcSecure && this.styleSrcSecure;
    }

    public String getBaseUriValue() {
        return this.baseUriValue;
    }

    public String getDefaultSrcValue() {
        return this.defaultSrcValue;
    }

    public String getChildSrcValue() {
        return this.childSrcValue;
    }

    public String getConnectSrcValue() {
        return this.connectSrcValue;
    }

    public String getFrameSrcValue() {
        return this.frameSrcValue;
    }

    public String getMediaSrcValue() {
        return this.mediaSrcValue;
    }

    public String getObjectSrcValue() {
        return this.objectSrcValue;
    }

    public String getScriptSrcValue() {
        return this.scriptSrcValue;
    }

    public String getStyleSrcValue() {
        return this.styleSrcValue;
    }

    public String getFormActionValue() {
        return this.formActionValue;
    }

    public String getFrameAncestorsValue() {
        return this.frameAncestorsValue;
    }

    public String getPluginTypesValue() {
        return this.pluginTypesValue;
    }

    public String getReflectedXssValue() {
        return this.reflectedXssValue;
    }

    public String getReferrerValue() {
        return this.referrerValue;
    }

    public boolean isBaseUriSecure() {
        return this.baseUriSecure;
    }

    public boolean isDefaultSrcSecure() {
        return this.defaultSrcSecure;
    }

    public boolean isChildSrcSecure() {
        return this.childSrcSecure;
    }

    public boolean isConnectSrcSecure() {
        return this.connectSrcSecure;
    }

    public boolean isFrameSrcSecure() {
        return this.frameSrcSecure;
    }

    public boolean isMediaSrcSecure() {
        return this.mediaSrcSecure;
    }

    public boolean isObjectSrcSecure() {
        return this.objectSrcSecure;
    }

    public boolean isScriptSrcSecure() {
        return this.scriptSrcSecure;
    }

    public boolean isStyleSrcSecure() {
        return this.styleSrcSecure;
    }

    public boolean isFormActionSecure() {
        return this.formActionSecure;
    }

    public boolean isFrameAncestorsSecure() {
        return this.frameAncestorsSecure;
    }

    public boolean isPluginTypesSecure() {
        return this.pluginTypesSecure;
    }

    public boolean isReflectedXssSecure() {
        return this.reflectedXssSecure;
    }

    public boolean isReferrerSecure() {
        return this.referrerSecure;
    }
}

