/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.app.info;

public final class LibraryDTM {
    private final long classCount;
    private final long externalDate;
    private final String file;
    private final String hash;
    private final long internalDate;
    private final String manifest;
    private final String url;
    private final long usedClassCount;
    private final String version;
    private final String tags;

    private LibraryDTM(Builder builder) {
        this.classCount = builder.classCount;
        this.file = builder.file;
        this.hash = builder.hash;
        this.internalDate = builder.internalDate;
        this.externalDate = builder.externalDate;
        this.manifest = builder.manifest;
        this.url = builder.url;
        this.usedClassCount = builder.usedClassCount;
        this.version = builder.version;
        this.tags = builder.tags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getClassCount() {
        return this.classCount;
    }

    public long getExternalDate() {
        return this.externalDate;
    }

    public String getFile() {
        return this.file;
    }

    public String getHash() {
        return this.hash;
    }

    public long getInternalDate() {
        return this.internalDate;
    }

    public String getManifest() {
        return this.manifest;
    }

    public String getUrl() {
        return this.url;
    }

    public long getUsedClassCount() {
        return this.usedClassCount;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTags() {
        return this.tags;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LibraryDTM libraryDTM = (LibraryDTM)object;
        if (this.classCount != libraryDTM.classCount) {
            return false;
        }
        if (this.externalDate != libraryDTM.externalDate) {
            return false;
        }
        if (this.internalDate != libraryDTM.internalDate) {
            return false;
        }
        if (this.usedClassCount != libraryDTM.usedClassCount) {
            return false;
        }
        if (this.file != null ? !this.file.equals(libraryDTM.file) : libraryDTM.file != null) {
            return false;
        }
        if (this.hash != null ? !this.hash.equals(libraryDTM.hash) : libraryDTM.hash != null) {
            return false;
        }
        if (this.manifest != null ? !this.manifest.equals(libraryDTM.manifest) : libraryDTM.manifest != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(libraryDTM.url) : libraryDTM.url != null) {
            return false;
        }
        return this.version != null ? this.version.equals(libraryDTM.version) : libraryDTM.version == null;
    }

    public int hashCode() {
        int n2 = (int)(this.classCount ^ this.classCount >>> 32);
        n2 = 31 * n2 + (int)(this.externalDate ^ this.externalDate >>> 32);
        n2 = 31 * n2 + (this.file != null ? this.file.hashCode() : 0);
        n2 = 31 * n2 + (this.hash != null ? this.hash.hashCode() : 0);
        n2 = 31 * n2 + (int)(this.internalDate ^ this.internalDate >>> 32);
        n2 = 31 * n2 + (this.manifest != null ? this.manifest.hashCode() : 0);
        n2 = 31 * n2 + (this.url != null ? this.url.hashCode() : 0);
        n2 = 31 * n2 + (int)(this.usedClassCount ^ this.usedClassCount >>> 32);
        n2 = 31 * n2 + (this.version != null ? this.version.hashCode() : 0);
        return n2;
    }

    public String toString() {
        return "LibraryDTM{classCount=" + this.classCount + ", externalDate=" + this.externalDate + ", file='" + this.file + '\'' + ", hash='" + this.hash + '\'' + ", internalDate=" + this.internalDate + ", manifest='" + this.manifest + '\'' + ", url='" + this.url + '\'' + ", usedClassCount=" + this.usedClassCount + ", version='" + this.version + '\'' + ", tags='" + this.tags + '\'' + '}';
    }

    public static final class Builder {
        private String tags;
        private long classCount;
        private String file;
        private String hash;
        private long internalDate;
        private long externalDate;
        private String manifest;
        private String url;
        private long usedClassCount;
        private String version;

        private Builder() {
        }

        public Builder tags(String string) {
            this.tags = string;
            return this;
        }

        public Builder classCount(long l2) {
            this.classCount = l2;
            return this;
        }

        public Builder file(String string) {
            this.file = string;
            return this;
        }

        public Builder hash(String string) {
            this.hash = string;
            return this;
        }

        public Builder internalDate(long l2) {
            this.internalDate = l2;
            return this;
        }

        public Builder externalDate(long l2) {
            this.externalDate = l2;
            return this;
        }

        public Builder manifest(String string) {
            this.manifest = string;
            return this;
        }

        public Builder url(String string) {
            this.url = string;
            return this;
        }

        public Builder usedClassCount(long l2) {
            this.usedClassCount = l2;
            return this;
        }

        public Builder version(String string) {
            this.version = string;
            return this;
        }

        public LibraryDTM build() {
            return new LibraryDTM(this);
        }
    }
}

