/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.routes;

import com.contrastsecurity.agent.commons.l;
import com.contrastsecurity.agent.commons.o;
import com.contrastsecurity.agent.messages.app.info.HTTPRoute;
import com.contrastsecurity.agent.messages.finding.trace.EventSource;
import com.contrastsecurity.thirdparty.com.google.gson.annotations.SerializedName;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public final class ObservedRoute {
    @SerializedName(value="session_id")
    private final String sessionId;
    private final String verb;
    private final String url;
    private final String signature;
    private final Set<EventSource> sources;

    public static Builder builderFromRoute(HTTPRoute hTTPRoute) {
        return ObservedRoute.builder().verb(hTTPRoute.getVerb()).url(hTTPRoute.getUrl()).signature(hTTPRoute.getSignature());
    }

    private ObservedRoute(Builder builder) {
        this.sessionId = l.a(builder.sessionId);
        this.verb = builder.verb;
        this.url = l.a(builder.url);
        this.signature = l.a(builder.signature);
        this.sources = o.a(builder.sources);
    }

    public static synchronized Builder builder() {
        return new Builder();
    }

    public String sessionId() {
        return this.sessionId;
    }

    public String verb() {
        return this.verb;
    }

    public String url() {
        return this.url;
    }

    public String signature() {
        return this.signature;
    }

    public Set<EventSource> sources() {
        return this.sources;
    }

    public String toString() {
        return "ObservedRoute{sessionId='" + this.sessionId + '\'' + ", verb='" + this.verb + '\'' + ", url='" + this.url + '\'' + ", signature='" + this.signature + '\'' + ", sources=" + this.sources + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ObservedRoute observedRoute = (ObservedRoute)object;
        if (this.sessionId != null ? !this.sessionId.equals(observedRoute.sessionId) : observedRoute.sessionId != null) {
            return false;
        }
        if (this.verb != null ? !this.verb.equals(observedRoute.verb) : observedRoute.verb != null) {
            return false;
        }
        if (!this.url.equals(observedRoute.url)) {
            return false;
        }
        if (!this.signature.equals(observedRoute.signature)) {
            return false;
        }
        return this.sources.equals(observedRoute.sources);
    }

    public int hashCode() {
        int n2 = this.sessionId != null ? this.sessionId.hashCode() : 0;
        n2 = 31 * n2 + (this.verb != null ? this.verb.hashCode() : 0);
        n2 = 31 * n2 + this.url.hashCode();
        n2 = 31 * n2 + this.signature.hashCode();
        n2 = 31 * n2 + this.sources.hashCode();
        return n2;
    }

    public static final class Builder {
        private String sessionId;
        private String verb;
        private String url;
        private String signature;
        private Set<EventSource> sources = new HashSet<EventSource>();

        public synchronized boolean requiredPropertiesSet() {
            return this.verb != null && this.url != null && this.signature != null && this.sessionId != null;
        }

        public synchronized Builder sessionId(String string) {
            this.sessionId = string;
            return this;
        }

        public synchronized Builder verb(String string) {
            this.verb = string;
            return this;
        }

        public synchronized Builder url(String string) {
            this.url = string;
            return this;
        }

        public synchronized Builder signature(String string) {
            this.signature = string;
            return this;
        }

        public synchronized Builder addSource(EventSource eventSource) {
            l.a(eventSource);
            this.sources.add(eventSource);
            return this;
        }

        public synchronized Builder addSources(Collection<EventSource> collection) {
            l.a(collection);
            this.sources.addAll(collection);
            return this;
        }

        public synchronized ObservedRoute build() {
            return new ObservedRoute(this);
        }
    }
}

