/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.messages.server.features;

import com.contrastsecurity.agent.messages.server.features.FeatureSet;
import com.contrastsecurity.agent.messages.server.features.InventoryFeatures;
import com.contrastsecurity.agent.messages.server.features.assessment.InputValidatorDTM;
import com.contrastsecurity.agent.messages.server.features.assessment.SamplingFeatures;
import com.contrastsecurity.agent.messages.server.features.assessment.SanitizerDTM;
import com.contrastsecurity.thirdparty.com.google.gson.annotations.SerializedName;
import java.util.Set;

public class AssessmentFeatures {
    private Set<String> disabledRules;
    private Boolean enabled;
    private Boolean identityTagging;
    private SamplingFeatures sampling;
    private Set<SanitizerDTM> sanitizers;
    @SerializedName(value="responseScanning")
    private Boolean scanningResponse;
    @SerializedName(value="dynamicSources")
    private Boolean useDynamicSources;
    @SerializedName(value="propagators")
    private Boolean usePropagators;
    @SerializedName(value="rules")
    private Boolean useRules;
    @SerializedName(value="sources")
    private Boolean useSources;
    @SerializedName(value="taggers")
    private Boolean useTaggers;
    @SerializedName(value="validatorScopes")
    private Boolean useValidatorScopes;
    private Set<InputValidatorDTM> validators;

    public static FeatureSet makeFeatureSet() {
        FeatureSet featureSet = new FeatureSet();
        featureSet.setInventory(new InventoryFeatures());
        InventoryFeatures inventoryFeatures = featureSet.getInventory();
        inventoryFeatures.setAnalyzeLibraries(true);
        inventoryFeatures.setMonitorDatabase(true);
        inventoryFeatures.setMonitorLdap(true);
        inventoryFeatures.setMonitorWebCalls(true);
        inventoryFeatures.setReportActivity(true);
        featureSet.setAssessment(new AssessmentFeatures());
        AssessmentFeatures assessmentFeatures = featureSet.getAssessment();
        assessmentFeatures.enabled = true;
        assessmentFeatures.identityTagging = true;
        assessmentFeatures.scanningResponse = true;
        assessmentFeatures.useDynamicSources = true;
        assessmentFeatures.useSources = true;
        assessmentFeatures.useRules = true;
        assessmentFeatures.usePropagators = true;
        assessmentFeatures.useTaggers = true;
        assessmentFeatures.useValidatorScopes = true;
        assessmentFeatures.sampling = new SamplingFeatures();
        assessmentFeatures.sampling.setEnabled(false);
        assessmentFeatures.sampling.setBaseline(5);
        assessmentFeatures.sampling.setRequestFrequency(10);
        assessmentFeatures.sampling.setResponseFrequency(25);
        assessmentFeatures.sampling.setWindow(180);
        featureSet.setLogFile(null);
        featureSet.setLogLevel("INFO");
        featureSet.setUseCache(false);
        return featureSet;
    }

    public Set<String> getDisabledRules() {
        return this.disabledRules;
    }

    public void setDisabledRules(Set<String> set) {
        this.disabledRules = set;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public Boolean isIdentityTagging() {
        return this.identityTagging;
    }

    public void setIdentityTagging(boolean bl) {
        this.identityTagging = bl;
    }

    public Boolean isUseDynamicSources() {
        return this.useDynamicSources;
    }

    public void setUseDynamicSources(boolean bl) {
        this.useDynamicSources = bl;
    }

    public Boolean isUsePropagators() {
        return this.usePropagators;
    }

    public void setUsePropagators(boolean bl) {
        this.usePropagators = bl;
    }

    public SamplingFeatures getSampling() {
        return this.sampling;
    }

    public void setSampling(SamplingFeatures samplingFeatures) {
        this.sampling = samplingFeatures;
    }

    public Set<SanitizerDTM> getSanitizers() {
        return this.sanitizers;
    }

    public void setSanitizers(Set<SanitizerDTM> set) {
        this.sanitizers = set;
    }

    public Boolean isScanningResponse() {
        return this.scanningResponse;
    }

    public void setScanningResponse(boolean bl) {
        this.scanningResponse = bl;
    }

    public Boolean isUseRules() {
        return this.useRules;
    }

    public void setUseRules(boolean bl) {
        this.useRules = bl;
    }

    public Boolean isUseSources() {
        return this.useSources;
    }

    public void setUseSources(boolean bl) {
        this.useSources = bl;
    }

    public Boolean isUseTaggers() {
        return this.useTaggers;
    }

    public void setUseTaggers(boolean bl) {
        this.useTaggers = bl;
    }

    public Boolean isUseValidatorScopes() {
        return this.useValidatorScopes;
    }

    public void setUseValidatorScopes(boolean bl) {
        this.useValidatorScopes = bl;
    }

    public Set<InputValidatorDTM> getValidators() {
        return this.validators;
    }

    public void setValidators(Set<InputValidatorDTM> set) {
        this.validators = set;
    }
}

