/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.j2ee;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.ScopingSensor;
import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.apps.Language;
import com.contrastsecurity.agent.commons.l;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.http.MultipartItem;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.J2EEHttpRequest;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.J2EEHttpResponse;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.J2EEObjectShare;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.f.a;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.f.b;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.f.c;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.f.d;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.f.e;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.f.f;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.f.g;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.f.h;
import com.contrastsecurity.agent.plugins.rasp.AttackBlockedException;
import com.contrastsecurity.agent.plugins.rasp.RaspManager;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.HttpWatcher;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.RuleProvider;
import com.contrastsecurity.agent.services.F;
import com.contrastsecurity.agent.u;
import com.contrastsecurity.agent.util.B;
import com.contrastsecurity.agent.util.BinaryScopeTracker;
import com.contrastsecurity.agent.util.D;
import com.contrastsecurity.agent.util.K;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.o;
import com.contrastsecurity.thirdparty.org.apache.commons.io.IOUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@DontObfuscate
public final class ContrastHttpServletDispatcherImpl
implements ContrastHttpServletDispatcher {
    private final boolean enableContextDiscovery;
    private final b[] contextFinders;
    private final BinaryScopeTracker httpMultipartParameterResolutionScope = new BinaryScopeTracker();
    private final BinaryScopeTracker httpParameterResolutionScope = new BinaryScopeTracker();
    private final BinaryScopeTracker httpScope = new BinaryScopeTracker();
    private final BinaryScopeTracker httpResponseHeaderScope = new BinaryScopeTracker();
    private final HttpManager httpManager;
    private final F serverVersionReporter;
    private final ApplicationManager applicationManager;
    private final com.contrastsecurity.agent.plugins.g pluginManager;
    private final RaspManager raspManager;
    private final ContrastEngine engine;
    private final com.contrastsecurity.agent.config.g config;
    private static final Object[] WEB_XML_ARGS = new Object[]{"/WEB-INF/web.xml"};
    private static final Map<String, String[]> STUB_PARAMETERS = Collections.singletonMap("=N/A", ObjectShare.EMPTY_STRING_ARRAY);
    private static final String DEFAULT_CONTEXT = "/";
    private static final Object[] GET_REAL_PATH_ARGS = new Object[]{"/"};
    private static final String GLASSFISH_TOKEN = "Oracle GlassFish Server";
    private static boolean REPORTED_SERVER_VERSION;
    private static final Logger logger;

    public ContrastHttpServletDispatcherImpl(com.contrastsecurity.agent.config.g g2, HttpManager httpManager, ApplicationManager applicationManager, com.contrastsecurity.agent.plugins.g g3, RaspManager raspManager, ContrastEngine contrastEngine, F f2) {
        this.httpManager = l.a(httpManager, "httpManager");
        this.applicationManager = l.a(applicationManager, "applicationManager");
        this.pluginManager = l.a(g3, "pluginManager");
        this.raspManager = l.a(raspManager, "raspManager");
        this.engine = l.a(contrastEngine, "engine");
        this.config = l.a(g2, "config");
        this.serverVersionReporter = l.a(f2, "serverVersionReporter");
        this.enableContextDiscovery = g2.f("contrast.j2ee.context.discovery");
        this.contextFinders = new b[]{new e(), new f(), new a(), new c(), new g(), new h(), new com.contrastsecurity.agent.plugins.frameworks.n.a(), new d()};
    }

    @Sensor
    public void onEnterMultipartParameterResolutionScope() {
        this.httpMultipartParameterResolutionScope.enterScope();
    }

    @Sensor
    public void onLeaveMultipartParameterResolutionScope() {
        this.httpMultipartParameterResolutionScope.leaveScope();
    }

    @Sensor
    public void onEnterParameterResolutionScope() {
        this.httpParameterResolutionScope.enterScope();
    }

    @Sensor
    public void onLeaveParameterResolutionScope() {
        this.httpParameterResolutionScope.leaveScope();
    }

    public void onMultipartInputStreamRead(MultipartItem multipartItem, byte[] byArray) {
        HttpRequest httpRequest = this.httpManager.getCurrentRequest();
        multipartItem.setInitialized(true);
        if (httpRequest != null) {
            String string = multipartItem.getContentType();
            logger.debug("Making string of size {}, content-type {}", (Object)byArray.length, (Object)string);
            String string2 = new String(byArray);
            multipartItem.setValue(string2);
            this.httpManager.onMultipartBodyRead(httpRequest, multipartItem);
        }
    }

    @ScopedSensor
    public InputStream onMultipartInputStreamRetrieved(InputStream inputStream, Object object) {
        InputStream inputStream2;
        try {
            HttpRequest httpRequest;
            ScopingSensor.aspectOf().startScope();
            if (!(inputStream instanceof com.contrastsecurity.agent.plugins.frameworks.j2ee.c.b) && (httpRequest = this.httpManager.getCurrentRequest()) != null) {
                Set<MultipartItem> set = httpRequest.getMultipartItems();
                for (MultipartItem multipartItem : set) {
                    if (multipartItem.getOriginalItem() != object) continue;
                    inputStream = new com.contrastsecurity.agent.plugins.frameworks.j2ee.c.b(multipartItem, inputStream, this);
                }
            }
            inputStream2 = inputStream;
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
        return inputStream2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScopedSensor
    public void onMultipartParametersResolved(Object object) {
        try {
            ScopingSensor.aspectOf().startScope();
            try {
                if (!this.httpMultipartParameterResolutionScope.inOutermostScope()) {
                } else {
                    HttpRequest httpRequest = this.httpManager.getCurrentRequest();
                    if (httpRequest != null) {
                        if (httpRequest.isMultipartParametersResolved()) {
                        } else {
                            httpRequest.resolvedMultipartParameters();
                            logger.debug("Detected the app asked for multipart. Adding to our own model.");
                            Collection<?> collection = J2EEObjectShare.REFLECTOR.e(object);
                            for (Object obj : collection) {
                                MultipartItem multipartItem = J2EEObjectShare.REFLECTOR.f(obj);
                                if (multipartItem == null) continue;
                                httpRequest.addMultipartItem(multipartItem);
                                this.httpManager.onMultipartHeaderRead(httpRequest, multipartItem);
                            }
                        }
                    }
                }
            }
            catch (AttackBlockedException attackBlockedException) {
                throw attackBlockedException;
            }
            catch (Throwable throwable) {
                logger.error("Problem resolving multipart parameters after app did", throwable);
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensor
    public void onParametersResolved(Object object) {
        AttackBlockedException attackBlockedException = null;
        try {
            this.engine.onEnteringSensor();
            if (!this.httpParameterResolutionScope.inOutermostScope()) {
                return;
            }
            HttpRequest httpRequest = this.httpManager.getCurrentRequest();
            if (httpRequest == null) {
                logger.debug("Ignoring parameter resolution event -- no request in scope");
                return;
            }
            if (httpRequest.isParametersResolved()) {
                if (this.config.f("contrast.defend.enabled")) {
                    this.raspManager.checkParameterAccess();
                }
                return;
            }
            httpRequest.resolvedParameters();
            if (!o.c(httpRequest)) {
                return;
            }
            Map<String, String[]> map = J2EEObjectShare.REFLECTOR.b(object);
            if (logger.isDebugEnabled()) {
                logger.debug("Detected the app asked for parameters on request {}. Adding to our own model.", (Object)K.a(object));
            }
            logger.debug("Adding {} parameters to our own model", (Object)(map != null ? map.size() : 0));
            boolean bl = this.config.f("contrast.assess.enabled");
            HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
            if (map != null) {
                for (String string : map.keySet()) {
                    String[] stringArray = map.get(string);
                    String[] stringArray2 = new String[stringArray.length];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    hashMap.put(bl ? new String(string) : string, stringArray2);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Using parameters {}", (Object)K.a(hashMap));
            }
            httpRequest.setParameters(hashMap);
            this.httpManager.onParametersResolved(httpRequest);
        }
        catch (AttackBlockedException attackBlockedException2) {
            attackBlockedException = attackBlockedException2;
        }
        catch (Throwable throwable) {
            logger.error("Problem resolving request parameters after app did", throwable);
        }
        finally {
            this.engine.onLeavingSensor();
        }
        if (attackBlockedException != null) {
            throw attackBlockedException;
        }
    }

    @ScopedSensor
    public void onEnterHttpScope() {
        try {
            ScopingSensor.aspectOf().startScope();
            this.httpScope.enterScope();
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    @ScopedSensor
    public void onLeaveHttpScope() {
        try {
            ScopingSensor.aspectOf().startScope();
            this.httpScope.leaveScope();
            if (!this.httpScope.inScope()) {
                this.httpManager.onRequestEnd();
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    @Sensor
    public boolean isFirstHandler() {
        return this.httpScope.inOutermostScope();
    }

    @Sensor
    public void logUri(String string) {
        if (logger.isDebugEnabled()) {
            this.engine.onEnteringSensor();
            try {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("[URL ");
                stringBuilder.append(this.httpScope);
                stringBuilder.append("] ");
                stringBuilder.append(string);
                logger.debug(">>> {}", (Object)stringBuilder);
            }
            finally {
                this.engine.onLeavingSensor();
            }
        }
    }

    @Sensor
    public ContrastHttpServletRequestModel createRequest(Object object) {
        return new J2EEHttpRequest(object);
    }

    @ScopedSensor
    public void onFirstRequestHandlerInvoked(Object object, Object object2, Object object3, Object object4, ContrastHttpServletRequestModel contrastHttpServletRequestModel, Enumeration<?> enumeration) {
        block9: {
            try {
                ScopingSensor.aspectOf().startScope();
                try {
                    J2EEHttpRequest j2EEHttpRequest = (J2EEHttpRequest)contrastHttpServletRequestModel;
                    Application application = this.applicationManager.current();
                    this.applicationManager.detectedAppContainer(true);
                    this.logUri(j2EEHttpRequest.getUri());
                    Object object5 = this.findContext(object, object2);
                    boolean bl = this.config.f("contrast.assess.enabled");
                    this.initializeHttpRequest(object, object2, object3, object5, object4, j2EEHttpRequest, enumeration, bl);
                    if (!REPORTED_SERVER_VERSION && object5 != null) {
                        REPORTED_SERVER_VERSION = true;
                        this.reportServerVersion(j2EEHttpRequest);
                    }
                    if (B.a()) {
                        break block9;
                    }
                    this.attachAppToContext(object2, object5, j2EEHttpRequest);
                    Application application2 = this.applicationManager.current();
                    if (application != null && application2 != null) {
                        application2.copyStateFromFallbackApplication(application);
                    }
                    HttpResponse httpResponse = this.httpManager.getCurrentResponse();
                    this.httpManager.onRequestStart(j2EEHttpRequest);
                    this.httpManager.onResponseStart(j2EEHttpRequest, httpResponse);
                }
                catch (Exception exception) {
                    if (exception instanceof AttackBlockedException) {
                        throw (AttackBlockedException)exception;
                    }
                    logger.error("Error adding HTTP tracking to thread:", exception);
                }
            }
            finally {
                ScopingSensor.aspectOf().leaveScope();
            }
        }
    }

    private Object findContext(Object object, Object object2) {
        Object object3 = null;
        if (this.enableContextDiscovery) {
            Object object4;
            if (logger.isDebugEnabled()) {
                String string = object == null ? "null" : object.getClass().getCanonicalName();
                object4 = object2 == null ? "null" : object2.getClass().getCanonicalName();
                logger.debug("finding context with servletObj: {} requestObj: {}", (Object)string, object4);
            }
            for (int i2 = 0; object3 == null && i2 < this.contextFinders.length; ++i2) {
                object4 = this.contextFinders[i2];
                if (!((b)object4).a(object, object2)) continue;
                object3 = ((b)object4).b(object, object2);
                if (i2 == 0 || object3 == null) continue;
                b b2 = this.contextFinders[0];
                this.contextFinders[0] = object4;
                this.contextFinders[i2] = b2;
            }
            if (logger.isDebugEnabled()) {
                if (object3 == null) {
                    logger.debug("Failed to detect servlet context");
                } else {
                    logger.debug("servletContext: {}", (Object)object3.getClass().getCanonicalName());
                }
            }
        } else {
            logger.debug("Context discovery intentionally disabled. There could be unintended side effects.");
        }
        return object3;
    }

    private void attachAppToContext(Object object, Object object2, J2EEHttpRequest j2EEHttpRequest) throws Exception {
        String string = j2EEHttpRequest.getContextPath();
        String string2 = string != null && string.startsWith(DEFAULT_CONTEXT) ? string : DEFAULT_CONTEXT;
        logger.debug("Detected app context path to be {}, appName={}", (Object)string, (Object)string2);
        Application application = this.applicationManager.findApplicationByPath(string2, Language.Java);
        this.applicationManager.current(application);
        if (!(application instanceof com.contrastsecurity.agent.plugins.frameworks.j2ee.a.c)) {
            com.contrastsecurity.agent.apps.a a2 = application.id();
            logger.error("Application with name=[{}] and path=[{}] relies on Servlet instrumentation, but is not an instance of {}", a2.a(), a2.b(), com.contrastsecurity.agent.plugins.frameworks.j2ee.a.c.class.getName());
            return;
        }
        boolean bl = object2 != null;
        com.contrastsecurity.agent.plugins.frameworks.j2ee.a.c c2 = (com.contrastsecurity.agent.plugins.frameworks.j2ee.a.c)application;
        if (bl && this.enableContextDiscovery) {
            c2.a(object2);
        } else if (!bl) {
            com.contrastsecurity.agent.apps.a a3 = application.id();
            logger.warn("Failed to obtain ServletContext for application with name=[{}] and path=[{}].", (Object)a3.a(), (Object)a3.b());
        }
        if (application.getInventoryState().b()) {
            return;
        }
        if (!this.resolvePath(application, object, object2)) {
            logger.debug("Failed to immediately resolve app path for {}", (Object)string2);
        } else {
            try {
                c2.a(this.pluginManager, this.parseWebXml(application.getResolvedPath()));
            }
            catch (Exception exception) {
                logger.error("Problem parsing web.xml", exception);
            }
        }
    }

    private void reportServerVersion(HttpRequest httpRequest) {
        String string = httpRequest.getServerVersionInfo();
        if (!this.serverVersionReporter.a() && string != null) {
            if (this.isWebLogicVersion(string)) {
                this.reportWebLogicVersion(string);
            } else if (this.isGlassFishVersion(string)) {
                this.reportGlassFishVersion(string);
            } else {
                this.reportSplitVersion(string);
            }
        }
    }

    String reportGlassFishVersion(String string) {
        String string2 = string.substring(GLASSFISH_TOKEN.length() + 1);
        this.serverVersionReporter.a(GLASSFISH_TOKEN, string2);
        return string2;
    }

    boolean isGlassFishVersion(String string) {
        return string.startsWith("Oracle GlassFish Server 3.");
    }

    String reportWebLogicVersion(String string) {
        String string2;
        int n2 = (string2 = string.substring(16)).indexOf(32);
        string2 = string2.substring(0, n2 != -1 ? n2 : string2.length());
        this.serverVersionReporter.a("WebLogic Server", string2);
        return string2;
    }

    boolean isWebLogicVersion(String string) {
        return string.startsWith("WebLogic Server ");
    }

    private void reportSplitVersion(String string) {
        String[] stringArray = string.split(DEFAULT_CONTEXT, 2);
        if (stringArray.length == 2) {
            this.serverVersionReporter.a(stringArray[0], stringArray[1]);
        } else if (string.startsWith("WildFly ")) {
            String string2 = com.contrastsecurity.agent.plugins.frameworks.f.d.a(string);
            if (string2 != null) {
                this.serverVersionReporter.a("WildFly", string2);
            }
        } else {
            logger.warn("Unknown format for container name/version: {}", (Object)string);
            this.serverVersionReporter.a(null, null);
        }
    }

    @ScopedSensor
    public void onEnterHttpResponseHeaderScope() {
        try {
            ScopingSensor.aspectOf().startScope();
            this.httpResponseHeaderScope.enterScope();
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    @ScopedSensor
    public void onLeaveHttpResponseHeaderScope() {
        try {
            ScopingSensor.aspectOf().startScope();
            this.httpResponseHeaderScope.leaveScope();
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    void initializeHttpRequest(Object object, Object object2, Object object3, Object object4, Object object5, J2EEHttpRequest j2EEHttpRequest, Enumeration<?> enumeration, boolean bl) {
        J2EEObjectShare.REFLECTOR.a(object4, j2EEHttpRequest);
        J2EEObjectShare.REFLECTOR.a(object2, j2EEHttpRequest, enumeration);
        j2EEHttpRequest.setParameters(STUB_PARAMETERS);
        this.httpManager.setCurrentRequest(j2EEHttpRequest);
        J2EEHttpResponse j2EEHttpResponse = new J2EEHttpResponse(this.httpManager, object3);
        this.httpManager.setCurrentResponse(j2EEHttpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseWebXml(String string) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = u.a.a(string + File.separatorChar + "WEB-INF" + File.separatorChar + "web.xml");
            byte[] byArray = IOUtils.toByteArray(fileInputStream);
            String string2 = new String(byArray);
            IOUtils.closeQuietly(fileInputStream);
            return string2;
        }
        catch (IOException iOException) {
            logger.debug("Problem reading web.xml file", iOException);
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
        }
        return null;
    }

    private boolean resolvePath(Application application, Object object, Object object2) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MalformedURLException {
        Method method = D.c(object.getClass(), "getRealPath", ObjectShare.SINGLE_STRING_ARRAY);
        String string = (String)method.invoke(object, GET_REAL_PATH_ARGS);
        if (!StringUtils.isEmpty(string)) {
            logger.debug("Resolved app path to: {}", (Object)string);
            application.setResolvedPath(string);
        } else {
            logger.debug("Real path root was empty. Trying servletContext.getRealPath()");
            if (object2 != null) {
                method = D.c(object2.getClass(), "getRealPath", ObjectShare.SINGLE_STRING_ARRAY);
                string = (String)method.invoke(object2, GET_REAL_PATH_ARGS);
                if (!StringUtils.isEmpty(string)) {
                    logger.debug("Resolved app path from session context to: {}", (Object)string);
                    application.setResolvedPath(string);
                } else {
                    string = this.resolvePathRoot(object2);
                    if (string == null) {
                        logger.debug("Unable to resolve path despite best efforts. Setting {}'s path to the empty string", (Object)application.getDisplayName());
                        string = "";
                    }
                    application.setResolvedPath(string);
                    if (StringUtils.isEmpty(string)) {
                        return false;
                    }
                }
            } else {
                if (!this.enableContextDiscovery) {
                    logger.debug("Context discovery intentionally disabled. Will never be able to resolvedPath. Inventorying could fail.");
                    application.setResolvedPath("");
                }
                logger.debug("SESSION WAS EMPTY");
                return false;
            }
        }
        return true;
    }

    private String resolvePathRoot(Object object) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        logger.debug("Trying to get path root via getResource()");
        Method method = D.c(object.getClass(), "getResource", String.class);
        URL uRL = (URL)method.invoke(object, WEB_XML_ARGS);
        String string = null;
        if (uRL != null) {
            string = uRL.getPath();
        }
        logger.debug("URL to web.xml from ServletContext.getResource(): " + string);
        if (!StringUtils.isEmpty(string) && string.endsWith(".xml")) {
            string = string.substring(0, string.indexOf("/WEB-INF"));
        }
        if (StringUtils.isEmpty(string) || !new File(string).exists()) {
            logger.debug("Last ditch effort to resolve app root result failed. Retrieved: " + string);
            return null;
        }
        logger.debug("Last ditch effort to resolve app root succeeded. Retrieved: " + string);
        return string;
    }

    @ScopedSensor
    public void onGetOutputCalled(Object object) {
        try {
            ScopingSensor.aspectOf().startScope();
            try {
                HttpResponse httpResponse = this.httpManager.getCurrentResponse();
                J2EEHttpResponse j2EEHttpResponse = (J2EEHttpResponse)httpResponse;
                if (j2EEHttpResponse != null && j2EEHttpResponse.a == null) {
                    j2EEHttpResponse.a = object;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Assigning output mechanism: {} to response {}", (Object)K.a(object), (Object)K.a(httpResponse));
                    }
                } else if (logger.isDebugEnabled()) {
                    logger.debug("Ignoring output mechanism: {} for response {}", (Object)K.a(object), (Object)K.a(httpResponse));
                }
            }
            catch (Throwable throwable) {
                logger.debug("Problem capturing output writing mechanism", throwable);
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    @ScopedSensor
    public void onGetInputCalled(Object object) {
        block7: {
            try {
                ScopingSensor.aspectOf().startScope();
                try {
                    HttpRequest httpRequest = this.httpManager.getCurrentRequest();
                    if (!(httpRequest instanceof J2EEHttpRequest)) {
                        break block7;
                    }
                    J2EEHttpRequest j2EEHttpRequest = (J2EEHttpRequest)httpRequest;
                    if (j2EEHttpRequest.a == null) {
                        j2EEHttpRequest.a = object;
                        logger.debug("Assigning input mechanism: {}", object);
                        break block7;
                    }
                    logger.debug("Ignoring input mechanism: {}", object);
                }
                catch (Throwable throwable) {
                    logger.debug("Problem capturing input reading mechanism", throwable);
                }
            }
            finally {
                ScopingSensor.aspectOf().leaveScope();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScopedSensor
    public void onSetResponseHeader(String string, String string2) {
        try {
            ScopingSensor.aspectOf().startScope();
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug(">> onSetResponseHeader() {}", (Object)this.httpResponseHeaderScope);
                }
                if (!this.httpResponseHeaderScope.inOutermostScope()) {
                } else {
                    HttpRequest httpRequest;
                    Collection<RuleProvider> collection;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Response Header written out: {}={}", (Object)string, (Object)string2);
                    }
                    Collection<RuleProvider> collection2 = collection = (httpRequest = this.httpManager.getCurrentRequest()) != null ? httpRequest.getResponseProviders() : null;
                    if (collection == null || collection.size() == 0) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Couldn't find providers");
                        }
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Handing off response headers to provider set ({})", (Object)collection.hashCode());
                        }
                        for (RuleProvider ruleProvider : collection) {
                            HttpWatcher httpWatcher = ruleProvider.getResponseWatcher();
                            if (httpWatcher == null) continue;
                            if (logger.isDebugEnabled()) {
                                logger.debug("Handing off response header to " + httpWatcher.getClass().getName());
                            }
                            httpWatcher.onHeaderSet(string, string2, httpRequest.context());
                        }
                        HttpResponse httpResponse = this.httpManager.getCurrentResponse();
                        if (httpResponse != null) {
                            httpResponse.onHeaderSet(string, string2, httpRequest.getUri());
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                logger.error("Problem processing header", throwable);
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    @ScopedSensor
    public void onSetResponseDateHeader(String string, long l2) {
        try {
            ScopingSensor.aspectOf().startScope();
            try {
                logger.debug(">> onSetResponseDateHeader()");
                if (!this.httpResponseHeaderScope.inOutermostScope()) {
                } else {
                    HttpRequest httpRequest;
                    Collection<RuleProvider> collection;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Response Date Header written out: " + string + "=" + l2);
                    }
                    Collection<RuleProvider> collection2 = collection = (httpRequest = this.httpManager.getCurrentRequest()) != null ? httpRequest.getResponseProviders() : null;
                    if (collection == null) {
                    } else {
                        logger.debug("Handing off response headers to provider set (" + collection.hashCode() + ")");
                        for (RuleProvider ruleProvider : collection) {
                            HttpWatcher httpWatcher = ruleProvider.getResponseWatcher();
                            if (httpWatcher == null) continue;
                            logger.debug("Handing off response date header to " + httpWatcher.getClass().getName());
                            httpWatcher.onDateHeaderSet(string, l2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                logger.error("Problem processing header (long)", throwable);
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ScopedSensor
    public void onSetResponseIntHeader(String string, int n2) {
        try {
            ScopingSensor.aspectOf().startScope();
            try {
                logger.debug(">> onSetResponseIntHeader()");
                if (!this.httpResponseHeaderScope.inOutermostScope()) {
                } else {
                    HttpRequest httpRequest;
                    Collection<RuleProvider> collection;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Response Integer Header written out: " + string + "=" + n2);
                    }
                    Collection<RuleProvider> collection2 = collection = (httpRequest = this.httpManager.getCurrentRequest()) != null ? httpRequest.getResponseProviders() : null;
                    if (collection == null) {
                    } else {
                        for (RuleProvider ruleProvider : collection) {
                            HttpWatcher httpWatcher = ruleProvider.getResponseWatcher();
                            if (httpWatcher == null) continue;
                            logger.debug("Handing off response int header to " + httpWatcher.getClass().getName());
                            httpWatcher.onIntHeaderSet(string, n2);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                logger.error("Problem processing header (long)", throwable);
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    @ScopedSensor
    public void onEnterReadingScope() {
        try {
            ScopingSensor.aspectOf().startScope();
            HttpRequest httpRequest = this.httpManager.getCurrentRequest();
            if (!(httpRequest instanceof J2EEHttpRequest)) {
            } else {
                J2EEHttpRequest j2EEHttpRequest = (J2EEHttpRequest)httpRequest;
                if (j2EEHttpRequest != null) {
                    j2EEHttpRequest.enterReadingScope();
                }
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    @ScopedSensor
    public void onLeaveReadingScope() {
        try {
            ScopingSensor.aspectOf().startScope();
            HttpRequest httpRequest = this.httpManager.getCurrentRequest();
            if (!(httpRequest instanceof J2EEHttpRequest)) {
            } else {
                J2EEHttpRequest j2EEHttpRequest = (J2EEHttpRequest)httpRequest;
                if (j2EEHttpRequest != null) {
                    j2EEHttpRequest.leaveReadingScope();
                }
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    @ScopedSensor
    public void onInputStreamRead(int n2, Object object) {
        try {
            ScopingSensor.aspectOf().startScope();
            if (n2 == -1) {
            } else {
                J2EEHttpRequest j2EEHttpRequest = this.getRequest(object);
                if (j2EEHttpRequest != null && (j2EEHttpRequest.isBufferToPlugins() || j2EEHttpRequest.isCapturingInFile() || j2EEHttpRequest.isCapturingInMemory())) {
                    j2EEHttpRequest.onBytesRead(n2);
                }
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    @ScopedSensor
    public void onInputStreamRead(int n2, Object object, byte[] byArray) {
        try {
            ScopingSensor.aspectOf().startScope();
            if (byArray != null) {
                if (n2 <= 0) {
                } else {
                    J2EEHttpRequest j2EEHttpRequest = this.getRequest(object);
                    if (j2EEHttpRequest != null && (j2EEHttpRequest.isBufferToPlugins() || j2EEHttpRequest.isCapturingInFile() || j2EEHttpRequest.isCapturingInMemory())) {
                        j2EEHttpRequest.onBytesRead(n2, byArray, 0, byArray.length);
                    }
                }
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    @ScopedSensor
    public void onInputStreamRead(int n2, Object object, byte[] byArray, int n3, int n4) {
        try {
            ScopingSensor.aspectOf().startScope();
            if (byArray != null) {
                if (n2 <= 0) {
                } else {
                    J2EEHttpRequest j2EEHttpRequest = this.getRequest(object);
                    if (j2EEHttpRequest != null && (j2EEHttpRequest.isBufferToPlugins() || j2EEHttpRequest.isCapturingInFile() || j2EEHttpRequest.isCapturingInMemory())) {
                        j2EEHttpRequest.onBytesRead(n2, byArray, n3, n4);
                    }
                }
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    private J2EEHttpRequest getRequest(Object object) {
        HttpRequest httpRequest = this.httpManager.getCurrentRequest();
        if (!(httpRequest instanceof J2EEHttpRequest)) {
            return null;
        }
        J2EEHttpRequest j2EEHttpRequest = (J2EEHttpRequest)httpRequest;
        if (j2EEHttpRequest.a == null) {
            j2EEHttpRequest.a = object;
        } else if (j2EEHttpRequest.a != object) {
            return null;
        }
        return j2EEHttpRequest;
    }

    @Sensor
    public boolean isOutputWriter(ContrastHttpServletResponseModel contrastHttpServletResponseModel, Object object) {
        return contrastHttpServletResponseModel.isOutputWriter(object);
    }

    public ContrastHttpServletResponseModel currentResponse() {
        HttpResponse httpResponse = this.httpManager.getCurrentResponse();
        if (httpResponse instanceof J2EEHttpResponse) {
            return (J2EEHttpResponse)httpResponse;
        }
        return null;
    }

    static {
        logger = LoggerFactory.getLogger(ContrastHttpServletDispatcherImpl.class);
    }
}

