/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.netty;

import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.ScopingSensor;
import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.l;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.HttpResponse;
import com.contrastsecurity.agent.plugins.frameworks.netty.b;
import com.contrastsecurity.agent.plugins.frameworks.netty.h;
import com.contrastsecurity.agent.plugins.frameworks.netty.i;
import com.contrastsecurity.agent.plugins.frameworks.netty.j;
import com.contrastsecurity.agent.plugins.frameworks.o;
import com.contrastsecurity.agent.plugins.rasp.AttackBlockedException;
import com.contrastsecurity.agent.plugins.rasp.RaspManager;
import com.contrastsecurity.agent.services.F;
import com.contrastsecurity.agent.u;
import com.contrastsecurity.agent.util.D;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Sensor
public final class ContrastNettyDispatcherImpl
implements ContrastNettyDispatcher {
    private final ApplicationManager a;
    private final HttpManager b;
    private final F c;
    private final g d;
    private final ContrastEngine e;
    private final o f;
    private final RaspManager g;
    private boolean h;
    private b i;
    private static final String j = "?";
    private static final String k = "netty";
    private static final String l = "io.netty.handler.codec.http.DefaultHttpRequest";
    private static final Logger m = LoggerFactory.getLogger(ContrastNettyDispatcherImpl.class);

    public ContrastNettyDispatcherImpl(g g2, ContrastEngine contrastEngine, ApplicationManager applicationManager, HttpManager httpManager, F f2, o o2, RaspManager raspManager) {
        this.d = com.contrastsecurity.agent.commons.l.a(g2);
        this.e = com.contrastsecurity.agent.commons.l.a(contrastEngine);
        this.a = com.contrastsecurity.agent.commons.l.a(applicationManager);
        this.f = com.contrastsecurity.agent.commons.l.a(o2);
        this.b = com.contrastsecurity.agent.commons.l.a(httpManager);
        this.c = com.contrastsecurity.agent.commons.l.a(f2);
        this.g = com.contrastsecurity.agent.commons.l.a(raspManager);
        this.h = false;
    }

    @ScopedSensor
    public void onChannelRead(Object object, Object object2) {
        try {
            ScopingSensor.aspectOf().startScope();
            m.debug("Entering netty channel with ctx={},msg {}", object, object2);
            if (this.d(object2)) {
                this.a(object, object2);
            } else if (this.a(object2)) {
                this.b(object2);
            } else {
                m.debug("Ignoring non-HTTP message");
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    private boolean a(Object object) {
        String string = object != null ? object.getClass().getName() : "";
        return string.contains("HttpContent");
    }

    private void b(Object object) {
        m.debug("Handling httpManager content {}", object);
        HttpRequest httpRequest = this.b.getCurrentRequest();
        if (httpRequest instanceof i) {
            i i2 = (i)httpRequest;
            if ("EmptyLastHttpContent".equals(object.toString())) {
                i2.a(true);
            } else if (object.getClass().getSimpleName().equals("DefaultLastHttpContent")) {
                m.debug("Seen last chunk");
                i2.a(true);
            }
        } else {
            m.debug("EmptyLastHttpContent received without request in scope");
        }
    }

    private void a(Object object, Object object2) {
        m.debug("Handling httpManager message {}", object2);
        try {
            com.contrastsecurity.agent.http.b b2;
            if (!this.h) {
                this.b();
                this.h = true;
            }
            b b3 = this.a();
            if (this.a.current() == null) {
                this.a.registerApplication(b3);
                this.a.current(b3);
            }
            if (this.b.getCurrentRequest() == null) {
                b2 = new i(object2, object);
                this.b.setCurrentRequest((HttpRequest)b2);
                this.b.onRequestStart((HttpRequest)b2);
                if (!((HttpRequest)b2).getParameters().isEmpty()) {
                    this.b.onParametersResolved((HttpRequest)b2);
                }
            }
            if (this.b.getCurrentResponse() == null) {
                b2 = new j();
                this.b.setCurrentResponse((HttpResponse)b2);
                this.b.onResponseStart(this.b.getCurrentRequest(), (HttpResponse)b2);
            }
        }
        catch (AttackBlockedException attackBlockedException) {
            throw attackBlockedException;
        }
        catch (h h2) {
            m.error("Couldn't reflect netty request data", h2);
        }
    }

    private b a() {
        if (this.i == null) {
            this.i = new b(null, this.d, this.e, this.a.getSharedLibraryUsage());
        }
        return this.i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensor
    public void onPostBodyReadAsParameters(Object object) {
        m.debug("Reading HTTP parameters");
        AttackBlockedException attackBlockedException = null;
        try {
            i i2;
            this.e.onEnteringSensor();
            if (this.d.f("contrast.defend.enabled")) {
                this.g.checkParameterAccess();
            }
            if ((i2 = (i)this.b.getCurrentRequest()) != null) {
                this.a(object, i2);
            }
        }
        catch (AttackBlockedException attackBlockedException2) {
            attackBlockedException = attackBlockedException2;
        }
        catch (Exception exception) {
            m.debug("Couldn't read request parameters", exception);
        }
        finally {
            this.e.onLeavingSensor();
        }
        if (attackBlockedException != null) {
            throw attackBlockedException;
        }
    }

    private void a(Object object, i i2) throws Exception {
        Field field = D.a(object, "isLastChunk");
        boolean bl = field.getBoolean(object);
        if (bl) {
            String[] stringArray;
            if (i2.getParameters() == null) {
                i2.setParameters(new HashMap<String, String[]>());
            }
            Method method = D.f(object.getClass(), "getBodyHttpDatas");
            List list = (List)method.invoke(object, new Object[0]);
            HashMap<String, ArrayList<String[]>> hashMap = new HashMap<String, ArrayList<String[]>>();
            if (list != null) {
                for (int i3 = 0; i3 < list.size(); ++i3) {
                    Iterator<Object> iterator = list.get(i3);
                    String string = this.c(iterator);
                    stringArray = this.a(iterator, string);
                    ArrayList<String[]> arrayList = (ArrayList<String[]>)hashMap.get(string);
                    if (arrayList == null) {
                        arrayList = new ArrayList<String[]>();
                        hashMap.put(string, arrayList);
                    }
                    arrayList.add(stringArray);
                }
            }
            HashMap<String, String[]> hashMap2 = new HashMap<String, String[]>();
            for (String string : hashMap.keySet()) {
                stringArray = ((List)hashMap.get(string)).toArray(ObjectShare.EMPTY_STRING_ARRAY);
                hashMap2.put(string, stringArray);
                i2.getParameters().put(string, stringArray);
            }
            this.b.onMoreParametersResolved(i2, hashMap2);
        }
    }

    private String c(Object object) throws Exception {
        Method method = D.f(object.getClass(), "getName");
        return (String)method.invoke(object, new Object[0]);
    }

    private String a(Object object, String string) throws Exception {
        int n2;
        Method method = D.f(object.getClass(), "toString");
        String string2 = (String)method.invoke(object, new Object[0]);
        if (string2 != null && (n2 = string.length() + 1) < string2.length()) {
            string2 = string2.substring(n2);
        }
        return string2;
    }

    @ScopedSensor
    public void onUncaughtException(Object object, Object object2, Throwable throwable) {
        block8: {
            try {
                ScopingSensor.aspectOf().startScope();
                m.debug("Uncaught exception detected of type {}", (Object)throwable.getClass());
                try {
                    i i2 = (i)this.b.getCurrentRequest();
                    if (i2 != null) {
                        if (this.b(object, object2)) {
                            this.b.onRequestEnd();
                        } else {
                            m.debug("Wasn't last in pipeline -- ignoring uncaught exception");
                        }
                        break block8;
                    }
                    m.debug("No request at time of uncaught exception -- ignoring");
                }
                catch (Exception exception) {
                    m.error("Problem checking pipeline status for ctx {}", object2, (Object)exception);
                }
            }
            finally {
                ScopingSensor.aspectOf().leaveScope();
            }
        }
    }

    private boolean b(Object object, Object object2) throws Exception {
        Method method = D.f(object2.getClass(), "pipeline");
        Object object3 = method.invoke(object2, new Object[0]);
        Method method2 = D.f(object3.getClass(), "last");
        Object object4 = method2.invoke(object3, new Object[0]);
        return object == object4;
    }

    private boolean d(Object object) {
        return object != null && l.equals(object.getClass().getName());
    }

    @ScopedSensor
    public void onResponseWritten(Object object, Object object2) {
        try {
            ScopingSensor.aspectOf().startScope();
            try {
                HttpRequest httpRequest;
                if (this.f(object2)) {
                    this.e(object2);
                }
                if ((httpRequest = this.b.getCurrentRequest()) instanceof i) {
                    i i2 = (i)httpRequest;
                    if (i2.c()) {
                        m.debug("Detected Vert.x request -- deferring to VertxHttpController");
                    } else if (i2.b()) {
                        m.debug("Detected normal Netty request -- firing onRequestEnd");
                        this.b.onRequestEnd();
                    } else {
                        m.debug("Unfinished HTTP request -- not firing event");
                    }
                }
            }
            catch (AttackBlockedException attackBlockedException) {
                this.b.onRequestEnd();
                throw attackBlockedException;
            }
            catch (Exception exception) {
                m.error("Problem checking pipeline status for ctx {}", object, (Object)exception);
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    private void e(Object object) throws h {
        HttpResponse httpResponse = this.b.getCurrentResponse();
        if (httpResponse instanceof j) {
            j j2 = (j)httpResponse;
            j2.a(object);
        }
    }

    private boolean f(Object object) {
        return object != null && object.getClass().getName().contains("HttpResponse");
    }

    private void b() {
        try {
            Object object;
            Map<String, Object> map = this.c();
            Object object2 = map.get("netty-codec-http");
            if (object2 == null && !(object = map.keySet()).isEmpty()) {
                String string = (String)object.iterator().next();
                object2 = map.get(string);
            }
            object = this.g(object2);
            this.c.a(k, (String)object);
        }
        catch (Exception exception) {
            m.error("Couldn't retrieve netty version", exception);
        }
    }

    private Map<String, Object> c() throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = u.a("io.netty.util.Version", true, classLoader);
        if (clazz == null) {
            m.error("Unable to access io.netty.util.Version");
            return Collections.emptyMap();
        }
        Method method = D.f(clazz, "identify");
        return (Map)method.invoke(null, ObjectShare.EMPTY_OBJ_ARRAY);
    }

    private String g(Object object) {
        String string = j;
        try {
            Field field = D.a(object, "artifactVersion");
            string = (String)field.get(object);
        }
        catch (Exception exception) {
            m.error("Problem parsing artifact version", exception);
        }
        return string;
    }
}

