/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.sql.a;

import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.u;
import com.contrastsecurity.agent.g;
import com.contrastsecurity.agent.plugins.architecture.controller.DbHelper;
import com.contrastsecurity.agent.plugins.architecture.controller.DbInfoBlock;
import com.contrastsecurity.agent.plugins.architecture.controller.a;
import com.contrastsecurity.agent.plugins.architecture.model.ArchitectureComponent;
import com.contrastsecurity.agent.plugins.architecture.util.ArchitectureScope;
import com.contrastsecurity.agent.plugins.frameworks.sql.a.b;
import com.contrastsecurity.agent.plugins.frameworks.sql.h;
import com.contrastsecurity.agent.plugins.frameworks.sql.i;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.util.Map;

final class c<T>
implements Runnable {
    private final i a;
    private final h b;
    private final Application c;
    private final a d;
    private final Map<T, b> e;
    private final T f;
    private static final Logger g = LoggerFactory.getLogger(c.class);

    @Override
    public void run() {
        ArchitectureScope.getTrackerScope().enterScope();
        Connection connection = null;
        try {
            connection = this.a.a();
            if (connection == null) {
                g.debug("Could not profile the database because no connection available");
                return;
            }
            ArchitectureComponent architectureComponent = com.contrastsecurity.agent.plugins.frameworks.sql.a.c.a(connection);
            this.e.put(this.f, com.contrastsecurity.agent.plugins.frameworks.sql.a.b.a(architectureComponent));
            this.d.a(this.c, architectureComponent);
        }
        catch (SQLException sQLException) {
            g.debug("Could not profile the database because of a SQL error while retrieving metadata", sQLException);
            if (sQLException instanceof SQLNonTransientException) {
                return;
            }
            g.debug("Database profiling will be retried the next time the application attempts to connect");
            this.e.remove(this.f);
        }
        catch (Throwable throwable) {
            u.a(throwable);
            g.debug("Could not profile the database because of an error while retrieving connection meta data", throwable);
        }
        finally {
            com.contrastsecurity.agent.plugins.frameworks.sql.a.c.a(this.b, connection);
            ArchitectureScope.getTrackerScope().leaveScope();
        }
    }

    c(i i2, h h2, Application application, a a2, Map<T, b> map, T t2) {
        this.a = i2;
        this.b = h2;
        this.c = application;
        this.d = a2;
        this.e = map;
        this.f = t2;
    }

    private static ArchitectureComponent a(Connection connection) throws SQLException {
        String string = connection.getMetaData().getURL();
        DbInfoBlock dbInfoBlock = DbHelper.parseDbUrl(string);
        if (dbInfoBlock == null) {
            throw new g("Cannot profile the database because the URL could not be parsed: " + string);
        }
        String string2 = dbInfoBlock.host;
        String string3 = dbInfoBlock.port == -1 ? "(unknown)" : String.valueOf(dbInfoBlock.port);
        String string4 = connection.getCatalog();
        return string4 != null ? ArchitectureComponent.databaseFrom(string, string2, string3, string4) : ArchitectureComponent.databaseFrom(string, string2, string3);
    }

    private static void a(h h2, Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            h2.a(connection);
        }
        catch (Exception exception) {
            g.debug("Could not close connection using closer", exception);
            try {
                if (!connection.isClosed()) {
                    connection.close();
                    g.debug("Connection closed directly");
                }
            }
            catch (SQLException sQLException) {
                g.debug("SQL error when trying to close connection directly", exception);
            }
        }
    }
}

