/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.exclusions.f;
import com.contrastsecurity.agent.apps.exclusions.h;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.plugins.security.controller.n;
import com.contrastsecurity.agent.plugins.security.controller.trigger.l;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.u;
import com.contrastsecurity.agent.plugins.security.policy.w;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;

@DontObfuscate
public class AssessSourceExclusionHandler
implements l {
    private final HttpManager httpManager;
    private static final Logger logger = LoggerFactory.getLogger(AssessSourceExclusionHandler.class);

    public AssessSourceExclusionHandler(HttpManager httpManager) {
        this.httpManager = httpManager;
    }

    @Override
    public boolean onTraceTriggered(Application application, Rule rule, Event event, Trace trace, Object object, Object[] objectArray, Object object2, n n2) {
        List<CodeEvent> list = trace.getEvents();
        boolean bl = true;
        HttpRequest httpRequest = this.httpManager.getCurrentRequest();
        h h2 = application.getExclusionProcessor();
        for (int i2 = 0; i2 < list.size() && bl; ++i2) {
            CodeEvent codeEvent = list.get(i2);
            if (!(codeEvent instanceof SourceEvent)) continue;
            bl = !this.isSourceExclusion(application, trace, rule, (SourceEvent)codeEvent, i2, httpRequest, h2);
        }
        return bl;
    }

    public boolean isSourceExclusion(Application application, Trace trace, Rule rule, SourceEvent sourceEvent, int n2, HttpRequest httpRequest, h h2) {
        if (h2 == null) {
            logger.debug("Skipping exclusion processing: exclusion processor is null");
            return false;
        }
        if (httpRequest == null) {
            logger.debug("Skipping exclusion processing: request model is null");
            return false;
        }
        u u2 = sourceEvent.getSource();
        if (!u2.hasSourceTypes()) {
            logger.debug("Skipping exclusion processing: untrusted data source [{}] does not have a processable type", (Object)u2.getId());
            return false;
        }
        String string = rule.getId();
        if (u2.isSourceType(w.f)) {
            String string2 = this.extractInputName(trace, sourceEvent, u2);
            if (h2.isInputExclusion(f.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.PARAMETER, string2)) {
                return true;
            }
        } else if (u2.isSourceType(w.d)) {
            String string3 = this.extractInputName(trace, sourceEvent, u2);
            if (h2.isInputExclusion(f.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.HEADER, string3)) {
                return true;
            }
        } else if (u2.isSourceType(w.g)) {
            if (h2.isInputExclusion(f.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.QUERYSTRING)) {
                return true;
            }
        } else if (u2.isSourceType(w.c)) {
            String string4 = sourceEvent.getFieldName();
            if (h2.isInputExclusion(f.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.COOKIE, string4)) {
                return true;
            }
        } else if (u2.isSourceType(w.a) || u2.isSourceType(w.e) ? h2.isInputExclusion(f.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.BODY) : u2.isSourceType(w.s) && h2.isInputExclusion(f.a.a, string, httpRequest.getUri(), ExceptionInputTypeDTM.HEADER, "authorization")) {
            return true;
        }
        return false;
    }

    private String extractInputName(Trace trace, SourceEvent sourceEvent, u u2) {
        String string = null;
        if (sourceEvent != null) {
            string = sourceEvent.getFieldName();
        }
        if (sourceEvent != null && string == null) {
            char[] cArray;
            int n2;
            if (u2 != null && u2.isSourceType(w.p)) {
                if (sourceEvent.getParameters() != null && sourceEvent.getParameters().length > 0) {
                    string = new String(sourceEvent.getParameters()[0]);
                }
            } else if (u2 != null && u2.isSourceType(w.o) && trace != null && trace.getEvents() != null && !trace.getEvents().isEmpty() && (n2 = trace.getEvents().indexOf(sourceEvent)) >= 0 && trace.getEvents().size() > n2 && (cArray = trace.getEvents().get(n2 + 1).getRet()) != null && cArray.length > 0) {
                string = new String(cArray);
            }
        }
        return string;
    }
}

