/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.B;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.c;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.plugins.security.ImmutableObjectSnapshotCache;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.k;
import com.contrastsecurity.agent.plugins.security.model.MethodEvent;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.util.K;
import com.contrastsecurity.agent.util.L;
import com.contrastsecurity.agent.util.N;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

@DontObfuscate
public class AssessmentContext {
    private long created;
    private final ImmutableObjectSnapshotCache snapshotCache;
    private final Map<Integer, Integer> lengthMap = new HashMap<Integer, Integer>();
    private final WeakHashMap<Object, Integer> trackedMap = new WeakHashMap();
    private final WeakHashMap<Thread, String> threadDescCache = new WeakHashMap();
    private final Map<Object, Trace> traceMap;
    private final ConcurrentHashMap<Integer, Set<String>> identityTagMap;
    private final ConcurrentHashMap<Integer, List<Trace>> identityTraceMap;
    private final boolean identityTaggingEnabled;
    private MethodEvent lastMethodEvent;
    private boolean canClearOnRequestEnd;
    private final int maxPropagationEvents;
    private final int maxSourceEvents;
    private int sourceEvents;
    private int propagationEvents;
    private static final Logger logger = LoggerFactory.getLogger(AssessmentContext.class);
    private static final Integer TRACKED_MARKER = 1;
    private static final k HASH = new k();

    AssessmentContext(g g2, c c2, int n2) {
        this.created = c2.a();
        this.traceMap = EventContext.buildTraceMap(n2);
        this.identityTagMap = new ConcurrentHashMap(n2 / 4);
        this.identityTraceMap = new ConcurrentHashMap(n2 / 2);
        this.canClearOnRequestEnd = true;
        this.sourceEvents = 0;
        this.propagationEvents = 0;
        this.snapshotCache = new ImmutableObjectSnapshotCache();
        this.maxSourceEvents = g2.c("contrast.assess.context.max.sources");
        this.maxPropagationEvents = g2.c("contrast.assess.context.max.propagations");
        this.identityTaggingEnabled = g2.f("contrast.identitytags");
    }

    long getCreationTime() {
        return this.created;
    }

    public boolean hasAlreadyTracked(Object object) {
        return this.trackedMap.containsKey(object);
    }

    public void markTracked(Object object) {
        this.trackedMap.put(object, TRACKED_MARKER);
    }

    public Set<String> getTags(Integer n2) {
        return this.identityTagMap.get(n2);
    }

    public void addTags(Integer n2, String ... stringArray) {
        Set<String> set = this.identityTagMap.get(n2);
        if (set == null) {
            set = Collections.synchronizedSet(new HashSet());
            this.identityTagMap.put(n2, set);
        }
        for (String string : stringArray) {
            set.add(string);
        }
    }

    public Integer getLength(Object object) {
        Integer n2 = object == null ? Integer.valueOf(0) : this.lengthMap.get(object.hashCode());
        return n2;
    }

    public void saveLength(Object object, Integer n2) {
        if (object != null) {
            this.lengthMap.put(object.hashCode(), n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clear() {
        int n2 = 0;
        ConcurrentHashMap<Integer, Collection<Object>> concurrentHashMap = this.identityTagMap;
        synchronized (concurrentHashMap) {
            n2 += this.identityTagMap.size();
            this.identityTagMap.clear();
        }
        concurrentHashMap = this.identityTraceMap;
        synchronized (concurrentHashMap) {
            n2 += this.identityTraceMap.size();
            this.identityTraceMap.clear();
        }
        n2 += this.trackedMap.size();
        this.trackedMap.clear();
        n2 += this.threadDescCache.size();
        this.threadDescCache.clear();
        if (this.traceMap != null) {
            n2 += this.traceMap.size();
            this.traceMap.clear();
        }
        return n2;
    }

    public void applyTags(int n2, String string, int n3) throws InvalidTagRangeException {
        this.applyTags(n2, L.a(string), n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyTags(int n2, String[] stringArray, int n3) throws InvalidTagRangeException {
        Set<String> set = this.identityTagMap.get(n2);
        if (set == null) {
            set = Collections.synchronizedSet(new HashSet());
            this.identityTagMap.put(n2, set);
        }
        Collection<Object> collection = set;
        synchronized (collection) {
            for (String string : stringArray) {
                set.add(string);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Adding {} to existing map for future use under identity {}, new set is {}", K.a(stringArray), n2, set);
            }
        }
        collection = this.identityTraceMap.get(n2);
        if (collection != null && !collection.isEmpty()) {
            logger.debug("Applying tags to {} traces", (Object)collection.size());
            for (int i2 = 0; i2 < collection.size(); ++i2) {
                Trace trace = (Trace)collection.get(i2);
                CodeEvent codeEvent = trace.getLastEvent();
                if (codeEvent == null) continue;
                codeEvent.addTags(stringArray, n3);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Adding {} to existing identity {} / trace ID {}", K.a(stringArray), n2, trace.getId());
            }
        } else {
            logger.debug("Found no traces under identity {}", (Object)n2);
        }
    }

    @B
    List<Trace> getTraces(Integer n2) {
        return this.identityTraceMap.get(n2);
    }

    public void addTrace(Integer n2, Trace trace) {
        List<Trace> list = this.identityTraceMap.get(n2);
        if (list == null) {
            list = Collections.synchronizedList(new ArrayList());
            this.identityTraceMap.put(n2, list);
        }
        list.add(trace);
    }

    public int getIdentity(int n2, int n3) {
        return HASH.a(n2, n3);
    }

    public String getThreadDescription(Thread thread) {
        String string = this.threadDescCache.get(thread);
        if (string == null) {
            string = N.a(thread);
            this.threadDescCache.put(thread, string);
        }
        return string;
    }

    public void clearLastMethodEvent() {
        this.lastMethodEvent = null;
    }

    public void setLastMethodEvent(MethodEvent methodEvent) {
        this.lastMethodEvent = methodEvent;
    }

    public MethodEvent getLastMethodEvent() {
        return this.lastMethodEvent;
    }

    public Map<Object, Trace> getTraceMap() {
        return this.traceMap;
    }

    public void refreshed() {
        this.created = System.currentTimeMillis();
    }

    public boolean isCanClearOnRequestEnd() {
        return this.canClearOnRequestEnd;
    }

    public void jumpedContexts() {
        this.canClearOnRequestEnd = false;
    }

    public void onSourceRecorded() {
        ++this.sourceEvents;
    }

    public boolean hasReachedMaximumSourceEvents() {
        return this.sourceEvents >= this.maxSourceEvents;
    }

    public void onPropagationRecorded() {
        ++this.propagationEvents;
    }

    public int getSourceEvents() {
        return this.sourceEvents;
    }

    public boolean hasReachedMaximumPropagationEvents() {
        return this.propagationEvents >= this.maxPropagationEvents;
    }

    public boolean isIdentityTaggingEnabled() {
        return this.identityTaggingEnabled;
    }

    public ImmutableObjectSnapshotCache getSnapshotCache() {
        return this.snapshotCache;
    }
}

