/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.trace.snapshot.DataSnapshot;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

@DontObfuscate
public final class ImmutableObjectSnapshotCache {
    private final Map<Object, char[]> snapshotMap = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Object, char[]> truncatedSnapshotMap = Collections.synchronizedMap(new WeakHashMap());
    private final Map<Object, DataSnapshot> truncatedTagRangeSnapshotMap = Collections.synchronizedMap(new WeakHashMap());

    public char[] getSnapshot(Object object) {
        return this.snapshotMap.get(object);
    }

    public char[] getTruncatedSnapshot(Object object) {
        return this.truncatedSnapshotMap.get(object);
    }

    public DataSnapshot getTruncatedTagRangedSnapshot(Object object) {
        return this.truncatedTagRangeSnapshotMap.get(object);
    }

    public void cacheSnapshot(Object object, char[] cArray) {
        this.snapshotMap.put(object, cArray);
    }

    public void cacheTruncatedSnapshot(Object object, char[] cArray) {
        this.truncatedSnapshotMap.put(object, cArray);
    }

    public void cacheTruncatedTagRangedSnapshot(Object object, DataSnapshot dataSnapshot) {
        this.truncatedTagRangeSnapshotMap.put(object, dataSnapshot);
    }

    public int snapshotSize() {
        return this.snapshotMap.size();
    }

    public int truncatedSnapshotSize() {
        return this.truncatedSnapshotMap.size();
    }

    public int truncatedTagRangeSnapshotSize() {
        return this.truncatedTagRangeSnapshotMap.size();
    }
}

