/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.c;
import com.contrastsecurity.agent.commons.l;
import com.contrastsecurity.agent.config.enums.TraceMapStrategy;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.config.i;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.reloadable.ChannelSubscriber;
import com.contrastsecurity.agent.services.Purgeable;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.weakmap.ConcurrentReferenceHashMap;
import com.contrastsecurity.thirdparty.javax.inject.Inject;
import com.contrastsecurity.thirdparty.javax.inject.Singleton;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;

@Singleton
@DontObfuscate
public class EventContext
implements ChannelSubscriber,
Purgeable {
    private static EventContext instance;
    private final AssessmentManager assessmentManager;
    private boolean enabled;
    private TraceMapStrategy traceMapStrategy;
    private final c clock;
    private final Map<Object, Trace> globalTraceMap;
    private final long maxStronglyReachableTraceTtl;
    private static final Logger logger;

    @Deprecated
    public static EventContext get() {
        if (instance == null) {
            throw new IllegalStateException("EventContext global has not yet been initialized");
        }
        return instance;
    }

    public static void initialize(EventContext eventContext) {
        l.a(eventContext);
        if (instance != null) {
            throw new IllegalStateException("Already initialized");
        }
        instance = eventContext;
    }

    @Inject
    public EventContext(g g2, c c2, AssessmentManager assessmentManager) {
        l.a(g2);
        l.a(c2);
        l.a(assessmentManager);
        this.clock = c2;
        this.assessmentManager = assessmentManager;
        this.enabled = false;
        this.maxStronglyReachableTraceTtl = g2.e("contrast.trace.ttl.max");
        this.traceMapStrategy = EventContext.traceMapStrategyFromConfig(g2);
        this.globalTraceMap = EventContext.buildTraceMap(10000);
    }

    static TraceMapStrategy traceMapStrategyFromConfig(g g2) {
        String string = g2.a("contrast.trace.map");
        TraceMapStrategy traceMapStrategy = TraceMapStrategy.valueOfIgnoreCase(string);
        if (traceMapStrategy == null) {
            throw new i("Invalid value [" + string + "] set for " + "contrast.trace.map" + ". Valid values are GLOBAL, CONTEXT, BOTH.");
        }
        return traceMapStrategy;
    }

    public static Map<Object, Trace> buildTraceMap(int n2) {
        return new ConcurrentReferenceHashMap<Object, Trace>(n2, 0.75f, 32, ConcurrentReferenceHashMap.c.b, ConcurrentReferenceHashMap.c.a, EnumSet.range(ConcurrentReferenceHashMap.b.a, ConcurrentReferenceHashMap.b.a));
    }

    @Override
    public void onMessageReceived(Map<String, Object> map) {
        this.globalTraceMap.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public Map<Object, Trace> getTraceMap() {
        Map<Object, Trace> map = null;
        if (TraceMapStrategy.GLOBAL == this.traceMapStrategy) {
            map = this.globalTraceMap;
        } else if (TraceMapStrategy.CONTEXT == this.traceMapStrategy) {
            AssessmentContext assessmentContext = this.assessmentManager.currentContext();
            if (assessmentContext != null) {
                map = assessmentContext.getTraceMap();
            }
        } else {
            AssessmentContext assessmentContext = this.assessmentManager.currentContext();
            if (assessmentContext != null) {
                map = assessmentContext.getTraceMap();
            }
            if (map == null) {
                map = this.globalTraceMap;
            }
        }
        return map;
    }

    public ContrastPolicy getPolicy() {
        return this.assessmentManager.currentPolicy();
    }

    public void changeStrategy(TraceMapStrategy traceMapStrategy) {
        logger.debug("Changed trace map strategy to {}", (Object)traceMapStrategy);
        this.traceMapStrategy = traceMapStrategy;
    }

    @Override
    public void purgeStale() {
        AssessmentContext assessmentContext;
        Map<Object, Trace> map = this.getTraceMap();
        if (map != null) {
            this.removeDeadTraces(map);
            this.removeExpiredTraces(map);
        }
        if ((assessmentContext = this.assessmentManager.currentContext()) != null) {
            assessmentContext.clearLastMethodEvent();
        }
    }

    private void removeDeadTraces(Map<Object, Trace> map) {
        ConcurrentReferenceHashMap concurrentReferenceHashMap = (ConcurrentReferenceHashMap)map;
        concurrentReferenceHashMap.dumpStats();
        concurrentReferenceHashMap.purgeStaleEntries();
    }

    private void removeExpiredTraces(Map<Object, Trace> map) {
        Collection<Trace> collection = map.values();
        Iterator<Trace> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Trace trace = iterator.next();
            try {
                CodeEvent codeEvent = trace.getEvents().get(0);
                long l2 = codeEvent.getTimestamp();
                long l3 = this.clock.a() - l2;
                if (l3 <= this.maxStronglyReachableTraceTtl) continue;
                iterator.remove();
            }
            catch (Throwable throwable) {
                logger.error("Problem pruning old trace {}", (Object)trace.getId(), (Object)throwable);
            }
        }
    }

    @Override
    public int purgeableCount() {
        Map<Object, Trace> map = this.getTraceMap();
        return map != null ? map.size() : 0;
    }

    public Integer getTrackedItemHash(Object[] objectArray) {
        Map<Object, Trace> map = this.getTraceMap();
        if (map == null) {
            return null;
        }
        Trace trace = map.get(objectArray);
        if (trace != null) {
            return Arrays.hashCode(objectArray);
        }
        for (Object object : objectArray) {
            Integer n2;
            if (object != null && object.getClass().isArray() && (n2 = this.getTrackedItemHash((Object[])object)) != null) {
                return n2;
            }
            trace = map.get(object);
            if (trace == null || object == null) continue;
            return object.hashCode();
        }
        return null;
    }

    static {
        logger = LoggerFactory.getLogger(EventContext.class);
    }
}

