/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller.track;

import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.l;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.i.c;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.controller.ScopeTracker;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.controller.j;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.InheritancePreference;
import com.contrastsecurity.agent.plugins.security.policy.r;
import com.contrastsecurity.agent.plugins.security.policy.s;
import com.contrastsecurity.agent.plugins.security.policy.w;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.u;
import com.contrastsecurity.agent.util.D;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Sensor
public final class ContrastDynamicSourceDispatcherImpl
implements ContrastDynamicSourceDispatcher {
    private Map<String, Integer> a;
    private final TraceController b;
    private static int c = 1;
    private final AssessmentManager d;
    private final ContrastEngine e;
    private final ScopeTracker f;
    private final ApplicationManager g;
    private static final String h = "problemInspectingDynamicSourceType";
    private static final Logger i = LoggerFactory.getLogger(ContrastDynamicSourceDispatcherImpl.class);

    public ContrastDynamicSourceDispatcherImpl(AssessmentManager assessmentManager, TraceController traceController, ContrastEngine contrastEngine, ScopeTracker scopeTracker, ApplicationManager applicationManager) {
        l.a(assessmentManager, "assessmentManager");
        l.a(traceController, "traceController");
        l.a(contrastEngine, "contrastEngine");
        l.a(scopeTracker, "scopeTracker");
        l.a(applicationManager, "applicationManager");
        this.a = new ConcurrentHashMap<String, Integer>();
        this.b = traceController;
        this.d = assessmentManager;
        this.e = contrastEngine;
        this.f = scopeTracker;
        this.g = applicationManager;
    }

    @Sensor
    private void onDynamicSourceHit(String string, Class<?> clazz, String string2, Set<String> set) {
        boolean bl;
        if (clazz == null) {
            i.debug("Attempted to apply a dynamic source to a null class");
            return;
        }
        if (clazz.isInterface()) {
            i.debug("The class {} is not appropraite for retransformation - it's an interface", (Object)clazz.getName());
            return;
        }
        if (!this.e.getInstrumentation().isModifiableClass(clazz)) {
            i.debug("The class {} is not modifiable", (Object)clazz.getName());
            return;
        }
        ContrastPolicy contrastPolicy = this.d.currentPolicy();
        if (contrastPolicy.getDynamicSource(string) == null) {
            i.debug("Couldn't find dynamic source for policy: {}", (Object)string);
            return;
        }
        Application application = this.g.current();
        if (application == null) {
            return;
        }
        String string3 = ContrastDynamicSourceDispatcherImpl.a(application, clazz, string2);
        if (string2.startsWith("set") && string2.length() > 3) {
            string2 = "get" + string2.substring(3);
        }
        if (!(bl = this.a.containsKey(string3))) {
            this.a.put(string3, 1);
            Class<?> clazz2 = this.a(clazz, string2);
            if (!this.a(clazz2)) {
                return;
            }
            i.debug("First time seeing new dynamic source for method {}. Adding to policy.", (Object)string3);
            String string4 = string + c++;
            r r2 = new r(clazz.getName(), string2, ObjectShare.EMPTY_STRING_ARRAY);
            String[] stringArray = set != null ? set.toArray(ObjectShare.EMPTY_STRING_ARRAY) : ObjectShare.EMPTY_STRING_ARRAY;
            com.contrastsecurity.agent.plugins.security.policy.u u2 = new com.contrastsecurity.agent.plugins.security.policy.u(contrastPolicy.getId(), contrastPolicy.getLocation(), string4, com.contrastsecurity.agent.plugins.security.policy.l.n, new s(r2), stringArray);
            u2.setInheritancePreference(InheritancePreference.NONE);
            u2.setScoped(true);
            u2.addSourceType(w.h);
            u2.setDeep(false);
            this.d.addDynamicSource(u2);
            try {
                if (i.isDebugEnabled()) {
                    i.debug("Attempting to retransform the method {} in {}", (Object)r2, (Object)clazz.getName());
                }
                this.e.getInstrumentation().retransformClasses(clazz);
            }
            catch (Throwable throwable) {
                i.error("Problem retransforming dynamic source from {} into bean", (Object)clazz.getName());
                if (i.isDebugEnabled()) {
                    i.debug("StackTrace for dynamic source retransforming exception", throwable);
                }
            }
        } else {
            i.trace("Already seen the dynamic source {}. Ignoring.", (Object)string3);
        }
    }

    private boolean a(Class<?> clazz) {
        return String.class.equals(clazz) || ObjectShare.EMPTY_STRING_ARRAY.getClass().equals(clazz);
    }

    private Class<?> a(Class<?> clazz, String string) {
        Class<?> clazz2 = null;
        try {
            Method method = D.a(clazz, string, ObjectShare.EMPTY_CLASS_ARRAY);
            clazz2 = method != null ? method.getReturnType() : null;
        }
        catch (Throwable throwable) {
            com.contrastsecurity.agent.i.c.b(h, i, "Problem inspecting class for dynamic source", throwable);
        }
        return clazz2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Sensor
    public void onDynamicSourceMethodCall(String string, Object object, Class<?> clazz, Object[] objectArray, Class<?>[] classArray, Class<?> clazz2, String string2) {
        j j2 = (j)this.f.get();
        j2.a();
        try {
            if (objectArray.length == 1 && this.b.isTracked(objectArray[0])) {
                Trace trace;
                if (i.isDebugEnabled()) {
                    i.debug("DETECTED and EXECUTING dynamic source call from {}.{}()", (Object)clazz.getName(), (Object)string);
                }
                Set<String> set = (trace = this.b.getTrace(objectArray[0])) != null ? trace.getTags() : null;
                this.onDynamicSourceHit(string2, clazz, string, set);
            } else if (i.isTraceEnabled()) {
                i.trace("DETECTED and IGNORING dynamic source call from {}.{}()", (Object)clazz.getName(), (Object)string);
            }
        }
        catch (Throwable throwable) {
            i.error("Unexpected exception:", throwable);
        }
        finally {
            j2.b();
        }
    }

    private static String a(Application application, Class<?> clazz, String string) {
        return application.getPath() + ':' + clazz.getName() + ':' + u.b(clazz) + ':' + string;
    }
}

