/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.controller.trigger;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.e.c;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.controller.n;
import com.contrastsecurity.agent.plugins.security.controller.trigger.l;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.rules.d;
import com.contrastsecurity.agent.plugins.security.policy.u;
import com.contrastsecurity.agent.plugins.security.policy.w;
import com.contrastsecurity.agent.plugins.security.s;
import com.contrastsecurity.agent.reloadable.AgentChannelHub;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.util.K;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;
import java.util.Set;

@DontObfuscate
public final class QueueFindingListener
implements l {
    private final ContrastEngine engine;
    private final HttpManager httpManager;
    private final Finding.d findingFactory;
    private final g config;
    private final d findingTelemetryCache;
    private static final String INVALID_DATA_FLOW_ERROR = "dataflow.invalid.notenough";
    private static final String RULE_HASH_CHANNEL = "assess.rule-and-hash";
    private static final Logger logger = LoggerFactory.getLogger(QueueFindingListener.class);

    public QueueFindingListener(ContrastEngine contrastEngine, HttpManager httpManager, g g2, Finding.d d2, d d3) {
        this.engine = contrastEngine;
        this.httpManager = httpManager;
        this.findingFactory = d2;
        this.config = g2;
        this.findingTelemetryCache = d3;
    }

    @Override
    public boolean onTraceTriggered(Application application, Rule rule, Event event, Trace trace, Object object, Object[] objectArray, Object object2, n n2) {
        Set<String> set;
        String string;
        String string2 = rule.getId();
        if (this.shouldUpdateIdToStoredXSS(string2, trace)) {
            string2 = "stored-xss";
        }
        if (StringUtils.isNotEmpty(string = this.config.a("contrast.disabledrules")) && (set = K.d(string, ",")).contains(string2)) {
            logger.debug("Suppressed trace {} in {} for the disabled rule {}", trace.getId(), application.getDisplayName(), string2);
            return false;
        }
        if (this.isInvalidDataFlow(rule, trace)) {
            com.contrastsecurity.agent.i.c.a(INVALID_DATA_FLOW_ERROR, logger, "Not enough data flow events for trace {}", null, new Object[]{c.a(logger, String.valueOf(trace))});
            logger.debug("Suppressed trace {} w/o enough events {}", (Object)trace.getId(), (Object)trace);
            return false;
        }
        long l2 = "crypto-bad-ciphers".equals(string2) || "crypto-bad-mac".equals(string2) ? s.c.a(rule.getId(), this.httpManager.getCurrentRequest(), (String)objectArray[0]) : s.d.a(rule.getId(), this.httpManager.getCurrentRequest(), trace);
        Finding finding = this.findingFactory.a(application, string2, trace, l2);
        HttpRequest httpRequest = this.httpManager.cloneCurrentRequest();
        if (httpRequest != null) {
            httpRequest.cacheBody();
        }
        finding.setRequest(httpRequest);
        logger.info("Added finding for rule ID: {} (hash={})", (Object)string2, (Object)finding.getHash());
        AgentChannelHub agentChannelHub = AgentChannelHub.get();
        if (agentChannelHub.hasSubscribers(RULE_HASH_CHANNEL)) {
            agentChannelHub.broadcast(RULE_HASH_CHANNEL, com.contrastsecurity.agent.commons.g.a().a(string2, finding.getHash()).a());
        }
        this.engine.queueReport(finding);
        if (this.findingTelemetryCache.e()) {
            try {
                if (finding.hasEvents()) {
                    this.findingTelemetryCache.a(string2, finding.getHash());
                }
            }
            catch (Exception exception) {
                logger.debug("Error encountered handling finding", exception);
            }
        }
        return true;
    }

    private boolean isInvalidDataFlow(Rule rule, Trace trace) {
        if (rule.requiresDataFlow() && trace != null) {
            List<CodeEvent> list = trace.getEvents();
            return list != null && list.size() <= 1;
        }
        return false;
    }

    private boolean shouldUpdateIdToStoredXSS(String string, Trace trace) {
        List<CodeEvent> list;
        if ("reflected-xss".equals(string) && trace != null && (list = trace.getEvents()) != null && !list.isEmpty()) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                u u2;
                CodeEvent codeEvent = list.get(i2);
                if (!(codeEvent instanceof SourceEvent) || (u2 = ((SourceEvent)codeEvent).getSource()) == null || !u2.hasSourceTypes() || !u2.isSourceType(w.h) && !u2.isSourceType(w.b)) continue;
                return true;
            }
        }
        return false;
    }
}

