/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy;

import com.contrastsecurity.agent.B;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.f;
import com.contrastsecurity.agent.commons.o;
import com.contrastsecurity.agent.instr.InstrumentationContext;
import com.contrastsecurity.agent.messages.server.features.AssessmentFeatures;
import com.contrastsecurity.agent.messages.server.features.assessment.CustomRuleAPI;
import com.contrastsecurity.agent.messages.server.features.assessment.InputValidatorDTM;
import com.contrastsecurity.agent.messages.server.features.assessment.SanitizerDTM;
import com.contrastsecurity.agent.plugins.security.policy.PolicyNode;
import com.contrastsecurity.agent.plugins.security.policy.TagList;
import com.contrastsecurity.agent.plugins.security.policy.Tagger;
import com.contrastsecurity.agent.plugins.security.policy.ValidatorScope;
import com.contrastsecurity.agent.plugins.security.policy.e;
import com.contrastsecurity.agent.plugins.security.policy.g;
import com.contrastsecurity.agent.plugins.security.policy.j;
import com.contrastsecurity.agent.plugins.security.policy.l;
import com.contrastsecurity.agent.plugins.security.policy.m;
import com.contrastsecurity.agent.plugins.security.policy.propagators.Propagator;
import com.contrastsecurity.agent.plugins.security.policy.r;
import com.contrastsecurity.agent.plugins.security.policy.rules.Event;
import com.contrastsecurity.agent.plugins.security.policy.rules.EventPattern;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.rules.a.c;
import com.contrastsecurity.agent.plugins.security.policy.rules.a.h;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.RuleProvider;
import com.contrastsecurity.agent.plugins.security.policy.s;
import com.contrastsecurity.agent.plugins.security.policy.sources.AbstractClassMatcher;
import com.contrastsecurity.agent.plugins.security.policy.sources.DynamicSource;
import com.contrastsecurity.agent.plugins.security.policy.u;
import com.contrastsecurity.agent.plugins.security.policy.x;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;

@DontObfuscate
public final class ContrastPolicy {
    private final String location;
    private final Map<String, u> sources;
    private final Map<String, List<u>> sourceClassAnnotationMap;
    private final Map<String, List<u>> sourceClassNameMap;
    private final Map<String, List<u>> parameterAnnotationSources;
    private final List<u> cachedSources;
    private final List<com.contrastsecurity.agent.plugins.security.pattern.a.a> patternAnalyzers;
    private final Set<j> internPreventionScopes;
    private final List<ValidatorScope> validatorScopes;
    private final Set<ValidatorScope> wildcardValidatorScopes;
    private final Map<String, TagList> customRulesTagLists;
    private final List<Tagger> allCustomSanitizers;
    private final List<Tagger> allCustomValidators;
    private final Map<Integer, Propagator> indexedSanitizersMap;
    private final Map<String, Propagator> customSanitizers;
    private final Map<String, Propagator> propagators;
    private final Map<String, List<Propagator>> propagatorClassAnnotationMap;
    private final Map<String, List<Propagator>> propagatorClassNameMap;
    private final c fastPropagatorLookup;
    private final Map<String, List<com.contrastsecurity.agent.plugins.security.policy.b.a>> frameworkAnnotations;
    private final Map<String, List<String>> parameterAnnotations;
    private final Map<String, TagList> tagLists;
    private final Map<String, Set<PolicyNode>> globalChanges;
    private final Set<String> globalClasses;
    private final Map<String, Rule> rules;
    private final Set<g> deadzones;
    private final Collection<Class<? extends RuleProvider>> ruleProviders;
    private final x tagListIndices;
    private final Map<String, String> properties;
    private final Map<String, DynamicSource> dynamicSources;
    private final Map<String, Set<String>> acceptedRegex;
    private final Map<String, Set<String>> rejectedRegex;
    private final int id;
    public static final String HC_OBJECT = "O";
    public static final String HC_RETURN = "R";
    public static final String HC_STACK = "STACK";
    public static final String HC_URL = "URL";
    public static final String HC_PARAM_PREFIX = "P";
    public static final String CUSTOM_SANITIZERS_ID = "custom-encoders-";
    static final String CUSTOM_SANITIZERS_TAG_HEADER = "custom-encoder-";
    static final String CUSTOM_VALIDATORS_ID = "custom-validators-";
    static final String CUSTOM_VALIDATORS_TAG_HEADER = "custom-validator-";
    public static final String LEVEL1_VALIDATOR_NAME_PREFIX = "custom-validator-";
    public static final String LEVEL1_SANITIZER_NAME_PREFIX = "custom-sanitizer-";
    private static final String CUSTOM_VALIDATORS_TAG = "custom-validated";
    private static final String NO_CLASS_ANNOTATION = "noClassAnnotation";

    private ContrastPolicy(Builder builder) {
        this.id = builder.id;
        this.location = builder.location;
        b b2 = b.a("untrusted source", builder.sources);
        this.sources = b2.a;
        this.sourceClassAnnotationMap = b2.b;
        this.sourceClassNameMap = b2.c;
        this.parameterAnnotationSources = com.contrastsecurity.agent.commons.g.d(builder.parameterAnnotationSources);
        this.cachedSources = f.a(builder.sources);
        this.patternAnalyzers = f.a(builder.patternAnalyzers);
        this.internPreventionScopes = o.a(builder.internPreventionScopes);
        this.validatorScopes = new ArrayList<ValidatorScope>(builder.validatorScopes);
        this.wildcardValidatorScopes = o.a(builder.wildcardValidatorScopes);
        this.customRulesTagLists = com.contrastsecurity.agent.commons.g.a(builder.customRulesCollectionBuilder.i);
        this.allCustomSanitizers = f.a(builder.customRulesCollectionBuilder.d);
        this.allCustomValidators = f.a(builder.customRulesCollectionBuilder.e);
        this.indexedSanitizersMap = com.contrastsecurity.agent.commons.g.a(builder.customRulesCollectionBuilder.g);
        this.customSanitizers = com.contrastsecurity.agent.commons.g.a(builder.customRulesCollectionBuilder.c);
        LinkedList<TagList> linkedList = new LinkedList<TagList>(builder.tagLists.values());
        linkedList.addAll(builder.customRulesCollectionBuilder.i.values());
        this.tagListIndices = x.a(linkedList);
        b b3 = b.a("propagator", builder.propagators);
        this.propagators = b3.a;
        this.propagatorClassAnnotationMap = b3.b;
        this.propagatorClassNameMap = b3.c;
        this.fastPropagatorLookup = c.a(builder.propagators);
        this.frameworkAnnotations = com.contrastsecurity.agent.commons.g.d(builder.frameworkAnnotations);
        this.parameterAnnotations = com.contrastsecurity.agent.commons.g.d(builder.parameterAnnotations);
        this.tagLists = com.contrastsecurity.agent.commons.g.b(builder.tagLists);
        this.globalChanges = com.contrastsecurity.agent.commons.g.f(builder.globalChanges);
        this.rules = com.contrastsecurity.agent.commons.g.a(builder.rules);
        this.deadzones = o.a(builder.deadzones);
        this.ruleProviders = f.a(builder.ruleProviders);
        HashSet<String> hashSet = new HashSet<String>(builder.globalClasses);
        hashSet.addAll(b2.d);
        hashSet.addAll(b3.d);
        this.globalClasses = Collections.unmodifiableSet(hashSet);
        this.properties = com.contrastsecurity.agent.commons.g.a(builder.properties);
        this.dynamicSources = com.contrastsecurity.agent.commons.g.a(builder.dynamicSources);
        this.acceptedRegex = com.contrastsecurity.agent.commons.g.f(builder.acceptedRegex);
        this.rejectedRegex = com.contrastsecurity.agent.commons.g.f(builder.rejectedRegex);
    }

    public ContrastPolicy(ContrastPolicy contrastPolicy, u u2) {
        com.contrastsecurity.agent.commons.l.a(u2.isSignatureBased(), "Only accepts signature based sources - this should never happen");
        LinkedList<u> linkedList = new LinkedList<u>(contrastPolicy.sources.values());
        linkedList.add(u2);
        b<u> b2 = b.a("source", linkedList);
        HashSet<String> hashSet = new HashSet<String>(contrastPolicy.globalClasses);
        if (u2.isSignatureBased()) {
            hashSet.add(ContrastPolicy.getGlobalNameFromSignature(u2));
        }
        this.globalClasses = Collections.unmodifiableSet(hashSet);
        this.globalChanges = ContrastPolicy.newGlobalChangesWithNode(contrastPolicy.globalChanges, u2);
        this.sources = b2.a;
        this.sourceClassAnnotationMap = b2.b;
        this.sourceClassNameMap = b2.c;
        this.cachedSources = linkedList;
        this.id = contrastPolicy.id;
        this.location = contrastPolicy.location;
        this.parameterAnnotationSources = contrastPolicy.parameterAnnotationSources;
        this.patternAnalyzers = contrastPolicy.patternAnalyzers;
        this.internPreventionScopes = contrastPolicy.internPreventionScopes;
        this.validatorScopes = contrastPolicy.validatorScopes;
        this.wildcardValidatorScopes = contrastPolicy.wildcardValidatorScopes;
        this.customRulesTagLists = contrastPolicy.customRulesTagLists;
        this.allCustomSanitizers = contrastPolicy.allCustomSanitizers;
        this.allCustomValidators = contrastPolicy.allCustomValidators;
        this.indexedSanitizersMap = contrastPolicy.indexedSanitizersMap;
        this.customSanitizers = contrastPolicy.customSanitizers;
        this.propagators = contrastPolicy.propagators;
        this.fastPropagatorLookup = contrastPolicy.fastPropagatorLookup;
        this.propagatorClassAnnotationMap = contrastPolicy.propagatorClassAnnotationMap;
        this.propagatorClassNameMap = contrastPolicy.propagatorClassNameMap;
        this.frameworkAnnotations = contrastPolicy.frameworkAnnotations;
        this.parameterAnnotations = contrastPolicy.parameterAnnotations;
        this.tagLists = contrastPolicy.tagLists;
        this.rules = contrastPolicy.rules;
        this.deadzones = contrastPolicy.deadzones;
        this.ruleProviders = contrastPolicy.ruleProviders;
        this.tagListIndices = contrastPolicy.tagListIndices;
        this.properties = contrastPolicy.properties;
        this.dynamicSources = contrastPolicy.dynamicSources;
        this.acceptedRegex = contrastPolicy.acceptedRegex;
        this.rejectedRegex = contrastPolicy.rejectedRegex;
    }

    public ContrastPolicy(ContrastPolicy contrastPolicy, a a2) {
        this.customRulesTagLists = a2.i;
        this.customSanitizers = a2.c;
        this.allCustomSanitizers = a2.d;
        this.allCustomValidators = a2.e;
        this.indexedSanitizersMap = a2.g;
        ArrayList<TagList> arrayList = new ArrayList<TagList>(contrastPolicy.getTagLists().values());
        arrayList.addAll(a2.i.values());
        this.tagListIndices = x.a(arrayList);
        HashSet<String> hashSet = new HashSet<String>(contrastPolicy.globalClasses);
        hashSet.addAll(this.getGlobalClassFromTaggers(a2.i));
        this.globalClasses = hashSet;
        LinkedList<Tagger> linkedList = new LinkedList<Tagger>();
        for (TagList tagList : a2.i.values()) {
            linkedList.addAll(tagList.getTaggers());
        }
        this.globalChanges = ContrastPolicy.newGlobalChangesWithNodes(contrastPolicy.globalChanges, linkedList);
        this.id = contrastPolicy.id;
        this.location = contrastPolicy.location;
        this.parameterAnnotationSources = contrastPolicy.parameterAnnotationSources;
        this.patternAnalyzers = contrastPolicy.patternAnalyzers;
        this.internPreventionScopes = contrastPolicy.internPreventionScopes;
        this.validatorScopes = contrastPolicy.validatorScopes;
        this.wildcardValidatorScopes = contrastPolicy.wildcardValidatorScopes;
        this.propagators = contrastPolicy.propagators;
        this.fastPropagatorLookup = contrastPolicy.fastPropagatorLookup;
        this.propagatorClassAnnotationMap = contrastPolicy.propagatorClassAnnotationMap;
        this.propagatorClassNameMap = contrastPolicy.propagatorClassNameMap;
        this.frameworkAnnotations = contrastPolicy.frameworkAnnotations;
        this.parameterAnnotations = contrastPolicy.parameterAnnotations;
        this.tagLists = contrastPolicy.tagLists;
        this.rules = contrastPolicy.rules;
        this.deadzones = contrastPolicy.deadzones;
        this.ruleProviders = contrastPolicy.ruleProviders;
        this.properties = contrastPolicy.properties;
        this.dynamicSources = contrastPolicy.dynamicSources;
        this.acceptedRegex = contrastPolicy.acceptedRegex;
        this.rejectedRegex = contrastPolicy.rejectedRegex;
        this.sources = contrastPolicy.sources;
        this.cachedSources = contrastPolicy.cachedSources;
        this.sourceClassAnnotationMap = contrastPolicy.sourceClassAnnotationMap;
        this.sourceClassNameMap = contrastPolicy.sourceClassNameMap;
    }

    private ContrastPolicy(ContrastPolicy contrastPolicy, Propagator propagator) {
        Object object;
        Object object2;
        Map<String, Propagator> map = com.contrastsecurity.agent.commons.g.c(contrastPolicy.propagators);
        map.put(propagator.getId(), propagator);
        HashSet<String> hashSet = new HashSet<String>(contrastPolicy.globalClasses);
        Map<String, List<Propagator>> map2 = com.contrastsecurity.agent.commons.g.c(contrastPolicy.propagatorClassAnnotationMap);
        Map<String, List<Propagator>> map3 = com.contrastsecurity.agent.commons.g.c(contrastPolicy.propagatorClassNameMap);
        boolean bl = propagator.isSignatureBased();
        m m2 = propagator.getMethodMatcher();
        if (bl) {
            hashSet.add(ContrastPolicy.getGlobalNameFromSignature(propagator));
        } else if (m2 instanceof com.contrastsecurity.agent.plugins.security.policy.a) {
            object2 = (com.contrastsecurity.agent.plugins.security.policy.a)m2;
            object = ((com.contrastsecurity.agent.plugins.security.policy.a)object2).a();
            List<Propagator> list = map2.get(object);
            if (list == null) {
                list = Collections.synchronizedList(new ArrayList());
                map2.put((String)object, list);
            }
            list.add(propagator);
        } else if (m2 instanceof com.contrastsecurity.agent.plugins.security.policy.b) {
            object2 = (com.contrastsecurity.agent.plugins.security.policy.b)m2;
            object = ((com.contrastsecurity.agent.plugins.security.policy.b)object2).b();
            List<Propagator> list = map3.get(object);
            if (list == null) {
                list = Collections.synchronizedList(new ArrayList());
                map3.put((String)object, list);
            }
            list.add(propagator);
        }
        this.globalClasses = Collections.unmodifiableSet(hashSet);
        this.propagatorClassAnnotationMap = Collections.unmodifiableMap(map2);
        this.propagatorClassNameMap = Collections.unmodifiableMap(map3);
        this.propagators = Collections.unmodifiableMap(map);
        object2 = Arrays.asList(contrastPolicy.fastPropagatorLookup.b);
        object = new ArrayList(object2);
        object.add(propagator);
        this.fastPropagatorLookup = c.a((List<Propagator>)object);
        this.globalChanges = ContrastPolicy.newGlobalChangesWithNode(contrastPolicy.globalChanges, propagator);
        this.id = contrastPolicy.id;
        this.location = contrastPolicy.location;
        this.parameterAnnotationSources = contrastPolicy.parameterAnnotationSources;
        this.patternAnalyzers = contrastPolicy.patternAnalyzers;
        this.internPreventionScopes = contrastPolicy.internPreventionScopes;
        this.validatorScopes = contrastPolicy.validatorScopes;
        this.wildcardValidatorScopes = contrastPolicy.wildcardValidatorScopes;
        this.customRulesTagLists = contrastPolicy.customRulesTagLists;
        this.allCustomSanitizers = contrastPolicy.allCustomSanitizers;
        this.allCustomValidators = contrastPolicy.allCustomValidators;
        this.indexedSanitizersMap = contrastPolicy.indexedSanitizersMap;
        this.customSanitizers = contrastPolicy.customSanitizers;
        this.frameworkAnnotations = contrastPolicy.frameworkAnnotations;
        this.parameterAnnotations = contrastPolicy.parameterAnnotations;
        this.tagLists = contrastPolicy.tagLists;
        this.rules = contrastPolicy.rules;
        this.deadzones = contrastPolicy.deadzones;
        this.ruleProviders = contrastPolicy.ruleProviders;
        this.tagListIndices = contrastPolicy.tagListIndices;
        this.properties = contrastPolicy.properties;
        this.dynamicSources = contrastPolicy.dynamicSources;
        this.acceptedRegex = contrastPolicy.acceptedRegex;
        this.rejectedRegex = contrastPolicy.rejectedRegex;
        this.sources = contrastPolicy.sources;
        this.cachedSources = contrastPolicy.cachedSources;
        this.sourceClassAnnotationMap = contrastPolicy.sourceClassAnnotationMap;
        this.sourceClassNameMap = contrastPolicy.sourceClassNameMap;
    }

    private ContrastPolicy(ContrastPolicy contrastPolicy, g g2) {
        com.contrastsecurity.agent.commons.l.a(g2.isSignatureBased(), "Only accepts signature based Deadzones - this should never happen");
        HashSet<g> hashSet = new HashSet<g>(contrastPolicy.deadzones);
        hashSet.add(g2);
        this.deadzones = Collections.unmodifiableSet(hashSet);
        HashSet<String> hashSet2 = new HashSet<String>(contrastPolicy.globalClasses);
        if (g2.isSignatureBased()) {
            hashSet2.add(ContrastPolicy.getGlobalNameFromSignature(g2));
        }
        this.globalClasses = hashSet2;
        this.globalChanges = ContrastPolicy.newGlobalChangesWithNode(contrastPolicy.globalChanges, g2);
        this.id = contrastPolicy.id;
        this.location = contrastPolicy.location;
        this.parameterAnnotationSources = contrastPolicy.parameterAnnotationSources;
        this.patternAnalyzers = contrastPolicy.patternAnalyzers;
        this.internPreventionScopes = contrastPolicy.internPreventionScopes;
        this.validatorScopes = contrastPolicy.validatorScopes;
        this.wildcardValidatorScopes = contrastPolicy.wildcardValidatorScopes;
        this.propagators = contrastPolicy.propagators;
        this.fastPropagatorLookup = contrastPolicy.fastPropagatorLookup;
        this.propagatorClassAnnotationMap = contrastPolicy.propagatorClassAnnotationMap;
        this.propagatorClassNameMap = contrastPolicy.propagatorClassNameMap;
        this.customRulesTagLists = contrastPolicy.customRulesTagLists;
        this.allCustomSanitizers = contrastPolicy.allCustomSanitizers;
        this.allCustomValidators = contrastPolicy.allCustomValidators;
        this.indexedSanitizersMap = contrastPolicy.indexedSanitizersMap;
        this.customSanitizers = contrastPolicy.customSanitizers;
        this.frameworkAnnotations = contrastPolicy.frameworkAnnotations;
        this.parameterAnnotations = contrastPolicy.parameterAnnotations;
        this.tagLists = contrastPolicy.tagLists;
        this.rules = contrastPolicy.rules;
        this.ruleProviders = contrastPolicy.ruleProviders;
        this.tagListIndices = contrastPolicy.tagListIndices;
        this.properties = contrastPolicy.properties;
        this.dynamicSources = contrastPolicy.dynamicSources;
        this.acceptedRegex = contrastPolicy.acceptedRegex;
        this.rejectedRegex = contrastPolicy.rejectedRegex;
        this.sources = contrastPolicy.sources;
        this.cachedSources = contrastPolicy.cachedSources;
        this.sourceClassAnnotationMap = contrastPolicy.sourceClassAnnotationMap;
        this.sourceClassNameMap = contrastPolicy.sourceClassNameMap;
    }

    static String getGlobalNameFromSignature(PolicyNode policyNode) {
        m m2 = policyNode.getMethodMatcher();
        if (m2 instanceof s) {
            r r2 = ((s)m2).a();
            return ContrastPolicy.transformGlobalClassName(r2.a());
        }
        throw new InvalidParameterException("Node does not have a signature, so we cannot get the global name from it");
    }

    private static boolean matchesDynamicSources(InstrumentationContext instrumentationContext, Collection<DynamicSource> collection) {
        for (DynamicSource dynamicSource : collection) {
            AbstractClassMatcher[] abstractClassMatcherArray;
            for (AbstractClassMatcher abstractClassMatcher : abstractClassMatcherArray = dynamicSource.getMatchers()) {
                if (!abstractClassMatcher.matches(instrumentationContext)) continue;
                return true;
            }
        }
        return false;
    }

    public static Builder builder(int n2, String string, com.contrastsecurity.agent.plugins.security.policy.propagators.a a2) {
        return new Builder(n2, string, a2);
    }

    private static String transformGlobalClassName(String string) {
        return string.replace('.', '/');
    }

    private static <T extends PolicyNode> Map<String, Set<PolicyNode>> newGlobalChangesWithNodes(Map<String, Set<PolicyNode>> map, Collection<T> collection) {
        Map<String, Set<PolicyNode>> map2 = com.contrastsecurity.agent.commons.g.c(map);
        for (PolicyNode policyNode : collection) {
            String string = policyNode.getMethodMatcher().toString();
            Set<PolicyNode> set = map2.get(string);
            Set<PolicyNode> set2 = ContrastPolicy.newUnmodifiableSetWithNode(policyNode, set);
            map2.put(string, set2);
        }
        return Collections.unmodifiableMap(map2);
    }

    private static <T extends PolicyNode> Map<String, Set<PolicyNode>> newGlobalChangesWithNode(Map<String, Set<PolicyNode>> map, T t2) {
        return ContrastPolicy.newGlobalChangesWithNodes(map, Collections.singleton(t2));
    }

    private static <T> Set<T> newUnmodifiableSetWithNode(T t2, Set<T> set) {
        if (set == null) {
            return Collections.singleton(t2);
        }
        HashSet<T> hashSet = new HashSet<T>(set);
        hashSet.add(t2);
        return Collections.unmodifiableSet(hashSet);
    }

    private Set<String> getGlobalClassFromTaggers(Map<String, TagList> map) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : map.keySet()) {
            TagList tagList = map.get(string);
            for (Tagger tagger : tagList.getTaggers()) {
                if (!tagger.isSignatureBased()) continue;
                String string2 = ContrastPolicy.getGlobalNameFromSignature(tagger);
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public String getLocation() {
        return this.location;
    }

    public Map<String, List<u>> getAnnotatedSources() {
        return this.sourceClassAnnotationMap;
    }

    public List<u> getUntrustedDataSources() {
        return this.cachedSources;
    }

    Set<j> getInternPreventionScopes() {
        return this.internPreventionScopes;
    }

    public List<com.contrastsecurity.agent.plugins.security.pattern.a.a> getPatternAnalyzers() {
        return this.patternAnalyzers;
    }

    public ValidatorScope getValidatorScopeByIndex(int n2) {
        if (n2 < this.validatorScopes.size()) {
            return this.validatorScopes.get(n2);
        }
        return null;
    }

    public int getValidatorScopeIndex(ValidatorScope validatorScope) {
        int n2 = -1;
        for (int i2 = 0; i2 < this.validatorScopes.size(); ++i2) {
            if (this.validatorScopes.get(i2) != validatorScope) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    List<ValidatorScope> getValidatorScopes() {
        return this.validatorScopes;
    }

    public Map<Integer, Propagator> getIndexedSanitizers() {
        return this.indexedSanitizersMap;
    }

    public Map<String, Propagator> getSanitizers() {
        return this.customSanitizers;
    }

    public c getFastPropagatorLookup() {
        return this.fastPropagatorLookup;
    }

    public Map<String, TagList> getCustomRulesTagLists() {
        return this.customRulesTagLists;
    }

    public Map<String, TagList> getTagLists() {
        return this.tagLists;
    }

    public String getProperty(String string) {
        return this.properties.get(string);
    }

    public DynamicSource getDynamicSource(String string) {
        for (DynamicSource dynamicSource : this.dynamicSources.values()) {
            if (!dynamicSource.getId().equals(string)) continue;
            return dynamicSource;
        }
        return null;
    }

    public Collection<Rule> getRules() {
        return this.rules.values();
    }

    public int getId() {
        return this.id;
    }

    public List<com.contrastsecurity.agent.plugins.security.policy.b.a> getFrameworkAnnotationsWithoutClassAnnotation() {
        return this.frameworkAnnotations.get(NO_CLASS_ANNOTATION);
    }

    public Map<String, List<com.contrastsecurity.agent.plugins.security.policy.b.a>> getFrameworkAnnotations() {
        return this.frameworkAnnotations;
    }

    public List<String> getParameterAnnotations(String string) {
        return this.parameterAnnotations.get(string);
    }

    public List<Tagger> getAllCustomSanitizerTagMethods() {
        return this.allCustomSanitizers;
    }

    public List<Tagger> getAllCustomInputValidatorTagMethods() {
        return this.allCustomValidators;
    }

    public Collection<ValidatorScope> getWildcardValidatorScopes() {
        return this.wildcardValidatorScopes;
    }

    public Rule getRuleById(String string) {
        return this.rules.get(string);
    }

    public List<Propagator> getPropagatorsByClassAnnotation(String string) {
        return this.propagatorClassAnnotationMap.get(string);
    }

    public List<Propagator> getPropagatorsByClassName(String string) {
        return this.propagatorClassNameMap.get(string);
    }

    @B
    public Propagator getPropagatorById(String string) {
        return this.propagators.get(string);
    }

    public u getSourceById(String string) {
        return this.sources.get(string);
    }

    public List<u> getSourceParameterAnnotationsFor(String string) {
        return this.parameterAnnotationSources.get(string);
    }

    public List<u> getSourcesByClassName(String string) {
        return this.sourceClassNameMap.get(string);
    }

    public TagList getTagListById(String string) {
        TagList tagList = this.tagLists.get(string);
        if (tagList == null) {
            tagList = this.customRulesTagLists.get(string);
        }
        return tagList;
    }

    public Collection<Class<? extends RuleProvider>> getRuleProviders() {
        return this.ruleProviders;
    }

    public Set<PolicyNode> lookupGlobalSensors(String string) {
        Set<PolicyNode> set = this.globalChanges.get(string);
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    public Map<String, Set<String>> getAcceptedRegex() {
        return this.acceptedRegex;
    }

    public Map<String, Set<String>> getRejectedRegex() {
        return this.rejectedRegex;
    }

    public Set<g> getDeadzones() {
        return this.deadzones;
    }

    Map<String, String> getPropertiesMap() {
        return this.properties;
    }

    Map<String, TagList> getTagListsMap() {
        return this.tagLists;
    }

    public boolean hasChangesFor(String string, InstrumentationContext instrumentationContext) {
        return this.globalClasses.contains(string) || ContrastPolicy.matchesDynamicSources(instrumentationContext, this.dynamicSources.values());
    }

    public ContrastPolicy withNewDynamicSource(u u2) {
        return new ContrastPolicy(this, u2);
    }

    public ContrastPolicy withNewPropagator(Propagator propagator) {
        return new ContrastPolicy(this, propagator);
    }

    public x getTagListIndices() {
        return this.tagListIndices;
    }

    public ContrastPolicy withNewCustomRulesCollection(a a2) {
        return new ContrastPolicy(this, a2);
    }

    public ContrastPolicy withNewDeadzone(g g2) {
        return g2.isSignatureBased() ? new ContrastPolicy(this, g2) : this;
    }

    public Collection<DynamicSource> getDynamicSources() {
        return this.dynamicSources.values();
    }

    public static class c {
        private static final Logger a = LoggerFactory.getLogger(ContrastPolicy.class);
        private final Propagator[] b;

        private c(Propagator[] propagatorArray) {
            this.b = propagatorArray;
            if (a.isDebugEnabled()) {
                for (int i2 = 0; i2 < propagatorArray.length; ++i2) {
                    a.debug("Caching propagator {} at array index {}", (Object)propagatorArray[i2].getId(), (Object)i2);
                }
            }
        }

        public static c a(List<Propagator> list) {
            return new c(list.toArray(new Propagator[0]));
        }

        public Propagator a(int n2) {
            return this.b[n2];
        }

        public Propagator[] a() {
            return this.b;
        }

        public int a(String string) {
            if (string.startsWith(ContrastPolicy.CUSTOM_SANITIZERS_ID)) {
                return Integer.valueOf(string.substring(ContrastPolicy.CUSTOM_SANITIZERS_ID.length()));
            }
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                Propagator propagator = this.b[i2];
                if (!propagator.getId().equals(string)) continue;
                return i2;
            }
            throw new IllegalArgumentException("Unknown propagator ID " + string);
        }

        public int b() {
            return this.b.length;
        }
    }

    private static class b<T extends e> {
        final Map<String, T> a;
        final Map<String, List<T>> b;
        final Map<String, List<T>> c;
        final Set<String> d;

        private b(Map<String, T> map, Map<String, List<T>> map2, Map<String, List<T>> map3, Set<String> set) {
            this.a = map;
            this.b = map2;
            this.c = map3;
            this.d = set;
        }

        public static <T extends e> b<T> a(String string, List<T> list) {
            HashMap<String, e> hashMap = new HashMap<String, e>();
            HashMap<String, List<T>> hashMap2 = new HashMap<String, List<T>>();
            HashMap<String, List<T>> hashMap3 = new HashMap<String, List<T>>();
            HashSet<String> hashSet = new HashSet<String>();
            for (e e2 : list) {
                List list2;
                String string2;
                m m2;
                String string3 = e2.getId();
                if (hashMap.containsKey(string3)) {
                    Builder.logger.warn("Duplicate {} '{}' detected. Overwriting.", (Object)string, (Object)string3);
                }
                hashMap.put(string3, e2);
                m m3 = e2.getMethodMatcher();
                if (e2.isSignatureBased()) {
                    m2 = (s)m3;
                    string2 = ((s)m2).a().a();
                    hashSet.add(ContrastPolicy.transformGlobalClassName(string2));
                    continue;
                }
                if (m3 instanceof com.contrastsecurity.agent.plugins.security.policy.a) {
                    m2 = (com.contrastsecurity.agent.plugins.security.policy.a)m3;
                    string2 = ((com.contrastsecurity.agent.plugins.security.policy.a)m2).a();
                    list2 = (List)hashMap2.get(string2);
                    if (list2 == null) {
                        list2 = Collections.synchronizedList(new ArrayList());
                        hashMap2.put(string2, list2);
                    }
                    list2.add(e2);
                    continue;
                }
                if (!(m3 instanceof com.contrastsecurity.agent.plugins.security.policy.b)) continue;
                m2 = (com.contrastsecurity.agent.plugins.security.policy.b)m3;
                string2 = ((com.contrastsecurity.agent.plugins.security.policy.b)m2).b();
                list2 = (List)hashMap3.get(string2);
                if (list2 == null) {
                    list2 = Collections.synchronizedList(new ArrayList());
                    hashMap3.put(string2, list2);
                }
                list2.add(e2);
            }
            return new b(hashMap, hashMap2, hashMap3, hashSet);
        }
    }

    public static class a {
        private final int a;
        private final String b;
        private final Map<String, Propagator> c;
        private final List<Tagger> d;
        private final List<Tagger> e;
        private final Set<String> f;
        private final Map<Integer, Propagator> g;
        private final com.contrastsecurity.agent.plugins.security.policy.propagators.a h;
        private Map<String, TagList> i;
        private int j;
        private static final Logger k = LoggerFactory.getLogger(a.class);
        private static final String l = "custom-encoded";
        private static int m;
        private static int n;

        a(int n2, String string, com.contrastsecurity.agent.plugins.security.policy.propagators.a a2) {
            this.a = n2;
            this.b = string;
            this.h = a2;
            this.g = new HashMap<Integer, Propagator>();
            this.c = new HashMap<String, Propagator>();
            this.d = new LinkedList<Tagger>();
            this.e = new LinkedList<Tagger>();
            this.f = new HashSet<String>();
            this.i = new TreeMap<String, TagList>();
        }

        public a(ContrastPolicy contrastPolicy, com.contrastsecurity.agent.plugins.security.policy.propagators.a a2) {
            this.a = contrastPolicy.id;
            this.b = contrastPolicy.location;
            this.h = a2;
            this.g = com.contrastsecurity.agent.commons.g.c(contrastPolicy.indexedSanitizersMap);
            this.c = new HashMap<String, Propagator>(contrastPolicy.customSanitizers);
            this.d = com.contrastsecurity.agent.commons.f.b(contrastPolicy.allCustomSanitizers);
            this.e = com.contrastsecurity.agent.commons.f.b(contrastPolicy.allCustomValidators);
            this.f = o.b(contrastPolicy.globalClasses);
            this.i = com.contrastsecurity.agent.commons.g.b(contrastPolicy.customRulesTagLists);
        }

        @B
        public Map<String, TagList> a() {
            return Collections.unmodifiableMap(this.i);
        }

        private static TagList a(boolean bl, List<String> list, Map<String, TagList> map) {
            TagList tagList = null;
            Set<String> set = map.keySet();
            String string = bl ? ContrastPolicy.CUSTOM_SANITIZERS_ID : ContrastPolicy.CUSTOM_VALIDATORS_ID;
            for (String string2 : set) {
                if (string2.startsWith(string) && (tagList = com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy$a.a(map.get(string2), bl, list)) != null) break;
            }
            return tagList;
        }

        private TagList a(boolean bl, List<String> list) {
            return com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy$a.a(bl, list, this.i);
        }

        private static TagList a(TagList tagList, boolean bl, List<String> list) {
            TagList tagList2 = null;
            String[] stringArray = tagList.getTagListTags();
            int n2 = stringArray.length;
            if (list == null || list.isEmpty()) {
                if (n2 == 1) {
                    String string;
                    String string2 = string = bl ? l : ContrastPolicy.CUSTOM_VALIDATORS_TAG;
                    if (string.equals(stringArray[0])) {
                        tagList2 = tagList;
                    }
                }
            } else {
                int n3 = list.size();
                if (n2 == n3) {
                    List<String> list2 = Arrays.asList(stringArray);
                    boolean bl2 = true;
                    for (String string : list) {
                        String string3 = (bl ? ContrastPolicy.CUSTOM_SANITIZERS_TAG_HEADER : "custom-validator-") + string;
                        if (list2.contains(string3)) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2) {
                        tagList2 = tagList;
                    }
                }
            }
            return tagList2;
        }

        public void a(com.contrastsecurity.agent.plugins.security.policy.rules.a.c c2, List<PolicyNode> list) {
            if (c2.a() == c.a.a) {
                this.a((com.contrastsecurity.agent.plugins.security.policy.rules.a.g)c2, list);
            } else if (c2.a() == c.a.b) {
                this.a((h)c2, list);
            }
        }

        private void a(com.contrastsecurity.agent.plugins.security.policy.rules.a.g g2, List<PolicyNode> list) {
            if (g2.b() == c.b.b) {
                SanitizerDTM sanitizerDTM = g2.f();
                this.a(sanitizerDTM);
            } else if (g2.b() == c.b.a) {
                this.a(list);
            }
        }

        private void a(h h2, List<PolicyNode> list) {
            if (h2.b() == c.b.b) {
                InputValidatorDTM inputValidatorDTM = h2.f();
                this.a(inputValidatorDTM);
            } else if (h2.b() == c.b.a) {
                PolicyNode.disableAll(list);
            }
        }

        public void b() {
            this.d.clear();
            this.e();
            this.e.clear();
            this.f();
        }

        public void a(AssessmentFeatures assessmentFeatures) {
            this.a(assessmentFeatures.getSanitizers());
            this.b(assessmentFeatures.getValidators());
        }

        public void a(Set<SanitizerDTM> set) {
            if (set != null && !set.isEmpty()) {
                for (SanitizerDTM sanitizerDTM : set) {
                    this.a(sanitizerDTM);
                }
            }
        }

        public void b(Set<InputValidatorDTM> set) {
            if (set != null && !set.isEmpty()) {
                for (InputValidatorDTM inputValidatorDTM : set) {
                    this.a(inputValidatorDTM);
                }
            }
        }

        void a(SanitizerDTM sanitizerDTM) {
            TagList tagList = this.b(sanitizerDTM);
            String string = sanitizerDTM.getApi();
            k.debug("Adding sanitizer {}", (Object)string);
            try {
                Tagger tagger = this.h.b(this.a, this.b, tagList, sanitizerDTM.getApi());
                tagList.addTagger(tagger, true);
                Propagator propagator = this.h.a(this.a, this.b, sanitizerDTM.getApi(), this.j);
                s s2 = (s)propagator.getMethodMatcher();
                r r2 = s2.a();
                this.a(r2.a());
                this.c.put(propagator.getId(), propagator);
                this.g.put(this.j, propagator);
                ++this.j;
                k.debug("Added sanitizer! {}", (Object)propagator);
            }
            catch (Exception exception) {
                k.error("Couldn't add Sanitizer", exception);
            }
        }

        public void a(InputValidatorDTM inputValidatorDTM) {
            TagList tagList = this.b(inputValidatorDTM);
            String string = inputValidatorDTM.getApi();
            k.debug("Adding validator: {}", (Object)string);
            try {
                Tagger tagger = this.h.a(this.a, this.b, tagList, inputValidatorDTM.getApi());
                tagger.setMethodGroup(tagList);
                tagList.addTagger(tagger, true);
                s s2 = (s)tagger.getMethodMatcher();
                r r2 = s2.a();
                this.a(r2.a());
                k.debug("Added validator!");
            }
            catch (Exception exception) {
                k.error("Couldn't add InputValidator", exception);
            }
        }

        void a(List<PolicyNode> list) {
            for (PolicyNode policyNode : list) {
                policyNode.setEnabled(false);
                if (!k.isDebugEnabled()) continue;
                k.debug("Disabled custom sanitizer tagger {}", (Object)policyNode);
            }
        }

        TagList a(CustomRuleAPI customRuleAPI) {
            return this.a(customRuleAPI instanceof SanitizerDTM, customRuleAPI.getRules());
        }

        public List<Tagger> b(List<String> list) {
            List<Tagger> list2 = null;
            TagList tagList = this.a(true, list);
            if (tagList != null) {
                list2 = tagList.getTaggers();
            }
            return list2;
        }

        private void e() {
            for (String string : this.i.keySet()) {
                if (string == null || !string.startsWith(ContrastPolicy.CUSTOM_SANITIZERS_ID)) continue;
                this.d.addAll(this.i.get(string).getTaggers());
            }
        }

        public List<Tagger> c(List<String> list) {
            List<Tagger> list2 = null;
            TagList tagList = this.a(false, list);
            if (tagList != null) {
                list2 = tagList.getTaggers();
            }
            return list2;
        }

        private void f() {
            for (String string : this.i.keySet()) {
                if (string == null || !string.startsWith(ContrastPolicy.CUSTOM_VALIDATORS_ID)) continue;
                this.e.addAll(this.i.get(string).getTaggers());
            }
        }

        private TagList b(CustomRuleAPI customRuleAPI) {
            TagList tagList = this.a(customRuleAPI);
            if (tagList == null) {
                String string;
                String[] stringArray;
                boolean bl = customRuleAPI instanceof SanitizerDTM;
                List<String> list = customRuleAPI.getRules();
                if (list == null || list.isEmpty()) {
                    stringArray = new String[]{bl ? l : ContrastPolicy.CUSTOM_VALIDATORS_TAG};
                } else {
                    stringArray = new String[list.size()];
                    string = customRuleAPI instanceof SanitizerDTM ? ContrastPolicy.CUSTOM_SANITIZERS_TAG_HEADER : "custom-validator-";
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        stringArray[i2] = string + list.get(i2);
                    }
                }
                if (bl) {
                    string = ContrastPolicy.CUSTOM_SANITIZERS_ID + m;
                    ++m;
                } else {
                    string = ContrastPolicy.CUSTOM_VALIDATORS_ID + n;
                    ++n;
                }
                tagList = new TagList();
                tagList.setId(string);
                tagList.setName(string);
                tagList.setTagListTags(stringArray);
                tagList.setTaggers(new ArrayList<Tagger>());
                this.i.put(string, tagList);
            }
            return tagList;
        }

        public Collection<Propagator> c() {
            return this.c.values();
        }

        private void a(String string) {
            this.f.add(ContrastPolicy.transformGlobalClassName(string));
        }

        void a(Map<String, TagList> map) {
            this.i = map;
        }

        Set<String> d() {
            return this.f;
        }
    }

    @DontObfuscate
    public static class Builder {
        private static final Logger logger = LoggerFactory.getLogger(ContrastPolicy.class);
        private final int id;
        private final String location;
        private final a customRulesCollectionBuilder;
        private List<u> sources;
        private Map<String, List<u>> parameterAnnotationSources;
        private List<com.contrastsecurity.agent.plugins.security.pattern.a.a> patternAnalyzers;
        private Set<j> internPreventionScopes;
        private Set<ValidatorScope> validatorScopes;
        private Set<ValidatorScope> wildcardValidatorScopes;
        private List<Propagator> propagators;
        private Map<String, List<com.contrastsecurity.agent.plugins.security.policy.b.a>> frameworkAnnotations;
        private Map<String, List<String>> parameterAnnotations;
        private Map<String, TagList> tagLists;
        private Map<String, Set<PolicyNode>> globalChanges;
        private Map<String, Rule> rules;
        private Set<g> deadzones;
        private Collection<Class<? extends RuleProvider>> ruleProviders;
        private Set<String> globalClasses;
        private Map<String, String> properties;
        private Map<String, DynamicSource> dynamicSources;
        private Map<String, Set<String>> acceptedRegex;
        private Map<String, Set<String>> rejectedRegex;

        protected Builder(int n2, String string, com.contrastsecurity.agent.plugins.security.policy.propagators.a a2) {
            com.contrastsecurity.agent.commons.l.a(string);
            this.location = string;
            this.id = n2;
            this.customRulesCollectionBuilder = new a(this.id, string, a2);
            this.deadzones = new CopyOnWriteArraySet<g>();
            this.tagLists = new TreeMap<String, TagList>();
            this.sources = new LinkedList<u>();
            this.parameterAnnotationSources = new HashMap<String, List<u>>();
            this.rules = new HashMap<String, Rule>();
            this.ruleProviders = new ArrayList<Class<? extends RuleProvider>>();
            this.propagators = new LinkedList<Propagator>();
            this.frameworkAnnotations = new HashMap<String, List<com.contrastsecurity.agent.plugins.security.policy.b.a>>();
            this.parameterAnnotations = new HashMap<String, List<String>>();
            this.dynamicSources = new HashMap<String, DynamicSource>();
            this.globalChanges = new HashMap<String, Set<PolicyNode>>();
            this.acceptedRegex = new HashMap<String, Set<String>>();
            this.rejectedRegex = new HashMap<String, Set<String>>();
            this.internPreventionScopes = new HashSet<j>();
            this.validatorScopes = new HashSet<ValidatorScope>();
            this.patternAnalyzers = new LinkedList<com.contrastsecurity.agent.plugins.security.pattern.a.a>();
            this.globalClasses = new HashSet<String>(256);
            this.properties = new HashMap<String, String>();
        }

        public String getProperty(String string) {
            return this.properties.get(string);
        }

        DynamicSource getDynamicSource(String string) {
            for (DynamicSource dynamicSource : this.dynamicSources.values()) {
                if (!dynamicSource.getId().equals(string)) continue;
                return dynamicSource;
            }
            return null;
        }

        public String getLocation() {
            return this.location;
        }

        public int getId() {
            return this.id;
        }

        void addProperty(String string, String string2) {
            if (this.properties.containsKey(string)) {
                logger.error("Duplicate property '{}' detected. Overwriting.", (Object)string);
            }
            this.properties.put(string, string2);
        }

        private void addProperties(Map<String, String> map) {
            logger.debug("Adding properties...");
            Set<String> set = map.keySet();
            for (String string : set) {
                this.addProperty(string, map.get(string));
            }
        }

        void addMethodList(TagList tagList) {
            String string = tagList.getId();
            if (this.tagLists.containsKey(string)) {
                logger.warn("Duplicate tag-list '{}' detected. Overwriting.", (Object)string);
            }
            this.tagLists.put(string, tagList);
            for (Tagger tagger : tagList.getTaggers()) {
                if (tagger.isSignatureBased()) {
                    this.addGlobalClass(tagger);
                    continue;
                }
                logger.error("Not supporting non-signature taggers yet as seen on id {}", (Object)string);
            }
        }

        private void addMethodLists(Map<String, TagList> map) {
            logger.debug("Adding tag-lists...");
            Set<String> set = map.keySet();
            for (String string : set) {
                this.addMethodList(map.get(string));
            }
        }

        private void addDeadZones(Set<g> set) {
            if (set == null || set.isEmpty()) {
                return;
            }
            for (g g2 : set) {
                this.addDeadzone(g2);
            }
        }

        private void addAcceptedValidators(Map<String, Set<String>> map) {
            if (map == null || map.isEmpty()) {
                return;
            }
            Set<String> set = map.keySet();
            for (String string : set) {
                Set<String> set2 = this.acceptedRegex.get(string);
                if (set2 != null) {
                    set2.addAll((Collection<String>)map.get(string));
                    continue;
                }
                this.acceptedRegex.put(string, map.get(string));
            }
        }

        private void addRejectedValidators(Map<String, Set<String>> map) {
            if (map == null || map.isEmpty()) {
                return;
            }
            Set<String> set = map.keySet();
            for (String string : set) {
                Set<String> set2 = this.rejectedRegex.get(string);
                if (set2 != null) {
                    set2.addAll((Collection<String>)map.get(string));
                    continue;
                }
                this.rejectedRegex.put(string, map.get(string));
            }
        }

        void addPatternAnalyzers(List<com.contrastsecurity.agent.plugins.security.pattern.a.a> list) {
            if (list == null || list.isEmpty()) {
                return;
            }
            for (com.contrastsecurity.agent.plugins.security.pattern.a.a a2 : list) {
                this.addPatternAnalyzer(a2);
            }
        }

        private void addPatternAnalyzer(com.contrastsecurity.agent.plugins.security.pattern.a.a a2) {
            this.patternAnalyzers.add(a2);
        }

        private void addValidatorScopes(Set<ValidatorScope> set) {
            if (set == null || set.isEmpty()) {
                return;
            }
            for (ValidatorScope validatorScope : set) {
                this.addValidatorScope(validatorScope);
            }
        }

        void addValidatorScope(ValidatorScope validatorScope) {
            this.validatorScopes.add(validatorScope);
            if (validatorScope.isSignatureBased()) {
                this.addGlobalClass(validatorScope);
            }
        }

        private void addGlobalClass(String string) {
            this.globalClasses.add(ContrastPolicy.transformGlobalClassName(string));
        }

        private void addGlobalClass(PolicyNode policyNode) {
            String string = ContrastPolicy.getGlobalNameFromSignature(policyNode);
            if (!StringUtils.isEmpty(string)) {
                this.addGlobalClass(string);
            }
        }

        private void addGlobalChange(String string, PolicyNode policyNode) {
            Set<PolicyNode> set = this.globalChanges.get(string);
            if (set == null) {
                set = new HashSet<PolicyNode>();
                this.globalChanges.put(string, set);
            }
            set.add(policyNode);
        }

        private void addInternPreventionScopes(Set<j> set) {
            if (set == null || set.isEmpty()) {
                return;
            }
            for (j j2 : set) {
                this.addInternPreventionScope(j2);
            }
        }

        void addInternPreventionScope(j j2) {
            this.internPreventionScopes.add(j2);
            if (j2.isSignatureBased()) {
                this.addGlobalClass(j2);
            }
        }

        void addRule(Rule rule) {
            Event[] eventArray;
            EventPattern eventPattern;
            if (this.rules.containsKey(rule.getId())) {
                logger.error("Duplicate rule '{}' detected. Overwriting.", (Object)rule.getId());
            }
            this.rules.put(rule.getId(), rule);
            if (rule.getProvider() != null && rule.isEnabled()) {
                this.ruleProviders.add(rule.getProvider().getProviderClass());
            }
            if ((eventPattern = rule.getEventPattern()) != null && (eventArray = eventPattern.getEvents()) != null && eventArray.length > 0) {
                for (Event event : eventArray) {
                    String string;
                    r r2 = event.getSignature();
                    if (r2 == null || (string = r2.a()) == null) continue;
                    this.addGlobalClass(string);
                }
            }
        }

        private void addRules(Map<String, Rule> map) {
            logger.debug("Adding rules...");
            Set<String> set = map.keySet();
            for (String string : set) {
                this.addRule(map.get(string));
            }
        }

        void addFrameworkAnnotation(com.contrastsecurity.agent.plugins.security.policy.b.a a2) {
            List<com.contrastsecurity.agent.plugins.security.policy.b.a> list;
            String string = a2.b();
            if (StringUtils.isEmpty(string)) {
                string = ContrastPolicy.NO_CLASS_ANNOTATION;
            }
            if ((list = this.frameworkAnnotations.get(string)) != null) {
                list.add(a2);
            } else {
                list = Collections.synchronizedList(new ArrayList());
                list.add(a2);
                this.frameworkAnnotations.put(string, list);
            }
        }

        private void addFrameworkAnnotations(Map<String, List<com.contrastsecurity.agent.plugins.security.policy.b.a>> map) {
            for (String string : map.keySet()) {
                List<com.contrastsecurity.agent.plugins.security.policy.b.a> list = this.frameworkAnnotations.get(string);
                if (list == null) {
                    this.frameworkAnnotations.put(string, map.get(string));
                    continue;
                }
                list.addAll((Collection<com.contrastsecurity.agent.plugins.security.policy.b.a>)map.get(string));
            }
        }

        Map<String, List<com.contrastsecurity.agent.plugins.security.policy.b.a>> getFrameworkAnnotations() {
            return this.frameworkAnnotations;
        }

        private void addParameterAnnotations(Map<String, List<String>> map) {
            for (String string : map.keySet()) {
                List<String> list = this.parameterAnnotations.get(string);
                if (list == null) {
                    this.parameterAnnotations.put(string, map.get(string));
                    continue;
                }
                list.addAll((Collection<String>)map.get(string));
            }
        }

        void addParameterAnnotation(String string, String string2) {
            List<String> list = this.parameterAnnotations.get(string);
            if (list != null) {
                list.add(string2);
            } else {
                list = Collections.synchronizedList(new ArrayList());
                list.add(string2);
                this.parameterAnnotations.put(string, list);
            }
        }

        synchronized void cache() {
            List<e> list;
            Object object;
            Object object2;
            logger.debug("Caching policy");
            this.globalChanges.clear();
            this.addGlobalChanges(this.propagators);
            for (Rule object42 : this.rules.values()) {
                object2 = object42.getEventPattern();
                if (object2 == null) continue;
                this.cacheEventPattern(object42, (EventPattern)object2);
            }
            this.parameterAnnotationSources.clear();
            Collection<u> collection = this.addGlobalChanges(this.sources);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                object2 = (u)iterator.next();
                if (!((u)object2).c()) continue;
                Object object3 = ((e)object2).getTargets()[0];
                object = ((l)object3).i();
                logger.debug("Saving {} for parameter annotation based sources", object);
                list = this.parameterAnnotationSources.get(object);
                if (list == null) {
                    list = new LinkedList<u>();
                    this.parameterAnnotationSources.put((String)object, list);
                }
                list.add((u)object2);
            }
            ArrayList<String> arrayList = new ArrayList<String>(this.tagLists.keySet());
            Collections.sort(arrayList);
            for (Object object3 : arrayList) {
                object = this.tagLists.get(object3);
                list = ((TagList)object).getTaggers();
                this.addGlobalChanges(list);
            }
            this.customRulesCollectionBuilder.b();
            this.globalClasses.addAll(this.customRulesCollectionBuilder.d());
            object2 = this.addGlobalChanges(this.validatorScopes);
            this.wildcardValidatorScopes = new HashSet<ValidatorScope>((Collection<ValidatorScope>)object2);
            this.addGlobalChanges(this.internPreventionScopes);
            this.addGlobalChanges(this.deadzones);
        }

        private <T extends PolicyNode> Collection<T> addGlobalChanges(Collection<T> collection) {
            LinkedList<PolicyNode> linkedList = new LinkedList<PolicyNode>();
            for (PolicyNode policyNode : collection) {
                if (policyNode.isSignatureBased()) {
                    s s2 = (s)policyNode.getMethodMatcher();
                    String string = s2.a().toString();
                    this.addGlobalChange(string, policyNode);
                    continue;
                }
                linkedList.add(policyNode);
            }
            return linkedList;
        }

        private void cacheEventPattern(Rule rule, EventPattern eventPattern) {
            Event[] eventArray = eventPattern.getEvents();
            r r2 = eventPattern.getScope();
            if (r2 != null) {
                String object = r2.toString();
                this.addGlobalChange(object, rule);
            }
            for (Event event : eventArray) {
                String string = event.getSignature().toString();
                this.addGlobalChange(string, event);
            }
        }

        void addDynamicSource(DynamicSource dynamicSource) {
            String string = dynamicSource.getId();
            if (this.dynamicSources.containsKey(string)) {
                logger.error("Duplicate dynamic-source '{}' detected. Overwriting.", (Object)string);
            }
            this.dynamicSources.put(string, dynamicSource);
        }

        private void addDynamicSources(Map<String, DynamicSource> map) {
            Set<String> set = map.keySet();
            for (String string : set) {
                this.addDynamicSource(map.get(string));
            }
        }

        void addAcceptedRegex(String string, String ... stringArray) {
            Set<String> set = this.acceptedRegex.get(string);
            if (set == null) {
                set = new HashSet<String>();
            }
            set.addAll(Arrays.asList(stringArray));
            this.acceptedRegex.put(string, set);
        }

        void addRejectedRegex(String string, String ... stringArray) {
            Set<String> set = this.rejectedRegex.get(string);
            if (set == null) {
                set = new HashSet<String>();
            }
            set.addAll(Arrays.asList(stringArray));
            this.rejectedRegex.put(string, set);
        }

        void addDeadzone(g g2) {
            if (g2.isSignatureBased()) {
                String string = ContrastPolicy.getGlobalNameFromSignature(g2);
                this.addGlobalClass(string);
                this.deadzones.add(g2);
            }
        }

        Map<String, String> getPropertiesMap() {
            return this.properties;
        }

        void applyOverrides(Builder builder) {
            this.addProperties(builder.properties);
            this.addPropagators(builder.propagators);
            this.addRules(builder.rules);
            this.addUntrustedDataSources(builder.sources);
            this.addDynamicSources(builder.dynamicSources);
            this.addMethodLists(builder.tagLists);
            this.addDeadZones(builder.deadzones);
            this.addAcceptedValidators(builder.acceptedRegex);
            this.addRejectedValidators(builder.rejectedRegex);
            this.addValidatorScopes(builder.validatorScopes);
            this.addInternPreventionScopes(builder.internPreventionScopes);
            this.addPatternAnalyzers(builder.patternAnalyzers);
            this.addFrameworkAnnotations(builder.frameworkAnnotations);
            this.addParameterAnnotations(builder.parameterAnnotations);
        }

        void addPropagators(List<Propagator> list) {
            this.propagators.addAll(list);
        }

        private void addUntrustedDataSources(List<u> list) {
            this.sources.addAll(list);
        }

        public ContrastPolicy build() {
            logger.info("Readying policy...");
            this.cache();
            logger.info("Policy ready...");
            return new ContrastPolicy(this);
        }

        void addUntrustedDataSource(u u2) {
            this.sources.add(u2);
        }

        public a getCustomRulesCollectionBuilder() {
            return this.customRulesCollectionBuilder;
        }

        public void applyFeatures(AssessmentFeatures assessmentFeatures) {
            this.customRulesCollectionBuilder.a(assessmentFeatures);
        }
    }
}

