/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy;

import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.plugins.security.policy.InheritancePreference;
import com.contrastsecurity.agent.plugins.security.policy.m;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Collection;
import java.util.Set;

@Sensor
public abstract class PolicyNode {
    private boolean enabled;
    protected int policyId;
    private InheritancePreference inheritancePreference;
    private Set<String> unwantedInheritors;
    private int totalTimesHit;
    private static final Logger logger = LoggerFactory.getLogger(PolicyNode.class);

    public static void disableAll(Collection<PolicyNode> collection) {
        for (PolicyNode policyNode : collection) {
            policyNode.setEnabled(false);
            logger.debug("Disabled node {}", (Object)policyNode);
        }
    }

    public PolicyNode(int n2) {
        this.policyId = n2;
    }

    public PolicyNode() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public InheritancePreference getInheritancePreference() {
        return this.inheritancePreference;
    }

    public void setInheritancePreference(InheritancePreference inheritancePreference) {
        this.inheritancePreference = inheritancePreference;
    }

    public boolean isUnwantedInheritor(String string) {
        return this.unwantedInheritors != null && this.unwantedInheritors.contains(string);
    }

    public void setUnwantedInheritors(Set<String> set) {
        this.unwantedInheritors = set;
    }

    public int getTotalTimesHit() {
        return this.totalTimesHit;
    }

    public void hit() {
        ++this.totalTimesHit;
    }

    public void resetUsageMetrics() {
        this.totalTimesHit = 0;
    }

    public int getPolicyId() {
        return this.policyId;
    }

    public abstract boolean isSignatureBased();

    public abstract m getMethodMatcher();

    protected abstract String getTypeLabel();
}

