/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.propagators;

import com.contrastsecurity.agent.B;
import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.controller.propagate.ContrastDataFlowPropagationDispatcherImpl;
import com.contrastsecurity.agent.plugins.security.model.d;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.InheritancePreference;
import com.contrastsecurity.agent.plugins.security.policy.a.a;
import com.contrastsecurity.agent.plugins.security.policy.a.h;
import com.contrastsecurity.agent.plugins.security.policy.e;
import com.contrastsecurity.agent.plugins.security.policy.g;
import com.contrastsecurity.agent.plugins.security.policy.i;
import com.contrastsecurity.agent.plugins.security.policy.l;
import com.contrastsecurity.agent.plugins.security.policy.m;
import com.contrastsecurity.agent.u;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.f;
import com.contrastsecurity.agent.util.s;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

@Sensor
public class Propagator
extends e
implements Cloneable {
    private final ContrastEngine engine;
    private final AssessmentManager assessmentManager;
    private final a adaptiveOptimizationManager;
    private String propagationType;
    private final Command cmd;
    private l[] sources;
    private final String[] cmdArguments;
    private int[] integerCmdArguments;
    private boolean[] isLiteralCmdArguments;
    private final String[] tags;
    private final String[] untags;
    private final boolean cloneOnUnchangedCloneableSource;
    private final boolean shouldTagsApplyWhenInvokedDuringSources;
    private long totalTimesHit;
    private boolean currentlyDeadzoning;
    private Set<String> requiredParameterTypes;
    private static final String TYPE_A2A = "A2A";
    private static final String TYPE_A2O = "A2O";
    private static final String TYPE_A2P = "A2P";
    private static final String TYPE_A2R = "A2R";
    private static final String TYPE_O2A = "O2A";
    private static final String TYPE_O2O = "O2O";
    private static final String TYPE_O2P = "O2P";
    private static final String TYPE_O2R = "O2R";
    private static final String TYPE_P2A = "P2A";
    private static final String TYPE_P2O = "P2O";
    private static final String TYPE_P2P = "P2P";
    private static final String TYPE_P2R = "P2R";
    private static final Logger logger = LoggerFactory.getLogger(Propagator.class);

    public Propagator(int n2, String string, String string2, l[] lArray, l[] lArray2, Command command, String[] stringArray, String[] stringArray2, String[] stringArray3, boolean bl, boolean bl2, m m2, ContrastEngine contrastEngine, AssessmentManager assessmentManager, a a2) {
        super(n2, string, string2, lArray2, m2);
        this.sources = com.contrastsecurity.agent.commons.l.a(lArray);
        com.contrastsecurity.agent.commons.l.a(lArray.length > 0, "Propagator with ID=%s has no sources", string2);
        this.engine = com.contrastsecurity.agent.commons.l.a(contrastEngine);
        this.assessmentManager = com.contrastsecurity.agent.commons.l.a(assessmentManager);
        this.adaptiveOptimizationManager = com.contrastsecurity.agent.commons.l.a(a2);
        this.isLiteralCmdArguments = new boolean[2];
        this.cmd = command;
        this.cmdArguments = stringArray;
        this.totalTimesHit = 0L;
        this.currentlyDeadzoning = false;
        this.requiredParameterTypes = Collections.emptySet();
        this.tags = stringArray2 != null ? stringArray2 : ObjectShare.EMPTY_STRING_ARRAY;
        this.untags = stringArray3 != null ? stringArray3 : ObjectShare.EMPTY_STRING_ARRAY;
        com.contrastsecurity.agent.commons.l.a(Collections.disjoint(Arrays.asList(this.tags), Arrays.asList(this.untags)), "Propagator with ID=%s has overlapping tags (%s) and untags (%s)", string2, this.tags, this.untags);
        this.cloneOnUnchangedCloneableSource = bl;
        if (bl2) {
            com.contrastsecurity.agent.commons.l.a(this.tags.length + this.untags.length > 0, "Propagator with ID=%s has no tags, but is configured to apply during sources", string2);
        }
        this.shouldTagsApplyWhenInvokedDuringSources = bl2;
        this.parseCommandArguments();
        this.calculatePropagationType();
    }

    public l[] getSources() {
        return this.sources;
    }

    public Set<String> getRequiredParameterTypes() {
        return this.requiredParameterTypes;
    }

    public void setSources(l[] lArray) {
        this.sources = lArray;
    }

    public int getCountOfArgSources() {
        int n2 = 0;
        if (this.sources != null) {
            for (l l2 : this.sources) {
                n2 += l2.c() ? 1 : 0;
            }
        }
        return n2;
    }

    public int getCountOfArgTargets() {
        int n2 = 0;
        if (this.targets != null) {
            for (l l2 : this.targets) {
                n2 += l2.c() ? 1 : 0;
            }
        }
        return n2;
    }

    public String[] getTags() {
        return this.tags;
    }

    public String[] getUntags() {
        return this.untags;
    }

    public boolean isCloneOnUnchangedCloneableSource() {
        return this.cloneOnUnchangedCloneableSource;
    }

    public boolean isShouldTagsApplyWhenInvokedDuringSources() {
        return this.shouldTagsApplyWhenInvokedDuringSources;
    }

    public void onHit(d d2) {
        if (this.adaptiveOptimizationManager.a()) {
            ++this.totalTimesHit;
            if (this.totalTimesHit % (long)this.adaptiveOptimizationManager.b() == 0L) {
                this.sampleForOptimization(d2);
            }
        }
    }

    private void sampleForOptimization(d d2) {
        StackTraceElement stackTraceElement;
        com.contrastsecurity.agent.o.i i2 = d2.j();
        List<StackTraceElement> list = i2.a();
        if (list != null && (stackTraceElement = f.a(list, 0)) != null) {
            this.sampleFrameOptimization(stackTraceElement);
        }
    }

    @B
    int calculateStackDepthOffset(int n2, List<StackTraceElement> list) {
        return this.isIBMJava() ? this.adjustOffsetIfNeeded(list, n2) : n2;
    }

    @B
    int adjustOffsetIfNeeded(List<StackTraceElement> list, int n2) {
        if (list.size() >= 3) {
            String string = list.get(1).getClassName();
            if (string.equals(ContrastDataFlowPropagationDispatcherImpl.class.getName())) {
                String string2 = list.get(1).getMethodName();
                if ("propagate".equals(string2)) {
                    logger.debug("Adjusting frame depth due to IBM weirdness");
                    return 2;
                }
                logger.trace("No need to adjust frame depth, method name was: {}", (Object)string2);
            } else {
                logger.trace("No need to adjust frame depth, class was: {}", (Object)string);
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sampleFrameOptimization(StackTraceElement stackTraceElement) {
        h h2 = this.getCallerHistory(stackTraceElement);
        if (h2 != null) {
            h2.d();
            if (this.historyWarrantsBlackholing(h2)) {
                if (!this.currentlyDeadzoning) {
                    this.currentlyDeadzoning = true;
                    logger.debug("Deadzoning {} as maximum frequency hit", (Object)stackTraceElement);
                    try {
                        this.deadzone(stackTraceElement);
                    }
                    catch (Throwable throwable) {
                        logger.error("Problem redefining frame", throwable);
                    }
                    finally {
                        this.currentlyDeadzoning = false;
                    }
                } else {
                    logger.debug("Already deadzoning, will catch this troublesome frame on the next frequency pass");
                }
            }
        }
    }

    @B
    boolean deadzone(StackTraceElement stackTraceElement) throws i {
        Instrumentation instrumentation = this.engine.getInstrumentation();
        List<Class<?>> list = this.getTargetedClasses(stackTraceElement, instrumentation);
        if (list != null && !list.isEmpty()) {
            String string = stackTraceElement.getMethodName();
            List<String> list2 = this.getMatchingSignatures(list, string);
            if (list2 != null && !list2.isEmpty()) {
                ContrastPolicy contrastPolicy = this.assessmentManager.currentPolicy();
                for (String string2 : list2) {
                    g g2 = new g(contrastPolicy.getId(), string2);
                    g2.setEnabled(true);
                    g2.setInheritancePreference(InheritancePreference.NONE);
                    logger.debug("Adding deadzone to policy: {}", (Object)g2.a());
                    this.assessmentManager.addDeadzone(g2);
                }
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Redefining {} class instances for adaptive instrumentation on frame {}", (Object)list.size(), (Object)stackTraceElement);
                    }
                    Class<?>[] classArray = list.toArray(ObjectShare.EMPTY_CLASS_ARRAY);
                    instrumentation.retransformClasses(classArray);
                    return true;
                }
                catch (Throwable throwable) {
                    logger.error("Problem redefining {} for adaptive optimization", (Object)stackTraceElement, (Object)throwable);
                }
            }
        } else {
            logger.warn("Wanted to deadzone low-yield code path for {} but couldn't match class", (Object)stackTraceElement);
        }
        return false;
    }

    @B
    List<String> getMatchingSignatures(final List<Class<?>> list, final String string) {
        return u.b() ? this._getMatchingSignatures(list, string) : AccessController.doPrivileged(new PrivilegedAction<List<String>>(){

            public List<String> a() {
                return Propagator.this._getMatchingSignatures(list, string);
            }

            @Override
            public /* synthetic */ Object run() {
                return this.a();
            }
        });
    }

    private List<String> _getMatchingSignatures(List<Class<?>> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Class<?> clazz : list) {
            if ("<init>".equals(string)) {
                arrayList.addAll(this.findMatchingConstructorsFromClass(clazz));
                continue;
            }
            arrayList.addAll(this.findMatchingMethodsFromClass(string, clazz));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private List<String> findMatchingConstructorsFromClass(Class<?> clazz) {
        Constructor<?>[] constructorArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
            arrayList.add(Propagator.buildSignature(clazz, "<init>", constructor.getParameterTypes()));
        }
        return arrayList;
    }

    private List<String> findMatchingMethodsFromClass(String string, Class<?> clazz) {
        Method[] methodArray;
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            if (!string.equals(method.getName())) continue;
            linkedList.add(Propagator.buildSignature(clazz, string, method.getParameterTypes()));
        }
        return linkedList;
    }

    private static String buildSignature(Class<?> clazz, String string, Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append(clazz.getName());
        stringBuilder.append('.');
        stringBuilder.append(string);
        stringBuilder.append('(');
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Class<?> clazz2 = classArray[i2];
            stringBuilder.append(clazz2.getName());
            if (i2 == n2 - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private List<Class<?>> getTargetedClasses(StackTraceElement stackTraceElement, Instrumentation instrumentation) {
        Class[] classArray = instrumentation.getAllLoadedClasses();
        LinkedList linkedList = new LinkedList();
        String string = stackTraceElement.getClassName();
        for (Class clazz : classArray) {
            if (!this.isAllowedTarget(clazz) || !string.equals(clazz.getName())) continue;
            linkedList.add(clazz);
        }
        return linkedList;
    }

    private boolean isAllowedTarget(Class<?> clazz) {
        return !clazz.isInterface() && !clazz.isArray() && !clazz.isAnnotation() && !clazz.isSynthetic() && !clazz.isEnum();
    }

    private boolean historyWarrantsBlackholing(h h2) {
        boolean bl = false;
        if (h2.a() == 0 && h2.c() >= this.adaptiveOptimizationManager.c()) {
            bl = true;
        }
        return bl;
    }

    private h getCallerHistory(StackTraceElement stackTraceElement) {
        String string = this.adaptiveOptimizationManager.a(stackTraceElement);
        h h2 = this.adaptiveOptimizationManager.a(string);
        if (h2 == null && !com.contrastsecurity.agent.util.e.a(string)) {
            h2 = new h(string);
            this.adaptiveOptimizationManager.a(string, h2);
        }
        return h2;
    }

    public void setTargetDescription(String string) {
        this.targetType = string;
    }

    public String getPropagationType() {
        return this.propagationType;
    }

    public String[] getCommandArguments() {
        return this.cmdArguments;
    }

    public int getParameterValue(int n2, Object[] objectArray) {
        if (this.cmdArguments == null || this.cmdArguments.length == 0 || this.integerCmdArguments == null || this.integerCmdArguments.length == 0) {
            logger.error("Configuration problem 1 with command parameters for {}", (Object)this.getId());
        }
        if (this.isLiteralCmdArguments != null && this.isLiteralCmdArguments[n2]) {
            return this.integerCmdArguments[n2];
        }
        if (objectArray == null || n2 > this.integerCmdArguments.length || this.integerCmdArguments[n2] > objectArray.length) {
            logger.error("Configuration problem 2 with command parameters for {}", (Object)this.getId());
        }
        return (Integer)objectArray[this.integerCmdArguments[n2]];
    }

    public Command getCommand() {
        return this.cmd;
    }

    private void parseCommandArguments() {
        boolean bl = this.cmdArguments != null;
        int n2 = bl ? this.cmdArguments.length : 0;
        this.integerCmdArguments = new int[n2];
        this.isLiteralCmdArguments = new boolean[n2];
        if (bl && (n2 != 1 || this.cmdArguments[0].length() > 0)) {
            for (int i2 = 0; i2 < this.cmdArguments.length; ++i2) {
                if (this.cmdArguments[i2].charAt(0) == 'P') {
                    this.cmdArguments[i2] = this.cmdArguments[i2].substring(1);
                    this.integerCmdArguments[i2] = Integer.parseInt(this.cmdArguments[i2]) - 1;
                    continue;
                }
                this.isLiteralCmdArguments[i2] = true;
                this.integerCmdArguments[i2] = Integer.parseInt(this.cmdArguments[i2]);
            }
        }
    }

    private void setLiteralCommandArguments(boolean[] blArray) {
        this.isLiteralCmdArguments = blArray;
    }

    private void setIntegerCommandArguments(int[] nArray) {
        this.integerCmdArguments = nArray;
    }

    public Propagator clone() {
        Propagator propagator = new Propagator(this.policyId, this.policyLocation, this.getId(), this.sources, this.targets, this.cmd, this.cmdArguments != null ? (String[])this.cmdArguments.clone() : null, this.tags, this.untags, this.cloneOnUnchangedCloneableSource, this.shouldTagsApplyWhenInvokedDuringSources, this.getMethodMatcher(), this.engine, this.assessmentManager, this.adaptiveOptimizationManager);
        propagator.setLiteralCommandArguments(this.isLiteralCmdArguments != null ? (boolean[])this.isLiteralCmdArguments.clone() : null);
        propagator.setIntegerCommandArguments(this.integerCmdArguments != null ? (int[])this.integerCmdArguments.clone() : null);
        propagator.deep = this.deep;
        propagator.scoped = this.scoped;
        propagator.operation = this.operation;
        return propagator;
    }

    void setRequiredParameterTypes(Set<String> set) {
        this.requiredParameterTypes = set;
    }

    private void calculatePropagationType() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (l l2 : this.sources) {
            bl = bl || l2.a();
            bl2 = bl2 || l2.c();
        }
        l[] lArray = this.targets;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            l l2;
            l2 = lArray[i2];
            bl3 = bl3 || l2.a();
            bl4 = bl4 || l2.c();
            bl5 = bl5 || l2.b();
        }
        boolean bl6 = bl && bl2;
        int n3 = n2 = bl3 && bl4 || bl3 && bl5 || bl4 && bl5 ? 1 : 0;
        if (bl6) {
            if (n2 != 0) {
                this.propagationType = TYPE_A2A;
            } else if (bl3) {
                this.propagationType = TYPE_A2O;
            } else if (bl4) {
                this.propagationType = TYPE_A2P;
            } else if (bl5) {
                this.propagationType = TYPE_A2R;
            }
        } else if (bl) {
            if (n2 != 0) {
                this.propagationType = TYPE_O2A;
            } else if (bl3) {
                this.propagationType = TYPE_O2O;
            } else if (bl4) {
                this.propagationType = TYPE_O2P;
            } else if (bl5) {
                this.propagationType = TYPE_O2R;
            }
        } else if (bl2) {
            if (n2 != 0) {
                this.propagationType = TYPE_P2A;
            } else if (bl3) {
                this.propagationType = TYPE_P2O;
            } else if (bl4) {
                this.propagationType = TYPE_P2P;
            } else if (bl5) {
                this.propagationType = TYPE_P2R;
            }
        }
    }

    @Override
    protected String getTypeLabel() {
        return "propagator";
    }

    @B
    boolean isIBMJava() {
        return s.b();
    }

    @Sensor
    public static enum Command {
        ALL,
        INSERT,
        APPEND,
        REMOVE,
        REPLACE,
        SUBSET,
        KEEP,
        GUESS,
        CONCAT,
        PREPEND,
        OVERWRITE,
        STRIP_WHITESPACE,
        STRIP_TRAILING_WHITESPACE,
        STRIP_LEADING_WHITESPACE;

    }
}

