/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf;

import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.commons.l;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.messages.app.activity.assessment.StateChangingActionDTM;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.b;
import com.contrastsecurity.agent.util.K;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.util.LinkedList;

@Sensor
public class ContrastCSRFDispatcherImpl
implements ContrastCSRFDispatcher {
    private String[] a;
    private final HttpManager b;
    private final ContrastScopeTrackerDispatcher c;
    private final ContrastEngine d;
    private static final String[] e = new String[]{".class", ".log.gz", ".classtmp", "_jsp.java", ".java", ".txt", ".log"};
    private static final Logger f = LoggerFactory.getLogger(ContrastCSRFDispatcherImpl.class);

    public ContrastCSRFDispatcherImpl(HttpManager httpManager, ContrastScopeTrackerDispatcher contrastScopeTrackerDispatcher, g g2, ContrastEngine contrastEngine) {
        l.a(httpManager, "httpManager");
        l.a(contrastScopeTrackerDispatcher, "scopeTrackerDispatcher");
        l.a(contrastEngine, "engine");
        this.b = httpManager;
        this.c = contrastScopeTrackerDispatcher;
        this.d = contrastEngine;
        String string = g2.b("csrf.allowed.filewrite.suffixes");
        if (!StringUtils.isEmpty(string)) {
            this.a = this.a(string.split(","));
            f.debug("Using additional suffixes {}", (Object)K.a(this.a));
        }
    }

    private String[] a(String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : stringArray) {
            String string2 = string.trim();
            if (StringUtils.isEmpty(string2)) continue;
            linkedList.add(string2);
        }
        return linkedList.toArray(ObjectShare.EMPTY_STRING_ARRAY);
    }

    @Sensor
    public void onTokenChecked() {
        HttpRequest httpRequest = this.b.getCurrentRequest();
        if (httpRequest != null) {
            httpRequest.getProperties().put("csrf.token.checked", 1);
        }
    }

    @Sensor
    public void onFileOpenedForWriting(File file) {
        if (file != null && !this.a() && !this.a(file)) {
            try {
                this.d.onEnteringSensor();
                this.b(file);
            }
            catch (Exception exception) {
                f.error("Problem registering file open for CSRF rule on file {}", (Object)file.getPath(), (Object)exception);
            }
            finally {
                this.d.onLeavingSensor();
            }
        }
    }

    private boolean a(File file) {
        String string = file.getName().trim();
        if (this.a != null && K.f(this.a, string)) {
            return true;
        }
        return K.f(e, string);
    }

    private boolean a() {
        return this.c.isInMasterOrSamplingScope();
    }

    private void b(File file) {
        HttpRequest httpRequest = this.b.getCurrentRequest();
        if (httpRequest != null) {
            com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.csrf.b.a(httpRequest, new StateChangingActionDTM(StateChangingActionDTM.Type.FILEWRITE, file.getPath()));
        }
    }
}

