/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.sessiontimeout;

import com.contrastsecurity.agent.B;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.ScopingSensor;
import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.l;
import com.contrastsecurity.agent.commons.r;
import com.contrastsecurity.agent.commons.s;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.d.b;
import com.contrastsecurity.agent.d.e;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.J2EEObjectShare;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.ProviderUtil;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.sessiontimeout.SessionTimeoutRule;
import com.contrastsecurity.agent.plugins.security.s;
import com.contrastsecurity.agent.util.v;
import com.contrastsecurity.thirdparty.org.apache.commons.io.IOUtils;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;

@Sensor
public final class ContrastSessionTimeoutRuleDispatcherImpl
implements ContrastSessionTimeoutRuleDispatcher {
    private static final Logger a = LoggerFactory.getLogger(ContrastSessionTimeoutRuleDispatcherImpl.class);
    private final ApplicationManager b;
    private final ProviderUtil c;
    private final long d;
    public static final int NUMBER_OF_CONTEXT_LINES = 5;
    private static final e.a<r> e = e.a.a(r.class);

    public ContrastSessionTimeoutRuleDispatcherImpl(ApplicationManager applicationManager, ProviderUtil providerUtil, g g2) {
        this.b = l.a(applicationManager);
        this.c = l.a(providerUtil);
        this.d = SessionTimeoutRule.a(g2);
    }

    @ScopedSensor
    public void onSessionObtained(final Object object) {
        try {
            ScopingSensor.aspectOf().startScope();
            if (object == null) {
                a.debug("Session provided to {} was null. Skipping checks for overly-long session timeout.", (Object)ContrastSessionTimeoutRuleDispatcherImpl.class.getName());
            } else {
                final Application application = this.b.current();
                if (application == null) {
                    a.debug("Current application provided to {} was null. Skipping checks for overly-long session timeout.", (Object)ContrastSessionTimeoutRuleDispatcherImpl.class.getName());
                } else if (!application.getInventoryState().b()) {
                    a.debug("Current application with name=\"{}\" provided to {} was not resolved. Skipping checks for overly-long session timeout.", (Object)application.getDisplayName(), (Object)ContrastSessionTimeoutRuleDispatcherImpl.class.getName());
                } else {
                    b b2 = application.context();
                    if (b2.a(e) != null) {
                        a.debug("Already checked session timeout settings for current application with name=\"{}\" and path=\"{}\". Skipping checks for overly-long session timeout.", (Object)application.getDisplayName(), (Object)application.getPath());
                    } else {
                        final Integer n2 = J2EEObjectShare.REFLECTOR.c(object);
                        if (n2 == null) {
                            a.debug("HttpSession.getMaxInactiveInterval() threw an error or returned null. Skipping checks for overly-long session timeout.");
                        } else {
                            b2.b(e, s.a(new r<Void>(){

                                public Void b() {
                                    boolean bl;
                                    boolean bl2 = bl = n2 < 1;
                                    if (bl || (long)n2.intValue() > ContrastSessionTimeoutRuleDispatcherImpl.this.d) {
                                        long l2 = s.b.a("session-timeout", application.getResolvedPath() + File.separatorChar + "WEB-INF" + File.separatorChar + "web.xml");
                                        int n22 = ContrastSessionTimeoutRuleDispatcherImpl.a(n2);
                                        String string = ContrastSessionTimeoutRuleDispatcherImpl.a(n22, object, application);
                                        boolean bl3 = string == null;
                                        ContrastSessionTimeoutRuleDispatcherImpl.this.c.reportFinding(application, "session-timeout", bl3 ? "servletContext.setSessionTimeout(" + n22 + ")" : string, l2, null, false, null);
                                        a.debug("Found vulnerable session timeout value {} (a timeout of zero or less indicates an unlimited timeout) for application with name=\"{}\" and path=\"{}\". Session timeout values must be less than configured value of {} from {}.", n2, application.getDisplayName(), application.getPath(), ContrastSessionTimeoutRuleDispatcherImpl.this.d, "web.session.timeout");
                                    } else {
                                        a.debug("Found safe session timeout value {} for application with name=\"{}\" and path=\"{}\". Session timeout values must be less than configured value of {} from {}.", n2, application.getDisplayName(), application.getPath(), ContrastSessionTimeoutRuleDispatcherImpl.this.d, "web.session.timeout");
                                    }
                                    return null;
                                }

                                @Override
                                public /* synthetic */ Object a() {
                                    return this.b();
                                }
                            }));
                            b2.a(e).a();
                        }
                    }
                }
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    @B
    static int a(int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 % 60 == 0) {
            return n2 / 60;
        }
        if (n2 < 0) {
            return n2 / 60 - 1;
        }
        return n2 / 60 + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @B
    static String a(int n2, Object object, Application application) {
        int n3;
        v v2;
        Object object2 = J2EEObjectShare.REFLECTOR.d(object);
        if (object2 == null) {
            return null;
        }
        InputStream inputStream = J2EEObjectShare.REFLECTOR.b(object2, "/WEB-INF/web.xml");
        if (inputStream == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));
        try {
            v2 = ContrastSessionTimeoutRuleDispatcherImpl.a(bufferedReader, "<session-timeout>", "</session-timeout>", 5);
        }
        catch (IOException iOException) {
            String string;
            try {
                a.debug("Unable to parse /WEB-INF/web.xml for app with name=\"{}\" and path=\"{}\".", application.getDisplayName(), application.getResolvedPath(), iOException);
                string = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader, inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(bufferedReader, inputStream);
            return string;
        }
        IOUtils.closeQuietly(bufferedReader, inputStream);
        if (v2 == null || !v2.c()) {
            return null;
        }
        String string = StringUtils.trimToNull(v2.a());
        if (string == null) {
            return null;
        }
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (n2 == n3) {
            return v2.b();
        }
        if (!(n2 != 0 && n2 != -1 || n3 != 0 && n3 != -1)) {
            return v2.b();
        }
        return null;
    }

    private static v a(BufferedReader bufferedReader, String string, String string2, int n2) throws IOException {
        int n3;
        String string3;
        v v2 = new v();
        v2.a(false);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = -1;
        int n5 = -1;
        int n6 = 1;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while ((string3 = bufferedReader.readLine()) != null) {
            arrayList.add(string3);
            if (!bl && n4 == -1 && string3.contains(string)) {
                n4 = n6;
                n3 = string3.indexOf(string);
                int n7 = string3.indexOf(string2);
                if (n7 != -1) {
                    stringBuilder.append(string3, n3 + string.length(), n7);
                    n5 = n6;
                }
            } else if (!bl && n5 == -1 && string3.contains(string2)) {
                n3 = string3.indexOf(string2);
                stringBuilder.append(string3, 0, n3);
                n5 = n6;
            } else if (n4 != -1 && n5 == -1) {
                stringBuilder.append(string3);
            }
            if (!v2.c() && n4 != -1 && n5 != -1) {
                bl = true;
            }
            ++n6;
        }
        if (bl) {
            v2.a(true);
            n4 = Math.max(1, n4 - n2);
            n5 = Math.min(arrayList.size(), n5 + n2);
            n3 = Integer.toString(n5).length();
            StringBuilder stringBuilder2 = new StringBuilder();
            for (int i2 = n4; i2 <= n5; ++i2) {
                stringBuilder2.append(StringUtils.leftPad(Integer.toString(i2), n3, ' '));
                stringBuilder2.append(": ");
                stringBuilder2.append((String)arrayList.get(i2 - 1));
                stringBuilder2.append('\n');
            }
            v2.a(stringBuilder.toString());
            v2.b(stringBuilder2.toString());
        }
        return v2;
    }
}

