/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.socketfactory;

import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.ScopingSensor;
import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.ApplicationManager;
import com.contrastsecurity.agent.commons.l;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.http.HttpManager;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.o.i;
import com.contrastsecurity.agent.o.j;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.Finding;
import com.contrastsecurity.agent.plugins.security.controller.EventContext;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.model.TriggerEvent;
import com.contrastsecurity.agent.plugins.security.model.c;
import com.contrastsecurity.agent.plugins.security.policy.ContrastPolicy;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.plugins.security.policy.rules.d;
import com.contrastsecurity.agent.plugins.security.s;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.UniqueMethod;
import com.contrastsecurity.agent.trace.b;
import com.contrastsecurity.agent.trace.snapshot.ObjectSnapshotFactory;
import com.contrastsecurity.agent.u;
import com.contrastsecurity.agent.util.K;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.s;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.net.Socket;
import java.util.Set;
import javax.net.ssl.SSLSocketFactory;

@Sensor
public final class ContrastSocketFactoryDispatcherImpl
implements ContrastSocketFactoryDispatcher {
    private final ApplicationManager a;
    private final g b;
    private final AssessmentManager c;
    private final EventContext d;
    private final ObjectSnapshotFactory e;
    private final HttpManager f;
    private final ContrastEngine g;
    private final d h;
    private final b i;
    private final TraceController j;
    private final Finding.d k;
    private final j l;
    private static final boolean m = ContrastSocketFactoryDispatcherImpl.b();
    private static final String n = "insecure-socket-factory";
    public static final String RULE_NAME = "insecure-socket-factory";
    private static final String o = "ssl.SocketFactory.provider";
    private static final Logger p = LoggerFactory.getLogger(ContrastSocketFactoryDispatcherImpl.class);

    public ContrastSocketFactoryDispatcherImpl(ApplicationManager applicationManager, AssessmentManager assessmentManager, g g2, EventContext eventContext, ObjectSnapshotFactory objectSnapshotFactory, HttpManager httpManager, ContrastEngine contrastEngine, d d2, b b2, TraceController traceController, Finding.d d3, j j2) {
        com.contrastsecurity.agent.commons.l.a(applicationManager);
        com.contrastsecurity.agent.commons.l.a(assessmentManager);
        com.contrastsecurity.agent.commons.l.a(g2);
        com.contrastsecurity.agent.commons.l.a(eventContext);
        com.contrastsecurity.agent.commons.l.a(objectSnapshotFactory);
        com.contrastsecurity.agent.commons.l.a(httpManager);
        com.contrastsecurity.agent.commons.l.a(contrastEngine);
        com.contrastsecurity.agent.commons.l.a(d2);
        com.contrastsecurity.agent.commons.l.a(b2);
        com.contrastsecurity.agent.commons.l.a(traceController);
        com.contrastsecurity.agent.commons.l.a(d3);
        com.contrastsecurity.agent.commons.l.a(j2);
        this.a = applicationManager;
        this.c = assessmentManager;
        this.b = g2;
        this.d = eventContext;
        this.e = objectSnapshotFactory;
        this.f = httpManager;
        this.g = contrastEngine;
        this.h = d2;
        this.i = b2;
        this.j = traceController;
        this.k = d3;
        this.l = j2;
    }

    @ScopedSensor
    public void trackSocketCreate(Object object, Object object2) {
        try {
            ScopingSensor.aspectOf().startScope();
            try {
                if (this.a() && m) {
                    this.a((SSLSocketFactory)object, (Socket)object2, this.k);
                }
            }
            catch (Throwable throwable) {
                p.error("Problem checking insecure-socket-factory trigger during socket creation", throwable);
            }
        }
        finally {
            ScopingSensor.aspectOf().leaveScope();
        }
    }

    private boolean a() {
        return u.b(o) == null;
    }

    private void a(SSLSocketFactory sSLSocketFactory, Socket socket, Finding.d d2) {
        Application application = this.a.current();
        if (application == null) {
            return;
        }
        String string = this.b.a("contrast.disabledrules");
        Set<String> set = K.d(string, ",");
        if (set.contains("insecure-socket-factory")) {
            p.debug("Suppressed socket connection report in {} for the disabled rule {}", (Object)application.getDisplayName(), (Object)"insecure-socket-factory");
            return;
        }
        ContrastPolicy contrastPolicy = this.c.currentPolicy();
        Rule rule = contrastPolicy.getRuleById("insecure-socket-factory");
        if (rule == null || !rule.isEnabled()) {
            return;
        }
        i i2 = this.l.a();
        StackTraceElement stackTraceElement = i2.a().get(0);
        UniqueMethod uniqueMethod = UniqueMethod.getMethod(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), "()Ljava/net/Socket;", 0);
        TriggerEvent triggerEvent = new TriggerEvent(this.c, this.e, this.j, rule, "O", uniqueMethod, (Object)sSLSocketFactory, ObjectShare.EMPTY_OBJ_ARRAY, socket);
        triggerEvent.setTimestamp(System.currentTimeMillis());
        triggerEvent.setThreadDesc(Thread.currentThread());
        triggerEvent.setStack(i2);
        try {
            AssessmentContext assessmentContext;
            Trace trace = this.i.a();
            trace.addEvent(triggerEvent);
            trace.setRuleId("insecure-socket-factory");
            long l2 = s.h.a("insecure-socket-factory", this.f.getCurrentRequest());
            Finding finding = d2.a(application, "insecure-socket-factory", trace, l2);
            HttpRequest httpRequest = this.f.cloneCurrentRequest();
            if (httpRequest != null) {
                finding.setRequest(httpRequest.clone());
            }
            p.info("Added finding for rule ID: insecure-socket-factory");
            if (this.h.e()) {
                this.h.a("insecure-socket-factory", finding.getHash());
            }
            if ((assessmentContext = this.c.currentContext()) != null) {
                assessmentContext.setLastMethodEvent(triggerEvent);
            }
            this.g.queueReport(finding);
        }
        catch (c c2) {
            p.info("Duplicate event detected for rule ID: insecure-socket-factory");
        }
    }

    private static boolean b() {
        String string = s.l();
        return string == null || string.contains("1.6");
    }
}

