/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.services;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.p;
import com.contrastsecurity.agent.commons.q;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.services.Purgeable;
import com.contrastsecurity.agent.services.w;
import com.contrastsecurity.agent.util.C;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.List;

@DontObfuscate
public class PurgeThread
extends Thread {
    private final w service;
    private final List<Purgeable> purgeables;
    private boolean profilePurgeables;
    private final q sleeper;
    private static final Logger logger = LoggerFactory.getLogger(PurgeThread.class);

    PurgeThread(w w2, g g2, List<Purgeable> list) {
        this.service = w2;
        this.purgeables = list;
        this.profilePurgeables = g2.f("contrast.profile.purgeables");
        this.sleeper = new p();
    }

    @Override
    public void run() {
        ContrastEngine contrastEngine = ContrastEngine.get();
        contrastEngine.onEnteringSensor();
        while (this.service.a) {
            int n2 = 0;
            int n3 = 0;
            for (Purgeable purgeable : this.purgeables) {
                int n4 = purgeable.purgeableCount();
                try {
                    purgeable.purgeStale();
                }
                catch (Exception exception) {
                    logger.error("Problem clearing purgeable {}", (Object)purgeable, (Object)exception);
                }
                int n5 = purgeable.purgeableCount();
                n2 += n5 - n4;
                n3 += n5;
                if (!logger.isDebugEnabled() && !this.profilePurgeables) continue;
                String string = "[" + purgeable.getClass().getSimpleName() + "] before=" + n4 + ", after=" + n5 + "]";
                if (this.profilePurgeables) {
                    C.a(string);
                    continue;
                }
                logger.debug(string);
            }
            logger.debug("Total purged={}, total still alive={}", (Object)n2, (Object)n3);
            this.sleeper.a(30000L);
        }
        logger.info("Stopped purging thread.");
    }
}

