/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.commons.l;
import com.contrastsecurity.agent.messages.finding.trace.EventActionDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventSignatureDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTagTypeDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTaintRangeDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTypeDTM;
import com.contrastsecurity.agent.messages.finding.trace.ObjectDTM;
import com.contrastsecurity.agent.messages.finding.trace.ParentObjectIdDTM;
import com.contrastsecurity.agent.messages.finding.trace.StackDTM;
import com.contrastsecurity.agent.plugins.security.AssessmentContext;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.policy.rules.Rule;
import com.contrastsecurity.agent.services.reporting.d;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.TagRange;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.trace.Trace;
import com.contrastsecurity.agent.trace.UniqueMethod;
import com.contrastsecurity.agent.trace.a;
import com.contrastsecurity.agent.trace.snapshot.ObjectSnapshotFactory;
import com.contrastsecurity.agent.util.N;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.i;
import com.contrastsecurity.agent.util.s;
import com.contrastsecurity.thirdparty.org.apache.commons.codec.binary.Base64;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Sensor
public class CodeEvent {
    protected final AssessmentManager assessmentManager;
    protected final TraceController traceController;
    protected EventTypeDTM eventTypeDTM;
    protected EventActionDTM eventActionDTM;
    @DontObfuscate
    protected long id;
    @DontObfuscate
    protected Set<Long> parentIds;
    @DontObfuscate
    protected com.contrastsecurity.agent.o.i stack;
    protected TagRanges tagRanges = new TagRanges();
    private TagRanges displayTagRanges;
    @DontObfuscate
    protected char[] objString;
    @DontObfuscate
    protected char[][] parameterStrings = ObjectShare.EMPTY_CHAR_2DARRAY;
    @DontObfuscate
    protected char[] retString;
    protected boolean objTracked;
    protected boolean[] parameterTracked = ObjectShare.EMPTY_BOOLEAN_ARRAY;
    protected boolean retTracked;
    protected int objHash;
    protected int[] parameterHash = ObjectShare.EMPTY_INT_ARRAY;
    protected int retHash;
    @DontObfuscate
    protected long timestamp;
    @DontObfuscate
    protected String threadDesc;
    protected Rule rule;
    protected String fileName;
    @DontObfuscate
    protected UniqueMethod callee;
    protected boolean useLinesNumbersInHashes;
    protected a stackTraceStrategy;
    protected int reportedTraceVersion;
    protected String sourceType;
    protected String targetType;
    private static String[] CONTAINER_PACKAGES = new String[]{"weblogic.servlet.internal"};
    private static final Logger logger = LoggerFactory.getLogger(CodeEvent.class);

    public CodeEvent(AssessmentManager assessmentManager, ObjectSnapshotFactory objectSnapshotFactory, UniqueMethod uniqueMethod, Object object, Object[] objectArray, Object object2, EventTypeDTM eventTypeDTM, EventActionDTM eventActionDTM, TraceController traceController) {
        this(assessmentManager, objectSnapshotFactory, traceController, uniqueMethod, object, objectArray, object2, eventTypeDTM, eventActionDTM);
    }

    public CodeEvent(AssessmentManager assessmentManager, ObjectSnapshotFactory objectSnapshotFactory, TraceController traceController, UniqueMethod uniqueMethod, Object object, Object[] objectArray, Object object2, EventTypeDTM eventTypeDTM, EventActionDTM eventActionDTM) {
        l.a(assessmentManager);
        this.assessmentManager = assessmentManager;
        this.objTracked = traceController.isTracked(object);
        this.objString = objectSnapshotFactory.snapshotAndTruncate(object);
        this.objHash = s.a(object);
        this.callee = uniqueMethod;
        this.eventTypeDTM = eventTypeDTM;
        this.eventActionDTM = eventActionDTM;
        l.a(traceController, "traceController");
        this.traceController = traceController;
        if (objectArray != null) {
            this.parameterStrings = new char[objectArray.length][];
            this.parameterTracked = new boolean[objectArray.length];
            this.parameterHash = new int[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                boolean bl;
                this.parameterTracked[i2] = bl = traceController.isTracked(objectArray[i2]);
                this.parameterStrings[i2] = objectSnapshotFactory.snapshotAndTruncate(objectArray[i2]);
                this.parameterHash[i2] = s.a(objectArray[i2]);
            }
        }
        if (object == object2) {
            this.retString = this.objString;
            this.retTracked = this.objTracked;
            this.retHash = this.objHash;
        } else {
            this.retTracked = traceController.isTracked(object2);
            this.retString = objectSnapshotFactory.snapshotAndTruncate(object2);
            this.retHash = s.a(object2);
        }
        this.parentIds = null;
        this.stackTraceStrategy = a.a;
        this.displayTagRanges = null;
    }

    public CodeEvent(AssessmentManager assessmentManager, TraceController traceController) {
        this.assessmentManager = assessmentManager;
        this.traceController = traceController;
    }

    protected CodeEvent clone() {
        CodeEvent codeEvent = new CodeEvent(this.assessmentManager, this.traceController);
        this.populateClone(codeEvent);
        return codeEvent;
    }

    public void populateClone(CodeEvent codeEvent) {
        codeEvent.eventTypeDTM = this.eventTypeDTM;
        codeEvent.eventActionDTM = this.eventActionDTM;
        codeEvent.stackTraceStrategy = this.stackTraceStrategy;
        codeEvent.stack = this.stack;
        codeEvent.tagRanges = this.tagRanges.clone();
        codeEvent.objString = this.objString;
        codeEvent.parameterStrings = this.parameterStrings;
        codeEvent.retString = this.retString;
        codeEvent.objTracked = this.objTracked;
        codeEvent.parameterTracked = this.parameterTracked;
        codeEvent.retTracked = this.retTracked;
        codeEvent.objHash = this.objHash;
        codeEvent.parameterHash = this.parameterHash;
        codeEvent.retHash = this.retHash;
        codeEvent.timestamp = this.timestamp;
        codeEvent.threadDesc = this.threadDesc;
        codeEvent.rule = this.rule;
        codeEvent.callee = this.callee;
        codeEvent.useLinesNumbersInHashes = this.useLinesNumbersInHashes;
        codeEvent.stackTraceStrategy = this.stackTraceStrategy;
        codeEvent.fileName = this.fileName;
    }

    public void prepareForReporting(List<CodeEvent> list, int n2) {
    }

    public void setThreadDesc(Thread thread) {
        AssessmentContext assessmentContext = this.assessmentManager.currentContext();
        String string = assessmentContext != null ? assessmentContext.getThreadDescription(thread) : N.a(thread);
        this.threadDesc = string;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l2) {
        this.timestamp = l2;
    }

    public com.contrastsecurity.agent.o.i getStack() {
        return this.stack;
    }

    public void setStack(com.contrastsecurity.agent.o.i i2) {
        this.stack = i2;
    }

    public char[] getObj() {
        return this.objString;
    }

    public char[][] getParameters() {
        return this.parameterStrings;
    }

    public char[] getRet() {
        return this.retString;
    }

    public Rule getRule() {
        return this.rule;
    }

    public UniqueMethod getCallee() {
        return this.callee;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.callee.getSignature());
        stringBuilder.append("\n         ");
        stringBuilder.append(this.getObj());
        stringBuilder.append(".");
        stringBuilder.append(this.callee.getName());
        char[][] cArray = this.getParameters();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            stringBuilder.append(cArray[i2].toString());
            if (i2 == cArray.length - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(" => ");
        stringBuilder.append(this.getRet());
        stringBuilder.append(" ");
        stringBuilder.append(this.getTagRanges());
        return stringBuilder.toString();
    }

    public void setReportedTraceVersion(int n2) {
        this.reportedTraceVersion = n2;
    }

    public final EventDTM toDtm() throws d {
        this.ensureValid();
        return this.getCommonDtm();
    }

    public final EventDTM getCommonDtm() {
        return this.getCommonDtmBuilder().build();
    }

    protected EventDTM.Builder getCommonDtmBuilder() {
        List<EventTaintRangeDTM> list = this.buildTaintRangeDTMs();
        return EventDTM.builder().type(this.eventTypeDTM).action(this.eventActionDTM).time(this.timestamp).thread(i.a(this.threadDesc)).objectId(this.id).parentObjectIds(this.buildParentIdDtms()).source(this.sourceType).target(this.targetType).signature(EventSignatureDTM.builder().setClassName(this.callee.getDeclaringClassType()).setMethodName(this.callee.getName()).setConstructor("<init>".equalsIgnoreCase(this.callee.getName())).setArgTypes(Arrays.asList(this.callee.getParameterTypeNames())).setReturnType(this.callee.getReturnTypeName()).setFlags(this.callee.getModifiers()).build()).taintRanges(list).object(new ObjectDTM(Base64.encodeBase64String(new String(this.objString).getBytes()), this.objHash, this.objTracked, this.objTracked ? list : null)).ret(new ObjectDTM(Base64.encodeBase64String(new String(this.retString).getBytes()), this.retHash, this.retTracked, this.retTracked ? list : null)).args(this.buildArgumentDTMs(list)).tags(EventDTM.Builder.buildTagsString(this.eventTypeDTM, this.buildEventTagTypeDTMs())).stack(this.buildStackDTM());
    }

    private List<EventTaintRangeDTM> buildTaintRangeDTMs() {
        List<EventTaintRangeDTM> list = this.displayTagRanges != null ? this.displayTagRanges.getDtm() : (this.tagRanges != null ? this.tagRanges.getDtm() : Collections.singletonList(new EventTaintRangeDTM(EventTagTypeDTM.UNTRUSTED, "")));
        return list;
    }

    private Set<ParentObjectIdDTM> buildParentIdDtms() {
        HashSet<ParentObjectIdDTM> hashSet;
        if (this.parentIds != null && !this.parentIds.isEmpty()) {
            hashSet = new HashSet<ParentObjectIdDTM>(this.parentIds.size());
            for (Long l2 : this.parentIds) {
                hashSet.add(new ParentObjectIdDTM(l2));
            }
        } else {
            hashSet = null;
        }
        return hashSet;
    }

    private List<ObjectDTM> buildArgumentDTMs(List<EventTaintRangeDTM> list) {
        boolean bl = !this.objTracked && !this.retTracked;
        ArrayList<ObjectDTM> arrayList = new ArrayList<ObjectDTM>(this.parameterStrings.length);
        for (int i2 = 0; i2 < this.parameterStrings.length; ++i2) {
            ObjectDTM objectDTM = new ObjectDTM(Base64.encodeBase64String(new String(this.parameterStrings[i2]).getBytes()), this.parameterHash[i2], this.parameterTracked[i2], bl && this.parameterTracked[i2] ? list : null);
            arrayList.add(objectDTM);
        }
        return arrayList;
    }

    private EventTagTypeDTM[] buildEventTagTypeDTMs() {
        EventTagTypeDTM[] eventTagTypeDTMArray = new EventTagTypeDTM[]{};
        Set<String> set = this.getTags();
        if (set != null && set.size() > 0) {
            ArrayList<EventTagTypeDTM> arrayList = new ArrayList<EventTagTypeDTM>(set.size());
            for (String string : set) {
                arrayList.add(EventTagTypeDTM.fromString(string));
            }
            eventTagTypeDTMArray = arrayList.toArray(eventTagTypeDTMArray);
        }
        return eventTagTypeDTMArray;
    }

    protected List<StackDTM> buildStackDTM() {
        ArrayList<StackDTM> arrayList = null;
        if (this.stack != null) {
            List<StackTraceElement> list = this.stack.a();
            arrayList = new ArrayList<StackDTM>(list.size());
            for (StackTraceElement stackTraceElement : list) {
                StackDTM stackDTM = StackDTM.of(stackTraceElement);
                arrayList.add(stackDTM);
            }
        }
        return arrayList;
    }

    public List<StackTraceElement> getStackWithoutContrastCode() {
        return this.stack.a();
    }

    private String signatureToString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.callee.getReturnTypeName());
        stringBuilder.append(' ');
        stringBuilder.append(this.callee.getDeclaringClassType());
        stringBuilder.append('.');
        stringBuilder.append(this.callee.getName());
        stringBuilder.append("(");
        String[] stringArray = this.callee.getParameterTypeNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuilder.append(stringArray[i2]);
            if (i2 == stringArray.length - 1) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String toShortString() {
        int n2;
        String[] stringArray;
        BitSet bitSet = this.getBitSet();
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getClass().getName().split("\\.")[3];
        stringBuilder.append(string.substring(0, 4).toUpperCase());
        stringBuilder.append("\n\t\t\t\t\t\t\t");
        stringBuilder.append("CALLEE: ").append(this.signatureToString());
        stringBuilder.append("\n\t\t\t\t\t\t\t");
        if (this.stack != null) {
            stringArray = this.stack.a();
            for (n2 = 0; n2 < 15 && n2 < stringArray.size(); ++n2) {
                stringBuilder.append("CALLER: ").append(stringArray.get(n2));
                stringBuilder.append("\n\t\t\t\t\t\t\t");
            }
        }
        stringBuilder.append("OBJ:").append(CodeEvent.formatValue(this.callee.getDeclaringClassType(), this.objString, this.objHash, this.objTracked));
        stringBuilder.append(".");
        stringBuilder.append(this.callee.getName());
        stringBuilder.append("\n\t\t\t\t\t\t\t");
        stringBuilder.append("LENGTH: ").append(this.objString.length);
        stringBuilder.append("\n\t\t\t\t\t\t\t");
        stringBuilder.append("TAGS: ").append(this.getTagRanges());
        stringArray = this.callee.getParameterTypeNames();
        for (n2 = 0; n2 < this.parameterStrings.length; ++n2) {
            stringBuilder.append("\n\t\t\t\t\t\t\t");
            stringBuilder.append("P-").append(n2).append(":").append(CodeEvent.formatValue(stringArray[n2], this.parameterStrings[n2], this.parameterHash[n2], this.parameterTracked[n2]));
            stringBuilder.append("\n\t\t\t\t\t\t\t");
            stringBuilder.append("LENGTH: ").append(this.parameterStrings[n2].length);
        }
        stringBuilder.append("\n\t\t\t\t\t\t\t");
        stringBuilder.append("RET:").append(CodeEvent.formatValue(this.callee.getReturnTypeName(), this.retString, this.retHash, this.retTracked));
        stringBuilder.append("\n\t\t\t\t\t\t\t");
        stringBuilder.append("B64:").append(this.toBitSetString(bitSet));
        stringBuilder.append("\n\t\t\t\t\t\t\t");
        stringBuilder.append("LENGTH: ").append(this.retString.length);
        return stringBuilder.toString();
    }

    private static String formatValue(String string, char[] cArray, int n2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("[");
        stringBuilder.append(cArray);
        stringBuilder.append("]");
        if (bl) {
            stringBuilder.append("*");
            stringBuilder.append(n2);
        }
        return stringBuilder.toString();
    }

    private boolean isContainerClass(String string) {
        for (String string2 : CONTAINER_PACKAGES) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private String toBitSetString(BitSet bitSet) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(128);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(bitSet);
            objectOutputStream.flush();
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return Base64.encodeBase64String(byArray);
        }
        catch (IOException iOException) {
            logger.error("Failure to convert bitset {} to a String", (Object)bitSet);
            return null;
        }
    }

    BitSet getBitSet() {
        BitSet bitSet = new BitSet();
        List<TagRange> list = this.getUntrustedRanges();
        if (list != null) {
            for (TagRange tagRange : list) {
                bitSet.set(tagRange.start, tagRange.stop);
            }
        }
        return bitSet;
    }

    public String getMethodName() {
        return this.callee.getDeclaringClassType() + "." + this.callee.getName();
    }

    public TagRanges getTagRanges() {
        return this.tagRanges;
    }

    protected void setDisplayTagRanges(TagRanges tagRanges) {
        this.displayTagRanges = tagRanges;
    }

    public void setTagRanges(TagRanges tagRanges) {
        this.tagRanges = tagRanges;
    }

    public void addTag(String string, int n2) throws InvalidTagRangeException {
        if (n2 <= 0) {
            return;
        }
        this.tagRanges.add(new TagRange(0, n2, string));
    }

    public void addTags(String[] stringArray, int n2) throws InvalidTagRangeException {
        if (n2 <= 0) {
            return;
        }
        for (String string : stringArray) {
            this.tagRanges.add(new TagRange(0, n2, string));
        }
    }

    public void addTags(Set<String> set, int n2) throws InvalidTagRangeException {
        if (n2 <= 0) {
            return;
        }
        for (String string : set) {
            this.tagRanges.add(new TagRange(0, n2, string));
        }
    }

    private List<TagRange> getUntrustedRanges() {
        return this.tagRanges != null ? this.tagRanges.getUntrustedRanges() : null;
    }

    public Set<String> getTags() {
        return this.tagRanges != null ? this.tagRanges.getTags() : null;
    }

    public void cloneTagsFromLastEvent(Trace trace) {
        CodeEvent codeEvent;
        if (trace != null && (codeEvent = trace.getLastEvent()) != null) {
            TagRanges tagRanges = codeEvent.getTagRanges().clone();
            this.tagRanges.addAll(tagRanges);
        }
    }

    public void cloneIdsFromLastEvent(Trace trace) {
        if (trace != null) {
            CodeEvent codeEvent = trace.getLastEvent();
            this.setId(codeEvent.getId());
            this.setParentIds(codeEvent.getParentIds());
        }
    }

    public int getObjHash() {
        return this.objHash;
    }

    public int[] getParameterHashes() {
        return this.parameterHash;
    }

    public int getRetHash() {
        return this.retHash;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l2) {
        this.id = l2;
    }

    public Set<Long> getParentIds() {
        return this.parentIds;
    }

    public void setParentIds(Set<Long> set) {
        this.parentIds = set;
    }

    public void addParentId(long l2) {
        if (this.parentIds == null) {
            this.parentIds = new HashSet<Long>();
        }
        this.parentIds.add(l2);
    }

    public void addParentIds(Set<Long> set) {
        if (this.parentIds == null) {
            this.parentIds = new HashSet<Long>();
        }
        this.parentIds.addAll(set);
    }

    public void updateTrackedParams(int[] nArray, Object[] objectArray) {
        if (nArray != null && objectArray != null) {
            for (int n2 : nArray) {
                if (0 > n2 || n2 >= this.parameterTracked.length) continue;
                this.parameterTracked[n2] = this.parameterTracked[n2] || this.traceController.isTracked(objectArray[n2]);
            }
        }
    }

    public void updateTrackedParams(int n2, Object[] objectArray) {
        this.parameterTracked[n2] = this.parameterTracked[n2] || this.traceController.isTracked(objectArray[n2]);
    }

    public boolean[] getParamsTracked() {
        return this.parameterTracked;
    }

    public boolean isAnyParamTracked() {
        boolean bl = false;
        if (this.parameterTracked != null) {
            for (int i2 = 0; i2 < this.parameterTracked.length && !bl; ++i2) {
                bl = this.parameterTracked[i2];
            }
        }
        return bl;
    }

    public void updateTrackedObject(Object object) {
        this.objTracked = this.objTracked || this.traceController.isTracked(object);
    }

    public boolean isObjectTracked() {
        return this.objTracked;
    }

    public boolean isReturnTracked() {
        return this.retTracked;
    }

    protected void ensureValid() throws d {
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String string) {
        this.targetType = string;
    }

    public EventTypeDTM getEventTypeDTM() {
        return this.eventTypeDTM;
    }

    public EventActionDTM getEventActionDTM() {
        return this.eventActionDTM;
    }
}

