/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.util.r;

@Sensor
public class TagRange
implements Comparable<TagRange> {
    public static final String UNTRUSTED = "untrusted";
    private String a = "untrusted";
    @DontObfuscate
    int start;
    @DontObfuscate
    int stop;

    public TagRange(int n2, int n3) {
        if (n3 <= n2) {
            throw new InvalidTagRangeException("Invalid tag range: stop [" + n3 + "] is before start [" + n2 + "]");
        }
        this.setStart(n2);
        this.setStop(n3);
    }

    public TagRange(int n2, int n3, String string) {
        this(n2, n3);
        this.a = string;
    }

    public TagRange clone() {
        try {
            return new TagRange(this.start, this.stop, this.a);
        }
        catch (InvalidTagRangeException invalidTagRangeException) {
            return null;
        }
    }

    public String toString(Object object) {
        String string = object.toString();
        return this.toString() + "=" + string.substring(this.start, this.stop);
    }

    public String toString() {
        return this.a + "(" + this.start + "," + this.stop + ")";
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n2) {
        if (n2 < 0) {
            throw new InvalidTagRangeException("Bad range start[" + n2 + "] < 0");
        }
        this.start = n2;
    }

    public int getStop() {
        return this.stop;
    }

    public void setStop(int n2) {
        if (n2 <= this.start) {
            throw new InvalidTagRangeException("Bad range stop[" + n2 + "] <= start[" + this.start + "]");
        }
        this.stop = n2;
    }

    public String getTag() {
        return this.a;
    }

    public void setTag(String string) {
        this.a = string;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.start;
        n3 = 31 * n3 + this.stop;
        n3 = 31 * n3 + (this.a == null ? 0 : this.a.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TagRange tagRange = (TagRange)object;
        if (this.start != tagRange.start) {
            return false;
        }
        if (this.stop != tagRange.stop) {
            return false;
        }
        if (this.a == null) {
            return tagRange.a == null;
        }
        return this.a.equals(tagRange.a);
    }

    public boolean overlaps(TagRange tagRange) {
        if (!tagRange.a.equals(this.a)) {
            return false;
        }
        return this.start < tagRange.start && this.stop >= tagRange.start || this.start >= tagRange.start && this.stop <= tagRange.stop || this.start <= tagRange.stop && this.stop > tagRange.stop;
    }

    public void merge(TagRange tagRange) {
        if (tagRange.start < this.start) {
            this.start = tagRange.start;
        }
        if (tagRange.stop > this.stop) {
            this.stop = tagRange.stop;
        }
    }

    public int width() {
        return this.stop - this.start;
    }

    @Override
    public int compareTo(TagRange tagRange) {
        return r.a(this.width(), tagRange.width());
    }

    public a compareRange(int n2, int n3) {
        if (this.start < n2 && this.stop <= n2) {
            return com.contrastsecurity.agent.trace.TagRange$a.a;
        }
        if (this.start < n2 && this.stop <= n3) {
            return com.contrastsecurity.agent.trace.TagRange$a.b;
        }
        if (this.start >= n2 && this.start < n3 && this.stop <= n3) {
            return com.contrastsecurity.agent.trace.TagRange$a.c;
        }
        if (this.start < n2 && this.stop > n3) {
            return com.contrastsecurity.agent.trace.TagRange$a.d;
        }
        if (this.start >= n2 && this.start < n3 && this.stop > n3) {
            return com.contrastsecurity.agent.trace.TagRange$a.e;
        }
        if (this.start >= n3 && this.stop > n3) {
            return com.contrastsecurity.agent.trace.TagRange$a.f;
        }
        throw new RuntimeException("Problem with range relationships");
    }

    public static enum a {
        a,
        b,
        c,
        d,
        e,
        f;

    }
}

