/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace;

import com.contrastsecurity.agent.Sensor;
import com.contrastsecurity.agent.messages.finding.trace.EventTagTypeDTM;
import com.contrastsecurity.agent.messages.finding.trace.EventTaintRangeDTM;
import com.contrastsecurity.agent.trace.InvalidTagRangeException;
import com.contrastsecurity.agent.trace.TagRange;
import com.contrastsecurity.agent.util.r;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@Sensor
public final class TagRanges {
    private final List<TagRange> a;
    public static final Comparator<TagRange> TAG_RANGES_COMPARATOR = new Comparator<TagRange>(){

        public int a(TagRange tagRange, TagRange tagRange2) {
            return r.a(tagRange.getStart() + tagRange.getStop(), tagRange2.getStart() + tagRange2.getStop());
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((TagRange)object, (TagRange)object2);
        }
    };

    public TagRanges() {
        this.a = new ArrayList<TagRange>();
    }

    public TagRanges(List<TagRange> list) {
        this.a = list;
        this.a();
    }

    public TagRanges(int n2, int n3, String string) {
        this();
        this.add(new TagRange(n2, n3, string));
    }

    @Deprecated
    public TagRanges add(TagRange tagRange) {
        this.a.add(tagRange);
        return this.a();
    }

    @Deprecated
    public TagRanges addAll(TagRanges tagRanges) {
        if (tagRanges == null) {
            return this;
        }
        this.a.addAll(tagRanges.getTagRanges());
        return this.a();
    }

    @Deprecated
    public TagRanges addAll(Collection<TagRange> collection) {
        if (collection == null) {
            return this;
        }
        this.a.addAll(collection);
        return this.a();
    }

    public void untag(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        if (this.a.size() == 0) {
            return;
        }
        for (String string : stringArray) {
            String string2 = string;
            if (StringUtils.isEmpty(string2)) continue;
            Iterator<TagRange> iterator = this.a.iterator();
            while (iterator.hasNext()) {
                TagRange tagRange = iterator.next();
                if (!tagRange.getTag().equals(string2)) continue;
                iterator.remove();
            }
        }
    }

    public TagRanges clone() {
        TagRanges tagRanges = new TagRanges();
        int n2 = this.a.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TagRange tagRange = this.a.get(i2);
            tagRanges.a.add(tagRange.clone());
        }
        return tagRanges;
    }

    public void shift(int n2) {
        int n3 = this.a.size();
        for (TagRange tagRange : this.a) {
            if (tagRange.start + n2 < 0 || tagRange.stop + n2 < 0) {
                throw new InvalidTagRangeException("Attempt to shift range into negative territory detected. Delta is " + n2 + ". " + this.toString());
            }
            tagRange.start += n2;
            tagRange.stop += n2;
        }
    }

    public TagRanges clear(int n2, int n3) {
        if (n2 < 0 || n2 > n3) {
            throw new InvalidTagRangeException("Attempt to clear invalid range " + n2 + " to " + n3 + " on " + this.toString());
        }
        Iterator<TagRange> iterator = this.a.iterator();
        TagRange tagRange = null;
        while (iterator.hasNext()) {
            TagRange tagRange2 = iterator.next();
            switch (tagRange2.compareRange(n2, n3)) {
                case a: {
                    break;
                }
                case b: {
                    tagRange2.stop = n2;
                    break;
                }
                case c: {
                    iterator.remove();
                    break;
                }
                case d: {
                    TagRange tagRange3 = tagRange2.clone();
                    tagRange2.stop = n2;
                    tagRange3.start = n3;
                    tagRange = tagRange3;
                    break;
                }
                case e: {
                    tagRange2.start = n3;
                    break;
                }
            }
        }
        if (tagRange != null) {
            this.add(tagRange);
        }
        return this;
    }

    public TagRanges remove(int n2, int n3) {
        if (n2 < 0) {
            throw new InvalidTagRangeException("Attempt to remove invalid range detected (start < 0). " + n2);
        }
        if (n3 < n2) {
            throw new InvalidTagRangeException("Attempt to remove invalid range detected (stop < start. " + n3 + "<" + n2);
        }
        if (n3 == n2) {
            return this;
        }
        int n4 = n3 - n2;
        Iterator<TagRange> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            TagRange tagRange = iterator.next();
            switch (tagRange.compareRange(n2, n3)) {
                case a: {
                    break;
                }
                case b: {
                    tagRange.stop = n2;
                    break;
                }
                case c: {
                    iterator.remove();
                    break;
                }
                case d: {
                    tagRange.stop -= n4;
                    break;
                }
                case e: {
                    tagRange.start = n2;
                    tagRange.stop -= n3 - tagRange.start;
                    break;
                }
                case f: {
                    tagRange.start -= n4;
                    tagRange.stop -= n4;
                }
            }
        }
        return this;
    }

    public TagRanges insert(int n2, int n3) {
        if (n2 < 0) {
            throw new InvalidTagRangeException("Attempt to insert invalid range detected (start < 0). " + n2);
        }
        if (n3 < n2) {
            throw new InvalidTagRangeException("Attempt to insert invalid range detected (stop < start. " + n3 + "<" + n2);
        }
        if (n3 == n2) {
            return this;
        }
        int n4 = n3 - n2;
        for (TagRange tagRange : this.a) {
            if (n2 > tagRange.stop) continue;
            if (n2 >= tagRange.start && n2 < tagRange.stop) {
                tagRange.stop += n4;
                continue;
            }
            if (n2 >= tagRange.start) continue;
            tagRange.start += n4;
            tagRange.stop += n4;
        }
        return this;
    }

    public TagRanges split(int n2, int n3) {
        if (n2 < 0) {
            throw new InvalidTagRangeException("Attempt to insert invalid range detected (start < 0). " + n2);
        }
        if (n3 < n2) {
            throw new InvalidTagRangeException("Attempt to insert invalid range detected (stop < start. " + n3 + "<" + n2);
        }
        if (n3 == n2) {
            return this;
        }
        int n4 = n3 - n2;
        ArrayList<TagRange> arrayList = new ArrayList<TagRange>();
        for (TagRange tagRange : this.a) {
            if (n2 > tagRange.stop) continue;
            if (n2 > tagRange.start && n2 < tagRange.stop) {
                TagRange tagRange2 = new TagRange(n3, tagRange.stop + n4, tagRange.getTag());
                arrayList.add(tagRange2);
                tagRange.stop = n2;
                continue;
            }
            if (n2 > tagRange.start) continue;
            tagRange.start += n4;
            tagRange.stop += n4;
        }
        this.a.addAll(arrayList);
        return this;
    }

    public TagRanges trim(int n2, int n3) {
        if (n2 < 0) {
            throw new InvalidTagRangeException("Attempt to trim invalid range detected (start < 0). " + n2);
        }
        if (n3 < n2) {
            throw new InvalidTagRangeException("Attempt to trim invalid range detected (stop < start. " + n3 + "<" + n2);
        }
        if (n3 == n2) {
            this.a.clear();
            return this;
        }
        Iterator<TagRange> iterator = this.a.iterator();
        while (iterator.hasNext()) {
            TagRange tagRange = iterator.next();
            switch (tagRange.compareRange(n2, n3)) {
                case a: 
                case f: {
                    iterator.remove();
                    break;
                }
                case b: {
                    tagRange.start = 0;
                    tagRange.stop -= n2;
                    break;
                }
                case c: {
                    tagRange.start -= n2;
                    tagRange.stop -= n2;
                    break;
                }
                case d: {
                    tagRange.start = 0;
                    tagRange.stop = n3 - n2;
                    break;
                }
                case e: {
                    tagRange.start -= n2;
                    tagRange.stop = n3 - n2;
                }
            }
        }
        return this;
    }

    public void subRange(int n2, int n3) {
        if (n2 < 0) {
            throw new InvalidTagRangeException("Attempt to trim invalid range detected (start < 0). " + n2);
        }
        if (n3 < n2) {
            throw new InvalidTagRangeException("Attempt to trim invalid range detected (stop < start. " + n3 + "<" + n2);
        }
        if (n3 == n2) {
            this.a.clear();
            return;
        }
        Iterator<TagRange> iterator = this.a.iterator();
        block3: while (iterator.hasNext()) {
            TagRange tagRange = iterator.next();
            switch (tagRange.compareRange(n2, n3)) {
                case a: 
                case f: {
                    iterator.remove();
                    continue block3;
                }
            }
            tagRange.start = Math.max(tagRange.start, n2);
            tagRange.stop = Math.min(tagRange.stop, n3);
        }
    }

    public TagRanges explode(int n2) {
        if (n2 < 0) {
            throw new InvalidTagRangeException("Attempt to explode to a negative length");
        }
        for (TagRange tagRange : this.a) {
            tagRange.start = 0;
            tagRange.stop = n2;
        }
        return this;
    }

    public List<TagRange> getUntrustedRanges() {
        LinkedList<TagRange> linkedList = new LinkedList<TagRange>();
        for (TagRange tagRange : this.a) {
            if (!tagRange.getTag().equals("untrusted")) continue;
            linkedList.add(tagRange);
        }
        return linkedList;
    }

    public boolean hasUntrustedRanges() {
        for (TagRange tagRange : this.a) {
            if (!tagRange.getTag().equals("untrusted")) continue;
            return true;
        }
        return false;
    }

    public Set<Integer> getRangeBoundaries() {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (TagRange tagRange : this.a) {
            treeSet.add(tagRange.getStart());
            treeSet.add(tagRange.getStop());
        }
        return treeSet;
    }

    public List<TagRange> getTagRanges() {
        return this.a;
    }

    public Set<String> getTags() {
        HashSet<String> hashSet = new HashSet<String>();
        for (TagRange tagRange : this.a) {
            hashSet.add(tagRange.getTag());
        }
        return hashSet;
    }

    public Set<String> getTagsAt(int n2) {
        Set<String> set = null;
        for (TagRange tagRange : this.a) {
            if (tagRange.start > n2 || tagRange.stop <= n2) continue;
            if (set == null) {
                set = new HashSet<String>();
            }
            set.add(tagRange.getTag());
        }
        if (set == null) {
            set = Collections.emptySet();
        }
        return set;
    }

    public List<EventTaintRangeDTM> getDtm() {
        HashMap<String, EventTaintRangeDTM> hashMap = new HashMap<String, EventTaintRangeDTM>();
        for (TagRange tagRange : this.a) {
            String string;
            EventTagTypeDTM eventTagTypeDTM;
            EventTaintRangeDTM eventTaintRangeDTM;
            String string2 = tagRange.getTag();
            if (StringUtils.isEmpty(string2)) {
                string2 = "untrusted";
            }
            if ((eventTaintRangeDTM = (EventTaintRangeDTM)hashMap.get(string2)) == null) {
                eventTagTypeDTM = EventTagTypeDTM.fromString(string2);
                string = tagRange.start + ":" + tagRange.stop;
            } else {
                eventTagTypeDTM = eventTaintRangeDTM.getTag();
                string = eventTaintRangeDTM.getRange() + ',' + tagRange.start + ':' + tagRange.stop;
            }
            EventTaintRangeDTM eventTaintRangeDTM2 = new EventTaintRangeDTM(eventTagTypeDTM, string);
            hashMap.put(string2, eventTaintRangeDTM2);
        }
        return Collections.unmodifiableList(new ArrayList(hashMap.values()));
    }

    public int size() {
        return this.a.size();
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public String toString() {
        return "Tags:" + this.a;
    }

    public String toString(Object object) {
        StringBuilder stringBuilder = new StringBuilder("{");
        for (TagRange tagRange : this.a) {
            stringBuilder.append(tagRange.toString(object));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private TagRanges a() {
        for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
            TagRange tagRange = this.a.get(i2);
            for (int i3 = this.a.size() - 1; i3 >= 0; --i3) {
                TagRange tagRange2;
                if (i3 == i2 || !tagRange.overlaps(tagRange2 = this.a.get(i3))) continue;
                tagRange.merge(tagRange2);
                this.a.remove(i3);
                if (i2 <= this.a.size() - 1) continue;
                i2 = this.a.size();
            }
        }
        return this;
    }
}

