/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace;

import com.contrastsecurity.agent.B;
import com.contrastsecurity.agent.Contrast;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.f;
import com.contrastsecurity.agent.messages.finding.trace.EventPropertyDTM;
import com.contrastsecurity.agent.plugins.security.AssessmentManager;
import com.contrastsecurity.agent.plugins.security.controller.TraceController;
import com.contrastsecurity.agent.plugins.security.model.PropagationEvent;
import com.contrastsecurity.agent.plugins.security.model.SourceEvent;
import com.contrastsecurity.agent.plugins.security.model.TagEvent;
import com.contrastsecurity.agent.plugins.security.model.TriggerEvent;
import com.contrastsecurity.agent.services.reporting.ConfidenceLevel;
import com.contrastsecurity.agent.trace.CodeEvent;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.util.A;
import com.contrastsecurity.agent.util.K;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.StringUtils;
import com.contrastsecurity.thirdparty.org.apache.log4j.Logger;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;

@DontObfuscate
public class Trace {
    private final AssessmentManager assessmentManager;
    private final TraceController traceController;
    private List<CodeEvent> events;
    private long id;
    private long parentId;
    private String evidence;
    private List<EventPropertyDTM> properties;
    public ConfidenceLevel level;
    private static final AtomicLong NEXT_ID = new AtomicLong(1L);
    private int eventsAddedSinceSummaryUpdate;
    private int summaryEventSize;
    private boolean summarized;
    private int identitySourceHash;
    private String ruleId;
    private static final int SUMMARIZATION_LEADING_EVENTS_COUNT = Contrast.config().c("contrast.summarization.leading.events");
    private static final int SUMMARIZATION_MIN_TRAILING_EVENTS_COUNT = Contrast.config().c("contrast.summarization.trailing.events");
    private static final int UPDATE_SUMMARY_THRESHOLD = SUMMARIZATION_LEADING_EVENTS_COUNT + SUMMARIZATION_MIN_TRAILING_EVENTS_COUNT;
    private static final int TRACE_SUMMARIZATION_THRESHOLD = Contrast.config().c("contrast.summarization.threshold");
    private static final Logger logger = Logger.getLogger(Trace.class);

    @B
    public Trace(AssessmentManager assessmentManager, TraceController traceController) {
        this.assessmentManager = assessmentManager;
        this.traceController = traceController;
        this.id = NEXT_ID.getAndIncrement();
        this.summarized = false;
        this.summaryEventSize = 0;
        this.events = new CopyOnWriteArrayList<CodeEvent>();
        this.properties = new CopyOnWriteArrayList<EventPropertyDTM>();
    }

    Trace(Trace trace) {
        this.assessmentManager = trace.assessmentManager;
        this.traceController = trace.traceController;
        this.id = NEXT_ID.getAndIncrement();
        this.events = new CopyOnWriteArrayList<CodeEvent>();
        this.copyEvents(trace);
        this.properties = new CopyOnWriteArrayList<EventPropertyDTM>();
        this.copyProperties(trace);
        this.evidence = trace.getEvidence();
        this.identitySourceHash = trace.getIdentitySourceHash();
        this.parentId = trace.getParentId();
        this.ruleId = trace.getRuleId();
        this.summarized = trace.summarized;
        this.summaryEventSize = trace.summaryEventSize;
    }

    private boolean shouldAddEvent(CodeEvent codeEvent) {
        if (this.isFrozen()) {
            return false;
        }
        if (codeEvent == null) {
            return false;
        }
        return !this.events.contains(codeEvent);
    }

    private void summarizeTrace() {
        int n2;
        CopyOnWriteArrayList<CodeEvent> copyOnWriteArrayList = new CopyOnWriteArrayList<CodeEvent>();
        CodeEvent codeEvent = null;
        for (int i2 = 0; i2 < SUMMARIZATION_LEADING_EVENTS_COUNT; ++i2) {
            codeEvent = this.events.get(i2);
            copyOnWriteArrayList.add(codeEvent);
        }
        com.contrastsecurity.agent.plugins.security.model.f f2 = new com.contrastsecurity.agent.plugins.security.model.f(this.assessmentManager, this.traceController);
        long l2 = codeEvent.getId();
        int n3 = this.events.size() - (SUMMARIZATION_MIN_TRAILING_EVENTS_COUNT + 1);
        int n4 = SUMMARIZATION_LEADING_EVENTS_COUNT + 1;
        int n5 = n3;
        for (n2 = n3; n2 >= n4; --n2) {
            codeEvent = this.events.get(n2);
            if (codeEvent instanceof TagEvent || codeEvent.getId() == l2) continue;
            n5 = n2;
            break;
        }
        for (n2 = SUMMARIZATION_LEADING_EVENTS_COUNT; n2 <= n5; ++n2) {
            codeEvent = this.events.get(n2);
            f2.a(codeEvent);
        }
        f2.b(codeEvent);
        f2.a(l2);
        f2.setId(codeEvent.getId());
        copyOnWriteArrayList.add(f2);
        for (n2 = n5 + 1; n2 < this.events.size(); ++n2) {
            codeEvent = this.events.get(n2);
            copyOnWriteArrayList.add(codeEvent);
        }
        this.events.clear();
        this.events = copyOnWriteArrayList;
        this.summaryEventSize = f2.c();
        this.eventsAddedSinceSummaryUpdate = 0;
        this.summarized = true;
    }

    private boolean isFrozen() {
        return this.summarized && this.summaryEventSize >= com.contrastsecurity.agent.plugins.security.model.f.b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(CodeEvent codeEvent) {
        if (!this.isFrozen()) {
            long l2 = System.currentTimeMillis();
            List<CodeEvent> list = this.events;
            synchronized (list) {
                if (this.shouldAddEvent(codeEvent)) {
                    A.a("Trace.addEvent()", l2, System.currentTimeMillis());
                    this.events.add(codeEvent);
                    ++this.eventsAddedSinceSummaryUpdate;
                }
                if (this.shouldSummarizeTrace()) {
                    this.summarizeTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyEvents(Trace trace) {
        if (trace == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Source is null");
            }
            return;
        }
        if (trace.getEvents() == null || trace.getEvents().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Source does not have any events");
            }
            return;
        }
        if (this.isFrozen()) {
            return;
        }
        long l2 = System.currentTimeMillis();
        List<CodeEvent> list = this.events;
        synchronized (list) {
            A.a("Trace.copyEvents()", l2, System.currentTimeMillis());
            for (int i2 = 0; i2 < trace.getEvents().size(); ++i2) {
                CodeEvent codeEvent = trace.getEvents().get(i2);
                if (!this.shouldAddEvent(codeEvent)) continue;
                if (codeEvent instanceof com.contrastsecurity.agent.plugins.security.model.f) {
                    this.eventsAddedSinceSummaryUpdate += trace.eventsAddedSinceSummaryUpdate;
                }
                this.events.add(codeEvent);
                ++this.eventsAddedSinceSummaryUpdate;
            }
            if (this.shouldSummarizeTrace()) {
                this.summarizeTrace();
            }
        }
    }

    private void copyProperties(Trace trace) {
        if (trace == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Source is null");
            }
            return;
        }
        if (trace.getProperties() == null || trace.getProperties().isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Source does not have any properties");
            }
            return;
        }
        this.properties.addAll(trace.getProperties());
    }

    private boolean shouldSummarizeTrace() {
        boolean bl = !this.summarized && this.events.size() >= TRACE_SUMMARIZATION_THRESHOLD;
        boolean bl2 = this.summarized && this.eventsAddedSinceSummaryUpdate >= UPDATE_SUMMARY_THRESHOLD;
        return !this.isFrozen() && (bl || bl2);
    }

    public List<CodeEvent> getEvents() {
        return this.events;
    }

    public void setEvents(CopyOnWriteArrayList<CodeEvent> copyOnWriteArrayList) {
        this.events = copyOnWriteArrayList;
    }

    public List<EventPropertyDTM> getProperties() {
        return f.a(this.properties);
    }

    public Iterable<EventPropertyDTM> getPropertiesIterable() {
        return this.properties;
    }

    public void addProperty(EventPropertyDTM eventPropertyDTM) {
        this.properties.add(eventPropertyDTM);
    }

    public boolean hasProperties() {
        return !this.properties.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TRACE " + this.getId() + " (" + this.getParentId() + ")\n");
        long l2 = System.currentTimeMillis();
        if (!StringUtils.isEmpty(this.evidence)) {
            stringBuilder.append(K.a((CharSequence)this.evidence, 20));
        } else {
            List<CodeEvent> list = this.events;
            synchronized (list) {
                A.a("Trace.toString()", l2, System.currentTimeMillis());
                for (CodeEvent codeEvent : this.events) {
                    stringBuilder.append("   : ").append(codeEvent).append("\n");
                }
            }
        }
        return stringBuilder.toString();
    }

    public long getId() {
        return this.id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long l2) {
        this.parentId = l2;
    }

    public void setEvidence(String string) {
        this.evidence = string;
    }

    public String getEvidence() {
        return this.evidence;
    }

    public int getLastTrigger() {
        for (int i2 = this.events.size() - 1; i2 >= 0; --i2) {
            CodeEvent codeEvent = this.events.get(i2);
            if (!(codeEvent instanceof TriggerEvent)) continue;
            return i2;
        }
        return 0;
    }

    public CodeEvent getFirstEvent() {
        if (this.events == null || this.events.size() == 0) {
            return null;
        }
        return this.events.get(0);
    }

    public CodeEvent getLastEvent() {
        if (this.events == null || this.events.size() == 0) {
            return null;
        }
        return this.events.get(this.events.size() - 1);
    }

    public BitSet getBitSet() {
        CodeEvent codeEvent = this.getLastEvent();
        if (codeEvent == null) {
            return null;
        }
        return codeEvent.getBitSet();
    }

    public Set<String> getTags() {
        CodeEvent codeEvent = this.getLastEvent();
        if (codeEvent == null) {
            return new HashSet<String>();
        }
        return codeEvent.getTags();
    }

    public TagRanges getTagRanges() {
        CodeEvent codeEvent = this.getLastEvent();
        if (codeEvent == null) {
            return new TagRanges();
        }
        return codeEvent.getTagRanges();
    }

    public boolean hasTag(String string) {
        Set<String> set = this.getTags();
        if (string.charAt(0) != '?') {
            return set != null && set.contains(string);
        }
        if (set != null) {
            for (String string2 : set) {
                if (!string2.contains(string.substring(1))) continue;
                return true;
            }
        }
        return false;
    }

    public Object getLength() {
        return this.events.size();
    }

    public void setRuleId(String string) {
        this.ruleId = string;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public int getIdentitySourceHash() {
        return this.identitySourceHash;
    }

    public void setIdentitySourceHash(int n2) {
        this.identitySourceHash = n2;
    }

    public PropagationEvent getLastPropagationEvent() {
        for (int i2 = this.events.size() - 1; i2 >= 0; --i2) {
            CodeEvent codeEvent = this.events.get(i2);
            if (!(codeEvent instanceof PropagationEvent)) continue;
            return (PropagationEvent)codeEvent;
        }
        return null;
    }

    public SourceEvent getFirstSourceEvent() {
        for (int i2 = 0; i2 < this.events.size(); ++i2) {
            CodeEvent codeEvent = this.events.get(i2);
            if (!(codeEvent instanceof SourceEvent)) continue;
            return (SourceEvent)codeEvent;
        }
        return null;
    }
}

