/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace.snapshot;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.trace.snapshot.DataSnapshot;
import com.contrastsecurity.agent.trace.snapshot.j;
import com.contrastsecurity.agent.trace.snapshot.t;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.ObjectUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@DontObfuscate
public final class MapSnapshotFactory
implements t<Map<?, ?>> {
    private final int maxSamples;
    private final int maxSampleCapture;
    private final int maxCapture;
    private final j identitySnapshotFactory;
    private static final int MAX_SAMPLES = 10;
    private static final int MAX_SAMPLE_CAPTURE = 128;
    private static final int MAX_CAPTURE = 512;
    private static final Logger logger = LoggerFactory.getLogger(MapSnapshotFactory.class);

    MapSnapshotFactory(int n2, int n3, int n4) {
        this.maxSamples = n2;
        this.maxSampleCapture = n3;
        this.maxCapture = n4;
        this.identitySnapshotFactory = new j();
    }

    public MapSnapshotFactory() {
        this(10, 128, 512);
    }

    @Override
    public boolean supports(Object object) {
        return object instanceof Map;
    }

    @Override
    public char[] snapshot(Map<?, ?> map) {
        return this.snapshotAndTruncate(map);
    }

    @Override
    public char[] snapshotAndTruncate(Map<?, ?> map) {
        Set<?> set = map.keySet();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        if (!set.isEmpty()) {
            Iterator<?> iterator = set.iterator();
            for (int i2 = 0; iterator.hasNext() && i2 < this.maxSamples; ++i2) {
                Object obj = iterator.next();
                Object obj2 = map.get(obj);
                stringBuilder.append(obj);
                stringBuilder.append('=');
                if (obj2 instanceof CharSequence) {
                    this.handleAppending(stringBuilder, (CharSequence)obj2);
                } else if (obj2 instanceof List) {
                    this.handleAppending(stringBuilder, (List)obj2);
                } else if (obj2 instanceof String[]) {
                    this.handleAppending(stringBuilder, (String[])obj2);
                } else {
                    stringBuilder.append(this.identitySnapshotFactory.snapshot(obj2));
                }
                if (!iterator.hasNext()) continue;
                stringBuilder.append(",");
                if (stringBuilder.length() < this.maxCapture) continue;
                stringBuilder.append("...");
                break;
            }
        }
        stringBuilder.append("}");
        return stringBuilder.toString().toCharArray();
    }

    @Override
    public DataSnapshot snapshotAndTruncate(Map<?, ?> map, TagRanges tagRanges) {
        return new DataSnapshot(this.snapshotAndTruncate(map), tagRanges);
    }

    public DataSnapshot snapshotTracked(Map<?, ?> map, TagRanges tagRanges) {
        char[] cArray = null;
        try {
            cArray = this.snapshot(map);
        }
        catch (Exception exception) {
            logger.error("Problem encoding map type {}", (Object)map.getClass().getName(), (Object)exception);
        }
        return new DataSnapshot(cArray, tagRanges);
    }

    private void handleAppending(StringBuilder stringBuilder, List<?> list) {
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object obj = list.get(i2);
            if (obj instanceof CharSequence) {
                this.handleAppending(stringBuilder, (CharSequence)obj);
            } else {
                stringBuilder.append(ObjectUtils.identityToString(obj));
            }
            if (i2 == list.size() - 1) continue;
            stringBuilder.append(',');
        }
    }

    private void handleAppending(StringBuilder stringBuilder, String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            this.handleAppending(stringBuilder, string);
            if (i2 == stringArray.length - 1) continue;
            stringBuilder.append(',');
        }
    }

    private void handleAppending(StringBuilder stringBuilder, CharSequence charSequence) {
        if (charSequence.length() > this.maxSampleCapture) {
            stringBuilder.append(charSequence.subSequence(0, this.maxSampleCapture));
            stringBuilder.append("...");
        } else {
            stringBuilder.append(charSequence);
        }
    }
}

