/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.trace.snapshot;

import com.contrastsecurity.agent.B;
import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.config.g;
import com.contrastsecurity.agent.plugins.frameworks.Q;
import com.contrastsecurity.agent.plugins.frameworks.o;
import com.contrastsecurity.agent.trace.TagRanges;
import com.contrastsecurity.agent.trace.snapshot.CharSequenceSnapshotFactory;
import com.contrastsecurity.agent.trace.snapshot.DataSnapshot;
import com.contrastsecurity.agent.trace.snapshot.DoubleArraySnapshotFactory;
import com.contrastsecurity.agent.trace.snapshot.MapSnapshotFactory;
import com.contrastsecurity.agent.trace.snapshot.StringCacheSnapshotFactory;
import com.contrastsecurity.agent.trace.snapshot.b;
import com.contrastsecurity.agent.trace.snapshot.c;
import com.contrastsecurity.agent.trace.snapshot.e;
import com.contrastsecurity.agent.trace.snapshot.h;
import com.contrastsecurity.agent.trace.snapshot.i;
import com.contrastsecurity.agent.trace.snapshot.j;
import com.contrastsecurity.agent.trace.snapshot.k;
import com.contrastsecurity.agent.trace.snapshot.l;
import com.contrastsecurity.agent.trace.snapshot.m;
import com.contrastsecurity.agent.trace.snapshot.n;
import com.contrastsecurity.agent.trace.snapshot.q;
import com.contrastsecurity.agent.trace.snapshot.r;
import com.contrastsecurity.agent.trace.snapshot.t;
import com.contrastsecurity.agent.trace.snapshot.u;
import com.contrastsecurity.agent.trace.snapshot.v;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.thirdparty.org.apache.commons.lang.ObjectUtils;
import com.contrastsecurity.thirdparty.org.slf4j.Logger;
import com.contrastsecurity.thirdparty.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@DontObfuscate
public final class ObjectSnapshotFactory {
    private final r contextCache;
    private final o frameworkManager;
    private final int maxContextSnapshotCacheSize;
    private static final m MAX_CHARACTERS = m.a(150);
    private static final n MAX_ITEMS = n.a(10);
    private static final DataSnapshot NULL_SNAPSHOT = new DataSnapshot(ObjectShare.NULL, null);
    private static final t<Object>[] FACTORIES = ObjectSnapshotFactory.buildFactories();
    private static final h DEFAULT_FACTORY = new h(MAX_CHARACTERS);
    private static final String LM_CACHE = "AssessContextCache";
    private static final j IDENTITY_FACTORY = new j();
    private static final Logger logger = LoggerFactory.getLogger(ObjectSnapshotFactory.class);

    public ObjectSnapshotFactory(g g2, r r2, o o2) {
        com.contrastsecurity.agent.commons.l.a(g2);
        com.contrastsecurity.agent.commons.l.a(r2);
        com.contrastsecurity.agent.commons.l.a(o2);
        this.contextCache = r2;
        this.frameworkManager = o2;
        this.maxContextSnapshotCacheSize = g2.c("contrast.assess.context.max.snapshots");
    }

    public char[] snapshot(Object object) {
        char[] cArray;
        boolean bl = this.qualifiesForContextCache(object);
        char[] cArray2 = cArray = bl ? this.contextCache.a(object) : null;
        if (cArray != null) {
            this.logCacheHit(u.a, object);
            return cArray;
        }
        if (object != null) {
            this.logCacheMiss(u.a, object);
        }
        try {
            if (object != null) {
                for (t<Object> t2 : FACTORIES) {
                    if (!t2.supports(object)) continue;
                    cArray = t2.snapshot(object);
                    break;
                }
                if (cArray == null) {
                    cArray = this.snapshotWithFrameworkSupporters(object);
                }
                if (cArray == null) {
                    cArray = DEFAULT_FACTORY.snapshotAndTruncate(object);
                }
            } else {
                cArray = ObjectShare.NULL;
            }
        }
        catch (Exception exception) {
            cArray = IDENTITY_FACTORY.snapshotAndTruncate(object);
        }
        if (bl && this.contextCache.a() < this.maxContextSnapshotCacheSize) {
            this.contextCache.a(object, cArray);
        }
        return cArray;
    }

    private void logCacheHit(u u2, Object object) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}|{}|operation={}&value={}", new Object[]{LM_CACHE, c.a, u2, ObjectUtils.identityToString(object)});
        }
    }

    private void logCacheMiss(u u2, Object object) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}|{}|operation={}&type={}&value={}", new Object[]{LM_CACHE, c.b, u2, object.getClass().getName(), ObjectUtils.identityToString(object)});
        }
    }

    private boolean qualifiesForContextCache(Object object) {
        return !(object instanceof String) && this.isProbablyImmutable(object);
    }

    public char[] snapshotAndTruncate(Object object) {
        char[] cArray;
        boolean bl = this.qualifiesForContextCache(object);
        char[] cArray2 = cArray = bl ? this.contextCache.b(object) : null;
        if (cArray != null) {
            this.logCacheHit(u.b, object);
            return cArray;
        }
        if (object != null) {
            this.logCacheMiss(u.b, object);
        }
        try {
            if (object != null) {
                for (t<Object> t2 : FACTORIES) {
                    if (!t2.supports(object)) continue;
                    cArray = t2.snapshotAndTruncate(object);
                    break;
                }
                if (cArray == null) {
                    cArray = this.snapshotAndTruncateWithFrameworkSupporters(object);
                }
                if (cArray == null) {
                    cArray = DEFAULT_FACTORY.snapshotAndTruncate(object);
                }
            } else {
                cArray = ObjectShare.NULL;
            }
        }
        catch (Exception exception) {
            cArray = IDENTITY_FACTORY.snapshotAndTruncate(object);
        }
        if (bl && this.contextCache.a() < this.maxContextSnapshotCacheSize) {
            this.contextCache.b(object, cArray);
        }
        return cArray;
    }

    public DataSnapshot snapshotAndTruncate(Object object, TagRanges tagRanges) {
        DataSnapshot dataSnapshot;
        boolean bl = this.qualifiesForContextCache(object);
        DataSnapshot dataSnapshot2 = dataSnapshot = bl ? this.contextCache.c(object) : null;
        if (dataSnapshot != null) {
            this.logCacheHit(u.c, object);
            return dataSnapshot;
        }
        if (object != null) {
            this.logCacheMiss(u.c, object);
        }
        try {
            if (object != null) {
                for (t<Object> t2 : FACTORIES) {
                    if (!t2.supports(object)) continue;
                    dataSnapshot = t2.snapshotAndTruncate(object, tagRanges);
                    break;
                }
                if (dataSnapshot == null) {
                    dataSnapshot = this.snapshotAndTruncateWithFrameworkSupporters(object, tagRanges);
                }
                if (dataSnapshot == null) {
                    dataSnapshot = DEFAULT_FACTORY.snapshotAndTruncate(object, tagRanges);
                }
            } else {
                dataSnapshot = NULL_SNAPSHOT;
            }
        }
        catch (Exception exception) {
            dataSnapshot = IDENTITY_FACTORY.snapshotAndTruncate(object, tagRanges);
        }
        if (bl && dataSnapshot != null && this.contextCache.a() < this.maxContextSnapshotCacheSize) {
            this.contextCache.a(object, dataSnapshot);
        }
        return dataSnapshot;
    }

    @B
    boolean isProbablyImmutable(Object object) {
        if (object instanceof String || object instanceof Number || object instanceof File || object instanceof InputStream || object instanceof URI || object instanceof URL) {
            return true;
        }
        return !(object instanceof Collection) && !(object instanceof Map) && !(object instanceof CharSequence) && (object == null || !object.getClass().isArray());
    }

    private char[] snapshotWithFrameworkSupporters(Object object) {
        List<Q> list = this.frameworkManager.h();
        char[] cArray = null;
        for (int i2 = 0; cArray == null && i2 < list.size(); ++i2) {
            Q q2 = list.get(i2);
            cArray = q2.a(object);
        }
        return cArray;
    }

    private char[] snapshotAndTruncateWithFrameworkSupporters(Object object) {
        List<Q> list = this.frameworkManager.h();
        char[] cArray = null;
        for (int i2 = 0; cArray == null && i2 < list.size(); ++i2) {
            Q q2 = list.get(i2);
            cArray = q2.b(object);
        }
        return cArray;
    }

    private DataSnapshot snapshotAndTruncateWithFrameworkSupporters(Object object, TagRanges tagRanges) {
        List<Q> list = this.frameworkManager.h();
        DataSnapshot dataSnapshot = null;
        for (int i2 = 0; dataSnapshot == null && i2 < list.size(); ++i2) {
            Q q2 = list.get(i2);
            dataSnapshot = q2.a(object, tagRanges);
        }
        return dataSnapshot;
    }

    private static t<Object>[] buildFactories() {
        CharSequenceSnapshotFactory charSequenceSnapshotFactory = new CharSequenceSnapshotFactory(MAX_CHARACTERS);
        return new t[]{new StringCacheSnapshotFactory(charSequenceSnapshotFactory), charSequenceSnapshotFactory, new e(MAX_CHARACTERS), new b(MAX_CHARACTERS, charSequenceSnapshotFactory), new k(MAX_CHARACTERS), new i(MAX_ITEMS), new l(MAX_CHARACTERS), new DoubleArraySnapshotFactory(MAX_ITEMS), new MapSnapshotFactory(), new v(MAX_CHARACTERS), new q(MAX_ITEMS)};
    }
}

