/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.com.google.gson;

import com.contrastsecurity.thirdparty.com.google.gson.JsonSyntaxException;
import com.contrastsecurity.thirdparty.com.google.gson.TypeAdapter;
import com.contrastsecurity.thirdparty.com.google.gson.internal.JavaVersion;
import com.contrastsecurity.thirdparty.com.google.gson.internal.PreJava9DateFormatProvider;
import com.contrastsecurity.thirdparty.com.google.gson.internal.bind.util.ISO8601Utils;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonReader;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonToken;
import com.contrastsecurity.thirdparty.com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

final class DefaultDateTypeAdapter
extends TypeAdapter<java.util.Date> {
    private static final String SIMPLE_NAME = "DefaultDateTypeAdapter";
    private final Class<? extends java.util.Date> dateType;
    private final List<DateFormat> dateFormats = new ArrayList<DateFormat>();

    DefaultDateTypeAdapter(Class<? extends java.util.Date> clazz) {
        this.dateType = DefaultDateTypeAdapter.verifyDateType(clazz);
        this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(DateFormat.getDateTimeInstance(2, 2));
        }
        if (JavaVersion.isJava9OrLater()) {
            this.dateFormats.add(PreJava9DateFormatProvider.getUSDateTimeFormat(2, 2));
        }
    }

    DefaultDateTypeAdapter(Class<? extends java.util.Date> clazz, String string) {
        this.dateType = DefaultDateTypeAdapter.verifyDateType(clazz);
        this.dateFormats.add(new SimpleDateFormat(string, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(new SimpleDateFormat(string));
        }
    }

    DefaultDateTypeAdapter(Class<? extends java.util.Date> clazz, int n2) {
        this.dateType = DefaultDateTypeAdapter.verifyDateType(clazz);
        this.dateFormats.add(DateFormat.getDateInstance(n2, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(DateFormat.getDateInstance(n2));
        }
        if (JavaVersion.isJava9OrLater()) {
            this.dateFormats.add(PreJava9DateFormatProvider.getUSDateFormat(n2));
        }
    }

    public DefaultDateTypeAdapter(int n2, int n3) {
        this(java.util.Date.class, n2, n3);
    }

    public DefaultDateTypeAdapter(Class<? extends java.util.Date> clazz, int n2, int n3) {
        this.dateType = DefaultDateTypeAdapter.verifyDateType(clazz);
        this.dateFormats.add(DateFormat.getDateTimeInstance(n2, n3, Locale.US));
        if (!Locale.getDefault().equals(Locale.US)) {
            this.dateFormats.add(DateFormat.getDateTimeInstance(n2, n3));
        }
        if (JavaVersion.isJava9OrLater()) {
            this.dateFormats.add(PreJava9DateFormatProvider.getUSDateTimeFormat(n2, n3));
        }
    }

    private static Class<? extends java.util.Date> verifyDateType(Class<? extends java.util.Date> clazz) {
        if (clazz != java.util.Date.class && clazz != Date.class && clazz != Timestamp.class) {
            throw new IllegalArgumentException("Date type must be one of " + java.util.Date.class + ", " + Timestamp.class + ", or " + Date.class + " but was " + clazz);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonWriter jsonWriter, java.util.Date date) throws IOException {
        if (date == null) {
            jsonWriter.nullValue();
            return;
        }
        List<DateFormat> list = this.dateFormats;
        synchronized (list) {
            String string = this.dateFormats.get(0).format(date);
            jsonWriter.value(string);
        }
    }

    @Override
    public java.util.Date read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        java.util.Date date = this.deserializeToDate(jsonReader.nextString());
        if (this.dateType == java.util.Date.class) {
            return date;
        }
        if (this.dateType == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (this.dateType == Date.class) {
            return new Date(date.getTime());
        }
        throw new AssertionError();
    }

    private java.util.Date deserializeToDate(String string) {
        List<DateFormat> list = this.dateFormats;
        synchronized (list) {
            for (DateFormat dateFormat : this.dateFormats) {
                try {
                    return dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                }
            }
            try {
                return ISO8601Utils.parse(string, new ParsePosition(0));
            }
            catch (ParseException parseException) {
                throw new JsonSyntaxException(string, parseException);
            }
        }
    }

    public String toString() {
        DateFormat dateFormat = this.dateFormats.get(0);
        if (dateFormat instanceof SimpleDateFormat) {
            return "DefaultDateTypeAdapter(" + ((SimpleDateFormat)dateFormat).toPattern() + ')';
        }
        return "DefaultDateTypeAdapter(" + dateFormat.getClass().getSimpleName() + ')';
    }
}

